/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.participants;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.tests.util.SimpleTestProject;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MoveRefactoringWithRefUpdateTest {
    private SimpleTestProject fProject;

    @Before
    public void setUp() throws Exception {
        this.fProject = new SimpleTestProject();
    }

    @After
    public void tearDown() throws Exception {
        this.fProject.delete();
    }

    @Test
    public void testMoveRefactoringWithParticipants() throws Exception {
        IFolder srcFold = this.fProject.createFolder("testFolder");
        IFile fileToUpdate = this.fProject.createFile((IContainer)srcFold, "referencer.txt", "using testFolder.fileToMove.txt;\nusing someOther.txt");
        IFile fileToMove = this.fProject.createFile((IContainer)srcFold, "fileToMove.txt", "");
        IFolder destFold = this.fProject.createFolder("dest");
        MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)new TestMoveProcessor(fileToUpdate, fileToMove, destFold));
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, null);
        Assert.assertTrue((String)"File is not moved", (boolean)this.fProject.getProject().getFolder("dest").getFile("fileToMove.txt").exists());
        String actual = this.fProject.getContent(fileToUpdate);
        Assert.assertEquals((Object)"using dest.fileToMove.txt;\nusing someOther.txt", (Object)actual);
    }

    private static class RefUpdateParticipant
    extends MoveParticipant {
        private IFile fFile;

        private RefUpdateParticipant() {
        }

        protected boolean initialize(Object element) {
            this.fFile = (IFile)element;
            return true;
        }

        public String getName() {
            return "participant";
        }

        public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            TextFileChange result = new TextFileChange("", this.fFile);
            MultiTextEdit root = new MultiTextEdit();
            root.addChild((TextEdit)new ReplaceEdit(6, 25, "dest.fileToMove.txt"));
            result.setEdit((TextEdit)root);
            return result;
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return null;
        }
    }

    private static class TestMoveProcessor
    extends MoveProcessor {
        private IFile fileToUpdate;
        private IFile fileToMove;
        private IFolder dest;

        public TestMoveProcessor(IFile file, IFile fileToMove, IFolder destFold) {
            this.fileToUpdate = file;
            this.fileToMove = fileToMove;
            this.dest = destFold;
        }

        public Object[] getElements() {
            return new Object[]{this.fileToUpdate};
        }

        public String getIdentifier() {
            return "org.eclipse.ltk.core.refactoring.tests.Processor";
        }

        public String getProcessorName() {
            return "processor";
        }

        public boolean isApplicable() throws CoreException {
            return true;
        }

        public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            MoveResourceChange moveChange = new MoveResourceChange((IResource)this.fileToMove, (IContainer)this.dest);
            return moveChange;
        }

        public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
            RefUpdateParticipant participant = new RefUpdateParticipant();
            participant.initialize((RefactoringProcessor)this, this.fileToUpdate, (RefactoringArguments)new MoveArguments((Object)this.dest, false));
            return new RefactoringParticipant[]{participant};
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException, OperationCanceledException {
            ArrayList<TextFileChange> postChanges = new ArrayList<TextFileChange>();
            TextFileChange referenceChange = new TextFileChange("", this.fileToUpdate);
            MultiTextEdit root = new MultiTextEdit();
            root.addChild((TextEdit)new ReplaceEdit(6, 25, "dest.fileToMove.txt"));
            referenceChange.setEdit((TextEdit)root);
            postChanges.add(referenceChange);
            if (postChanges.isEmpty()) {
                return null;
            }
            ArrayList<IFile> alreadyTouchedFiles = new ArrayList<IFile>();
            this.getModifiedFiles(alreadyTouchedFiles, participantChanges);
            CompositeChange mergedChange = new CompositeChange("TestMoveProcessor Post Change");
            mergedChange.markAsSynthetic();
            for (TextChange textChange : postChanges) {
                TextFileChange change = (TextFileChange)textChange;
                if (alreadyTouchedFiles.contains(change.getFile())) continue;
                mergedChange.add((Change)change);
            }
            return mergedChange;
        }

        private void getModifiedFiles(List<IFile> result, Change[] changes) {
            Change[] changeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                Change change = changeArray[n2];
                Object modifiedElement = change.getModifiedElement();
                if (modifiedElement instanceof IAdaptable && (file = (IFile)((IAdaptable)modifiedElement).getAdapter(IFile.class)) != null) {
                    result.add(file);
                }
                if (change instanceof CompositeChange) {
                    this.getModifiedFiles(result, ((CompositeChange)change).getChildren());
                }
                ++n2;
            }
        }
    }
}

