/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.participants;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.tests.util.SimpleTestProject;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SharedTextChangeTests {
    private SimpleTestProject fProject;

    @Before
    public void setUp() throws Exception {
        this.fProject = new SimpleTestProject();
    }

    @After
    public void tearDown() throws Exception {
        this.fProject.delete();
    }

    @Test
    public void testSharedUpdating() throws Exception {
        IFolder folder = this.fProject.createFolder("test");
        IFile file = this.fProject.createFile((IContainer)folder, "test.txt", "section one section two");
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)new Processor(file));
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, null);
        String actual = this.fProject.getContent(file);
        Assert.assertEquals((Object)"section three section four", (Object)actual);
    }

    private static class Participant
    extends RenameParticipant {
        private IFile fFile;

        private Participant() {
        }

        protected boolean initialize(Object element) {
            this.fFile = (IFile)element;
            return true;
        }

        public String getName() {
            return "participant";
        }

        public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            TextChange change = this.getTextChange(this.fFile);
            change.addEdit((TextEdit)new ReplaceEdit(20, 3, "four"));
            return null;
        }
    }

    private static class Processor
    extends RenameProcessor {
        private IFile fFile;

        public Processor(IFile file) {
            this.fFile = file;
        }

        public Object[] getElements() {
            return new Object[]{this.fFile};
        }

        public String getIdentifier() {
            return "org.eclipse.ltk.core.refactoring.tests.Processor";
        }

        public String getProcessorName() {
            return "processor";
        }

        public boolean isApplicable() throws CoreException {
            return true;
        }

        public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            TextFileChange result = new TextFileChange("", this.fFile);
            MultiTextEdit root = new MultiTextEdit();
            root.addChild((TextEdit)new ReplaceEdit(8, 3, "three"));
            result.setEdit((TextEdit)root);
            return result;
        }

        public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
            Participant participant = new Participant();
            participant.initialize((RefactoringProcessor)this, this.fFile, (RefactoringArguments)new RenameArguments("", false));
            return new RefactoringParticipant[]{participant};
        }
    }
}

