/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourcesDescriptor;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;
import org.eclipse.ltk.core.refactoring.tests.FileSystemHelper;
import org.eclipse.ltk.core.refactoring.tests.RefactoringCoreTestPlugin;
import org.eclipse.ltk.core.refactoring.tests.participants.ElementRenameProcessor;
import org.eclipse.ltk.core.refactoring.tests.participants.ElementRenameRefactoring;
import org.eclipse.ltk.core.refactoring.tests.util.SimpleTestProject;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceRefactoringUndoTests {
    private static final String TEST_NEWPROJECT_NAME = "projectTestNew";
    private static final String TEST_FOLDER_NAME = "test";
    private static final String TEST_NEWFOLDER_NAME = "testNew";
    private static final String TEST_FILE_NAME = "myFile.txt";
    private static final String TEST_NEWFILE_NAME = "newFile.txt";
    private static final String TEST_LINKEDFOLDER_NAME = "linkedFolder";
    private static final String TEST_LINKEDFILE_NAME = "linkedFile.txt";
    private static final String TEST_SUBFOLDER_NAME = "subFolder";
    private static List<String> fileNameExcludes = new ArrayList<String>();
    private static final String CONTENT = "hello";
    private SimpleTestProject fProject;
    private IFolder testFolder;
    private IFile testFile;
    private IOperationHistory history;
    private IUndoContext context;
    private final Set<IFileStore> storesToDelete = new HashSet<IFileStore>();
    private IFolder testLinkedFolder;
    private IFile testLinkedFile;
    private IFolder testSubFolder;

    static {
        fileNameExcludes.add(".project");
    }

    @Before
    public void setUp() throws Exception {
        this.fProject = new SimpleTestProject();
        this.testFolder = this.fProject.createFolder(TEST_FOLDER_NAME);
        this.testFile = this.fProject.createFile((IContainer)this.testFolder, TEST_FILE_NAME, CONTENT);
        IFileStore folderStore = this.getTempStore();
        IFileStore fileStore = this.getTempStore();
        IPath folderLocation = URIUtil.toPath((URI)folderStore.toURI());
        IPath fileLocation = URIUtil.toPath((URI)fileStore.toURI());
        folderStore.mkdir(0, this.getMonitor());
        fileStore.openOutputStream(0, this.getMonitor()).close();
        this.testLinkedFolder = this.testFolder.getFolder(TEST_LINKEDFOLDER_NAME);
        this.testLinkedFolder.createLink(folderLocation, 0, this.getMonitor());
        Assert.assertTrue((boolean)this.testLinkedFolder.exists());
        this.testLinkedFile = this.testFolder.getFile(TEST_LINKEDFILE_NAME);
        this.testLinkedFile.createLink(fileLocation, 0, this.getMonitor());
        this.testSubFolder = this.testFolder.getFolder(TEST_SUBFOLDER_NAME);
        this.testSubFolder.create(true, true, this.getMonitor());
        this.history = OperationHistoryFactory.getOperationHistory();
        this.context = RefactoringCorePlugin.getUndoContext();
    }

    @After
    public void tearDown() throws Exception {
        this.fProject.delete();
        IFileStore[] toDelete = this.storesToDelete.toArray(new IFileStore[this.storesToDelete.size()]);
        this.storesToDelete.clear();
        IFileStore[] iFileStoreArray = toDelete;
        int n = toDelete.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore d = iFileStoreArray[n2];
            this.clear(d);
            ++n2;
        }
    }

    @Test
    public void testFileRenameUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.rename.resource");
        RenameResourceDescriptor desc = (RenameResourceDescriptor)renameContribution.createDescriptor();
        desc.setResourcePath(this.testFile.getFullPath());
        desc.setNewName(TEST_NEWFILE_NAME);
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FileSnapshot snap = new FileSnapshot(this.testFile);
        this.execute(op);
        IFile renamedFile = this.testFolder.getFile(TEST_NEWFILE_NAME);
        Assert.assertTrue((String)"File rename failed", (boolean)renamedFile.exists());
        snap.name = TEST_NEWFILE_NAME;
        Assert.assertTrue((String)"File CONTENT was altered on rename", (boolean)snap.isValid((IResource)this.testFolder));
        this.undo();
        snap.name = TEST_FILE_NAME;
        Assert.assertTrue((String)"File CONTENT was altered on undo rename", (boolean)snap.isValid((IResource)this.testFolder));
        Assert.assertFalse((String)"Undo rename failed", (boolean)renamedFile.exists());
        this.redo();
        snap.name = TEST_NEWFILE_NAME;
        Assert.assertTrue((String)"File CONTENT was altered on redo rename", (boolean)snap.isValid((IResource)this.testFolder));
    }

    @Test
    public void testFolderRenameUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.rename.resource");
        RenameResourceDescriptor desc = (RenameResourceDescriptor)renameContribution.createDescriptor();
        desc.setResourcePath(this.testFolder.getFullPath());
        desc.setNewName(TEST_NEWFOLDER_NAME);
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FolderSnapshot snap = new FolderSnapshot(this.testFolder);
        this.execute(op);
        IFolder renamedFolder = this.fProject.getProject().getFolder(TEST_NEWFOLDER_NAME);
        Assert.assertTrue((String)"Project rename failed", (boolean)renamedFolder.exists());
        snap.name = TEST_NEWFOLDER_NAME;
        Assert.assertTrue((String)"Folder CONTENT was altered on rename", (boolean)snap.isValid((IResource)this.fProject.getProject()));
        this.undo();
        snap.name = TEST_FOLDER_NAME;
        Assert.assertTrue((String)"Folder CONTENT was altered on undo rename", (boolean)snap.isValid((IResource)this.fProject.getProject()));
        Assert.assertFalse((String)"Undo rename failed", (boolean)renamedFolder.exists());
        this.redo();
        snap.name = TEST_NEWFOLDER_NAME;
        Assert.assertTrue((String)"Folder CONTENT was altered on redo rename", (boolean)snap.isValid((IResource)this.fProject.getProject()));
    }

    @Test
    public void testProjectRenameUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.rename.resource");
        RenameResourceDescriptor desc = (RenameResourceDescriptor)renameContribution.createDescriptor();
        desc.setResourcePath(this.fProject.getProject().getFullPath());
        desc.setNewName(TEST_NEWPROJECT_NAME);
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        ProjectSnapshot snap = new ProjectSnapshot(this.fProject.getProject());
        this.execute(op);
        IProject renamedProject = this.getWorkspaceRoot().getProject(TEST_NEWPROJECT_NAME);
        try {
            Assert.assertTrue((String)"Project rename failed", (boolean)renamedProject.exists());
            snap.name = TEST_NEWPROJECT_NAME;
            Assert.assertTrue((String)"Project CONTENT was altered on rename", (boolean)snap.isValid());
            this.undo();
            snap.name = "TestProject";
            Assert.assertTrue((String)"Project CONTENT was altered on undo rename", (boolean)snap.isValid());
            Assert.assertFalse((String)"Undo rename failed", (boolean)renamedProject.exists());
            this.redo();
            snap.name = TEST_NEWPROJECT_NAME;
            Assert.assertTrue((String)"Project CONTENT was altered on redo rename", (boolean)snap.isValid());
        }
        finally {
            renamedProject.delete(true, true, null);
        }
    }

    @Test
    public void testFileDeleteUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)renameContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.testFile.getFullPath()});
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FileSnapshot snap = new FileSnapshot(this.testFile);
        this.execute(op);
        Assert.assertFalse((String)"File delete failed", (boolean)this.testFile.exists());
        this.undo();
        Assert.assertTrue((String)"File recreation failed", (boolean)this.testFile.exists());
        Assert.assertTrue((String)"File CONTENT was altered on undo", (boolean)snap.isValid((IResource)this.testFile.getParent()));
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.testFile.exists());
    }

    @Test
    public void testFileLinkedDeleteUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)renameContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.testLinkedFile.getFullPath()});
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FileSnapshot snap = new FileSnapshot(this.testLinkedFile);
        this.execute(op);
        Assert.assertFalse((String)"File delete failed", (boolean)this.testLinkedFile.exists());
        this.undo();
        Assert.assertTrue((String)"File recreation failed", (boolean)this.testLinkedFile.exists());
        Assert.assertTrue((String)"File CONTENT was altered on undo", (boolean)snap.isValid((IResource)this.testLinkedFile.getParent()));
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.testLinkedFile.exists());
    }

    @Test
    public void testFolderDeleteUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)renameContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.testSubFolder.getFullPath()});
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FolderSnapshot snap = new FolderSnapshot(this.testSubFolder);
        this.execute(op);
        Assert.assertFalse((String)"Folder delete failed", (boolean)this.testSubFolder.exists());
        this.undo();
        Assert.assertTrue((String)"Folder recreation failed", (boolean)this.testSubFolder.exists());
        Assert.assertTrue((String)"Folder CONTENT was altered on undo", (boolean)snap.isValid((IResource)this.testSubFolder.getParent()));
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.testSubFolder.exists());
    }

    @Test
    public void testFolderDeleteLinkedUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)renameContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.testLinkedFolder.getFullPath()});
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FolderSnapshot snap = new FolderSnapshot(this.testLinkedFolder);
        this.execute(op);
        Assert.assertFalse((String)"Folder delete failed", (boolean)this.testLinkedFolder.exists());
        this.undo();
        Assert.assertTrue((String)"Folder recreation failed", (boolean)this.testLinkedFolder.exists());
        Assert.assertTrue((String)"Folder CONTENT was altered on undo", (boolean)snap.isValid((IResource)this.testLinkedFolder.getParent()));
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.testLinkedFolder.exists());
    }

    @Test
    public void testFolderDeleteLinkedDeletedOnFilesystemUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution deleteContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)deleteContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.testLinkedFolder.getFullPath()});
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        FolderSnapshot snap = new FolderSnapshot(this.testLinkedFolder);
        IFolder subfolder = this.testLinkedFolder.getFolder("A");
        subfolder.create(true, true, this.getMonitor());
        IFile file = subfolder.getFile("test.txt");
        file.create((InputStream)new ByteArrayInputStream("test contents".getBytes(StandardCharsets.UTF_8)), true, this.getMonitor());
        IFileStore folderStore = EFS.getStore((URI)this.testLinkedFolder.getLocationURI());
        folderStore.delete(0, this.getMonitor());
        this.execute(op);
        Assert.assertFalse((String)"Folder delete failed", (boolean)this.testLinkedFolder.exists());
        this.undo();
        Assert.assertTrue((String)"Folder recreation failed", (boolean)this.testLinkedFolder.exists());
        Assert.assertTrue((String)"Folder CONTENT was altered on undo", (boolean)snap.isValid((IResource)this.testLinkedFolder.getParent()));
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.testLinkedFolder.exists());
    }

    @Test
    public void testProjectDeleteUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)renameContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.fProject.getProject().getFullPath()});
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        this.execute(op);
        Assert.assertFalse((String)"Project delete failed", (boolean)this.fProject.getProject().exists());
        this.undo();
        Assert.assertTrue((String)"Project recreation failed", (boolean)this.fProject.getProject().exists());
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.fProject.getProject().exists());
        this.undo();
    }

    @Test
    public void testProjectClosedDeleteUndoRedoLTK() throws ExecutionException, CoreException {
        this.fProject.getProject().close(this.getMonitor());
        this.testProjectDeleteUndoRedoLTK();
    }

    @Test
    public void testProjectDeleteWithContentUndoRedoLTK() throws ExecutionException, CoreException {
        RefactoringContribution renameContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor desc = (DeleteResourcesDescriptor)renameContribution.createDescriptor();
        desc.setResourcePaths(new IPath[]{this.fProject.getProject().getFullPath()});
        desc.setDeleteContents(true);
        PerformRefactoringOperation op = new PerformRefactoringOperation(desc.createRefactoringContext(new RefactoringStatus()), 6);
        this.execute(op);
        Assert.assertFalse((String)"Project delete failed", (boolean)this.fProject.getProject().exists());
        this.undo();
        Assert.assertTrue((String)"Project was recreated", (boolean)this.fProject.getProject().exists());
        this.redo();
        Assert.assertFalse((String)"Redo delete failed", (boolean)this.fProject.getProject().exists());
    }

    @Test
    public void testProjectClosedDeleteWithContentUndoRedoLTK() throws ExecutionException, CoreException {
        this.fProject.getProject().close(this.getMonitor());
        this.testProjectDeleteWithContentUndoRedoLTK();
    }

    @Test
    public void testPreChangeUndoRedoLTK() throws ExecutionException, CoreException {
        ElementRenameRefactoring ref = new ElementRenameRefactoring(13);
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)ref, 6);
        this.execute(op);
        List<String> h = ElementRenameProcessor.fHistory;
        int i = 0;
        Assert.assertEquals((Object)"mainCreate", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingCreate", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingPreCreatePre", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingPreCreate", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingPreExecPre", (Object)h.get(i++));
        Assert.assertEquals((Object)"mainExec", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingExec", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingPreExec", (Object)h.get(i++));
        this.undo();
        Assert.assertEquals((Object)"workingPreExecUndo", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingExecUndo", (Object)h.get(i++));
        Assert.assertEquals((Object)"mainExecUndo", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingPreExecPreUndo", (Object)h.get(i++));
        this.redo();
        Assert.assertEquals((Object)"workingPreExecPre", (Object)h.get(i++));
        Assert.assertEquals((Object)"mainExec", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingExec", (Object)h.get(i++));
        Assert.assertEquals((Object)"workingPreExec", (Object)h.get(i++));
    }

    private void execute(PerformRefactoringOperation op) throws CoreException {
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, this.getMonitor());
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void undo() throws ExecutionException {
        Assert.assertTrue((String)"Operation can be undone", (boolean)this.history.canUndo(this.context));
        IStatus status = this.history.undo(this.context, this.getMonitor(), null);
        Assert.assertTrue((String)"Undo should be OK status", (boolean)status.isOK());
    }

    private void redo() throws ExecutionException {
        Assert.assertTrue((String)"Operation can be redone", (boolean)this.history.canRedo(this.context));
        IStatus status = this.history.redo(this.context, this.getMonitor(), null);
        Assert.assertTrue((String)"Redo should be OK status", (boolean)status.isOK());
    }

    private IProgressMonitor getMonitor() {
        return null;
    }

    private ResourceSnapshot snapshotFromResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            return new FileSnapshot((IFile)resource);
        }
        if (resource instanceof IFolder) {
            return new FolderSnapshot((IFolder)resource);
        }
        if (resource instanceof IProject) {
            return new ProjectSnapshot((IProject)resource);
        }
        Assert.fail((String)"Unknown resource type");
        return new FileSnapshot((IFile)resource);
    }

    private String readContent(IFile file) throws CoreException {
        InputStream is = file.getContents();
        String encoding = file.getCharset();
        if (is == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));){
                StringBuilder buffer = new StringBuilder();
                char[] part = new char[2048];
                int read = 0;
                while ((read = reader.read(part)) != -1) {
                    buffer.append(part, 0, read);
                }
                return buffer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, RefactoringCoreTestPlugin.getPluginId(), ex.getMessage()));
        }
    }

    private IFileStore getTempStore() {
        IFileStore store = EFS.getLocalFileSystem().getStore(FileSystemHelper.getRandomLocation(FileSystemHelper.getTempDir()));
        this.storesToDelete.add(store);
        return store;
    }

    private void clear(IFileStore store) {
        try {
            store.delete(0, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    class FileSnapshot
    extends ResourceSnapshot {
        String content;
        URI location;
        MarkerSnapshot[] markerSnapshots;

        FileSnapshot(IFile file) throws CoreException {
            this.content = ResourceRefactoringUndoTests.this.readContent(file);
            this.name = file.getName();
            if (file.isLinked()) {
                this.location = file.getLocationURI();
            }
            IMarker[] markers = file.findMarkers(null, true, 2);
            this.markerSnapshots = new MarkerSnapshot[markers.length];
            int i = 0;
            while (i < markers.length) {
                this.markerSnapshots[i] = new MarkerSnapshot(markers[i]);
                ++i;
            }
        }

        @Override
        boolean isValid(IResource parent) throws CoreException {
            IResource resource = this.getWorkspaceRoot().findMember(parent.getFullPath().append(this.name));
            if (resource == null || !(resource instanceof IFile)) {
                return false;
            }
            IFile file = (IFile)resource;
            boolean contentMatch = ResourceRefactoringUndoTests.this.readContent(file).equals(this.content);
            if (file.isLinked()) {
                boolean bl = contentMatch = contentMatch && file.getLocationURI().equals(this.location);
            }
            if (!contentMatch) {
                return false;
            }
            MarkerSnapshot[] markerSnapshotArray = this.markerSnapshots;
            int n = this.markerSnapshots.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerSnapshot markerSnapshot = markerSnapshotArray[n2];
                if (!markerSnapshot.existsOn(resource)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    class FolderSnapshot
    extends ResourceSnapshot {
        URI location;
        ResourceSnapshot[] memberSnapshots;

        FolderSnapshot(IFolder folder) throws CoreException {
            this.name = folder.getName();
            if (folder.isLinked()) {
                this.location = folder.getLocationURI();
            }
            IResource[] members = folder.members();
            this.memberSnapshots = new ResourceSnapshot[members.length];
            int i = 0;
            while (i < members.length) {
                this.memberSnapshots[i] = ResourceRefactoringUndoTests.this.snapshotFromResource(members[i]);
                ++i;
            }
        }

        @Override
        boolean isValid(IResource parent) throws CoreException {
            IResource resource = this.getWorkspaceRoot().findMember(parent.getFullPath().append(this.name));
            if (resource == null || !(resource instanceof IFolder)) {
                return false;
            }
            IFolder folder = (IFolder)resource;
            if (folder.isLinked() && !folder.getLocationURI().equals(this.location)) {
                return false;
            }
            ResourceSnapshot[] resourceSnapshotArray = this.memberSnapshots;
            int n = this.memberSnapshots.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceSnapshot memberSnapshot = resourceSnapshotArray[n2];
                if (!fileNameExcludes.contains(memberSnapshot.name) && !memberSnapshot.isValid((IResource)folder)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    static class MarkerSnapshot {
        String type;
        Map<String, Object> attributes;

        MarkerSnapshot(IMarker marker) throws CoreException {
            this.type = marker.getType();
            this.attributes = marker.getAttributes();
        }

        boolean existsOn(IResource resource) throws CoreException {
            IMarker[] iMarkerArray = resource.findMarkers(this.type, false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.getAttributes().equals(this.attributes)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    class ProjectSnapshot
    extends ResourceSnapshot {
        ResourceSnapshot[] memberSnapshots;

        ProjectSnapshot(IProject project) throws CoreException {
            this.name = project.getName();
            boolean open = project.isOpen();
            if (!open) {
                project.open(null);
            }
            IResource[] members = project.members();
            this.memberSnapshots = new ResourceSnapshot[members.length];
            int i = 0;
            while (i < members.length) {
                this.memberSnapshots[i] = ResourceRefactoringUndoTests.this.snapshotFromResource(members[i]);
                ++i;
            }
            if (!open) {
                project.close(null);
            }
        }

        @Override
        boolean isValid(IResource parent) throws CoreException {
            IResource resource = this.getWorkspaceRoot().findMember(parent.getFullPath().append(this.name));
            if (resource == null || !(resource instanceof IProject)) {
                return false;
            }
            IProject project = (IProject)resource;
            boolean open = project.isOpen();
            if (!open) {
                project.open(null);
            }
            ResourceSnapshot[] resourceSnapshotArray = this.memberSnapshots;
            int n = this.memberSnapshots.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceSnapshot memberSnapshot = resourceSnapshotArray[n2];
                if (!fileNameExcludes.contains(memberSnapshot.name) && !memberSnapshot.isValid(resource)) {
                    return false;
                }
                ++n2;
            }
            if (!open) {
                project.close(null);
            }
            return true;
        }

        boolean isValid() throws CoreException {
            return this.isValid((IResource)this.getWorkspaceRoot());
        }
    }

    static abstract class ResourceSnapshot {
        String name;

        ResourceSnapshot() {
        }

        abstract boolean isValid(IResource var1) throws CoreException;

        IWorkspaceRoot getWorkspaceRoot() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }
}

