/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SimpleTestProject {
    public static final String TEST_PROJECT_NAME = "TestProject";
    private IProject fProject;

    public SimpleTestProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.fProject = root.getProject(TEST_PROJECT_NAME);
        this.fProject.create(null);
        this.fProject.open(null);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IFolder createFolder(String name) throws CoreException {
        return this.createFolder((IContainer)this.fProject, name);
    }

    public IFolder createFolder(IContainer parent, String name) throws CoreException {
        IFolder result = parent.getFolder((IPath)new Path(name));
        result.create(true, true, null);
        return result;
    }

    public IFile createFile(IContainer parent, String name, String content) throws CoreException {
        IFile result = parent.getFile((IPath)new Path(name));
        result.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        return result;
    }

    public void delete() throws CoreException {
        this.fProject.delete(true, true, null);
    }

    public String getContent(IFile file) throws CoreException, IOException {
        StringBuilder result = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStreamReader reader = new InputStreamReader(file.getContents());){
            int amount;
            char[] buffer = new char[1024];
            while ((amount = reader.read(buffer)) != -1) {
                result.append(buffer, 0, amount);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result.toString();
    }
}

