/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyType;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.net.Activator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class NetTest {
    private static final boolean BUG_338097 = true;
    private boolean isSetEnabled;
    private boolean isProxiesDefault;
    private boolean isSystemProxiesDefault;
    private final Map<String, IProxyData> dataCache = new HashMap<String, IProxyData>();

    @BeforeEach
    public void setUp() throws Exception {
        this.isSystemProxiesDefault = this.isSystemProxiesEnabled();
        this.setSystemProxiesEnabled(false);
        this.isProxiesDefault = this.isProxiesEnabled();
        this.setProxiesEnabled(true);
        this.isSetEnabled = true;
        this.dataCache.clear();
        ProxyType.socksSystemPropertySetting = 1;
    }

    @AfterEach
    public void tearDown() throws Exception {
        IProxyData[] data;
        this.setProxiesEnabled(this.isProxiesDefault);
        this.setSystemProxiesEnabled(this.isSystemProxiesDefault);
        IProxyData[] iProxyDataArray = data = this.getProxyManager().getProxyData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            proxyData.disable();
            ++n2;
        }
        this.getProxyManager().setProxyData(data);
    }

    private IProxyService getProxyManager() {
        return Activator.getProxyService();
    }

    private void assertProxyDataEqual(IProxyData expected) {
        ProxyData expectedData = (ProxyData)expected;
        ProxyData data = (ProxyData)this.getProxyManager().getProxyData(expectedData.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getType(), (Object)data.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getHost(), (Object)data.getHost());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedData.getPort(), (int)data.getPort());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getUserId(), (Object)data.getUserId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getPassword(), (Object)data.getPassword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.isRequiresAuthentication(), (Object)data.isRequiresAuthentication());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getSource(), (Object)data.getSource());
        this.assertSystemPropertiesMatch((IProxyData)data);
    }

    public void assertSystemPropertiesMatch(IProxyData proxyData) {
        if (proxyData.getType().equals("HTTP")) {
            this.assertHttpSystemProperties(proxyData, "http");
        } else if (proxyData.getType().equals("HTTPS")) {
            this.assertHttpSystemProperties(proxyData, "https");
        } else if (proxyData.getType().equals("SOCKS")) {
            this.assertSocksSystemProperties(proxyData);
        }
    }

    private void assertHttpSystemProperties(IProxyData proxyData, String keyPrefix) {
        Properties sysProps = System.getProperties();
        if (this.getProxyManager().isProxiesEnabled()) {
            boolean isSet = Boolean.getBoolean(keyPrefix + ".proxySet");
            org.junit.jupiter.api.Assertions.assertEquals((Object)(proxyData.getHost() != null ? 1 : 0), (Object)isSet);
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyData.getHost(), (Object)sysProps.get(keyPrefix + ".proxyHost"));
            String portString = (String)sysProps.get(keyPrefix + ".proxyPort");
            int port = -1;
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)proxyData.getPort(), (int)port);
            if (isSet) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)ProxyType.convertHostsToPropertyString((String[])this.getProxyManager().getNonProxiedHosts()), (Object)sysProps.get(keyPrefix + ".nonProxyHosts"));
            } else {
                org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".nonProxyHosts"));
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyData.getUserId(), (Object)sysProps.get(keyPrefix + ".proxyUser"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyData.getUserId(), (Object)sysProps.get(keyPrefix + ".proxyUserName"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyData.getPassword(), (Object)sysProps.get(keyPrefix + ".proxyPassword"));
        } else {
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".proxySet"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".proxyHost"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".proxyPort"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".nonProxyHosts"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".proxyUser"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".proxyUserName"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get(keyPrefix + ".proxyPassword"));
        }
    }

    private void assertSocksSystemProperties(IProxyData proxyData) {
        Properties sysProps = System.getProperties();
        if (this.getProxyManager().isProxiesEnabled()) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyData.getHost(), (Object)sysProps.get("socksProxyHost"));
            String portString = (String)sysProps.get("socksProxyPort");
            int port = -1;
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)proxyData.getPort(), (int)port);
        } else {
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get("socksProxyHost"));
            org.junit.jupiter.api.Assertions.assertNull((Object)sysProps.get("socksProxyPort"));
        }
    }

    private IProxyData getProxyData(String type) {
        IProxyData data = this.dataCache.get(type);
        if (data == null) {
            data = this.getProxyManager().getProxyData(type);
            this.assertProxyDataEqual(data);
        }
        return data;
    }

    private void setProxyData(IProxyData data) throws CoreException {
        if (this.isSetEnabled) {
            this.getProxyManager().setProxyData(new IProxyData[]{data});
            this.assertProxyDataEqual(data);
        } else {
            this.dataCache.put(data.getType(), data);
        }
    }

    private void disableProxy(IProxyData proxyData) throws CoreException {
        proxyData.disable();
        this.setProxyData(proxyData);
    }

    private void changeProxyData(IProxyData oldData, IProxyData data) throws CoreException {
        if (this.isSetEnabled) {
            this.assertProxyDataEqual(oldData);
        }
        this.setProxyData(data);
    }

    private void setHost(String type) throws CoreException {
        String host = "www.eclipse.org";
        this.setHost(type, host);
    }

    private void setHost(String type, String host) throws CoreException {
        IProxyData data = this.getProxyData(type);
        IProxyData oldData = this.getProxyData(type);
        data.setHost(host);
        this.changeProxyData(oldData, data);
    }

    private void setPort(String type, int port) throws CoreException {
        IProxyData data = this.getProxyData(type);
        IProxyData oldData = this.getProxyData(type);
        data.setPort(port);
        this.changeProxyData(oldData, data);
    }

    private void setUser(String type, String user, String password) throws CoreException {
        IProxyData data = this.getProxyData(type);
        IProxyData oldData = this.getProxyData(type);
        data.setUserid(user);
        data.setPassword(password);
        this.changeProxyData(oldData, data);
    }

    private void setDataTest(String type) throws CoreException {
        this.setHost(type, "www.eclipse.org");
        this.setPort(type, 1024);
        this.setUser(type, "me", "passw0rd");
    }

    private boolean isProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private boolean isSystemProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private void setProxiesEnabled(boolean enabled) {
        this.getProxyManager().setProxiesEnabled(enabled);
        if (enabled && this.getProxyManager().isSystemProxiesEnabled() && !this.getProxyManager().hasSystemProxies()) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)this.getProxyManager().isProxiesEnabled());
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)enabled, (Object)this.getProxyManager().isProxiesEnabled());
        }
    }

    private void setSystemProxiesEnabled(boolean enabled) {
        this.getProxyManager().setSystemProxiesEnabled(enabled);
        org.junit.jupiter.api.Assertions.assertEquals((Object)enabled, (Object)this.getProxyManager().isSystemProxiesEnabled());
    }

    private void delaySettingData() {
        this.isSetEnabled = false;
    }

    private void performSettingData() throws CoreException {
        IProxyData[] data = this.dataCache.values().toArray(new IProxyData[this.dataCache.size()]);
        this.getProxyManager().setProxyData(data);
        IProxyData[] iProxyDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            this.assertProxyDataEqual(proxyData);
            ++n2;
        }
        this.isSetEnabled = true;
        this.dataCache.clear();
    }

    @Test
    public void testIndividualSetAndClear() throws CoreException {
        IProxyData[] data;
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        IProxyData[] iProxyDataArray = data = this.getProxyManager().getProxyData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            this.disableProxy(proxyData);
            ++n2;
        }
    }

    @Test
    public void testAllSetAndClear() throws CoreException {
        IProxyData[] data;
        this.delaySettingData();
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        this.performSettingData();
        this.delaySettingData();
        IProxyData[] iProxyDataArray = data = this.getProxyManager().getProxyData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            this.disableProxy(proxyData);
            ++n2;
        }
        this.performSettingData();
    }

    @Test
    public void testSetWhenDisabled() throws CoreException {
        this.setProxiesEnabled(false);
        String type = "HTTP";
        this.setHost(type);
    }

    @Test
    public void testDisableAfterSet() throws CoreException {
        String type = "HTTP";
        this.setHost(type);
        IProxyData data = this.getProxyManager().getProxyData(type);
        this.setProxiesEnabled(false);
        this.assertProxyDataEqual(data);
    }

    @Test
    @Disabled(value="Disabled due to bug 403311")
    public void _testSimpleHost() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("www.randomhot.com")).hasSize(3);
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("www.randomhot.com", "HTTP")).isNotNull();
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("localhost")).isEmpty();
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("localhost", "HTTP")).isNull();
    }

    @Test
    public void testHostPattern() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        this.getProxyManager().setNonProxiedHosts(new String[]{"*ignore.com"});
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("www.randomhot.com")).hasSize(3);
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("www.randomhot.com", "HTTP")).isNotNull();
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("www.ignore.com")).isEmpty();
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("www.ignore.com", "HTTP")).isNull();
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("ignore.com")).isEmpty();
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("ignore.com", "HTTP")).isNull();
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    @Test
    public void testHostPatternBug505906() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        this.getProxyManager().setNonProxiedHosts(new String[]{"ignore.com"});
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("ignore.com.randomhot.com")).hasSize(3);
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("ignore.com.randomhot.com", "HTTP")).isNotNull();
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("www.ignore.com")).isEmpty();
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("www.ignore.com", "HTTP")).isNull();
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("ignore.com")).isEmpty();
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("ignore.com", "HTTP")).isNull();
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    @Test
    public void testBug238796() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        this.getProxyManager().setNonProxiedHosts(new String[]{"nonexisting.com"});
        Assertions.assertThat((Object[])this.getProxyManager().getProxyDataForHost("NONEXISTING.COM")).isEmpty();
        Assertions.assertThat((Object)this.getProxyManager().getProxyDataForHost("NONEXISTING.COM", "HTTP")).isNull();
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    @Test
    public void testBug247408() throws CoreException, URISyntaxException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        IProxyData data1 = this.getProxyManager().getProxyDataForHost("randomhost.com", "HTTP");
        Object[] data2 = this.getProxyManager().select(new URI("http://randomhost.com"));
        Assertions.assertThat((Object[])data2).singleElement().isEqualTo((Object)data1);
        IProxyData data3 = this.getProxyManager().getProxyDataForHost("randomhost.com", null);
        Object[] data4 = this.getProxyManager().select(new URI(null, "randomhost.com", null, null));
        Assertions.assertThat((Object)data3).isNull();
        Assertions.assertThat((Object[])data4).isEmpty();
    }

    @Test
    public void testBug255981() throws CoreException, URISyntaxException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        this.getProxyManager().setProxiesEnabled(false);
        IProxyData data = this.getProxyManager().getProxyDataForHost("randomhost.com", "HTTP");
        Assertions.assertThat((Object)data).isNull();
        Object[] data2 = this.getProxyManager().select(new URI("http://randomhost.com"));
        Assertions.assertThat((Object[])data2).isEmpty();
        Object[] data3 = this.getProxyManager().getProxyDataForHost("http://randomhost.com");
        Assertions.assertThat((Object[])data3).isEmpty();
    }

    @Test
    public void testBug257503() throws CoreException {
    }

    @Test
    public void testNonProxyHosts() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        String testHost = "bug284540.com";
        ArrayList<String> hostsList = new ArrayList<String>();
        hostsList.addAll(Arrays.asList(oldHosts));
        hostsList.add(testHost);
        String[] newHosts = hostsList.toArray(new String[0]);
        this.getProxyManager().setNonProxiedHosts(newHosts);
        String sysPropNonProxyHosts = System.getProperty("http.nonProxyHosts");
        Assertions.assertThat((String)sysPropNonProxyHosts).contains(new CharSequence[]{testHost});
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    private void validateSystemProperties(boolean present) {
        this.validateProperty("http.proxySet", "true", present);
        this.validateProperty("http.proxyHost", "www.eclipse.org", present);
        this.validateProperty("http.proxyPort", "1024", present);
        this.validateProperty("http.proxyUser", "me", present);
        this.validateProperty("http.proxyUserName", "me", present);
        this.validateProperty("http.proxyPassword", "passw0rd", present);
        this.validateProperty("https.proxySet", "true", present);
        this.validateProperty("https.proxyHost", "www.eclipse.org", present);
        this.validateProperty("https.proxyPort", "1024", present);
        this.validateProperty("https.proxyUser", "me", present);
        this.validateProperty("https.proxyUserName", "me", present);
        this.validateProperty("https.proxyPassword", "passw0rd", present);
        this.validateProperty("socksProxyHost", "www.eclipse.org", present);
        this.validateProperty("socksProxyPort", "1024", present);
    }

    private void validateProperty(String key, String expected, boolean equals) {
        String actual = System.getProperties().getProperty(key);
        if (equals) {
            Assertions.assertThat((String)actual).isEqualTo(expected);
        } else {
            Assertions.assertThat((String)actual).isNotEqualTo((Object)expected);
        }
    }
}

