/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.tests.net.Activator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SystemProxyTest {
    private boolean isProxiesDefault;
    private boolean isSystemProxiesDefault;
    private final Map<String, IProxyData> proxyDataMap = new HashMap<String, IProxyData>();

    @BeforeEach
    public void setUp() throws Exception {
        this.isSystemProxiesDefault = this.isSystemProxiesEnabled();
        this.setSystemProxiesEnabled(true);
        this.isProxiesDefault = this.isProxiesEnabled();
        this.setProxiesEnabled(true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        IProxyData[] data;
        this.setProxiesEnabled(this.isProxiesDefault);
        this.setSystemProxiesEnabled(this.isSystemProxiesDefault);
        IProxyData[] iProxyDataArray = data = this.getProxyManager().getProxyData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            proxyData.disable();
            ++n2;
        }
        this.getProxyManager().setProxyData(data);
    }

    private IProxyService getProxyManager() {
        return Activator.getProxyService();
    }

    private boolean isProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private boolean isSystemProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private void setProxiesEnabled(boolean enabled) {
        this.getProxyManager().setProxiesEnabled(enabled);
        if (enabled && this.getProxyManager().isSystemProxiesEnabled() && !this.getProxyManager().hasSystemProxies()) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)this.getProxyManager().isProxiesEnabled());
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)enabled, (Object)this.getProxyManager().isProxiesEnabled());
        }
    }

    private void setSystemProxiesEnabled(boolean enabled) {
        this.getProxyManager().setSystemProxiesEnabled(enabled);
        org.junit.jupiter.api.Assertions.assertEquals((Object)enabled, (Object)this.getProxyManager().isSystemProxiesEnabled());
    }

    private void assertProxyDataEqual(IProxyData actual, IProxyData expected) {
        ProxyData data = (ProxyData)actual;
        ProxyData expectedData = (ProxyData)expected;
        org.junit.jupiter.api.Assertions.assertTrue((expectedData.getType() == data.getType() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getHost(), (Object)data.getHost());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedData.getPort(), (int)data.getPort());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getUserId(), (Object)data.getUserId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getPassword(), (Object)data.getPassword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.isRequiresAuthentication(), (Object)data.isRequiresAuthentication());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedData.getSource(), (Object)data.getSource());
    }

    private void checkGetProxyDataForHost() {
        this.checkGetProxyDataForHost("http://www.something.org");
        this.checkGetProxyDataForHost("https://www.something.org");
        this.checkGetProxyDataForHost("socks://www.something.org");
        this.checkGetProxyDataForHost("www.something.org");
    }

    private void checkGetProxyDataForHost(String host) {
        IProxyData[] proxiesData = this.getProxyManager().getProxyDataForHost(host);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)proxiesData);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        IProxyData[] iProxyDataArray = proxiesData;
        int n = proxiesData.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData p = iProxyDataArray[n2];
            this.assertProxyDataEqual(p, this.proxyDataMap.get(p.getType()));
            typeMap.put(p.getType(), p.getType());
            ++n2;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)typeMap.size());
    }

    private void checkProxySelector() {
        ProxyData[] proxiesData = ProxySelector.getProxyData((String)"Native");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)proxiesData);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        ProxyData[] proxyDataArray = proxiesData;
        int n = proxiesData.length;
        int n2 = 0;
        while (n2 < n) {
            ProxyData p = proxyDataArray[n2];
            this.assertProxyDataEqual((IProxyData)p, this.proxyDataMap.get(p.getType()));
            typeMap.put(p.getType(), p.getType());
            ++n2;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)typeMap.size());
    }

    @Test
    public void testGetProxyDataForHost_LinuxEnvSettings() {
        this.initializeTestProxyData("LINUX_ENV");
        this.checkGetProxyDataForHost();
    }

    @Test
    public void testProxySelector_LinuxEnvSettings() {
        this.initializeTestProxyData("LINUX_ENV");
        this.checkProxySelector();
    }

    @Test
    public void testGetProxyDataForHost_LinuxGnomeSettings() {
        this.initializeTestProxyData("LINUX_GNOME");
        this.checkGetProxyDataForHost();
    }

    @Test
    public void testProxySelector_LinuxGnomeSettings() {
        this.initializeTestProxyData("LINUX_GNOME");
        this.checkProxySelector();
    }

    @Test
    public void testGetProxyDataForHost_WindowsIEManualSettings() {
        this.initializeTestProxyData("WINDOWS_IE");
        this.checkGetProxyDataForHost();
    }

    @Test
    public void testProxySelector_WindowsIEManualSettings() {
        this.initializeTestProxyData("WINDOWS_IE");
        this.checkProxySelector();
    }

    @Test
    public void testNonProxiedHosts_WindowsIEManualSettings() throws URISyntaxException {
        Assertions.assertThat((Object[])this.getProxyManager().select(new URI("http://eclipse"))).hasSize(1);
        Assertions.assertThat((Object[])this.getProxyManager().select(new URI("http://eclipse.org/bugs"))).isEmpty();
        Assertions.assertThat((Object[])this.getProxyManager().select(new URI("http://nonexisting.com"))).isEmpty();
        Assertions.assertThat((Object[])this.getProxyManager().select(new URI("http://www.eclipse.org"))).isEmpty();
        Assertions.assertThat((Object[])this.getProxyManager().select(new URI("http://www.myDomain.com"))).isEmpty();
        Assertions.assertThat((Object[])this.getProxyManager().select(new URI("http://www.test.edu"))).isEmpty();
    }

    void initializeTestProxyData(String proxyDataSource) {
        this.proxyDataMap.put("HTTP", (IProxyData)new ProxyData("HTTP", "127.0.0.1", 8081, false, proxyDataSource));
        this.proxyDataMap.put("HTTPS", (IProxyData)new ProxyData("HTTPS", "127.0.0.2", 8082, false, proxyDataSource));
        this.proxyDataMap.put("SOCKS", (IProxyData)new ProxyData("SOCKS", "127.0.0.3", 8083, false, proxyDataSource));
    }
}

