/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.editor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.examples.contributions.ContributionMessages;
import org.eclipse.ui.examples.contributions.model.IPersonService;
import org.eclipse.ui.examples.contributions.model.Person;
import org.eclipse.ui.examples.contributions.model.PersonInput;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;

public class InfoEditor
extends EditorPart {
    public static final String ID = "org.eclipse.ui.examples.contributions.editor";
    private static final String EDITOR_RESET_ID = "org.eclipse.ui.examples.contributions.editor.reset";
    private Person person;
    private Text surnameText;
    private Text givennameText;
    private boolean dirty = false;
    private IHandler resetHandler;

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(this.getPartName(), 3);
        this.person.setSurname(this.surnameText.getText());
        monitor.worked(1);
        this.person.setGivenname(this.givennameText.getText());
        monitor.worked(1);
        IPersonService service = (IPersonService)this.getSite().getService(IPersonService.class);
        service.updatePerson(this.person);
        monitor.worked(1);
        monitor.done();
        this.setDirty(false);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (!(input instanceof PersonInput)) {
            throw new PartInitException("Not a person");
        }
        PersonInput pinput = (PersonInput)input;
        IPersonService service = (IPersonService)this.getSite().getService(IPersonService.class);
        this.person = service.getPerson(pinput.getIndex());
        if (this.person == null) {
            throw new PartInitException("person does not exist");
        }
        this.setPartName("Person - " + pinput.getIndex());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean d) {
        this.dirty = d;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode & SWT.MODIFIER_MASK) == 0) {
                    InfoEditor.this.setDirty(true);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        Label l = new Label(composite, 131072);
        l.setText(ContributionMessages.InfoEditor_surname);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.surnameText = new Text(composite, 4);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.surnameText.setLayoutData((Object)gridData);
        this.surnameText.addKeyListener(keyListener);
        l = new Label(composite, 131072);
        l.setText(ContributionMessages.InfoEditor_givenname);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.givennameText = new Text(composite, 4);
        gridData = new GridData(4, 0x1000000, true, false);
        this.givennameText.setLayoutData((Object)gridData);
        this.givennameText.addKeyListener(keyListener);
        this.updateText();
        this.createHandlers();
    }

    private void updateText() {
        this.surnameText.setText(this.person.getSurname());
        this.givennameText.setText(this.person.getGivenname());
    }

    private void createHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.resetHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                InfoEditor.this.updateText();
                InfoEditor.this.setDirty(false);
                return null;
            }
        };
        handlerService.activateHandler(EDITOR_RESET_ID, this.resetHandler);
    }

    public void setFocus() {
        this.surnameText.setFocus();
    }

    public Person getCurrentPerson() {
        this.person.setSurname(this.surnameText.getText());
        this.person.setGivenname(this.givennameText.getText());
        return this.person;
    }
}

