/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.model;

import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.examples.contributions.model.IPersonService;
import org.eclipse.ui.examples.contributions.model.Person;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public class PersonServiceSlave
implements IPersonService,
IDisposable {
    private IServiceLocator serviceLocator;
    private IPersonService parentService;
    private final ListenerList<IPropertyChangeListener> localListeners = new ListenerList(1);

    public PersonServiceSlave(IServiceLocator locator, IPersonService parent) {
        this.serviceLocator = locator;
        this.parentService = parent;
        this.serviceLocator.hasService(IHandlerService.class);
    }

    @Override
    public void addPersonChangeListener(IPropertyChangeListener listener) {
        this.localListeners.add((Object)listener);
        this.parentService.addPersonChangeListener(listener);
    }

    @Override
    public Collection<Person> getPeople() {
        return this.parentService.getPeople();
    }

    @Override
    public Person getPerson(int id) {
        return this.parentService.getPerson(id);
    }

    @Override
    public void removePersonChangeListener(IPropertyChangeListener listener) {
        this.localListeners.remove((Object)listener);
        this.parentService.removePersonChangeListener(listener);
    }

    @Override
    public void updatePerson(Person person) {
        this.parentService.updatePerson(person);
    }

    @Override
    public Person createPerson(int id) {
        return this.parentService.createPerson(id);
    }

    public void dispose() {
        Object[] array = this.localListeners.getListeners();
        this.localListeners.clear();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            this.parentService.removePersonChangeListener((IPropertyChangeListener)a);
            ++n2;
        }
        this.serviceLocator = null;
        this.parentService = null;
    }

    @Override
    public void login(Person person) {
        this.parentService.login(person);
    }
}

