/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.examples.contributions.ContributionMessages;
import org.eclipse.ui.examples.contributions.model.IPersonService;
import org.eclipse.ui.examples.contributions.model.Person;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class InfoView
extends ViewPart {
    public static final String ID = "org.eclipse.ui.examples.contributions.view";
    private static final String VIEW_COUNT_ID = "org.eclipse.ui.examples.contributions.view.count";
    private static final String VIEW_CONTEXT_ID = "org.eclipse.ui.examples.contributions.view.context";
    private ListViewer viewer;
    private IHandler countHandler;
    private ArrayList<Object> viewerInput;
    private final IPropertyChangeListener personListener = event -> {
        if ("change".equals(event.getProperty())) {
            this.refresh();
        } else if ("add".equals(event.getProperty())) {
            this.viewerInput.add(event.getNewValue());
            this.viewer.add(event.getNewValue());
        }
    };

    public void createPartControl(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addDoubleClickListener(event -> this.editSelection());
        IPersonService service = (IPersonService)this.getSite().getService(IPersonService.class);
        this.viewerInput = new ArrayList<Person>(service.getPeople());
        service.addPersonChangeListener(this.personListener);
        this.viewer.setInput(this.viewerInput);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.activateContext();
        this.createHandlers();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(VIEW_CONTEXT_ID);
    }

    private void createHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.countHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                List elements = (List)InfoView.this.viewer.getInput();
                MessageDialog.openInformation((Shell)InfoView.this.getSite().getShell(), (String)ContributionMessages.SampleHandler_plugin_name, (String)NLS.bind((String)ContributionMessages.InfoView_countElements, (Object)elements.size()));
                return null;
            }
        };
        handlerService.activateHandler(VIEW_COUNT_ID, this.countHandler);
    }

    public void dispose() {
        if (this.countHandler != null) {
            this.countHandler.dispose();
            this.countHandler = null;
        }
        super.dispose();
    }

    public void swap(Person p1, Person p2) {
        ArrayList<Object> elements = this.viewerInput;
        int i1 = elements.indexOf(p1);
        int i2 = elements.indexOf(p2);
        Collections.swap(elements, i1, i2);
        this.viewer.refresh();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    private void editSelection() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        try {
            handlerService.executeCommand("org.eclipse.ui.examples.contributions.view.edit", null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
            // empty catch block
        }
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return null;
        }
    }
}

