/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleValueAdapter;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AccessibleValueExample {
    private static int value = 40;
    private static int min = 0;
    private static int max = 100;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Accessible Value Example");
        final Canvas canvas = new Canvas((Composite)shell, 0x20000000);
        canvas.addPaintListener(e -> {
            Rectangle rect = canvas.getClientArea();
            String val = String.valueOf(value);
            Point size = e.gc.stringExtent(val);
            e.gc.setBackground(e.display.getSystemColor(26));
            e.gc.fillRectangle(0, 0, rect.width * value / (max - min), rect.height);
            e.gc.drawString(val, rect.x + (rect.width - size.x) / 2, rect.y + (rect.height - size.y) / 2, true);
        });
        Accessible accessible = canvas.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "The value of this canvas is " + value;
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 48;
            }
        });
        accessible.addAccessibleValueListener((AccessibleValueListener)new AccessibleValueAdapter(){

            public void setCurrentValue(AccessibleValueEvent e) {
                value = e.value.intValue();
                canvas.redraw();
            }

            public void getMinimumValue(AccessibleValueEvent e) {
                e.value = min;
            }

            public void getMaximumValue(AccessibleValueEvent e) {
                e.value = max;
            }

            public void getCurrentValue(AccessibleValueEvent e) {
                e.value = value;
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

