/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import java.util.EventListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.accessibility.CTableColumn;
import org.eclipse.swt.examples.accessibility.CTableItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;

public class CTable
extends Composite {
    Canvas header;
    CTableColumn[] columns = new CTableColumn[0];
    CTableColumn[] orderedColumns;
    CTableItem[] items = new CTableItem[0];
    CTableItem[] selectedItems = new CTableItem[0];
    CTableItem focusItem;
    CTableItem anchorItem;
    CTableItem lastClickedItem;
    Event lastSelectionEvent;
    boolean linesVisible;
    boolean ignoreKey;
    boolean ignoreDispose;
    boolean customHeightSet;
    int itemsCount = 0;
    int topIndex = 0;
    int horizontalOffset = 0;
    int fontHeight = 0;
    int imageHeight = 0;
    int itemHeight = 0;
    int col0ImageWidth = 0;
    int headerImageHeight = 0;
    CTableColumn resizeColumn;
    int resizeColumnX = -1;
    int drawCount = 0;
    CTableColumn sortColumn;
    int sortDirection = 0;
    Listener toolTipListener;
    Shell toolTipShell;
    Label toolTipLabel;
    Rectangle arrowBounds;
    Rectangle checkboxBounds;
    Rectangle clientArea;
    static final int MARGIN_IMAGE = 3;
    static final int MARGIN_CELL = 1;
    static final int SIZE_HORIZONTALSCROLL = 5;
    static final int TOLLERANCE_COLUMNRESIZE = 2;
    static final int WIDTH_HEADER_SHADOW = 2;
    static final int WIDTH_CELL_HIGHLIGHT = 1;
    static final int[] toolTipEvents = new int[]{7, 32, 5, 3};
    static final String ELLIPSIS = "...";
    static final String ID_UNCHECKED = "UNCHECKED";
    static final String ID_GRAYUNCHECKED = "GRAYUNCHECKED";
    static final String ID_CHECKMARK = "CHECKMARK";
    static final String ID_ARROWUP = "ARROWUP";
    static final String ID_ARROWDOWN = "ARROWDOWN";
    Display display;
    boolean hasFocus;

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public CTable(Composite parent, int style) {
        super(parent, CTable.checkStyle(style));
        ScrollBar vBar;
        this.display = parent.getDisplay();
        this.setForeground(null);
        this.setBackground(null);
        GC gc = new GC((Drawable)this);
        this.fontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
        this.itemHeight = this.fontHeight + 2 * this.getCellPadding();
        CTable.initImages(this.display);
        this.checkboxBounds = this.getUncheckedImage().getBounds();
        this.arrowBounds = this.getArrowDownImage().getBounds();
        this.clientArea = this.getClientArea();
        Listener listener = this::handleEvents;
        this.addListener(9, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(8, listener);
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.addListener(1, listener);
        this.addListener(16, listener);
        this.addListener(15, listener);
        this.addListener(31, listener);
        this.initAccessibility();
        this.header = new Canvas((Composite)this, 0x180000);
        this.header.setVisible(false);
        this.header.setBounds(0, 0, 0, this.fontHeight + 2 * this.getHeaderPadding());
        this.header.addListener(9, listener);
        this.header.addListener(3, listener);
        this.header.addListener(4, listener);
        this.header.addListener(32, listener);
        this.header.addListener(8, listener);
        this.header.addListener(5, listener);
        this.header.addListener(7, listener);
        this.header.addListener(35, listener);
        this.toolTipListener = event -> {
            switch (event.type) {
                case 5: 
                case 32: {
                    if (this.headerUpdateToolTip(event.x)) break;
                }
                case 3: 
                case 7: {
                    this.headerHideToolTip();
                }
            }
        };
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setValues(0, 0, 1, 1, 1, 1);
            hBar.setVisible(false);
            hBar.addListener(13, listener);
        }
        if ((vBar = this.getVerticalBar()) != null) {
            vBar.setValues(0, 0, 1, 1, 1, 1);
            vBar.setVisible(false);
            vBar.addListener(13, listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13, 14});
    }

    boolean checkData(CTableItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.getStyle() & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = this.indexOf(item);
            this.notifyListeners(36, event);
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw) {
                this.redrawItem(item.index, false);
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        style |= 0x20140000;
        return CTable.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    public void clear(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            SWT.error((int)6);
        }
        Rectangle bounds = this.items[index].getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        this.items[index].clear();
        if (this.columns.length == 0) {
            this.updateHorizontalBar(0, -oldRightX);
        }
        this.redrawItem(index, false);
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemsCount) {
            SWT.error((int)6);
        }
        int i = start;
        while (i <= end) {
            this.items[i].clear();
            ++i;
        }
        this.updateHorizontalBar();
        this.redrawItems(start, end, false);
    }

    public void clear(int[] indices) {
        int index;
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemsCount) {
                SWT.error((int)6);
            }
            ++i;
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            index = nArray[n2];
            this.items[index].clear();
            ++n2;
        }
        this.updateHorizontalBar();
        nArray = indices;
        n = indices.length;
        n2 = 0;
        while (n2 < n) {
            index = nArray[n2];
            this.redrawItem(index, false);
            ++n2;
        }
    }

    public void clearAll() {
        this.checkWidget();
        this.clear(0, this.itemsCount - 1);
    }

    int computeColumnIntersect(int x, int startColumn) {
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        if (orderedColumns.length - 1 < startColumn) {
            return -1;
        }
        int rightX = orderedColumns[startColumn].getX();
        int i = startColumn;
        while (i < orderedColumns.length) {
            if (x < (rightX += orderedColumns[i].width)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint != -1) {
            width = wHint;
        } else if (this.columns.length == 0) {
            int i = 0;
            while (i < this.itemsCount) {
                Rectangle itemBounds = this.items[i].getBounds(false);
                width = Math.max(width, itemBounds.x + itemBounds.width);
                ++i;
            }
        } else {
            CTableColumn[] orderedColumns = this.getOrderedColumns();
            CTableColumn lastColumn = orderedColumns[orderedColumns.length - 1];
            width = lastColumn.getX() + lastColumn.width;
        }
        height = hHint != -1 ? hHint : this.getHeaderHeight() + this.itemsCount * this.itemHeight;
        Rectangle result = this.computeTrim(0, 0, width, height);
        return new Point(result.width, result.height);
    }

    void createItem(CTableColumn column, int index) {
        CTableColumn[] newColumns = new CTableColumn[this.columns.length + 1];
        System.arraycopy(this.columns, 0, newColumns, 0, index);
        newColumns[index] = column;
        System.arraycopy(this.columns, index, newColumns, index + 1, this.columns.length - index);
        this.columns = newColumns;
        if (this.orderedColumns != null) {
            int insertIndex = 0;
            if (index > 0) {
                insertIndex = this.columns[index - 1].getOrderIndex() + 1;
            }
            CTableColumn[] newOrderedColumns = new CTableColumn[this.orderedColumns.length + 1];
            System.arraycopy(this.orderedColumns, 0, newOrderedColumns, 0, insertIndex);
            newOrderedColumns[insertIndex] = column;
            System.arraycopy(this.orderedColumns, insertIndex, newOrderedColumns, insertIndex + 1, this.orderedColumns.length - insertIndex);
            this.orderedColumns = newOrderedColumns;
        }
        int i = 0;
        while (i < this.itemsCount) {
            this.items[i].addColumn(column);
            ++i;
        }
        if (this.columns.length == 1 && this.itemsCount > 0) {
            this.redrawFromItemDownwards(this.topIndex);
        } else if (this.itemsCount > 0 && (this.getStyle() & 0x20) != 0 && index == 0 && column.getOrderIndex() == 0) {
            this.redrawFromItemDownwards(this.topIndex);
        }
        int[] eventData = new int[]{0, 0, 0, index, 1};
        this.getAccessible().sendEvent(518, (Object)eventData);
    }

    void createItem(CTableItem item) {
        int index = item.index;
        if (this.itemsCount == this.items.length) {
            int grow = this.drawCount <= 0 ? 4 : Math.max(4, this.items.length * 3 / 2);
            CTableItem[] newItems = new CTableItem[this.items.length + grow];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if (index != this.itemsCount) {
            System.arraycopy(this.items, index, this.items, index + 1, this.itemsCount - index);
        }
        this.items[index] = item;
        ++this.itemsCount;
        int i = index + 1;
        while (i < this.itemsCount) {
            this.items[i].index = i;
            ++i;
        }
        int[] eventData = new int[]{0, index, 1, 0, 0};
        this.getAccessible().sendEvent(518, (Object)eventData);
        this.updateVerticalBar();
        Rectangle bounds = item.getBounds(false);
        int rightX = bounds.x + bounds.width;
        this.updateHorizontalBar(rightX, rightX);
        if (item.index < this.topIndex) {
            ++this.topIndex;
            ScrollBar vBar = this.getVerticalBar();
            if (vBar != null) {
                vBar.setSelection(this.topIndex);
            }
            return;
        }
        if (this.itemsCount == 1 && this.isFocusControl()) {
            this.focusItem = item;
            this.redraw();
            return;
        }
        if (item.isInViewport()) {
            this.redrawFromItemDownwards(index);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            return;
        }
        CTableItem item = this.items[index];
        int selectIndex = this.getSelectionIndex(item);
        if (selectIndex == -1) {
            return;
        }
        CTableItem[] newSelectedItems = new CTableItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, selectIndex);
        System.arraycopy(this.selectedItems, selectIndex + 1, newSelectedItems, selectIndex, newSelectedItems.length - selectIndex);
        this.selectedItems = newSelectedItems;
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            this.redrawItem(item.index, false);
        }
        this.getAccessible().selectionChanged();
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.itemsCount - 1) {
            this.deselectAll();
        } else {
            start = Math.max(start, 0);
            end = Math.min(end, this.itemsCount - 1);
            int i = start;
            while (i <= end) {
                this.deselect(i);
                ++i;
            }
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            this.deselect(index);
            ++n2;
        }
    }

    public void deselectAll() {
        CTableItem element;
        int n;
        int n2;
        CTableItem[] cTableItemArray;
        this.checkWidget();
        CTableItem[] oldSelection = this.selectedItems;
        this.selectedItems = new CTableItem[0];
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            cTableItemArray = oldSelection;
            n2 = oldSelection.length;
            n = 0;
            while (n < n2) {
                element = cTableItemArray[n];
                this.redrawItem(element.index, true);
                ++n;
            }
        }
        cTableItemArray = oldSelection;
        n2 = oldSelection.length;
        n = 0;
        while (n < n2) {
            element = cTableItemArray[n];
            element.getAccessible(this.getAccessible(), 0).selectionChanged();
            ++n;
        }
        if (oldSelection.length > 0) {
            this.getAccessible().selectionChanged();
        }
    }

    void deselectItem(CTableItem item) {
        int index = this.getSelectionIndex(item);
        if (index == -1) {
            return;
        }
        CTableItem[] newSelectedItems = new CTableItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, index);
        System.arraycopy(this.selectedItems, index + 1, newSelectedItems, index, newSelectedItems.length - index);
        this.selectedItems = newSelectedItems;
        item.getAccessible(this.getAccessible(), 0).selectionChanged();
    }

    void destroyItem(CTableColumn column) {
        this.headerHideToolTip();
        int index = column.getIndex();
        int orderedIndex = column.getOrderIndex();
        CTableColumn[] newColumns = new CTableColumn[this.columns.length - 1];
        System.arraycopy(this.columns, 0, newColumns, 0, index);
        System.arraycopy(this.columns, index + 1, newColumns, index, newColumns.length - index);
        this.columns = newColumns;
        if (this.orderedColumns != null) {
            if (this.columns.length < 2) {
                this.orderedColumns = null;
            } else {
                int removeIndex = column.getOrderIndex();
                CTableColumn[] newOrderedColumns = new CTableColumn[this.orderedColumns.length - 1];
                System.arraycopy(this.orderedColumns, 0, newOrderedColumns, 0, removeIndex);
                System.arraycopy(this.orderedColumns, removeIndex + 1, newOrderedColumns, removeIndex, newOrderedColumns.length - removeIndex);
                this.orderedColumns = newOrderedColumns;
            }
        }
        if (index == 0 && this.columns.length > 0) {
            int style = this.columns[0].getStyle();
            style |= 0x4000;
            this.columns[0].setStyle(style &= 0xFEFDFFFF);
        }
        int i = 0;
        while (i < this.itemsCount) {
            this.items[i].removeColumn(column, index);
            ++i;
        }
        int lastColumnIndex = this.columns.length - 1;
        if (lastColumnIndex < 0) {
            this.updateHorizontalBar();
        } else {
            int selection;
            int newWidth = 0;
            CTableColumn[] cTableColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                CTableColumn column2 = cTableColumnArray[n2];
                newWidth += column2.width;
                ++n2;
            }
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setMaximum(newWidth);
                hBar.setVisible(this.clientArea.width < newWidth);
            }
            if ((selection = hBar.getSelection()) != this.horizontalOffset) {
                this.horizontalOffset = selection;
                this.redraw();
                if (this.header.isVisible() && this.drawCount <= 0) {
                    this.header.redraw();
                }
            }
        }
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        int i2 = orderedIndex;
        while (i2 < orderedColumns.length) {
            if (!orderedColumns[i2].isDisposed()) {
                orderedColumns[i2].notifyListeners(10, new Event());
            }
            ++i2;
        }
        int[] eventData = new int[]{1, 0, 0, index, 1};
        this.getAccessible().sendEvent(518, (Object)eventData);
        if (this.sortColumn == column) {
            this.sortColumn = null;
        }
    }

    void destroyItem(CTableItem item) {
        if (item == this.focusItem) {
            this.reassignFocus();
        }
        int index = item.index;
        Rectangle bounds = item.getBounds(false);
        int rightX = bounds.x + bounds.width;
        if (index != this.itemsCount - 1) {
            System.arraycopy(this.items, index + 1, this.items, index, this.itemsCount - index - 1);
            this.items[this.itemsCount - 1] = null;
        } else {
            this.items[index] = null;
        }
        --this.itemsCount;
        if (this.drawCount <= 0 && this.items.length - this.itemsCount == 4) {
            CTableItem[] newItems = new CTableItem[this.itemsCount];
            System.arraycopy(this.items, 0, newItems, 0, newItems.length);
            this.items = newItems;
        }
        int i = index;
        while (i < this.itemsCount) {
            this.items[i].index = i;
            ++i;
        }
        item.index = -1;
        int oldTopIndex = this.topIndex;
        this.updateVerticalBar();
        this.updateHorizontalBar(0, -rightX);
        if (index < this.topIndex) {
            this.topIndex = oldTopIndex - 1;
            ScrollBar vBar = this.getVerticalBar();
            if (vBar != null) {
                vBar.setSelection(this.topIndex);
            }
        }
        if (item.isSelected()) {
            int selectionIndex = this.getSelectionIndex(item);
            CTableItem[] newSelectedItems = new CTableItem[this.selectedItems.length - 1];
            System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, selectionIndex);
            System.arraycopy(this.selectedItems, selectionIndex + 1, newSelectedItems, selectionIndex, newSelectedItems.length - selectionIndex);
            this.selectedItems = newSelectedItems;
        }
        if (item == this.anchorItem) {
            this.anchorItem = null;
        }
        if (item == this.lastClickedItem) {
            this.lastClickedItem = null;
        }
        if (this.itemsCount == 0 && this.isFocusControl()) {
            this.redraw();
        }
        int[] eventData = new int[]{1, index, 1, 0, 0};
        this.getAccessible().sendEvent(518, (Object)eventData);
    }

    Image getArrowDownImage() {
        return (Image)this.display.getData(ID_ARROWDOWN);
    }

    Image getArrowUpImage() {
        return (Image)this.display.getData(ID_ARROWUP);
    }

    int getCellPadding() {
        return 2;
    }

    Image getCheckmarkImage() {
        return (Image)this.display.getData(ID_CHECKMARK);
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] controls = super.getChildren();
        if (this.header == null) {
            return controls;
        }
        Control[] result = new Control[controls.length - 1];
        int index = 0;
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != this.header) {
                result[index++] = control;
            }
            ++n2;
        }
        return result;
    }

    public CTableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columns.length) {
            SWT.error((int)6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.length;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] result = new int[this.columns.length];
        if (this.orderedColumns != null) {
            int i = 0;
            while (i < result.length) {
                result[i] = this.orderedColumns[i].getIndex();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.columns.length) {
                result[i] = i;
                ++i;
            }
        }
        return result;
    }

    public CTableColumn[] getColumns() {
        this.checkWidget();
        CTableColumn[] result = new CTableColumn[this.columns.length];
        System.arraycopy(this.columns, 0, result, 0, this.columns.length);
        return result;
    }

    Image getGrayUncheckedImage() {
        return (Image)this.display.getData(ID_GRAYUNCHECKED);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.header.getVisible()) {
            return 0;
        }
        return this.header.getSize().y;
    }

    int getHeaderPadding() {
        return 3;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.header.getVisible();
    }

    public CTableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            SWT.error((int)6);
        }
        return this.items[index];
    }

    public CTableItem getItem(Point point) {
        int index;
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        if ((index = (point.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || index >= this.itemsCount) {
            return null;
        }
        CTableItem result = this.items[index];
        if (!result.getHitBounds().contains(point)) {
            return null;
        }
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemsCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.itemHeight;
    }

    public CTableItem[] getItems() {
        this.checkWidget();
        CTableItem[] result = new CTableItem[this.itemsCount];
        System.arraycopy(this.items, 0, result, 0, this.itemsCount);
        return result;
    }

    int getItemY(CTableItem item) {
        return (item.index - this.topIndex) * this.itemHeight + this.getHeaderHeight();
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    CTableColumn[] getOrderedColumns() {
        if (this.orderedColumns != null) {
            return this.orderedColumns;
        }
        return this.columns;
    }

    public CTableItem[] getSelection() {
        this.checkWidget();
        CTableItem[] result = new CTableItem[this.selectedItems.length];
        System.arraycopy(this.selectedItems, 0, result, 0, this.selectedItems.length);
        this.sortAscent(result);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selectedItems.length;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.selectedItems.length == 0) {
            return -1;
        }
        return this.selectedItems[0].index;
    }

    int getSelectionIndex(CTableItem item) {
        int i = 0;
        while (i < this.selectedItems.length) {
            if (this.selectedItems[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] result = new int[this.selectedItems.length];
        int i = 0;
        while (i < this.selectedItems.length) {
            result[i] = this.selectedItems[i].index;
            ++i;
        }
        this.sortAscent(result);
        return result;
    }

    public CTableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    Image getUncheckedImage() {
        return (Image)this.display.getData(ID_UNCHECKED);
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 9: {
                if (event.widget == this.header) {
                    this.headerOnPaint(event);
                    break;
                }
                this.onPaint(event);
                break;
            }
            case 35: {
                this.notifyListeners(35, event);
                break;
            }
            case 3: {
                if (event.widget == this.header) {
                    this.headerOnMouseDown(event);
                    break;
                }
                this.onMouseDown(event);
                break;
            }
            case 4: {
                if (event.widget == this.header) {
                    this.headerOnMouseUp(event);
                    break;
                }
                this.onMouseUp(event);
                break;
            }
            case 32: {
                this.headerOnMouseHover(event);
                break;
            }
            case 5: {
                this.headerOnMouseMove(event);
                break;
            }
            case 8: {
                if (event.widget == this.header) {
                    this.headerOnMouseDoubleClick(event);
                    break;
                }
                this.onMouseDoubleClick(event);
                break;
            }
            case 7: {
                this.headerOnMouseExit();
                break;
            }
            case 12: {
                this.onDispose(event);
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 11: {
                this.onResize(event);
                break;
            }
            case 13: {
                if (event.widget == this.getHorizontalBar()) {
                    this.onScrollHorizontal(event);
                }
                if (event.widget != this.getVerticalBar()) break;
                this.onScrollVertical(event);
                break;
            }
            case 16: {
                this.onFocusOut();
                break;
            }
            case 15: {
                this.onFocusIn();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                    }
                }
            }
        }
    }

    String headerGetToolTip(int x) {
        int columnRightX;
        if (this.resizeColumn != null) {
            return null;
        }
        int orderedIndex = this.computeColumnIntersect(x, 0);
        if (orderedIndex == -1) {
            return null;
        }
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        CTableColumn column = orderedColumns[orderedIndex];
        if (column.toolTipText == null) {
            return null;
        }
        int columnX = column.getX();
        if (orderedIndex > 0 && orderedColumns[orderedIndex - 1].resizable && x - columnX <= 2) {
            return null;
        }
        if (column.resizable && (columnRightX = columnX + column.width) - x <= 2) {
            return null;
        }
        return this.removeMnemonics(column.toolTipText);
    }

    void headerHideToolTip() {
        if (this.toolTipShell == null) {
            return;
        }
        int[] nArray = toolTipEvents;
        int n = toolTipEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int toolTipEvent = nArray[n2];
            this.header.removeListener(toolTipEvent, this.toolTipListener);
            ++n2;
        }
        this.toolTipShell.dispose();
        this.toolTipShell = null;
        this.toolTipLabel = null;
    }

    void headerOnMouseDoubleClick(Event event) {
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if (this.columns.length == 0) {
            return;
        }
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        int x = -this.horizontalOffset;
        int i = 0;
        while (i < orderedColumns.length) {
            CTableColumn column = orderedColumns[i];
            if (event.x < (x += column.width)) {
                CTableColumn packColumn = null;
                if (x - event.x <= 2) {
                    packColumn = column;
                } else if (i > 0 && event.x - column.getX() <= 2) {
                    packColumn = orderedColumns[i - 1];
                }
                if (packColumn != null) {
                    packColumn.pack();
                    this.resizeColumn = null;
                    if (Math.abs(packColumn.getX() + packColumn.width - event.x) > 2) {
                        this.setCursor(null);
                    }
                    return;
                }
                Event newEvent = new Event();
                newEvent.widget = column;
                column.notifyListeners(14, newEvent);
                return;
            }
            ++i;
        }
    }

    void headerOnMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        int x = -this.horizontalOffset;
        CTableColumn[] cTableColumnArray = orderedColumns;
        int n = orderedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            CTableColumn column = cTableColumnArray[n2];
            if (column.resizable && Math.abs((x += column.width) - event.x) <= 2) {
                this.resizeColumn = column;
                this.resizeColumnX = x;
                return;
            }
            if (event.x < x) {
                if (column.moveable) {
                    int columnX = column.getX();
                    int pointerOffset = event.x - columnX;
                    this.headerHideToolTip();
                    Tracker tracker = new Tracker((Composite)this, 0);
                    tracker.setRectangles(new Rectangle[]{new Rectangle(columnX, 0, column.width, this.getHeaderHeight())});
                    if (!tracker.open()) {
                        return;
                    }
                    Rectangle result = tracker.getRectangles()[0];
                    int pointerX = result.x + pointerOffset;
                    if (pointerX < 0) {
                        return;
                    }
                    x = -this.horizontalOffset;
                    int destIndex = 0;
                    while (destIndex < orderedColumns.length) {
                        CTableColumn destColumn = orderedColumns[destIndex];
                        if (pointerX < (x += destColumn.width)) {
                            int oldIndex = column.getOrderIndex();
                            if (destIndex == oldIndex) {
                                Event newEvent = new Event();
                                newEvent.widget = column;
                                column.notifyListeners(13, newEvent);
                                return;
                            }
                            int leftmostIndex = Math.min(destIndex, oldIndex);
                            int[] oldOrder = this.getColumnOrder();
                            int[] newOrder = new int[oldOrder.length];
                            System.arraycopy(oldOrder, 0, newOrder, 0, leftmostIndex);
                            if (leftmostIndex == oldIndex) {
                                System.arraycopy(oldOrder, oldIndex + 1, newOrder, oldIndex, destIndex - oldIndex);
                            } else {
                                System.arraycopy(oldOrder, destIndex, newOrder, destIndex + 1, oldIndex - destIndex);
                            }
                            newOrder[destIndex] = oldOrder[oldIndex];
                            int rightmostIndex = Math.max(destIndex, oldIndex);
                            System.arraycopy(oldOrder, rightmostIndex + 1, newOrder, rightmostIndex + 1, newOrder.length - rightmostIndex - 1);
                            this.setColumnOrder(newOrder);
                            return;
                        }
                        ++destIndex;
                    }
                    return;
                }
                Event newEvent = new Event();
                newEvent.widget = column;
                column.notifyListeners(13, newEvent);
                return;
            }
            ++n2;
        }
    }

    void headerOnMouseExit() {
        if (this.resizeColumn != null) {
            return;
        }
        this.setCursor(null);
    }

    void headerOnMouseHover(Event event) {
        this.headerShowToolTip(event.x);
    }

    void headerOnMouseMove(Event event) {
        if (this.resizeColumn == null) {
            CTableColumn[] cTableColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                CTableColumn column = cTableColumnArray[n2];
                int x = column.getX() + column.width;
                if (Math.abs(x - event.x) <= 2) {
                    if (column.resizable) {
                        this.setCursor(this.display.getSystemCursor(9));
                    } else {
                        this.setCursor(null);
                    }
                    return;
                }
                ++n2;
            }
            this.setCursor(null);
            return;
        }
        if (event.x <= this.resizeColumn.getX()) {
            return;
        }
        GC gc = new GC((Drawable)this);
        gc.setForeground(this.display.getSystemColor(2));
        int lineHeight = this.clientArea.height;
        this.redraw(this.resizeColumnX - 1, 0, 1, lineHeight, false);
        this.resizeColumnX = event.x;
        gc.drawLine(this.resizeColumnX - 1, 0, this.resizeColumnX - 1, lineHeight);
        gc.dispose();
    }

    void headerOnMouseUp(Event event) {
        if (this.resizeColumn == null) {
            return;
        }
        GC gc = new GC((Drawable)this);
        this.redraw(this.resizeColumnX - 1, 0, 1, this.clientArea.height, false);
        gc.dispose();
        int newWidth = this.resizeColumnX - this.resizeColumn.getX();
        if (newWidth != this.resizeColumn.width) {
            this.setCursor(null);
            this.updateColumnWidth(this.resizeColumn, newWidth);
        }
        this.resizeColumnX = -1;
        this.resizeColumn = null;
    }

    void headerOnPaint(Event event) {
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        int numColumns = orderedColumns.length;
        GC gc = event.gc;
        Rectangle clipping = gc.getClipping();
        int startColumn = -1;
        int endColumn = -1;
        if (numColumns > 0) {
            startColumn = this.computeColumnIntersect(clipping.x, 0);
            if (startColumn != -1 && (endColumn = this.computeColumnIntersect(clipping.x + clipping.width, startColumn)) == -1) {
                endColumn = numColumns - 1;
            }
        } else {
            endColumn = 0;
            startColumn = 0;
        }
        Point headerSize = this.header.getSize();
        this.headerPaintHShadows(gc, 0, 0, headerSize.x, headerSize.y);
        if (startColumn == -1) {
            return;
        }
        if (numColumns == 0) {
            return;
        }
        int i = startColumn;
        while (i <= endColumn) {
            this.headerPaintVShadows(gc, orderedColumns[i].getX(), 0, orderedColumns[i].width, headerSize.y);
            orderedColumns[i].paint(gc);
            ++i;
        }
    }

    void headerPaintHShadows(GC gc, int x, int y, int width, int height) {
        gc.setClipping(x, y, width, height);
        int endX = x + width;
        gc.setForeground(this.display.getSystemColor(20));
        gc.drawLine(x, y, endX, y);
        gc.setForeground(this.display.getSystemColor(18));
        gc.drawLine(x, height - 2, endX, height - 2);
        gc.setForeground(this.display.getSystemColor(17));
        gc.drawLine(x, height - 1, endX, height - 1);
    }

    void headerPaintVShadows(GC gc, int x, int y, int width, int height) {
        gc.setClipping(x, y, width, height);
        int endX = x + width;
        gc.setForeground(this.display.getSystemColor(20));
        gc.drawLine(x, y, x, y + height - 1);
        gc.setForeground(this.display.getSystemColor(18));
        gc.drawLine(endX - 2, y + 1, endX - 2, height - 2);
        gc.setForeground(this.display.getSystemColor(17));
        gc.drawLine(endX - 1, y, endX - 1, height - 1);
    }

    void headerShowToolTip(int x) {
        String tooltip = this.headerGetToolTip(x);
        if (tooltip == null || tooltip.length() == 0) {
            return;
        }
        if (this.toolTipShell == null) {
            this.toolTipShell = new Shell(this.getShell(), 16388);
            this.toolTipLabel = new Label((Composite)this.toolTipShell, 0x1000000);
            Display display = this.toolTipShell.getDisplay();
            this.toolTipLabel.setForeground(display.getSystemColor(28));
            this.toolTipLabel.setBackground(display.getSystemColor(29));
            int[] nArray = toolTipEvents;
            int n = toolTipEvents.length;
            int n2 = 0;
            while (n2 < n) {
                int toolTipEvent = nArray[n2];
                this.header.addListener(toolTipEvent, this.toolTipListener);
                ++n2;
            }
        }
        if (this.headerUpdateToolTip(x)) {
            this.toolTipShell.setVisible(true);
        } else {
            this.headerHideToolTip();
        }
    }

    boolean headerUpdateToolTip(int x) {
        String tooltip = this.headerGetToolTip(x);
        if (tooltip == null || tooltip.length() == 0) {
            return false;
        }
        if (tooltip.equals(this.toolTipLabel.getText())) {
            return true;
        }
        this.toolTipLabel.setText(tooltip);
        CTableColumn column = this.getOrderedColumns()[this.computeColumnIntersect(x, 0)];
        this.toolTipShell.setData((Object)column.getIndex());
        Point labelSize = this.toolTipLabel.computeSize(-1, -1, true);
        labelSize.x += 2;
        labelSize.y += 2;
        this.toolTipLabel.setSize(labelSize);
        this.toolTipShell.pack();
        Rectangle area = this.toolTipShell.getClientArea();
        this.toolTipLabel.setSize(area.width, area.height);
        Point cursorLocation = this.getDisplay().getCursorLocation();
        int cursorHeight = 21;
        Point size = this.toolTipShell.getSize();
        Rectangle rect = this.getMonitor().getBounds();
        Point pt = new Point(cursorLocation.x, cursorLocation.y + cursorHeight + 2);
        pt.x = Math.max(pt.x, rect.x);
        if (pt.x + size.x > rect.x + rect.width) {
            pt.x = rect.x + rect.width - size.x;
        }
        if (pt.y + size.y > rect.y + rect.height) {
            pt.y = cursorLocation.y - 2 - size.y;
        }
        this.toolTipShell.setLocation(pt);
        return true;
    }

    public int indexOf(CTableColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        if (column.parent != this) {
            return -1;
        }
        return column.getIndex();
    }

    public int indexOf(CTableItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.parent != this) {
            return -1;
        }
        return item.index;
    }

    void initAccessibility() {
        final Accessible accessibleTable = this.getAccessible();
        accessibleTable.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Control[] siblings = CTable.this.getParent().getChildren();
                int i = 0;
                while (i < siblings.length) {
                    Control control;
                    if (i != 0 && siblings[i] == CTable.this && (control = siblings[i - 1]) instanceof Label) {
                        e.result = ((Label)control).getText();
                    }
                    ++i;
                }
            }

            public void getHelp(AccessibleEvent e) {
                e.result = CTable.this.getToolTipText();
            }
        });
        accessibleTable.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChild(AccessibleControlEvent e) {
                int childID = e.childID;
                if (childID == -4) {
                    childID = e.detail;
                }
                if (CTable.this.columns.length > 0 && childID >= 0 && childID < CTable.this.columns.length) {
                    CTableColumn column = CTable.this.columns[childID];
                    e.accessible = column.getAccessible(accessibleTable);
                } else {
                    int columnCount;
                    int n = columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
                    if (CTable.this.columns.length > 0) {
                        childID -= columnCount;
                    }
                    if (childID >= 0 && childID < CTable.this.itemsCount * columnCount) {
                        int rowIndex = childID / columnCount;
                        int columnIndex = childID - rowIndex * columnCount;
                        e.accessible = CTable.this.items[rowIndex].getAccessible(accessibleTable, columnIndex);
                    }
                }
            }

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point point = CTable.this.toControl(e.x, e.y);
                if (CTable.this.columns.length > 0 && point.y < CTable.this.getHeaderHeight()) {
                    int columnIndex = CTable.this.computeColumnIntersect(point.x, 0);
                    if (columnIndex != -1) {
                        CTableColumn column = CTable.this.columns[columnIndex];
                        e.accessible = column.getAccessible(accessibleTable);
                    }
                } else {
                    int rowIndex;
                    int columnIndex;
                    int n = columnIndex = CTable.this.columns.length > 0 ? CTable.this.computeColumnIntersect(point.x, 0) : 0;
                    if (columnIndex != -1 && (rowIndex = (point.y - CTable.this.getHeaderHeight()) / CTable.this.itemHeight + CTable.this.topIndex) >= 0 && rowIndex < CTable.this.itemsCount && CTable.this.items[rowIndex].getHitBounds().contains(point)) {
                        e.accessible = CTable.this.items[rowIndex].getAccessible(accessibleTable, columnIndex);
                    }
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = CTable.this.columns.length > 0 ? CTable.this.columns.length + CTable.this.itemsCount * CTable.this.columns.length : CTable.this.itemsCount;
            }

            public void getChildren(AccessibleControlEvent e) {
                int childIdCount = CTable.this.columns.length > 0 ? CTable.this.columns.length + CTable.this.itemsCount * CTable.this.columns.length : CTable.this.itemsCount;
                Object[] children = new Object[childIdCount];
                int i = 0;
                while (i < childIdCount) {
                    children[i] = i;
                    ++i;
                }
                e.children = children;
            }

            public void getFocus(AccessibleControlEvent e) {
                e.childID = CTable.this.isFocusControl() ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                Point pt = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = CTable.this.getBounds();
                    pt = CTable.this.getParent().toDisplay(location.x, location.y);
                } else if (CTable.this.columns.length > 0 && childID >= 0 && childID < CTable.this.columns.length) {
                    CTableColumn column = CTable.this.columns[childID];
                    location = new Rectangle(column.getX(), 0, column.getWidth(), CTable.this.getHeaderHeight());
                    pt = CTable.this.toDisplay(location.x, location.y);
                } else {
                    int columnCount;
                    int n = columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
                    if (CTable.this.columns.length > 0) {
                        childID -= columnCount;
                    }
                    if (childID >= 0 && childID < CTable.this.itemsCount * columnCount) {
                        int rowIndex = childID / columnCount;
                        int columnIndex = childID - rowIndex * columnCount;
                        location = CTable.this.items[rowIndex].getBounds(columnIndex);
                        pt = CTable.this.toDisplay(location.x, location.y);
                    }
                }
                if (location != null && pt != null) {
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = e.childID == -1 ? 24 : 29;
            }

            public void getSelection(AccessibleControlEvent e) {
                int columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
                int[] selectionIndices = CTable.this.getSelectionIndices();
                Object[] selectedChildren = new Object[selectionIndices.length * columnCount];
                int i = 0;
                while (i < selectionIndices.length) {
                    int row = selectionIndices[i];
                    int col = 0;
                    while (col < columnCount) {
                        selectedChildren[i] = row * columnCount + col;
                        ++col;
                    }
                    ++i;
                }
                e.children = selectedChildren;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                int childID = e.childID;
                if (childID == -1) {
                    state |= 0x100000;
                    if (CTable.this.isFocusControl()) {
                        state |= 4;
                    }
                } else if (CTable.this.columns.length > 0 && childID >= 0 && childID < CTable.this.columns.length) {
                    state |= 0x20000;
                } else {
                    int columnCount;
                    int n = columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
                    if (CTable.this.columns.length > 0) {
                        childID -= columnCount;
                    }
                    if (childID >= 0 && childID < CTable.this.itemsCount * columnCount) {
                        int rowIndex = childID / columnCount;
                        state |= 0x200000;
                        if (CTable.this.isFocusControl()) {
                            state |= 0x100000;
                        }
                        if (CTable.this.items[rowIndex].isSelected()) {
                            state |= 2;
                            if (CTable.this.isFocusControl()) {
                                state |= 4;
                            }
                        }
                    }
                }
                e.detail = state;
            }
        });
        accessibleTable.addAccessibleTableListener((AccessibleTableListener)new AccessibleTableAdapter(){

            public void deselectColumn(AccessibleTableEvent e) {
            }

            public void deselectRow(AccessibleTableEvent e) {
                CTable.this.deselect(e.row);
                e.result = "OK";
            }

            public void getCaption(AccessibleTableEvent e) {
                e.result = "This is the Custom Table's Test Caption";
            }

            public void getCell(AccessibleTableEvent e) {
                int index = e.row;
                if (index >= 0 && index < CTable.this.itemsCount) {
                    CTableItem row = CTable.this.items[index];
                    index = e.column;
                    if (CTable.this.columns.length == 0 || index >= 0 && index < CTable.this.columns.length) {
                        e.accessible = row.getAccessible(accessibleTable, index);
                    }
                }
            }

            public void getColumnCount(AccessibleTableEvent e) {
                int columnCount;
                e.count = columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
            }

            public void getColumnDescription(AccessibleTableEvent e) {
                e.result = "This is the Custom Table's Test Description for column " + e.column;
            }

            public void getColumnHeaderCells(AccessibleTableEvent e) {
                if (CTable.this.columns.length == 0) {
                    e.accessibles = null;
                } else {
                    Accessible[] accessibles = new Accessible[CTable.this.columns.length];
                    int i = 0;
                    while (i < CTable.this.columns.length) {
                        CTableColumn column = CTable.this.columns[i];
                        accessibles[i] = column.getAccessible(accessibleTable);
                        ++i;
                    }
                    e.accessibles = accessibles;
                }
            }

            public void getRowCount(AccessibleTableEvent e) {
                e.count = CTable.this.itemsCount;
            }

            public void getRowDescription(AccessibleTableEvent e) {
                e.result = "This is the Custom Table's Test Description for row " + e.row;
            }

            public void getRowHeader(AccessibleTableEvent e) {
            }

            public void getSelectedCellCount(AccessibleTableEvent e) {
                int columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
                e.count = CTable.this.selectedItems.length * columnCount;
            }

            public void getSelectedCells(AccessibleTableEvent e) {
                int columnCount = CTable.this.columns.length > 0 ? CTable.this.columns.length : 1;
                Accessible[] accessibles = new Accessible[CTable.this.selectedItems.length * columnCount];
                int r = 0;
                while (r < CTable.this.selectedItems.length) {
                    CTableItem row = CTable.this.selectedItems[r];
                    int c = 0;
                    while (c < columnCount) {
                        accessibles[r + c] = row.getAccessible(accessibleTable, c);
                        ++c;
                    }
                    ++r;
                }
                e.accessibles = accessibles;
            }

            public void getSelectedColumnCount(AccessibleTableEvent e) {
                e.count = 0;
            }

            public void getSelectedColumns(AccessibleTableEvent e) {
            }

            public void getSelectedRowCount(AccessibleTableEvent e) {
                e.count = CTable.this.selectedItems.length;
            }

            public void getSelectedRows(AccessibleTableEvent e) {
                int[] selectedIndices = new int[CTable.this.selectedItems.length];
                int i = 0;
                while (i < CTable.this.selectedItems.length) {
                    selectedIndices[i] = CTable.this.selectedItems[i].index;
                    ++i;
                }
                e.selected = selectedIndices;
            }

            public void getSummary(AccessibleTableEvent e) {
                e.result = "This is the Custom Table's Summary";
            }

            public void isColumnSelected(AccessibleTableEvent e) {
                e.isSelected = false;
            }

            public void isRowSelected(AccessibleTableEvent e) {
                e.isSelected = CTable.this.isSelected(e.row);
            }

            public void selectColumn(AccessibleTableEvent e) {
            }

            public void selectRow(AccessibleTableEvent e) {
                CTable.this.select(e.row);
                e.result = "OK";
            }

            public void setSelectedColumn(AccessibleTableEvent e) {
            }

            public void setSelectedRow(AccessibleTableEvent e) {
                CTable.this.setSelection(e.row);
                e.result = "OK";
            }
        });
    }

    static void initImages(Display display) {
        PaletteData arrowPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        if (display.getData(ID_ARROWDOWN) == null) {
            byte[] byArray = new byte[4];
            byArray[1] = -125;
            byArray[2] = -57;
            byArray[3] = -17;
            ImageData arrowDown = new ImageData(7, 4, 1, arrowPalette, 1, byArray);
            arrowDown.transparentPixel = 1;
            display.setData(ID_ARROWDOWN, (Object)new Image((Device)display, arrowDown));
        }
        if (display.getData(ID_ARROWUP) == null) {
            byte[] byArray = new byte[4];
            byArray[0] = -17;
            byArray[1] = -57;
            byArray[2] = -125;
            ImageData arrowUp = new ImageData(7, 4, 1, arrowPalette, 1, byArray);
            arrowUp.transparentPixel = 1;
            display.setData(ID_ARROWUP, (Object)new Image((Device)display, arrowUp));
        }
        PaletteData checkMarkPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(252, 3, 251)});
        byte[] byArray = new byte[22];
        byArray[2] = 127;
        byArray[3] = -64;
        byArray[4] = 127;
        byArray[5] = -64;
        byArray[6] = 127;
        byArray[7] = -64;
        byArray[8] = 127;
        byArray[9] = -64;
        byArray[10] = 127;
        byArray[11] = -64;
        byArray[12] = 127;
        byArray[13] = -64;
        byArray[14] = 127;
        byArray[15] = -64;
        byArray[16] = 127;
        byArray[17] = -64;
        byArray[18] = 127;
        byArray[19] = -64;
        byte[] checkbox = byArray;
        ImageData checkmark = new ImageData(7, 7, 1, checkMarkPalette, 1, new byte[]{-4, -8, 112, 34, 6, -114, -34});
        checkmark.transparentPixel = 1;
        if (display.getData(ID_CHECKMARK) == null) {
            display.setData(ID_CHECKMARK, (Object)new Image((Device)display, checkmark));
        }
        if (display.getData(ID_UNCHECKED) == null) {
            PaletteData uncheckedPalette = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(255, 255, 255)});
            ImageData unchecked = new ImageData(11, 11, 1, uncheckedPalette, 2, checkbox);
            display.setData(ID_UNCHECKED, (Object)new Image((Device)display, unchecked));
        }
        if (display.getData(ID_GRAYUNCHECKED) == null) {
            PaletteData grayUncheckedPalette = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(192, 192, 192)});
            ImageData grayUnchecked = new ImageData(11, 11, 1, grayUncheckedPalette, 2, checkbox);
            display.setData(ID_GRAYUNCHECKED, (Object)new Image((Device)display, grayUnchecked));
        }
        display.disposeExec(() -> {
            Image arrowUp;
            Image arrowDown;
            Image checkmark1;
            Image grayUnchecked;
            Image unchecked = (Image)display.getData(ID_UNCHECKED);
            if (unchecked != null) {
                unchecked.dispose();
            }
            if ((grayUnchecked = (Image)display.getData(ID_GRAYUNCHECKED)) != null) {
                grayUnchecked.dispose();
            }
            if ((checkmark1 = (Image)display.getData(ID_CHECKMARK)) != null) {
                checkmark1.dispose();
            }
            if ((arrowDown = (Image)display.getData(ID_ARROWDOWN)) != null) {
                arrowDown.dispose();
            }
            if ((arrowUp = (Image)display.getData(ID_ARROWUP)) != null) {
                arrowUp.dispose();
            }
            display.setData(ID_UNCHECKED, null);
            display.setData(ID_GRAYUNCHECKED, null);
            display.setData(ID_CHECKMARK, null);
            display.setData(ID_ARROWDOWN, null);
            display.setData(ID_ARROWUP, null);
        });
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            return false;
        }
        return this.items[index].isSelected();
    }

    public void notifyListeners(int eventType, Event event) {
        super.notifyListeners(eventType, event);
        if (eventType == 13 && event.detail != 32) {
            this.getAccessible().selectionChanged();
        }
    }

    void onArrowDown(int stateMask) {
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = this.focusItem.index + 1;
            if (newFocusIndex == this.itemsCount) {
                return;
            }
            this.selectItem(this.items[newFocusIndex], false);
            this.setFocusItem(this.items[newFocusIndex], true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(this.items[newFocusIndex]);
            Event newEvent = new Event();
            newEvent.item = this.items[newFocusIndex];
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.itemsCount <= this.topIndex + visibleItemCount) {
                    return;
                }
                this.update();
                ++this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC((Drawable)this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gc.dispose();
                return;
            }
            int newFocusIndex = this.focusItem.index + 1;
            if (newFocusIndex == this.itemsCount) {
                return;
            }
            this.selectItem(this.items[newFocusIndex], false);
            this.setFocusItem(this.items[newFocusIndex], true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(this.items[newFocusIndex]);
            Event newEvent = new Event();
            newEvent.item = this.items[newFocusIndex];
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.itemsCount <= this.topIndex + visibleItemCount) {
                    return;
                }
                this.update();
                ++this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC((Drawable)this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gc.dispose();
                return;
            }
            int focusIndex = this.focusItem.index;
            if (focusIndex == this.itemsCount - 1) {
                return;
            }
            CTableItem newFocusItem = this.items[focusIndex + 1];
            this.setFocusItem(newFocusItem, true);
            this.redrawItem(newFocusItem.index, true);
            this.showItem(newFocusItem);
            return;
        }
        int newFocusIndex = this.focusItem.index + 1;
        if (newFocusIndex == this.itemsCount) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.focusItem.index < this.anchorItem.index) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.index, true);
        }
        this.selectItem(this.items[newFocusIndex], true);
        this.setFocusItem(this.items[newFocusIndex], true);
        this.redrawItem(newFocusIndex, true);
        this.showItem(this.items[newFocusIndex]);
        Event newEvent = new Event();
        newEvent.item = this.items[newFocusIndex];
        this.notifyListeners(13, newEvent);
    }

    void onArrowLeft(int stateMask) {
        if (this.horizontalOffset == 0) {
            return;
        }
        int newSelection = Math.max(0, this.horizontalOffset - 5);
        this.update();
        GC gc = new GC((Drawable)this);
        gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - newSelection, 0);
        gc.dispose();
        if (this.header.getVisible()) {
            this.header.update();
            Rectangle headerClientArea = this.header.getClientArea();
            gc = new GC((Drawable)this.header);
            gc.copyArea(0, 0, headerClientArea.width, headerClientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
        }
        this.horizontalOffset = newSelection;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setSelection(this.horizontalOffset);
        }
    }

    void onArrowRight(int stateMask) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int maximum = hBar.getMaximum();
        int clientWidth = this.clientArea.width;
        if (this.horizontalOffset + this.clientArea.width == maximum) {
            return;
        }
        if (maximum <= clientWidth) {
            return;
        }
        int newSelection = Math.min(this.horizontalOffset + 5, maximum - clientWidth);
        this.update();
        GC gc = new GC((Drawable)this);
        gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - newSelection, 0);
        gc.dispose();
        if (this.header.getVisible()) {
            Rectangle headerClientArea = this.header.getClientArea();
            this.header.update();
            gc = new GC((Drawable)this.header);
            gc.copyArea(0, 0, headerClientArea.width, headerClientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
        }
        this.horizontalOffset = newSelection;
        hBar.setSelection(this.horizontalOffset);
    }

    void onArrowUp(int stateMask) {
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = this.focusItem.index - 1;
            if (newFocusIndex < 0) {
                return;
            }
            CTableItem item = this.items[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC((Drawable)this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gc.dispose();
                return;
            }
            int newFocusIndex = this.focusItem.index - 1;
            if (newFocusIndex < 0) {
                return;
            }
            CTableItem item = this.items[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC((Drawable)this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gc.dispose();
                return;
            }
            int focusIndex = this.focusItem.index;
            if (focusIndex == 0) {
                return;
            }
            CTableItem newFocusItem = this.items[focusIndex - 1];
            this.setFocusItem(newFocusItem, true);
            this.showItem(newFocusItem);
            this.redrawItem(newFocusItem.index, true);
            return;
        }
        int newFocusIndex = this.focusItem.index - 1;
        if (newFocusIndex < 0) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.anchorItem.index < this.focusItem.index) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.index, true);
        }
        CTableItem item = this.items[newFocusIndex];
        this.selectItem(item, true);
        this.setFocusItem(item, true);
        this.redrawItem(newFocusIndex, true);
        this.showItem(item);
        Event newEvent = new Event();
        newEvent.item = item;
        this.notifyListeners(13, newEvent);
    }

    void onCR() {
        if (this.focusItem == null) {
            return;
        }
        Event event = new Event();
        event.item = this.focusItem;
        this.notifyListeners(14, event);
    }

    void onDispose(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.ignoreDispose) {
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        int i = 0;
        while (i < this.itemsCount) {
            this.items[i].dispose(false);
            ++i;
        }
        CTableColumn[] cTableColumnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            CTableColumn column = cTableColumnArray[n2];
            column.dispose(false);
            ++n2;
        }
        if (this.toolTipShell != null) {
            this.toolTipShell.dispose();
            this.toolTipShell = null;
            this.toolTipLabel = null;
        }
        this.toolTipListener = null;
        this.horizontalOffset = 0;
        this.topIndex = 0;
        this.itemsCount = 0;
        this.selectedItems = null;
        this.items = null;
        this.orderedColumns = null;
        this.columns = null;
        this.lastClickedItem = null;
        this.anchorItem = null;
        this.focusItem = null;
        this.lastSelectionEvent = null;
        this.header = null;
        this.sortColumn = null;
        this.resizeColumn = null;
    }

    void onEnd(int stateMask) {
        CTableItem selectedItem;
        int lastAvailableIndex = this.itemsCount - 1;
        if ((stateMask & 0x60000) == 0) {
            if (this.focusItem.index == lastAvailableIndex) {
                return;
            }
            CTableItem item = this.items[lastAvailableIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(lastAvailableIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                this.setTopIndex(this.itemsCount - visibleItemCount);
                return;
            }
            if (this.focusItem.index == lastAvailableIndex) {
                return;
            }
            CTableItem item = this.items[lastAvailableIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(lastAvailableIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                this.showItem(this.items[lastAvailableIndex]);
                return;
            }
            if (this.focusItem.index == lastAvailableIndex) {
                return;
            }
            CTableItem item = this.items[lastAvailableIndex];
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.index, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((selectedItem = this.items[lastAvailableIndex]) == this.focusItem && selectedItem.isSelected()) {
            return;
        }
        int anchorIndex = this.anchorItem.index;
        int selectIndex = selectedItem.index;
        CTableItem[] newSelection = new CTableItem[selectIndex - anchorIndex + 1];
        int writeIndex = 0;
        int i = anchorIndex;
        while (i <= selectIndex) {
            newSelection[writeIndex++] = this.items[i];
            ++i;
        }
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.redrawItems(anchorIndex, selectIndex, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.notifyListeners(13, newEvent);
    }

    void onFocusIn() {
        this.hasFocus = true;
        if (this.itemsCount == 0) {
            this.redraw();
            return;
        }
        if ((this.getStyle() & 0x8002) == 32770) {
            CTableItem[] cTableItemArray = this.selectedItems;
            int n = this.selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTableItem selectedItem = cTableItemArray[n2];
                this.redrawItem(selectedItem.index, true);
                ++n2;
            }
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.index, true);
            return;
        }
        CTableItem initialFocus = this.selectedItems.length > 0 ? this.selectedItems[0] : this.items[this.topIndex];
        this.setFocusItem(initialFocus, false);
        this.redrawItem(initialFocus.index, true);
    }

    void onFocusOut() {
        this.hasFocus = false;
        if (this.itemsCount == 0) {
            this.redraw();
            return;
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.index, true);
        }
        if ((this.getStyle() & 0x8002) == 32770) {
            CTableItem[] cTableItemArray = this.selectedItems;
            int n = this.selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTableItem selectedItem = cTableItemArray[n2];
                this.redrawItem(selectedItem.index, true);
                ++n2;
            }
        }
    }

    void onHome(int stateMask) {
        CTableItem selectedItem;
        if ((stateMask & 0x60000) == 0) {
            if (this.focusItem.index == 0) {
                return;
            }
            CTableItem item = this.items[0];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(0, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                this.setTopIndex(0);
                return;
            }
            if (this.focusItem.index == 0) {
                return;
            }
            CTableItem item = this.items[0];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(0, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.notifyListeners(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                this.setTopIndex(0);
                return;
            }
            if (this.focusItem.index == 0) {
                return;
            }
            CTableItem item = this.items[0];
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.index, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((selectedItem = this.items[0]) == this.focusItem && selectedItem.isSelected()) {
            return;
        }
        int anchorIndex = this.anchorItem.index;
        int selectIndex = selectedItem.index;
        CTableItem[] newSelection = new CTableItem[anchorIndex + 1];
        int writeIndex = 0;
        int i = anchorIndex;
        while (i >= 0) {
            newSelection[writeIndex++] = this.items[i];
            --i;
        }
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.redrawItems(anchorIndex, selectIndex, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.notifyListeners(13, newEvent);
    }

    void onKeyDown(Event event) {
        String text;
        CTableItem item;
        if (this.ignoreKey) {
            this.ignoreKey = false;
            return;
        }
        this.ignoreKey = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        if (!event.doit) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        switch (event.keyCode) {
            case 0x1000001: {
                this.onArrowUp(event.stateMask);
                return;
            }
            case 0x1000002: {
                this.onArrowDown(event.stateMask);
                return;
            }
            case 0x1000003: {
                this.onArrowLeft(event.stateMask);
                return;
            }
            case 0x1000004: {
                this.onArrowRight(event.stateMask);
                return;
            }
            case 0x1000005: {
                this.onPageUp(event.stateMask);
                return;
            }
            case 0x1000006: {
                this.onPageDown(event.stateMask);
                return;
            }
            case 0x1000007: {
                this.onHome(event.stateMask);
                return;
            }
            case 0x1000008: {
                this.onEnd(event.stateMask);
                return;
            }
        }
        if (event.character == ' ') {
            this.onSpace();
            return;
        }
        if (event.character == '\r') {
            this.onCR();
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            return;
        }
        int initialIndex = this.focusItem.index;
        char character = Character.toLowerCase(event.character);
        int i = initialIndex + 1;
        while (i < this.itemsCount) {
            item = this.items[i];
            text = item.getText(0, false);
            if (text.length() > 0 && Character.toLowerCase(text.charAt(0)) == character) {
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.redrawItem(i, true);
                this.showItem(item);
                Event newEvent = new Event();
                newEvent.item = item;
                this.notifyListeners(13, newEvent);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < initialIndex) {
            item = this.items[i];
            text = item.getText(0, false);
            if (text.length() > 0 && Character.toLowerCase(text.charAt(0)) == character) {
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.redrawItem(i, true);
                this.showItem(item);
                Event newEvent = new Event();
                newEvent.item = item;
                this.notifyListeners(13, newEvent);
                return;
            }
            ++i;
        }
    }

    void onMouseDoubleClick(Event event) {
        int index;
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if ((index = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || index >= this.itemsCount) {
            return;
        }
        CTableItem selectedItem = this.items[index];
        if (selectedItem != this.lastClickedItem) {
            return;
        }
        if (!selectedItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.notifyListeners(14, newEvent);
    }

    void onMouseDown(Event event) {
        int index;
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        if ((index = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || index >= this.itemsCount) {
            return;
        }
        CTableItem selectedItem = this.items[index];
        if ((this.getStyle() & 0x20) != 0 && selectedItem.getCheckboxBounds().contains(event.x, event.y)) {
            if (event.button != 1) {
                return;
            }
            selectedItem.setChecked(!selectedItem.checked);
            Event newEvent = new Event();
            newEvent.item = selectedItem;
            newEvent.detail = 32;
            this.notifyListeners(13, newEvent);
            return;
        }
        if (!selectedItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        boolean sendSelection = true;
        if (this.lastSelectionEvent != null && this.lastSelectionEvent.item == selectedItem) {
            if (event.time - this.lastSelectionEvent.time <= this.display.getDoubleClickTime()) {
                sendSelection = false;
            } else {
                this.lastSelectionEvent = event;
                event.item = selectedItem;
            }
        } else {
            this.lastSelectionEvent = event;
            event.item = selectedItem;
        }
        if ((this.getStyle() & 4) != 0) {
            if (!selectedItem.isSelected()) {
                if (event.button == 1) {
                    this.selectItem(selectedItem, false);
                    this.setFocusItem(selectedItem, true);
                    this.redrawItem(selectedItem.index, true);
                    if (sendSelection) {
                        Event newEvent = new Event();
                        newEvent.item = selectedItem;
                        this.notifyListeners(13, newEvent);
                    }
                    return;
                }
                if ((event.stateMask & 0x60000) == 0) {
                    this.selectItem(selectedItem, false);
                    this.setFocusItem(selectedItem, true);
                    this.redrawItem(selectedItem.index, true);
                    if (sendSelection) {
                        Event newEvent = new Event();
                        newEvent.item = selectedItem;
                        this.notifyListeners(13, newEvent);
                    }
                    return;
                }
            }
            if (event.button == 1) {
                if (sendSelection) {
                    Event newEvent = new Event();
                    newEvent.item = selectedItem;
                    this.notifyListeners(13, newEvent);
                }
                return;
            }
        }
        if (!selectedItem.isSelected()) {
            if (event.button == 1) {
                if ((event.stateMask & 0x60000) == 131072) {
                    if (this.anchorItem == null) {
                        this.anchorItem = this.focusItem;
                    }
                    int anchorIndex = this.anchorItem.index;
                    int selectIndex = selectedItem.index;
                    CTableItem[] newSelection = new CTableItem[Math.abs(anchorIndex - selectIndex) + 1];
                    int step = anchorIndex < selectIndex ? 1 : -1;
                    int writeIndex = 0;
                    int i = anchorIndex;
                    while (i != selectIndex) {
                        newSelection[writeIndex++] = this.items[i];
                        i += step;
                    }
                    newSelection[writeIndex] = this.items[selectIndex];
                    this.setSelection(newSelection, false);
                    this.setFocusItem(selectedItem, true);
                    this.redrawItems(Math.min(anchorIndex, selectIndex), Math.max(anchorIndex, selectIndex), true);
                    if (sendSelection) {
                        Event newEvent = new Event();
                        newEvent.item = selectedItem;
                        this.notifyListeners(13, newEvent);
                    }
                    return;
                }
                this.selectItem(selectedItem, (event.stateMask & 0x40000) != 0);
                this.setFocusItem(selectedItem, true);
                this.redrawItem(selectedItem.index, true);
                if (sendSelection) {
                    Event newEvent = new Event();
                    newEvent.item = selectedItem;
                    this.notifyListeners(13, newEvent);
                }
                return;
            }
            if ((event.stateMask & 0x60000) == 0) {
                this.selectItem(selectedItem, false);
                this.setFocusItem(selectedItem, true);
                this.redrawItem(selectedItem.index, true);
                if (sendSelection) {
                    Event newEvent = new Event();
                    newEvent.item = selectedItem;
                    this.notifyListeners(13, newEvent);
                }
                return;
            }
        }
        if (event.button != 1) {
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            this.removeSelectedItem(this.getSelectionIndex(selectedItem));
            this.setFocusItem(selectedItem, true);
            this.redrawItem(selectedItem.index, true);
            if (sendSelection) {
                Event newEvent = new Event();
                newEvent.item = selectedItem;
                this.notifyListeners(13, newEvent);
            }
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            if (this.anchorItem == null) {
                this.anchorItem = this.focusItem;
            }
            int anchorIndex = this.anchorItem.index;
            int selectIndex = selectedItem.index;
            CTableItem[] newSelection = new CTableItem[Math.abs(anchorIndex - selectIndex) + 1];
            int step = anchorIndex < selectIndex ? 1 : -1;
            int writeIndex = 0;
            int i = anchorIndex;
            while (i != selectIndex) {
                newSelection[writeIndex++] = this.items[i];
                i += step;
            }
            newSelection[writeIndex] = this.items[selectIndex];
            this.setSelection(newSelection, false);
            this.setFocusItem(selectedItem, true);
            this.redrawItems(Math.min(anchorIndex, selectIndex), Math.max(anchorIndex, selectIndex), true);
            if (sendSelection) {
                Event newEvent = new Event();
                newEvent.item = selectedItem;
                this.notifyListeners(13, newEvent);
            }
            return;
        }
        this.selectItem(selectedItem, false);
        this.setFocusItem(selectedItem, true);
        this.redrawItem(selectedItem.index, true);
        if (sendSelection) {
            Event newEvent = new Event();
            newEvent.item = selectedItem;
            this.notifyListeners(13, newEvent);
        }
    }

    void onMouseUp(Event event) {
        int index = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex;
        if (index < 0 || index >= this.itemsCount) {
            return;
        }
        this.lastClickedItem = this.items[index];
    }

    void onPageDown(int stateMask) {
        int selectIndex;
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = this.focusItem.index + visibleItemCount - 1;
            if ((newFocusIndex = Math.min(newFocusIndex, this.itemsCount - 1)) == this.focusItem.index) {
                return;
            }
            CTableItem item = this.items[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.index, true);
            return;
        }
        if ((stateMask & 0x60000) == 393216) {
            int newTopIndex = this.topIndex + visibleItemCount;
            if ((newTopIndex = Math.min(newTopIndex, this.itemsCount - visibleItemCount)) == this.topIndex) {
                return;
            }
            this.setTopIndex(newTopIndex);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            if ((stateMask & 0x20000) != 0) {
                int newFocusIndex = this.focusItem.index + visibleItemCount - 1;
                if ((newFocusIndex = Math.min(newFocusIndex, this.itemsCount - 1)) == this.focusItem.index) {
                    return;
                }
                CTableItem item = this.items[newFocusIndex];
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.showItem(item);
                this.redrawItem(item.index, true);
                return;
            }
            int newTopIndex = this.topIndex + visibleItemCount;
            if ((newTopIndex = Math.min(newTopIndex, this.itemsCount - visibleItemCount)) == this.topIndex) {
                return;
            }
            this.setTopIndex(newTopIndex);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            int bottomIndex = Math.min(this.topIndex + visibleItemCount - 1, this.itemsCount - 1);
            if (this.focusItem.index != bottomIndex) {
                this.setFocusItem(this.items[bottomIndex], true);
                this.redrawItem(bottomIndex, true);
            } else {
                int newFocusIndex = Math.min(this.itemsCount - 1, bottomIndex + visibleItemCount);
                if (newFocusIndex == this.focusItem.index) {
                    return;
                }
                this.setFocusItem(this.items[newFocusIndex], true);
                this.showItem(this.items[newFocusIndex]);
                this.redrawItem(newFocusIndex, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int anchorIndex = this.anchorItem.index;
        int bottomIndex = Math.min(this.topIndex + visibleItemCount - 1, this.itemsCount - 1);
        if (this.focusItem.index != bottomIndex) {
            selectIndex = bottomIndex;
        } else {
            selectIndex = Math.min(this.itemsCount - 1, bottomIndex + visibleItemCount);
            if (selectIndex == this.focusItem.index && this.focusItem.isSelected()) {
                return;
            }
        }
        CTableItem selectedItem = this.items[selectIndex];
        CTableItem[] newSelection = new CTableItem[Math.abs(anchorIndex - selectIndex) + 1];
        int step = anchorIndex < selectIndex ? 1 : -1;
        int writeIndex = 0;
        int i = anchorIndex;
        while (i != selectIndex) {
            newSelection[writeIndex++] = this.items[i];
            i += step;
        }
        newSelection[writeIndex] = this.items[selectIndex];
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.notifyListeners(13, newEvent);
    }

    void onPageUp(int stateMask) {
        int selectIndex;
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = Math.max(0, this.focusItem.index - visibleItemCount + 1);
            if (newFocusIndex == this.focusItem.index) {
                return;
            }
            CTableItem item = this.items[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.index, true);
            return;
        }
        if ((stateMask & 0x60000) == 393216) {
            int newTopIndex = Math.max(0, this.topIndex - visibleItemCount);
            if (newTopIndex == this.topIndex) {
                return;
            }
            this.setTopIndex(newTopIndex);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            if ((stateMask & 0x20000) != 0) {
                int newFocusIndex = Math.max(0, this.focusItem.index - visibleItemCount + 1);
                if (newFocusIndex == this.focusItem.index) {
                    return;
                }
                CTableItem item = this.items[newFocusIndex];
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.showItem(item);
                this.redrawItem(item.index, true);
                return;
            }
            int newTopIndex = Math.max(0, this.topIndex - visibleItemCount);
            if (newTopIndex == this.topIndex) {
                return;
            }
            this.setTopIndex(newTopIndex);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if (this.focusItem.index != this.topIndex) {
                this.setFocusItem(this.items[this.topIndex], true);
                this.redrawItem(this.topIndex, true);
            } else {
                int newFocusIndex = Math.max(0, this.focusItem.index - visibleItemCount);
                if (newFocusIndex == this.focusItem.index) {
                    return;
                }
                this.setFocusItem(this.items[newFocusIndex], true);
                this.showItem(this.items[newFocusIndex]);
                this.redrawItem(newFocusIndex, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int anchorIndex = this.anchorItem.index;
        if (this.focusItem.index != this.topIndex) {
            selectIndex = this.topIndex;
        } else {
            selectIndex = Math.max(0, this.topIndex - visibleItemCount);
            if (selectIndex == this.focusItem.index && this.focusItem.isSelected()) {
                return;
            }
        }
        CTableItem selectedItem = this.items[selectIndex];
        CTableItem[] newSelection = new CTableItem[Math.abs(anchorIndex - selectIndex) + 1];
        int step = anchorIndex < selectIndex ? 1 : -1;
        int writeIndex = 0;
        int i = anchorIndex;
        while (i != selectIndex) {
            newSelection[writeIndex++] = this.items[i];
            i += step;
        }
        newSelection[writeIndex] = this.items[selectIndex];
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.notifyListeners(13, newEvent);
    }

    void onPaint(Event event) {
        CTableColumn column;
        int rightX;
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        GC gc = event.gc;
        Rectangle clipping = gc.getClipping();
        int headerHeight = this.getHeaderHeight();
        int numColumns = orderedColumns.length;
        int startColumn = -1;
        int endColumn = -1;
        if (numColumns > 0) {
            startColumn = this.computeColumnIntersect(clipping.x, 0);
            if (startColumn != -1 && (endColumn = this.computeColumnIntersect(clipping.x + clipping.width, startColumn)) == -1) {
                endColumn = numColumns - 1;
            }
        } else {
            endColumn = 0;
            startColumn = 0;
        }
        int startIndex = (clipping.y - headerHeight) / this.itemHeight + this.topIndex;
        int endIndex = -1;
        if (startIndex < this.itemsCount) {
            endIndex = startIndex + (int)Math.ceil((float)clipping.height / (float)this.itemHeight);
        }
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(endIndex, this.itemsCount - 1);
        gc.setBackground(this.getBackground());
        gc.setClipping(clipping);
        int bottomY = endIndex >= 0 ? this.getItemY(this.items[endIndex]) + this.itemHeight : 0;
        int fillHeight = Math.max(0, this.clientArea.height - bottomY);
        if (fillHeight > 0) {
            gc.fillRectangle(0, bottomY, this.clientArea.width, fillHeight);
        }
        if (this.columns.length > 0 && (rightX = (column = orderedColumns[orderedColumns.length - 1]).getX() + column.width) < this.clientArea.width) {
            gc.fillRectangle(rightX, 0, this.clientArea.width - rightX, this.clientArea.height - fillHeight);
        }
        boolean noFocusDraw = false;
        int[] lineDash = gc.getLineDash();
        int lineWidth = gc.getLineWidth();
        int i = startIndex;
        while (i <= Math.min(endIndex, this.itemsCount - 1)) {
            CTableItem item = this.items[i];
            if (!item.isDisposed()) {
                if (startColumn == -1) {
                    noFocusDraw = item.paint(gc, null, true) || noFocusDraw;
                } else if (numColumns == 0) {
                    noFocusDraw = item.paint(gc, null, false) || noFocusDraw;
                } else {
                    int j = startColumn;
                    while (j <= Math.min(endColumn, this.columns.length - 1)) {
                        if (!item.isDisposed()) {
                            boolean bl = noFocusDraw = item.paint(gc, orderedColumns[j], false) || noFocusDraw;
                        }
                        if (this.isDisposed() || gc.isDisposed()) {
                            return;
                        }
                        ++j;
                    }
                }
            }
            if (this.isDisposed() || gc.isDisposed()) {
                return;
            }
            ++i;
        }
        gc.setClipping(clipping);
        gc.setLineWidth(lineWidth);
        if (this.linesVisible) {
            gc.setForeground(this.display.getSystemColor(19));
            gc.setLineDash(lineDash);
            if (numColumns > 0 && startColumn != -1) {
                i = startColumn;
                while (i <= endColumn) {
                    int x = orderedColumns[i].getX() + orderedColumns[i].width - 1;
                    gc.drawLine(x, clipping.y, x, clipping.y + clipping.height);
                    ++i;
                }
            }
            bottomY = clipping.y + clipping.height;
            int rightX2 = clipping.x + clipping.width;
            int y = (clipping.y - headerHeight) / this.itemHeight * this.itemHeight + headerHeight;
            while (y <= bottomY) {
                gc.drawLine(clipping.x, y, rightX2, y);
                y += this.itemHeight;
            }
        }
        if (!noFocusDraw && this.isFocusControl()) {
            if (this.focusItem != null) {
                Rectangle focusBounds = this.focusItem.getFocusBounds();
                if (focusBounds.width > 0) {
                    gc.setForeground(this.display.getSystemColor(2));
                    gc.setClipping(focusBounds);
                    if (this.focusItem.isSelected()) {
                        gc.setLineDash(new int[]{2, 2});
                    } else {
                        gc.setLineDash(new int[]{1, 1});
                    }
                    gc.drawFocus(focusBounds.x, focusBounds.y, focusBounds.width, focusBounds.height);
                }
            } else {
                int y = headerHeight + 1;
                int width = Math.max(0, this.clientArea.width - 2);
                int height = Math.max(0, this.clientArea.height - headerHeight - 2);
                gc.setForeground(this.display.getSystemColor(2));
                gc.setClipping(1, y, width, height);
                gc.setLineDash(new int[]{1, 1});
                gc.drawFocus(1, y, width, height);
            }
        }
    }

    void onResize(Event event) {
        ScrollBar hBar;
        boolean visible;
        this.clientArea = this.getClientArea();
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            int clientHeight = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
            int thumb = Math.min(clientHeight, this.itemsCount);
            vBar.setThumb(thumb);
            vBar.setPageIncrement(thumb);
            int index = vBar.getSelection();
            if (index != this.topIndex) {
                this.topIndex = index;
                this.redraw();
            }
            boolean bl = visible = clientHeight < this.itemsCount;
            if (visible != vBar.getVisible()) {
                vBar.setVisible(visible);
                this.clientArea = this.getClientArea();
            }
        }
        if ((hBar = this.getHorizontalBar()) != null) {
            int hBarMaximum = hBar.getMaximum();
            int thumb = Math.min(this.clientArea.width, hBarMaximum);
            hBar.setThumb(thumb);
            hBar.setPageIncrement(thumb);
            this.horizontalOffset = hBar.getSelection();
            boolean bl = visible = this.clientArea.width < hBarMaximum;
            if (visible != hBar.getVisible()) {
                hBar.setVisible(visible);
                this.clientArea = this.getClientArea();
            }
        }
        int headerHeight = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        this.header.setSize(this.clientArea.width, headerHeight);
        if (this.itemsCount == 0 && this.isFocusControl()) {
            this.redraw();
        }
    }

    void onScrollHorizontal(Event event) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int newSelection = hBar.getSelection();
        this.update();
        if (this.itemsCount > 0) {
            GC gc = new GC((Drawable)this);
            gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
        } else {
            this.redraw();
        }
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.update();
            Rectangle headerClientArea = this.header.getClientArea();
            GC gc = new GC((Drawable)this.header);
            gc.copyArea(0, 0, headerClientArea.width, headerClientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
        }
        this.horizontalOffset = newSelection;
    }

    void onScrollVertical(Event event) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return;
        }
        int newSelection = vBar.getSelection();
        this.update();
        GC gc = new GC((Drawable)this);
        gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, (this.topIndex - newSelection) * this.itemHeight);
        gc.dispose();
        this.topIndex = newSelection;
    }

    void onSpace() {
        if (this.focusItem == null) {
            return;
        }
        if (!this.focusItem.isSelected()) {
            this.selectItem(this.focusItem, (this.getStyle() & 2) != 0);
            this.redrawItem(this.focusItem.index, true);
        }
        if ((this.getStyle() & 0x20) != 0) {
            this.focusItem.setChecked(!this.focusItem.checked);
        }
        this.showItem(this.focusItem);
        Event event = new Event();
        event.item = this.focusItem;
        this.notifyListeners(13, event);
        if ((this.getStyle() & 0x20) == 0) {
            return;
        }
        event = new Event();
        event.item = this.focusItem;
        event.detail = 32;
        this.notifyListeners(13, event);
    }

    void reassignFocus() {
        if (this.focusItem == null) {
            return;
        }
        int index = this.focusItem.index;
        index = index != 0 ? --index : ++index;
        if (index < this.itemsCount) {
            CTableItem item = this.items[index];
            this.setFocusItem(item, false);
            this.showItem(item);
        } else {
            this.setFocusItem(null, false);
        }
    }

    public void redraw() {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw(x, y, width, height, all);
        }
    }

    void redrawFromItemDownwards(int index) {
        this.redrawItems(index, this.itemsCount - 1, false);
    }

    void redrawItem(int itemIndex, boolean focusBoundsOnly) {
        if (itemIndex < this.itemsCount && !this.items[itemIndex].isInViewport()) {
            return;
        }
        this.redrawItems(itemIndex, itemIndex, focusBoundsOnly);
    }

    void redrawItems(int startIndex, int endIndex, boolean focusBoundsOnly) {
        if (this.drawCount > 0) {
            return;
        }
        int startY = (startIndex - this.topIndex) * this.itemHeight + this.getHeaderHeight();
        int height = (endIndex - startIndex + 1) * this.itemHeight;
        if (focusBoundsOnly) {
            boolean custom;
            boolean bl = custom = this.isListening(40) || this.isListening(42);
            if (!custom && this.columns.length > 0) {
                CTableColumn lastColumn;
                if ((this.getStyle() & 0x10000) != 0) {
                    CTableColumn[] orderedColumns = this.getOrderedColumns();
                    lastColumn = orderedColumns[orderedColumns.length - 1];
                } else {
                    lastColumn = this.columns[0];
                }
                int rightX = lastColumn.getX() + lastColumn.getWidth();
                if (rightX <= 0) {
                    return;
                }
            }
            endIndex = Math.min(endIndex, this.itemsCount - 1);
            int i = startIndex;
            while (i <= endIndex) {
                CTableItem item = this.items[i];
                if (item.isInViewport()) {
                    if (custom) {
                        this.redraw(0, this.getItemY(item), this.clientArea.width, this.itemHeight, false);
                    } else {
                        Rectangle bounds = item.getFocusBounds();
                        this.redraw(bounds.x, startY, bounds.width, height, false);
                    }
                }
                ++i;
            }
        } else {
            this.redraw(0, startY, this.clientArea.width, height, false);
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            SWT.error((int)6);
        }
        this.items[index].dispose();
        int[] eventData = new int[]{1, index, 1, 0, 0};
        this.getAccessible().sendEvent(518, (Object)eventData);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemsCount) {
            SWT.error((int)6);
        }
        if (start == 0 && end == this.itemsCount - 1) {
            this.removeAll();
        } else {
            int i = end;
            while (i >= start) {
                this.items[i].dispose();
                --i;
            }
            int[] eventData = new int[]{1, start, end - start + 1, 0, 0};
            this.getAccessible().sendEvent(518, (Object)eventData);
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sortDescent(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemsCount) {
            SWT.error((int)6);
        }
        int lastRemovedIndex = -1;
        int[] eventData = new int[5];
        int[] nArray = newIndices;
        int n = newIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int newIndice = nArray[n2];
            if (newIndice != lastRemovedIndex) {
                this.items[newIndice].dispose();
                eventData[0] = 1;
                eventData[1] = newIndice;
                eventData[2] = 1;
                eventData[3] = 0;
                eventData[4] = 0;
                this.getAccessible().sendEvent(518, (Object)eventData);
                lastRemovedIndex = newIndice;
            }
            ++n2;
        }
    }

    public void removeAll() {
        this.checkWidget();
        if (this.itemsCount == 0) {
            return;
        }
        this.setRedraw(false);
        this.setFocusItem(null, false);
        int i = 0;
        while (i < this.itemsCount) {
            this.items[i].dispose(false);
            ++i;
        }
        this.items = new CTableItem[0];
        this.selectedItems = new CTableItem[0];
        int oldCount = this.itemsCount;
        this.topIndex = 0;
        this.itemsCount = 0;
        this.lastClickedItem = null;
        this.anchorItem = null;
        this.lastSelectionEvent = null;
        int[] eventData = new int[]{1, 0, oldCount, 0, 0};
        this.getAccessible().sendEvent(518, (Object)eventData);
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            vBar.setMaximum(1);
            vBar.setVisible(false);
        }
        if (this.columns.length == 0) {
            this.horizontalOffset = 0;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setMaximum(1);
                hBar.setVisible(false);
            }
        }
        this.setRedraw(true);
    }

    String removeMnemonics(String string) {
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            if (chars[i] == '&') {
                if (++i == chars.length) break;
                if (chars[i] == '&') {
                    chars[j++] = chars[i - 1];
                }
            }
            chars[j] = chars[i];
            ++i;
            ++j;
        }
        if (i == j) {
            return string;
        }
        return new String(chars, 0, j);
    }

    void removeSelectedItem(int index) {
        CTableItem[] newSelectedItems = new CTableItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, index);
        System.arraycopy(this.selectedItems, index + 1, newSelectedItems, index, newSelectedItems.length - index);
        this.selectedItems = newSelectedItems;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeTypedListener(13, (EventListener)listener);
        this.removeTypedListener(14, (EventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            return;
        }
        this.selectItem(this.items[index], (this.getStyle() & 2) != 0);
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            this.redrawItem(index, false);
        }
        this.getAccessible().selectionChanged();
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.getStyle() & 4) != 0 && start != end) {
            return;
        }
        if (this.itemsCount == 0 || start >= this.itemsCount) {
            return;
        }
        start = Math.max(start, 0);
        end = Math.min(end, this.itemsCount - 1);
        int i = start;
        while (i <= end) {
            this.selectItem(this.items[i], (this.getStyle() & 2) != 0);
            ++i;
        }
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            this.redrawItems(start, end, false);
        }
        this.getAccessible().selectionChanged();
    }

    public void select(int[] indices) {
        int index;
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0 || (this.getStyle() & 4) != 0 && indices.length > 1) {
            return;
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            index = nArray[n2];
            if (index >= 0 && index < this.itemsCount) {
                this.selectItem(this.items[index], (this.getStyle() & 2) != 0);
            }
            ++n2;
        }
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            nArray = indices;
            n = indices.length;
            n2 = 0;
            while (n2 < n) {
                index = nArray[n2];
                if (index >= 0 && index < this.itemsCount) {
                    this.redrawItem(index, false);
                }
                ++n2;
            }
        }
        this.getAccessible().selectionChanged();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        this.selectedItems = new CTableItem[this.itemsCount];
        System.arraycopy(this.items, 0, this.selectedItems, 0, this.itemsCount);
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            this.redraw();
        }
        CTableItem[] cTableItemArray = this.selectedItems;
        int n = this.selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            CTableItem selectedItem = cTableItemArray[n2];
            selectedItem.getAccessible(this.getAccessible(), 0).selectionChanged();
            ++n2;
        }
        this.getAccessible().selectionChanged();
    }

    void selectItem(CTableItem item, boolean addToSelection) {
        CTableItem[] oldSelectedItems = this.selectedItems;
        if (!addToSelection || (this.getStyle() & 4) != 0) {
            CTableItem oldSelectedItem;
            int n;
            int n2;
            CTableItem[] cTableItemArray;
            this.selectedItems = new CTableItem[]{item};
            if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
                cTableItemArray = oldSelectedItems;
                n2 = oldSelectedItems.length;
                n = 0;
                while (n < n2) {
                    oldSelectedItem = cTableItemArray[n];
                    if (oldSelectedItem != item) {
                        this.redrawItem(oldSelectedItem.index, true);
                    }
                    ++n;
                }
            }
            cTableItemArray = oldSelectedItems;
            n2 = oldSelectedItems.length;
            n = 0;
            while (n < n2) {
                oldSelectedItem = cTableItemArray[n];
                oldSelectedItem.getAccessible(this.getAccessible(), 0).selectionChanged();
                ++n;
            }
        } else {
            if (item.isSelected()) {
                return;
            }
            this.selectedItems = new CTableItem[this.selectedItems.length + 1];
            System.arraycopy(oldSelectedItems, 0, this.selectedItems, 0, oldSelectedItems.length);
            this.selectedItems[this.selectedItems.length - 1] = item;
        }
        item.getAccessible(this.getAccessible(), 0).selectionChanged();
        this.getAccessible().selectionChanged();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(25);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(24);
        }
        super.setForeground(color);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            SWT.error((int)4);
        }
        if (this.columns.length == 0) {
            if (order.length != 0) {
                SWT.error((int)5);
            }
            return;
        }
        if (order.length != this.columns.length) {
            SWT.error((int)5);
        }
        boolean reorder = false;
        boolean[] seen = new boolean[this.columns.length];
        int[] oldOrder = this.getColumnOrder();
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columns.length) {
                SWT.error((int)6);
            }
            if (seen[index]) {
                SWT.error((int)5);
            }
            seen[index] = true;
            if (index != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (!reorder) {
            return;
        }
        this.headerHideToolTip();
        int[] oldX = new int[this.columns.length];
        int i2 = 0;
        while (i2 < this.columns.length) {
            oldX[i2] = this.columns[i2].getX();
            ++i2;
        }
        this.orderedColumns = new CTableColumn[order.length];
        i2 = 0;
        while (i2 < order.length) {
            this.orderedColumns[i2] = this.columns[order[i2]];
            ++i2;
        }
        CTableColumn[] cTableColumnArray = this.orderedColumns;
        int n = this.orderedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            CTableColumn orderedColumn = cTableColumnArray[n2];
            CTableColumn column = orderedColumn;
            if (!column.isDisposed() && column.getX() != oldX[column.getIndex()]) {
                column.notifyListeners(10, new Event());
            }
            ++n2;
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    void setFocusItem(CTableItem item, boolean redrawOldFocus) {
        if (item == this.focusItem) {
            return;
        }
        CTableItem oldFocusItem = this.focusItem;
        if (oldFocusItem != null) {
            oldFocusItem.getAccessible(this.getAccessible(), 0).setFocus(-1);
        }
        this.focusItem = item;
        if (redrawOldFocus && oldFocusItem != null) {
            this.redrawItem(oldFocusItem.index, true);
        }
        if (this.focusItem != null) {
            this.focusItem.getAccessible(this.getAccessible(), 0).setFocus(-1);
        }
    }

    public void setFont(Font value) {
        ScrollBar vBar;
        this.checkWidget();
        Font oldFont = this.getFont();
        super.setFont(value);
        Font font = this.getFont();
        if (font.equals((Object)oldFont)) {
            return;
        }
        GC gc = new GC((Drawable)this);
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
        Point headerSize = this.header.getSize();
        int newHeaderHeight = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (headerSize.y != newHeaderHeight) {
            this.header.setSize(headerSize.x, newHeaderHeight);
        }
        this.header.setFont(font);
        CTableColumn[] cTableColumnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            CTableColumn column = cTableColumnArray[n2];
            column.updateFont(gc);
            ++n2;
        }
        int i = 0;
        while (i < this.itemsCount) {
            this.items[i].updateFont(gc);
            ++i;
        }
        gc.dispose();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
        if (this.columns.length == 0) {
            this.updateHorizontalBar();
        }
        if ((vBar = this.getVerticalBar()) != null) {
            int thumb = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
            vBar.setThumb(thumb);
            vBar.setPageIncrement(thumb);
            this.topIndex = vBar.getSelection();
            vBar.setVisible(thumb < vBar.getMaximum());
        }
        this.redraw();
    }

    void setHeaderImageHeight(int value) {
        this.headerImageHeight = value;
        Point headerSize = this.header.getSize();
        int newHeaderHeight = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (headerSize.y != newHeaderHeight) {
            this.header.setSize(headerSize.x, newHeaderHeight);
        }
    }

    public void setHeaderVisible(boolean value) {
        this.checkWidget();
        if (this.header.getVisible() == value) {
            return;
        }
        this.headerHideToolTip();
        this.header.setVisible(value);
        this.updateVerticalBar();
        this.redraw();
    }

    void setImageHeight(int value) {
        this.imageHeight = value;
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
    }

    public void setItemCount(int count) {
        int redrawEnd;
        int redrawStart;
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.itemsCount) {
            return;
        }
        int oldCount = this.itemsCount;
        if (count < this.itemsCount) {
            redrawStart = count;
            redrawEnd = this.itemsCount - 1;
            int i = count;
            while (i < this.itemsCount) {
                this.items[i].dispose(false);
                ++i;
            }
            int newSelectedCount = 0;
            CTableItem[] cTableItemArray = this.selectedItems;
            int n = this.selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTableItem selectedItem = cTableItemArray[n2];
                if (!selectedItem.isDisposed()) {
                    ++newSelectedCount;
                }
                ++n2;
            }
            if (newSelectedCount != this.selectedItems.length) {
                CTableItem[] newSelectedItems = new CTableItem[newSelectedCount];
                int pos = 0;
                CTableItem[] cTableItemArray2 = this.selectedItems;
                int n3 = this.selectedItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    CTableItem selectedItem = cTableItemArray2[n4];
                    CTableItem item = selectedItem;
                    if (!item.isDisposed()) {
                        newSelectedItems[pos++] = item;
                    }
                    ++n4;
                }
                this.selectedItems = newSelectedItems;
            }
            if (this.anchorItem != null && this.anchorItem.isDisposed()) {
                this.anchorItem = null;
            }
            if (this.lastClickedItem != null && this.lastClickedItem.isDisposed()) {
                this.lastClickedItem = null;
            }
            if (this.focusItem != null && this.focusItem.isDisposed()) {
                CTableItem newFocusItem = count > 0 ? this.items[count - 1] : null;
                this.setFocusItem(newFocusItem, false);
            }
            int[] eventData = new int[]{1, redrawStart, redrawEnd - redrawStart, 0, 0};
            this.getAccessible().sendEvent(518, (Object)eventData);
            this.itemsCount = count;
            if (this.columns.length == 0) {
                this.updateHorizontalBar();
            }
        } else {
            redrawStart = this.itemsCount;
            redrawEnd = count - 1;
            CTableItem[] newItems = new CTableItem[count];
            System.arraycopy(this.items, 0, newItems, 0, this.itemsCount);
            this.items = newItems;
            int i = this.itemsCount;
            while (i < count) {
                this.items[i] = new CTableItem(this, 0, i, false);
                ++this.itemsCount;
                ++i;
            }
            int[] eventData = new int[]{0, redrawStart, count, 0, 0};
            this.getAccessible().sendEvent(518, (Object)eventData);
            if (oldCount == 0) {
                this.focusItem = this.items[0];
            }
        }
        this.updateVerticalBar();
        if ((oldCount == 0 || this.itemsCount == 0) && this.isFocusControl()) {
            this.redraw();
            return;
        }
        this.redrawItems(redrawStart, redrawEnd, false);
    }

    boolean setItemHeight(int value) {
        boolean update;
        boolean bl = update = !this.customHeightSet || this.itemHeight < value;
        if (update) {
            this.itemHeight = value;
        }
        return update;
    }

    public void setLinesVisible(boolean value) {
        this.checkWidget();
        if (this.linesVisible == value) {
            return;
        }
        this.linesVisible = value;
        this.redraw();
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.header.setMenu(menu);
    }

    public void setRedraw(boolean value) {
        this.checkWidget();
        if (value) {
            if (--this.drawCount == 0) {
                if (this.items.length - this.itemsCount > 3) {
                    CTableItem[] newItems = new CTableItem[this.itemsCount];
                    System.arraycopy(this.items, 0, newItems, 0, this.itemsCount);
                    this.items = newItems;
                }
                this.updateVerticalBar();
                this.updateHorizontalBar();
            }
        } else {
            ++this.drawCount;
        }
        super.setRedraw(value);
        this.header.setRedraw(value);
    }

    public void setSelection(CTableItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        this.setSelection(new CTableItem[]{item}, true);
    }

    public void setSelection(CTableItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        this.setSelection(items, true);
    }

    void setSelection(CTableItem[] items, boolean updateViewport) {
        if (items.length == 0 || (this.getStyle() & 4) != 0 && items.length > 1) {
            this.deselectAll();
            return;
        }
        CTableItem[] oldSelection = this.selectedItems;
        int index = 0;
        this.selectedItems = new CTableItem[items.length];
        CTableItem[] cTableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTableItem item2 = cTableItemArray[n2];
            CTableItem item = item2;
            if (item != null && item.parent == this && !item.isSelected()) {
                this.selectedItems[index++] = item;
            }
            ++n2;
        }
        if (index != items.length) {
            CTableItem[] temp = new CTableItem[index];
            System.arraycopy(this.selectedItems, 0, temp, 0, index);
            this.selectedItems = temp;
        }
        if (this.selectedItems.length == 0) {
            this.deselectAll();
            return;
        }
        boolean tableSelectionChanged = false;
        if (this.isFocusControl() || (this.getStyle() & 0x8000) == 0) {
            CTableItem[] cTableItemArray2 = oldSelection;
            int n3 = oldSelection.length;
            n = 0;
            while (n < n3) {
                CTableItem item = cTableItemArray2[n];
                if (!item.isSelected()) {
                    this.redrawItem(item.index, true);
                    item.getAccessible(this.getAccessible(), 0).selectionChanged();
                    tableSelectionChanged = true;
                }
                ++n;
            }
            cTableItemArray2 = this.selectedItems;
            n3 = this.selectedItems.length;
            n = 0;
            while (n < n3) {
                CTableItem selectedItem = cTableItemArray2[n];
                this.redrawItem(selectedItem.index, true);
                selectedItem.getAccessible(this.getAccessible(), 0).selectionChanged();
                tableSelectionChanged = true;
                ++n;
            }
        }
        if (updateViewport) {
            this.showItem(this.selectedItems[0]);
            this.setFocusItem(this.selectedItems[0], true);
        }
        if (tableSelectionChanged) {
            this.getAccessible().selectionChanged();
        }
    }

    public void setSortColumn(CTableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            SWT.error((int)5);
        }
        if (column == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        if (index < 0 || index >= this.itemsCount) {
            return;
        }
        this.selectItem(this.items[index], false);
        this.setFocusItem(this.items[index], true);
        this.redrawItem(index, true);
        this.showSelection();
        this.getAccessible().selectionChanged();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.getStyle() & 4) != 0 && start != end) {
            return;
        }
        if (this.itemsCount == 0 || start >= this.itemsCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemsCount - 1);
        this.select(start, end);
        this.setFocusItem(this.items[start], true);
        this.showSelection();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        int focusIndex = -1;
        int i = 0;
        while (i < indices.length && focusIndex == -1) {
            if (indices[i] >= 0 && indices[i] < this.itemsCount) {
                focusIndex = indices[i];
            }
            ++i;
        }
        if (focusIndex != -1) {
            this.setFocusItem(this.items[focusIndex], true);
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemsCount) {
            return;
        }
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if (this.itemsCount <= visibleItemCount) {
            return;
        }
        if ((index = Math.min(index, this.itemsCount - visibleItemCount)) == this.topIndex) {
            return;
        }
        this.update();
        int change = this.topIndex - index;
        this.topIndex = index;
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            vBar.setSelection(this.topIndex);
        }
        if (this.drawCount <= 0) {
            GC gc = new GC((Drawable)this);
            gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, change * this.itemHeight);
            gc.dispose();
        }
    }

    public void showColumn(CTableColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        if (column.isDisposed()) {
            SWT.error((int)5);
        }
        if (column.parent != this) {
            return;
        }
        int x = column.getX();
        int rightX = x + column.width;
        if (x >= 0 && rightX <= this.clientArea.width) {
            return;
        }
        this.headerHideToolTip();
        int absX = 0;
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        int i = 0;
        while (i < column.getOrderIndex()) {
            absX += orderedColumns[i].width;
            ++i;
        }
        this.horizontalOffset = x < this.clientArea.x ? absX : absX + column.width - this.clientArea.width;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setSelection(this.horizontalOffset);
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    public void showItem(CTableItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        if (item.parent != this) {
            return;
        }
        int index = item.index;
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if (this.topIndex <= index && index < this.topIndex + visibleItemCount) {
            return;
        }
        if (index <= this.topIndex) {
            this.setTopIndex(item.index);
        } else {
            visibleItemCount = Math.max(visibleItemCount, 1);
            this.setTopIndex(Math.min(index - visibleItemCount + 1, this.itemsCount - 1));
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedItems.length == 0) {
            return;
        }
        this.showItem(this.selectedItems[0]);
    }

    void sortDescent(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void sortAscent(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] >= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void sortAscent(CTableItem[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j].index >= items[j + gap].index) {
                        CTableItem swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void updateColumnWidth(CTableColumn column, int width) {
        this.headerHideToolTip();
        int oldWidth = column.width;
        int columnX = column.getX();
        int x = columnX + oldWidth - 1;
        this.update();
        GC gc = new GC((Drawable)this);
        gc.copyArea(x, 0, this.clientArea.width - x, this.clientArea.height, columnX + width - 1, 0);
        if (width > oldWidth) {
            change = width - oldWidth + 1;
            this.redraw(x - 1, 0, change + 1, this.clientArea.height, false);
        } else {
            change = oldWidth - width + 1;
            this.redraw(this.clientArea.width - change, 0, change, this.clientArea.height, false);
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.index, true);
        }
        GC headerGC = new GC((Drawable)this.header);
        if (this.drawCount <= 0 && this.header.getVisible()) {
            Rectangle headerBounds = this.header.getClientArea();
            this.header.update();
            headerGC.copyArea(--x, 0, headerBounds.width - x, headerBounds.height, columnX + width - 2, 0);
            if (width > oldWidth) {
                change = width - oldWidth + 2;
                this.header.redraw(x, 0, change, headerBounds.height, false);
            } else {
                change = oldWidth - width + 2;
                this.header.redraw(headerBounds.width - change, 0, change, headerBounds.height, false);
            }
        }
        column.width = width;
        column.updateWidth(headerGC);
        headerGC.dispose();
        int i = 0;
        while (i < this.itemsCount) {
            this.items[i].updateColumnWidth(column, gc);
            ++i;
        }
        gc.dispose();
        int maximum = 0;
        CTableColumn[] cTableColumnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            CTableColumn column2 = cTableColumnArray[n2];
            maximum += column2.width;
            ++n2;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setMaximum(Math.max(1, maximum));
            if (hBar.getThumb() != this.clientArea.width) {
                hBar.setThumb(this.clientArea.width);
                hBar.setPageIncrement(this.clientArea.width);
            }
            int oldHorizontalOffset = this.horizontalOffset;
            hBar.setVisible(this.clientArea.width < maximum);
            int selection = hBar.getSelection();
            if (selection != oldHorizontalOffset) {
                this.horizontalOffset = selection;
                this.redraw();
                if (this.drawCount <= 0 && this.header.getVisible()) {
                    this.header.redraw();
                }
            }
        }
        column.notifyListeners(11, new Event());
        CTableColumn[] orderedColumns = this.getOrderedColumns();
        int i2 = column.getOrderIndex() + 1;
        while (i2 < orderedColumns.length) {
            if (!orderedColumns[i2].isDisposed()) {
                orderedColumns[i2].notifyListeners(10, new Event());
            }
            ++i2;
        }
        if (this.itemsCount == 0) {
            this.redraw();
        }
    }

    void updateHorizontalBar() {
        int thumb;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int maxX = 0;
        if (this.columns.length > 0) {
            CTableColumn[] cTableColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                CTableColumn column = cTableColumnArray[n2];
                maxX += column.width;
                ++n2;
            }
        } else {
            int i = 0;
            while (i < this.itemsCount) {
                Rectangle itemBounds = this.items[i].getCellBounds(0);
                maxX = Math.max(maxX, itemBounds.x + itemBounds.width + this.horizontalOffset);
                ++i;
            }
        }
        int clientWidth = this.clientArea.width;
        if (maxX != hBar.getMaximum()) {
            hBar.setMaximum(Math.max(1, maxX));
        }
        if ((thumb = Math.min(clientWidth, maxX)) != hBar.getThumb()) {
            hBar.setThumb(thumb);
            hBar.setPageIncrement(thumb);
        }
        hBar.setVisible(clientWidth < maxX);
        if (maxX < this.horizontalOffset + thumb) {
            this.horizontalOffset = maxX - thumb;
            hBar.setSelection(this.horizontalOffset);
            this.redraw();
        } else {
            int selection = hBar.getSelection();
            if (selection != this.horizontalOffset) {
                this.horizontalOffset = selection;
                this.redraw();
            }
        }
    }

    void updateHorizontalBar(int newRightX, int rightXchange) {
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int barMaximum = hBar.getMaximum();
        if ((newRightX += this.horizontalOffset) > barMaximum) {
            hBar.setMaximum(newRightX);
            int clientAreaWidth = this.clientArea.width;
            int thumb = Math.min(newRightX, clientAreaWidth);
            hBar.setThumb(thumb);
            hBar.setPageIncrement(thumb);
            hBar.setVisible(clientAreaWidth <= newRightX);
            return;
        }
        int previousRightX = newRightX - rightXchange;
        if (previousRightX != barMaximum) {
            int clientAreaWidth = this.clientArea.width;
            int thumb = Math.min(barMaximum, clientAreaWidth);
            hBar.setThumb(thumb);
            hBar.setPageIncrement(thumb);
            hBar.setVisible(clientAreaWidth <= barMaximum);
            return;
        }
        this.updateHorizontalBar();
    }

    void updateVerticalBar() {
        int thumb;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return;
        }
        int pageSize = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        int maximum = Math.max(1, this.itemsCount);
        if (maximum != vBar.getMaximum()) {
            vBar.setMaximum(maximum);
        }
        if ((thumb = Math.min(pageSize, maximum)) != vBar.getThumb()) {
            vBar.setThumb(thumb);
            vBar.setPageIncrement(thumb);
        }
        vBar.setVisible(pageSize < maximum);
        if (maximum < this.topIndex + thumb) {
            this.topIndex = maximum - thumb;
            vBar.setSelection(this.topIndex);
            this.redraw();
        } else {
            int selection = vBar.getSelection();
            if (selection != this.topIndex) {
                this.topIndex = selection;
                this.redraw();
            }
        }
    }
}

