/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.addressbook;

import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataEntryDialog {
    private static ResourceBundle resAddressBook = ResourceBundle.getBundle("examples_addressbook");
    Shell shell;
    String[] values;
    String[] labels;

    public DataEntryDialog(Shell parent) {
        this.shell = new Shell(parent, 34912);
        this.shell.setLayout((Layout)new GridLayout());
    }

    private void addTextListener(Text text) {
        text.addModifyListener(e -> {
            Integer index = (Integer)text.getData("index");
            this.values[index.intValue()] = text.getText();
        });
    }

    private void createControlButtons() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(64));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Button okButton = new Button(composite, 8);
        okButton.setText(resAddressBook.getString("OK"));
        okButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.shell.close()));
        Button cancelButton = new Button(composite, 8);
        cancelButton.setText(resAddressBook.getString("Cancel"));
        cancelButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.values = null;
            this.shell.close();
        }));
        this.shell.setDefaultButton(okButton);
    }

    private void createTextWidgets() {
        if (this.labels == null) {
            return;
        }
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        if (this.values == null) {
            this.values = new String[this.labels.length];
        }
        int i = 0;
        while (i < this.labels.length) {
            Label label = new Label(composite, 131072);
            label.setText(this.labels[i]);
            Text text = new Text(composite, 2048);
            GridData gridData = new GridData();
            gridData.widthHint = 400;
            text.setLayoutData((Object)gridData);
            if (this.values[i] != null) {
                text.setText(this.values[i]);
            }
            text.setData("index", (Object)i);
            this.addTextListener(text);
            ++i;
        }
    }

    public String[] getLabels() {
        return this.labels;
    }

    public String getTitle() {
        return this.shell.getText();
    }

    public String[] getValues() {
        return this.values;
    }

    public String[] open() {
        this.createTextWidgets();
        this.createControlButtons();
        this.shell.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getValues();
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public void setTitle(String title) {
        this.shell.setText(title);
    }

    public void setValues(String[] itemInfo) {
        if (this.labels == null) {
            return;
        }
        if (this.values == null) {
            this.values = new String[this.labels.length];
        }
        int numItems = Math.min(this.values.length, itemInfo.length);
        System.arraycopy(itemInfo, 0, this.values, 0, numItems);
    }
}

