/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.addressbook;

import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.addressbook.FindListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog {
    private static ResourceBundle resAddressBook = ResourceBundle.getBundle("examples_addressbook");
    Shell shell;
    Text searchText;
    Combo searchArea;
    Label searchAreaLabel;
    Button matchCase;
    Button matchWord;
    Button findButton;
    Button down;
    FindListener findHandler;

    public SearchDialog(Shell parent) {
        this.shell = new Shell(parent, 2144);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        this.shell.setText(resAddressBook.getString("Search_dialog_title"));
        this.shell.addShellListener(ShellListener.shellClosedAdapter(e -> {
            e.doit = false;
            this.shell.setVisible(false);
        }));
        Label label = new Label((Composite)this.shell, 16384);
        label.setText(resAddressBook.getString("Dialog_find_what"));
        this.searchText = new Text((Composite)this.shell, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addModifyListener(e -> {
            boolean enableFind = this.searchText.getCharCount() != 0;
            this.findButton.setEnabled(enableFind);
        });
        this.searchAreaLabel = new Label((Composite)this.shell, 16384);
        this.searchArea = new Combo((Composite)this.shell, 12);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.searchArea.setLayoutData((Object)gridData);
        this.matchCase = new Button((Composite)this.shell, 32);
        this.matchCase.setText(resAddressBook.getString("Dialog_match_case"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.matchCase.setLayoutData((Object)gridData);
        this.matchWord = new Button((Composite)this.shell, 32);
        this.matchWord.setText(resAddressBook.getString("Dialog_match_word"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.matchWord.setLayoutData((Object)gridData);
        Group direction = new Group((Composite)this.shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        direction.setLayoutData((Object)gridData);
        direction.setLayout((Layout)new FillLayout());
        direction.setText(resAddressBook.getString("Dialog_direction"));
        Button up = new Button((Composite)direction, 16);
        up.setText(resAddressBook.getString("Dialog_dir_up"));
        up.setSelection(false);
        this.down = new Button((Composite)direction, 16);
        this.down.setText(resAddressBook.getString("Dialog_dir_down"));
        this.down.setSelection(true);
        Composite composite = new Composite((Composite)this.shell, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.findButton = new Button(composite, 8);
        this.findButton.setText(resAddressBook.getString("Dialog_find"));
        this.findButton.setLayoutData((Object)new GridData(128));
        this.findButton.setEnabled(false);
        this.findButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.findHandler.find()) {
                MessageBox box = new MessageBox(this.shell, 32802);
                box.setText(this.shell.getText());
                box.setMessage(resAddressBook.getString("Cannot_find") + "\"" + this.searchText.getText() + "\"");
                box.open();
            }
        }));
        Button cancelButton = new Button(composite, 8);
        cancelButton.setText(resAddressBook.getString("Cancel"));
        cancelButton.setLayoutData((Object)new GridData(32));
        cancelButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.shell.setVisible(false)));
        this.shell.pack();
    }

    public String getSearchAreaLabel(String label) {
        return this.searchAreaLabel.getText();
    }

    public String[] getsearchAreaNames() {
        return this.searchArea.getItems();
    }

    public boolean getMatchCase() {
        return this.matchCase.getSelection();
    }

    public boolean getMatchWord() {
        return this.matchWord.getSelection();
    }

    public String getSearchString() {
        return this.searchText.getText();
    }

    public boolean getSearchDown() {
        return this.down.getSelection();
    }

    public int getSelectedSearchArea() {
        return this.searchArea.getSelectionIndex();
    }

    public void open() {
        if (this.shell.isVisible()) {
            this.shell.setFocus();
        } else {
            this.shell.open();
        }
        this.searchText.setFocus();
    }

    public void setSearchAreaNames(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.searchArea.add(name);
            ++n2;
        }
        this.searchArea.select(0);
    }

    public void setSearchAreaLabel(String label) {
        this.searchAreaLabel.setText(label);
    }

    public void setMatchCase(boolean match) {
        this.matchCase.setSelection(match);
    }

    public void setMatchWord(boolean match) {
        this.matchWord.setSelection(match);
    }

    public void setSearchDown(boolean searchDown) {
        this.down.setSelection(searchDown);
    }

    public void setSearchString(String searchString) {
        this.searchText.setText(searchString);
    }

    public void setSelectedSearchArea(int index) {
        this.searchArea.select(index);
    }

    public void addFindListener(FindListener listener) {
        this.findHandler = listener;
    }

    public void removeFindListener(FindListener listener) {
        this.findHandler = null;
    }
}

