/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browserexample;

import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserExample {
    static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_browser");
    int index;
    boolean busy;
    Image[] images;
    Image icon = null;
    boolean title = false;
    Composite parent;
    Text locationBar;
    Browser browser;
    ToolBar toolbar;
    Canvas canvas;
    ToolItem itemBack;
    ToolItem itemForward;
    Label status;
    ProgressBar progressBar;
    SWTError error = null;
    static final String[] imageLocations = new String[]{"eclipse01.bmp", "eclipse02.bmp", "eclipse03.bmp", "eclipse04.bmp", "eclipse05.bmp", "eclipse06.bmp", "eclipse07.bmp", "eclipse08.bmp", "eclipse09.bmp", "eclipse10.bmp", "eclipse11.bmp", "eclipse12.bmp"};
    static final String iconLocation = "document.gif";

    public BrowserExample(Composite parent, boolean top) {
        this.parent = parent;
        try {
            this.browser = new Browser(parent, 2048);
        }
        catch (SWTError e2) {
            this.error = e2;
            parent.setLayout((Layout)new FillLayout());
            Label label = new Label(parent, 0x1000040);
            label.setText(BrowserExample.getResourceString("BrowserNotCreated"));
            label.requestLayout();
            return;
        }
        this.initResources();
        Display display = parent.getDisplay();
        this.browser.setData("org.eclipse.swt.examples.browserexample.BrowserApplication", (Object)this);
        this.browser.addOpenWindowListener(event -> {
            Shell shell = new Shell(display);
            if (this.icon != null) {
                shell.setImage(this.icon);
            }
            shell.setLayout((Layout)new FillLayout());
            BrowserExample app = new BrowserExample((Composite)shell, false);
            app.setShellDecoration(this.icon, true);
            event.browser = app.getBrowser();
        });
        if (top) {
            this.browser.setUrl(BrowserExample.getResourceString("Startup"));
            this.show(false, null, null, true, true, true, true);
        } else {
            this.browser.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(e -> {
                Browser browser = (Browser)e.widget;
                BrowserExample app = (BrowserExample)browser.getData("org.eclipse.swt.examples.browserexample.BrowserApplication");
                app.show(true, e.location, e.size, e.addressBar, e.menuBar, e.statusBar, e.toolBar);
            }));
            this.browser.addCloseWindowListener(event -> {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            });
        }
    }

    public void dispose() {
        this.freeResources();
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public SWTError getError() {
        return this.error;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setShellDecoration(Image icon, boolean title) {
        this.icon = icon;
        this.title = title;
    }

    void show(boolean owned, Point location, Point size, boolean addressBar, boolean menuBar, boolean statusBar, boolean toolBar) {
        Shell shell = this.browser.getShell();
        if (owned) {
            if (location != null) {
                shell.setLocation(location);
            }
            if (size != null) {
                shell.setSize(shell.computeSize(size.x, size.y));
            }
        }
        FormData data = null;
        if (toolBar) {
            this.toolbar = new ToolBar(this.parent, 0);
            data = new FormData();
            data.top = new FormAttachment(0, 5);
            this.toolbar.setLayoutData((Object)data);
            this.itemBack = new ToolItem(this.toolbar, 8);
            this.itemBack.setText(BrowserExample.getResourceString("Back"));
            this.itemForward = new ToolItem(this.toolbar, 8);
            this.itemForward.setText(BrowserExample.getResourceString("Forward"));
            ToolItem itemStop = new ToolItem(this.toolbar, 8);
            itemStop.setText(BrowserExample.getResourceString("Stop"));
            ToolItem itemRefresh = new ToolItem(this.toolbar, 8);
            itemRefresh.setText(BrowserExample.getResourceString("Refresh"));
            ToolItem itemGo = new ToolItem(this.toolbar, 8);
            itemGo.setText(BrowserExample.getResourceString("Go"));
            this.itemBack.setEnabled(this.browser.isBackEnabled());
            this.itemForward.setEnabled(this.browser.isForwardEnabled());
            Listener listener = event -> {
                ToolItem item = (ToolItem)event.widget;
                if (item == this.itemBack) {
                    this.browser.back();
                } else if (item == this.itemForward) {
                    this.browser.forward();
                } else if (item == itemStop) {
                    this.browser.stop();
                } else if (item == itemRefresh) {
                    this.browser.refresh();
                } else if (item == itemGo) {
                    this.browser.setUrl(this.locationBar.getText());
                }
            };
            this.itemBack.addListener(13, listener);
            this.itemForward.addListener(13, listener);
            itemStop.addListener(13, listener);
            itemRefresh.addListener(13, listener);
            itemGo.addListener(13, listener);
            this.canvas = new Canvas(this.parent, 262144);
            data = new FormData();
            data.width = 24;
            data.height = 24;
            data.top = new FormAttachment(0, 5);
            data.right = new FormAttachment(100, -5);
            this.canvas.setLayoutData((Object)data);
            Rectangle rect = this.images[0].getBounds();
            this.canvas.addListener(9, e -> {
                Point pt = ((Canvas)e.widget).getSize();
                e.gc.drawImage(this.images[this.index], 0, 0, rectangle.width, rectangle.height, 0, 0, pt.x, pt.y);
            });
            this.canvas.addListener(3, e -> {
                boolean bl = this.browser.setUrl(BrowserExample.getResourceString("Startup"));
            });
            final Display display = this.parent.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (BrowserExample.this.canvas.isDisposed()) {
                        return;
                    }
                    if (BrowserExample.this.busy) {
                        ++BrowserExample.this.index;
                        if (BrowserExample.this.index == BrowserExample.this.images.length) {
                            BrowserExample.this.index = 0;
                        }
                        BrowserExample.this.canvas.redraw();
                    }
                    display.timerExec(150, (Runnable)this);
                }
            });
        }
        if (addressBar) {
            this.locationBar = new Text(this.parent, 2048);
            data = new FormData();
            if (this.toolbar != null) {
                data.top = new FormAttachment((Control)this.toolbar, 0, 128);
                data.left = new FormAttachment((Control)this.toolbar, 5, 131072);
                data.right = new FormAttachment((Control)this.canvas, -5, -1);
            } else {
                data.top = new FormAttachment(0, 0);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
            }
            this.locationBar.setLayoutData((Object)data);
            this.locationBar.addListener(14, e -> {
                boolean bl = this.browser.setUrl(this.locationBar.getText());
            });
        }
        if (statusBar) {
            this.status = new Label(this.parent, 0);
            this.progressBar = new ProgressBar(this.parent, 0);
            data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment((Control)this.progressBar, 0, -1);
            data.bottom = new FormAttachment(100, -5);
            this.status.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment(100, -5);
            data.bottom = new FormAttachment(100, -5);
            this.progressBar.setLayoutData((Object)data);
            this.browser.addStatusTextListener(event -> this.status.setText(event.text));
        }
        this.parent.setLayout((Layout)new FormLayout());
        Canvas aboveBrowser = toolBar ? this.canvas : (addressBar ? this.locationBar : null);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = aboveBrowser != null ? new FormAttachment((Control)aboveBrowser, 5, -1) : new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = this.status != null ? new FormAttachment((Control)this.status, -5, -1) : new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)data);
        if (statusBar || toolBar) {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    if (BrowserExample.this.progressBar != null) {
                        BrowserExample.this.progressBar.setSelection(ratio);
                    }
                    boolean bl = BrowserExample.this.busy = event.current != event.total;
                    if (!BrowserExample.this.busy) {
                        BrowserExample.this.index = 0;
                        if (BrowserExample.this.canvas != null) {
                            BrowserExample.this.canvas.redraw();
                        }
                    }
                }

                public void completed(ProgressEvent event) {
                    if (BrowserExample.this.progressBar != null) {
                        BrowserExample.this.progressBar.setSelection(0);
                    }
                    BrowserExample.this.busy = false;
                    BrowserExample.this.index = 0;
                    if (BrowserExample.this.canvas != null) {
                        BrowserExample.this.itemBack.setEnabled(BrowserExample.this.browser.isBackEnabled());
                        BrowserExample.this.itemForward.setEnabled(BrowserExample.this.browser.isForwardEnabled());
                        BrowserExample.this.canvas.redraw();
                    }
                }
            });
        }
        if (addressBar || statusBar || toolBar) {
            this.browser.addLocationListener(LocationListener.changedAdapter(event -> {
                this.busy = true;
                if (event.top && this.locationBar != null) {
                    this.locationBar.setText(event.location);
                }
            }));
        }
        if (this.title) {
            this.browser.addTitleListener(event -> shell.setText(event.title + " - " + BrowserExample.getResourceString("window.title")));
        }
        this.parent.layout(true);
        if (owned) {
            shell.open();
        }
    }

    public void focus() {
        if (this.locationBar != null) {
            this.locationBar.setFocus();
        } else if (this.browser != null) {
            this.browser.setFocus();
        } else {
            this.parent.setFocus();
        }
    }

    void freeResources() {
        if (this.images != null) {
            Image[] imageArray = this.images;
            int n = this.images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
            this.images = null;
        }
    }

    void initResources() {
        Class<?> clazz = this.getClass();
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (InputStream sourceStream = clazz.getResourceAsStream(imageLocations[i]);){
                            ImageData source = new ImageData(sourceStream);
                            ImageData mask = source.getTransparencyMask();
                            this.images[i] = new Image(null, source, mask);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        ++i;
                    }
                }
                return;
            }
            catch (Throwable throwable) {}
        }
        String error = resourceBundle != null ? BrowserExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    public static void main(String[] args) throws IOException {
        Image icon;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(BrowserExample.getResourceString("window.title"));
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream stream = BrowserExample.class.getResourceAsStream(iconLocation);){
            icon = new Image((Device)display, stream);
            shell.setImage(icon);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        BrowserExample app = new BrowserExample((Composite)shell, true);
        app.setShellDecoration(icon, true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        icon.dispose();
        app.dispose();
        display.dispose();
    }
}

