/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class CLabelTab
extends AlignableTab {
    CLabel label1;
    CLabel label2;
    CLabel label3;
    Group textLabelGroup;
    Button shadowInButton;
    Button shadowOutButton;
    Button shadowNoneButton;

    CLabelTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.textLabelGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textLabelGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textLabelGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textLabelGroup.setText(ControlExample.getResourceString("Custom_Labels"));
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.shadowInButton.getSelection()) {
            style |= 4;
        }
        if (this.shadowNoneButton.getSelection()) {
            style |= 0x20;
        }
        if (this.shadowOutButton.getSelection()) {
            style |= 8;
        }
        if (this.leftButton.getSelection()) {
            style |= 0x4000;
        }
        if (this.centerButton.getSelection()) {
            style |= 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            style |= 0x20000;
        }
        this.label1 = new CLabel((Composite)this.textLabelGroup, style);
        this.label1.setText(ControlExample.getResourceString("One"));
        this.label1.setImage(this.instance.images[0]);
        this.label2 = new CLabel((Composite)this.textLabelGroup, style);
        this.label2.setImage(this.instance.images[2]);
        this.label3 = new CLabel((Composite)this.textLabelGroup, style);
        this.label3.setText(ControlExample.getResourceString("Example_string") + "\n" + ControlExample.getResourceString("One_Two_Three"));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.shadowNoneButton = new Button((Composite)this.styleGroup, 16);
        this.shadowNoneButton.setText("SWT.SHADOW_NONE");
        this.shadowInButton = new Button((Composite)this.styleGroup, 16);
        this.shadowInButton.setText("SWT.SHADOW_IN");
        this.shadowOutButton = new Button((Composite)this.styleGroup, 16);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.label1, this.label2, this.label3};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"BottomMargin", "LeftMargin", "RightMargin", "Text", "ToolTipText", "TopMargin"};
    }

    @Override
    String getTabText() {
        return "CLabel";
    }

    @Override
    void setExampleWidgetAlignment() {
        int alignment = 0;
        if (this.leftButton.getSelection()) {
            alignment = 16384;
        }
        if (this.centerButton.getSelection()) {
            alignment = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            alignment = 131072;
        }
        this.label1.setAlignment(alignment);
        this.label2.setAlignment(alignment);
        this.label3.setAlignment(alignment);
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.leftButton.setSelection((this.label1.getStyle() & 0x4000) != 0);
        this.centerButton.setSelection((this.label1.getStyle() & 0x1000000) != 0);
        this.rightButton.setSelection((this.label1.getStyle() & 0x20000) != 0);
        this.shadowInButton.setSelection((this.label1.getStyle() & 4) != 0);
        this.shadowOutButton.setSelection((this.label1.getStyle() & 8) != 0);
        this.shadowNoneButton.setSelection((this.label1.getStyle() & 0xC) == 0);
    }
}

