/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

class CTabFolderTab
extends Tab {
    int lastSelectedTab = 0;
    CTabFolder tabFolder1;
    Group tabFolderGroup;
    Group itemGroup;
    Group tabHeightGroup;
    Button topButton;
    Button bottomButton;
    Button flatButton;
    Button closeButton;
    Button rightButton;
    Button fillButton;
    Button wrapButton;
    static String[] CTabItems1 = new String[]{ControlExample.getResourceString("CTabItem1_0"), ControlExample.getResourceString("CTabItem1_1"), ControlExample.getResourceString("CTabItem1_2")};
    static final int SELECTION_FOREGROUND_COLOR = 3;
    static final int SELECTION_BACKGROUND_COLOR = 4;
    static final int ITEM_FONT = 5;
    static final int ITEM_FOREGROUND_COLOR = 6;
    static final int ITEM_BACKGROUND_COLOR = 7;
    Color selectionForegroundColor;
    Color selectionBackgroundColor;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Font itemFont;
    Button simpleTabButton;
    Button singleTabButton;
    Button imageButton;
    Button showMinButton;
    Button showMaxButton;
    Button topRightButton;
    Button unselectedCloseButton;
    Button unselectedImageButton;
    ToolBar topRightControl;
    Button tabHeightDefault;
    Button tabHeightSmall;
    Button tabHeightMedium;
    Button tabHeightLarge;

    CTabFolderTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createControlGroup() {
        super.createControlGroup();
        this.tabHeightGroup = new Group((Composite)this.controlGroup, 0);
        this.tabHeightGroup.setLayout((Layout)new GridLayout());
        this.tabHeightGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabHeightGroup.setText(ControlExample.getResourceString("Tab_Height"));
        this.tabHeightDefault = new Button((Composite)this.tabHeightGroup, 16);
        this.tabHeightDefault.setText(ControlExample.getResourceString("Preferred"));
        this.tabHeightDefault.setSelection(true);
        this.tabHeightDefault.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setTabHeight(-1)));
        this.tabHeightSmall = new Button((Composite)this.tabHeightGroup, 16);
        this.tabHeightSmall.setText("8");
        this.tabHeightSmall.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setTabHeight(Integer.parseInt(this.tabHeightSmall.getText()))));
        this.tabHeightMedium = new Button((Composite)this.tabHeightGroup, 16);
        this.tabHeightMedium.setText("20");
        this.tabHeightMedium.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setTabHeight(Integer.parseInt(this.tabHeightMedium.getText()))));
        this.tabHeightLarge = new Button((Composite)this.tabHeightGroup, 16);
        this.tabHeightLarge.setText("45");
        this.tabHeightLarge.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setTabHeight(Integer.parseInt(this.tabHeightLarge.getText()))));
    }

    @Override
    void createColorAndFontGroup() {
        super.createColorAndFontGroup();
        TableItem item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Selection_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Selection_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Font"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Background_Color"));
        this.shell.addDisposeListener(event -> {
            if (this.itemFont != null) {
                this.itemFont.dispose();
            }
            this.selectionBackgroundColor = null;
            this.selectionForegroundColor = null;
            this.itemFont = null;
            this.itemBackgroundColor = null;
            this.itemForegroundColor = null;
        });
    }

    @Override
    void changeFontOrColor(int index) {
        switch (index) {
            case 3: {
                Color oldColor = this.selectionForegroundColor;
                if (oldColor == null) {
                    oldColor = this.tabFolder1.getSelectionForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.selectionForegroundColor = new Color(rgb);
                this.setSelectionForeground();
                break;
            }
            case 4: {
                Color oldColor = this.selectionBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.tabFolder1.getSelectionBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.selectionBackgroundColor = new Color(rgb);
                this.setSelectionBackground();
                break;
            }
            case 5: {
                Font oldFont = this.itemFont;
                if (oldFont == null) {
                    oldFont = this.tabFolder1.getItem(0).getFont();
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.itemFont;
                this.itemFont = new Font((Device)this.display, fontData);
                this.setItemFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            case 6: {
                Color oldColor = this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = this.tabFolder1.getItem(0).getControl().getForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.itemForegroundColor = new Color(rgb);
                this.setItemForeground();
                break;
            }
            case 7: {
                Color oldColor = this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.tabFolder1.getItem(0).getControl().getBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.itemBackgroundColor = new Color(rgb);
                this.setItemBackground();
                break;
            }
            default: {
                super.changeFontOrColor(index);
            }
        }
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.simpleTabButton = new Button((Composite)this.otherGroup, 32);
        this.simpleTabButton.setText(ControlExample.getResourceString("Set_Simple_Tabs"));
        this.simpleTabButton.setSelection(true);
        this.simpleTabButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setSimpleTabs()));
        this.singleTabButton = new Button((Composite)this.otherGroup, 32);
        this.singleTabButton.setText(ControlExample.getResourceString("Set_Single_Tabs"));
        this.singleTabButton.setSelection(false);
        this.singleTabButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setSingleTabs()));
        this.showMinButton = new Button((Composite)this.otherGroup, 32);
        this.showMinButton.setText(ControlExample.getResourceString("Set_Min_Visible"));
        this.showMinButton.setSelection(false);
        this.showMinButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setMinimizeVisible()));
        this.showMaxButton = new Button((Composite)this.otherGroup, 32);
        this.showMaxButton.setText(ControlExample.getResourceString("Set_Max_Visible"));
        this.showMaxButton.setSelection(false);
        this.showMaxButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setMaximizeVisible()));
        this.topRightButton = new Button((Composite)this.otherGroup, 32);
        this.topRightButton.setText(ControlExample.getResourceString("Set_Top_Right"));
        this.topRightButton.setSelection(false);
        this.topRightButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setTopRight()));
        this.imageButton = new Button((Composite)this.otherGroup, 32);
        this.imageButton.setText(ControlExample.getResourceString("Set_Image"));
        this.imageButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setImages()));
        this.unselectedImageButton = new Button((Composite)this.otherGroup, 32);
        this.unselectedImageButton.setText(ControlExample.getResourceString("Set_Unselected_Image_Visible"));
        this.unselectedImageButton.setSelection(true);
        this.unselectedImageButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setUnselectedImageVisible()));
        this.unselectedCloseButton = new Button((Composite)this.otherGroup, 32);
        this.unselectedCloseButton.setText(ControlExample.getResourceString("Set_Unselected_Close_Visible"));
        this.unselectedCloseButton.setSelection(true);
        this.unselectedCloseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setUnselectedCloseVisible()));
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.tabFolderGroup = new Group((Composite)this.exampleGroup, 0);
        this.tabFolderGroup.setLayout((Layout)new GridLayout());
        this.tabFolderGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolderGroup.setText("CTabFolder");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.topButton.getSelection()) {
            style |= 0x80;
        }
        if (this.bottomButton.getSelection()) {
            style |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.closeButton.getSelection()) {
            style |= 0x40;
        }
        this.tabFolder1 = new CTabFolder((Composite)this.tabFolderGroup, style);
        int i = 0;
        while (i < CTabItems1.length) {
            CTabItem item = new CTabItem(this.tabFolder1, 0);
            item.setText(CTabItems1[i]);
            Text text = new Text((Composite)this.tabFolder1, 66);
            text.setText(ControlExample.getResourceString("CTabItem_content") + ": " + i);
            item.setControl((Control)text);
            ++i;
        }
        this.tabFolder1.addListener(13, event -> {
            int n = this.lastSelectedTab = this.tabFolder1.getSelectionIndex();
        });
        this.tabFolder1.setSelection(this.lastSelectedTab);
        this.setTopRight();
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.topButton = new Button((Composite)this.styleGroup, 16);
        this.topButton.setText("SWT.TOP");
        this.topButton.setSelection(true);
        this.bottomButton = new Button((Composite)this.styleGroup, 16);
        this.bottomButton.setText("SWT.BOTTOM");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.closeButton = new Button((Composite)this.styleGroup, 32);
        this.closeButton.setText("SWT.CLOSE");
        Group topRightGroup = new Group((Composite)this.styleGroup, 0);
        topRightGroup.setLayout((Layout)new GridLayout());
        topRightGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        topRightGroup.setText(ControlExample.getResourceString("Top_Right_Styles"));
        this.rightButton = new Button((Composite)topRightGroup, 16);
        this.rightButton.setText("SWT.RIGHT");
        this.rightButton.setSelection(true);
        this.fillButton = new Button((Composite)topRightGroup, 16);
        this.fillButton.setText("SWT.FILL");
        this.wrapButton = new Button((Composite)topRightGroup, 16);
        this.wrapButton.setText("SWT.RIGHT | SWT.WRAP");
    }

    @Override
    String[] getCustomEventNames() {
        return new String[]{"CTabFolderEvent"};
    }

    @Override
    Item[] getExampleWidgetItems() {
        return this.tabFolder1.getItems();
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.tabFolder1};
    }

    @Override
    String getTabText() {
        return "CTabFolder";
    }

    @Override
    void hookCustomListener(final String eventName) {
        if (eventName == "CTabFolderEvent") {
            this.tabFolder1.addCTabFolder2Listener(new CTabFolder2Listener(){

                public void close(CTabFolderEvent event) {
                    CTabFolderTab.this.log(eventName, (TypedEvent)event);
                }

                public void minimize(CTabFolderEvent event) {
                    CTabFolderTab.this.log(eventName, (TypedEvent)event);
                }

                public void maximize(CTabFolderEvent event) {
                    CTabFolderTab.this.log(eventName, (TypedEvent)event);
                }

                public void restore(CTabFolderEvent event) {
                    CTabFolderTab.this.log(eventName, (TypedEvent)event);
                }

                public void showList(CTabFolderEvent event) {
                    CTabFolderTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
    }

    @Override
    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        this.selectionForegroundColor = null;
        this.setSelectionForeground();
        this.selectionBackgroundColor = null;
        this.setSelectionBackground();
        Font oldFont = this.itemFont;
        this.itemFont = null;
        this.setItemFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
        this.itemForegroundColor = null;
        this.setItemForeground();
        this.itemBackgroundColor = null;
        this.setItemBackground();
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setSimpleTabs();
        this.setSingleTabs();
        this.setImages();
        this.setMinimizeVisible();
        this.setMaximizeVisible();
        this.setUnselectedCloseVisible();
        this.setUnselectedImageVisible();
        this.setSelectionBackground();
        this.setSelectionForeground();
        this.setItemFont();
        this.setItemBackground();
        this.setItemForeground();
        this.setExampleWidgetSize();
    }

    void setSimpleTabs() {
        this.tabFolder1.setSimple(this.simpleTabButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setSingleTabs() {
        this.tabFolder1.setSingle(this.singleTabButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setImages() {
        CTabItem[] items;
        boolean setImage = this.imageButton.getSelection();
        CTabItem[] cTabItemArray = items = this.tabFolder1.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (setImage) {
                item.setImage(this.instance.images[0]);
            } else {
                item.setImage(null);
            }
            ++n2;
        }
        this.setExampleWidgetSize();
    }

    void setMinimizeVisible() {
        this.tabFolder1.setMinimizeVisible(this.showMinButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setMaximizeVisible() {
        this.tabFolder1.setMaximizeVisible(this.showMaxButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setTopRight() {
        if (this.topRightButton.getSelection()) {
            this.topRightControl = new ToolBar((Composite)this.tabFolder1, 0x800000);
            ToolItem item = new ToolItem(this.topRightControl, 8);
            item.setImage(this.instance.images[0]);
            item = new ToolItem(this.topRightControl, 8);
            item.setImage(this.instance.images[1]);
            int topRightStyle = 0;
            if (this.rightButton.getSelection()) {
                topRightStyle |= 0x20000;
            }
            if (this.fillButton.getSelection()) {
                topRightStyle |= 4;
            }
            if (this.wrapButton.getSelection()) {
                topRightStyle |= 0x20040;
            }
            this.tabFolder1.setTopRight((Control)this.topRightControl, topRightStyle);
        } else if (this.topRightControl != null) {
            this.tabFolder1.setTopRight(null);
            this.topRightControl.dispose();
        }
        this.setExampleWidgetSize();
    }

    void setUnselectedCloseVisible() {
        this.tabFolder1.setUnselectedCloseVisible(this.unselectedCloseButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setUnselectedImageVisible() {
        this.tabFolder1.setUnselectedImageVisible(this.unselectedImageButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setSelectionBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.tabFolder1.setSelectionBackground(this.selectionBackgroundColor);
        }
        if ((color = this.selectionBackgroundColor) == null) {
            color = this.tabFolder1.getSelectionBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(4)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setSelectionForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.tabFolder1.setSelectionForeground(this.selectionForegroundColor);
        }
        if ((color = this.selectionForegroundColor) == null) {
            color = this.tabFolder1.getSelectionForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(3)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.tabFolder1.getItem(0).setFont(this.itemFont);
            this.setExampleWidgetSize();
        }
        if ((ft = this.itemFont) == null) {
            ft = this.tabFolder1.getItem(0).getFont();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(5)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setItemBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.tabFolder1.getItem(0).getControl().setBackground(this.itemBackgroundColor);
        }
        if ((color = this.itemBackgroundColor) == null) {
            color = this.tabFolder1.getItem(0).getControl().getBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(7)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.tabFolder1.getItem(0).getControl().setForeground(this.itemForegroundColor);
        }
        if ((color = this.itemForegroundColor) == null) {
            color = this.tabFolder1.getItem(0).getControl().getForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(6)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setTabHeight(int height) {
        this.tabFolder1.setTabHeight(height);
    }
}

