/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

class ScaleTab
extends RangeTab {
    Scale scale1;
    Group scaleGroup;
    Spinner incrementSpinner;
    Spinner pageIncrementSpinner;

    ScaleTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createControlWidgets() {
        super.createControlWidgets();
        this.createIncrementGroup();
        this.createPageIncrementGroup();
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.scaleGroup = new Group((Composite)this.exampleGroup, 0);
        this.scaleGroup.setLayout((Layout)new GridLayout());
        this.scaleGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scaleGroup.setText("Scale");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.scale1 = new Scale((Composite)this.scaleGroup, style);
    }

    void createIncrementGroup() {
        Group incrementGroup = new Group((Composite)this.controlGroup, 0);
        incrementGroup.setLayout((Layout)new GridLayout());
        incrementGroup.setText(ControlExample.getResourceString("Increment"));
        incrementGroup.setLayoutData((Object)new GridData(768));
        this.incrementSpinner = new Spinner((Composite)incrementGroup, 2048);
        this.incrementSpinner.setMaximum(100000);
        this.incrementSpinner.setSelection(this.getDefaultIncrement());
        this.incrementSpinner.setPageIncrement(100);
        this.incrementSpinner.setIncrement(1);
        this.incrementSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.incrementSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setWidgetIncrement()));
    }

    void createPageIncrementGroup() {
        Group pageIncrementGroup = new Group((Composite)this.controlGroup, 0);
        pageIncrementGroup.setLayout((Layout)new GridLayout());
        pageIncrementGroup.setText(ControlExample.getResourceString("Page_Increment"));
        pageIncrementGroup.setLayoutData((Object)new GridData(768));
        this.pageIncrementSpinner = new Spinner((Composite)pageIncrementGroup, 2048);
        this.pageIncrementSpinner.setMaximum(100000);
        this.pageIncrementSpinner.setSelection(this.getDefaultPageIncrement());
        this.pageIncrementSpinner.setPageIncrement(100);
        this.pageIncrementSpinner.setIncrement(1);
        this.pageIncrementSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pageIncrementSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetPageIncrement()));
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.scale1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Selection", "ToolTipText"};
    }

    @Override
    String getTabText() {
        return "Scale";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        if (!this.instance.startup) {
            this.setWidgetIncrement();
            this.setWidgetPageIncrement();
        }
    }

    @Override
    int getDefaultMaximum() {
        return this.scale1.getMaximum();
    }

    @Override
    int getDefaultMinimum() {
        return this.scale1.getMinimum();
    }

    @Override
    int getDefaultSelection() {
        return this.scale1.getSelection();
    }

    int getDefaultIncrement() {
        return this.scale1.getIncrement();
    }

    int getDefaultPageIncrement() {
        return this.scale1.getPageIncrement();
    }

    void setWidgetIncrement() {
        this.scale1.setIncrement(this.incrementSpinner.getSelection());
    }

    @Override
    void setWidgetMaximum() {
        this.scale1.setMaximum(this.maximumSpinner.getSelection());
    }

    @Override
    void setWidgetMinimum() {
        this.scale1.setMinimum(this.minimumSpinner.getSelection());
    }

    void setWidgetPageIncrement() {
        this.scale1.setPageIncrement(this.pageIncrementSpinner.getSelection());
    }

    @Override
    void setWidgetSelection() {
        this.scale1.setSelection(this.selectionSpinner.getSelection());
    }
}

