/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class TableTab
extends ScrollableTab {
    Table table1;
    Group tableGroup;
    Button packColumnsButton;
    Button noScrollButton;
    Button checkButton;
    Button fullSelectionButton;
    Button hideSelectionButton;
    Button multipleColumns;
    Button moveableColumns;
    Button resizableColumns;
    Button headerVisibleButton;
    Button sortIndicatorButton;
    Button headerImagesButton;
    Button linesVisibleButton;
    Button subImagesButton;
    Button editableButton;
    static final int ITEM_FOREGROUND_COLOR = 3;
    static final int ITEM_BACKGROUND_COLOR = 4;
    static final int ITEM_FONT = 5;
    static final int CELL_FOREGROUND_COLOR = 6;
    static final int CELL_BACKGROUND_COLOR = 7;
    static final int CELL_FONT = 8;
    static final int HEADER_FOREGROUND_COLOR = 9;
    static final int HEADER_BACKGROUND_COLOR = 10;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Color cellForegroundColor;
    Color cellBackgroundColor;
    Color headerForegroundColor;
    Color headerBackgroundColor;
    Font itemFont;
    Font cellFont;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[][] tableData = new String[][]{{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")}, {ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")}, {ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")}};
    Point menuMouseCoords;

    TableTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createColorAndFontGroup() {
        super.createColorAndFontGroup();
        TableItem item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Font"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Font"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Header_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Header_Background_Color"));
        this.shell.addDisposeListener(event -> {
            if (this.itemFont != null) {
                this.itemFont.dispose();
            }
            if (this.cellFont != null) {
                this.cellFont.dispose();
            }
            this.itemBackgroundColor = null;
            this.itemForegroundColor = null;
            this.itemFont = null;
            this.cellBackgroundColor = null;
            this.cellForegroundColor = null;
            this.cellFont = null;
            this.headerForegroundColor = null;
            this.headerBackgroundColor = null;
        });
    }

    @Override
    void changeFontOrColor(int index) {
        switch (index) {
            case 3: {
                Color oldColor = this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.itemForegroundColor = new Color(rgb);
                this.setItemForeground();
                break;
            }
            case 4: {
                Color oldColor = this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.itemBackgroundColor = new Color(rgb);
                this.setItemBackground();
                break;
            }
            case 5: {
                Font oldFont = this.itemFont;
                if (oldFont == null) {
                    oldFont = this.table1.getItem(0).getFont();
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.itemFont;
                this.itemFont = new Font((Device)this.display, fontData);
                this.setItemFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            case 6: {
                Color oldColor = this.cellForegroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getForeground(1);
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.cellForegroundColor = new Color(rgb);
                this.setCellForeground();
                break;
            }
            case 7: {
                Color oldColor = this.cellBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getBackground(1);
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.cellBackgroundColor = new Color(rgb);
                this.setCellBackground();
                break;
            }
            case 8: {
                Font oldFont = this.cellFont;
                if (oldFont == null) {
                    oldFont = this.table1.getItem(0).getFont(1);
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.cellFont;
                this.cellFont = new Font((Device)this.display, fontData);
                this.setCellFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            case 9: {
                Color oldColor = this.headerForegroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getHeaderForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.headerForegroundColor = new Color(rgb);
                this.setHeaderForeground();
                break;
            }
            case 10: {
                Color oldColor = this.headerBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getHeaderBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.headerBackgroundColor = new Color(rgb);
                this.setHeaderBackground();
                break;
            }
            default: {
                super.changeFontOrColor(index);
            }
        }
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.multipleColumns = new Button((Composite)this.otherGroup, 32);
        this.multipleColumns.setText(ControlExample.getResourceString("Multiple_Columns"));
        this.multipleColumns.setSelection(true);
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.sortIndicatorButton = new Button((Composite)this.otherGroup, 32);
        this.sortIndicatorButton.setText(ControlExample.getResourceString("Sort_Indicator"));
        this.moveableColumns = new Button((Composite)this.otherGroup, 32);
        this.moveableColumns.setText(ControlExample.getResourceString("Moveable_Columns"));
        this.resizableColumns = new Button((Composite)this.otherGroup, 32);
        this.resizableColumns.setText(ControlExample.getResourceString("Resizable_Columns"));
        this.headerImagesButton = new Button((Composite)this.otherGroup, 32);
        this.headerImagesButton.setText(ControlExample.getResourceString("Header_Images"));
        this.subImagesButton = new Button((Composite)this.otherGroup, 32);
        this.subImagesButton.setText(ControlExample.getResourceString("Sub_Images"));
        this.editableButton = new Button((Composite)this.otherGroup, 32);
        this.editableButton.setText(ControlExample.getResourceString("Editable"));
        this.linesVisibleButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetLinesVisible()));
        this.multipleColumns.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
        this.headerVisibleButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetHeaderVisible()));
        this.sortIndicatorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetSortIndicator()));
        this.moveableColumns.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setColumnsMoveable()));
        this.resizableColumns.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setColumnsResizable()));
        this.headerImagesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
        this.subImagesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
        this.editableButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.makeTableContentEditable()));
    }

    void makeTableContentEditable() {
        TableEditor editor = new TableEditor(this.table1);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.table1.addListener(8, event -> {
            Point point;
            TableItem item;
            if (!this.editableButton.getSelection()) {
                return;
            }
            Control oldEditor = editor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            if ((item = this.table1.getItem(point = new Point(event.x, event.y))) == null) {
                return;
            }
            int column = TableTab.findColumnContainingPoint(item, point);
            if (column == -1) {
                return;
            }
            Text newEditor = new Text((Composite)this.table1, 0);
            newEditor.setText(item.getText(column));
            newEditor.addModifyListener(e -> {
                Text text = (Text)editor.getEditor();
                item.setText(column, text.getText());
            });
            newEditor.selectAll();
            newEditor.setFocus();
            newEditor.addListener(16, e -> {
                item.setText(newEditor.getText());
                newEditor.dispose();
            });
            newEditor.addListener(1, e -> {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    item.setText(newEditor.getText());
                    newEditor.dispose();
                }
            });
            editor.setEditor((Control)newEditor, item, column);
        });
    }

    private static int findColumnContainingPoint(TableItem item, Point point) {
        int i = 0;
        while (i < item.getParent().getColumnCount()) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(point)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.tableGroup = new Group((Composite)this.exampleGroup, 0);
        this.tableGroup.setLayout((Layout)new GridLayout());
        this.tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableGroup.setText("Table");
    }

    @Override
    void createExampleWidgets() {
        int i;
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.noScrollButton.getSelection()) {
            style |= 0x10;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.hideSelectionButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.table1 = new Table((Composite)this.tableGroup, style);
        boolean multiColumn = this.multipleColumns.getSelection();
        if (multiColumn) {
            i = 0;
            while (i < columnTitles.length) {
                TableColumn tableColumn = new TableColumn(this.table1, 0);
                tableColumn.setText(columnTitles[i]);
                tableColumn.setToolTipText(ControlExample.getResourceString("Tooltip", columnTitles[i]));
                if (this.headerImagesButton.getSelection()) {
                    tableColumn.setImage(this.instance.images[i % 3]);
                }
                ++i;
            }
            this.table1.setSortColumn(this.table1.getColumn(0));
        }
        i = 0;
        while (i < 16) {
            TableItem item = new TableItem(this.table1, 0);
            if (multiColumn && this.subImagesButton.getSelection()) {
                int j = 0;
                while (j < columnTitles.length) {
                    item.setImage(j, this.instance.images[i % 3]);
                    ++j;
                }
            } else {
                item.setImage(this.instance.images[i % 3]);
            }
            this.setItemText(item, i, ControlExample.getResourceString("Index") + i);
            ++i;
        }
        this.packColumns();
    }

    void setItemText(TableItem item, int i, String node) {
        int index = i % 3;
        if (this.multipleColumns.getSelection()) {
            TableTab.tableData[index][0] = node;
            item.setText(tableData[index]);
        } else {
            item.setText(node);
        }
    }

    @Override
    void createSizeGroup() {
        super.createSizeGroup();
        this.packColumnsButton = new Button((Composite)this.sizeGroup, 8);
        this.packColumnsButton.setText(ControlExample.getResourceString("Pack_Columns"));
        this.packColumnsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.packColumns();
            this.setExampleWidgetSize();
        }));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.noScrollButton = new Button((Composite)this.styleGroup, 32);
        this.noScrollButton.setText("SWT.NO_SCROLL");
        this.noScrollButton.moveAbove((Control)this.borderButton);
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
        this.hideSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.hideSelectionButton.setText("SWT.HIDE_SELECTION");
    }

    @Override
    Item[] getExampleWidgetItems() {
        TableColumn[] columns = this.table1.getColumns();
        TableItem[] items = this.table1.getItems();
        Item[] allItems = new Item[columns.length + items.length];
        System.arraycopy(columns, 0, allItems, 0, columns.length);
        System.arraycopy(items, 0, allItems, columns.length, items.length);
        return allItems;
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.table1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"ColumnOrder", "ItemCount", "Selection", "SelectionIndex", "ToolTipText", "TopIndex"};
    }

    @Override
    String setMethodName(String methodRoot) {
        return methodRoot.equals("SelectionIndex") ? "setSelection" : "set" + methodRoot;
    }

    void packColumns() {
        int columnCount = this.table1.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn tableColumn = this.table1.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    @Override
    Object[] parameterForType(String typeName, String value, Widget widget) {
        TableItem item;
        if (value.isEmpty()) {
            return new Object[]{new TableItem[0]};
        }
        if (typeName.equals("org.eclipse.swt.widgets.TableItem") && (item = this.findItem(value, ((Table)widget).getItems())) != null) {
            return new Object[]{item};
        }
        if (typeName.equals("[Lorg.eclipse.swt.widgets.TableItem;")) {
            String[] values = this.split(value, ',');
            TableItem[] items = new TableItem[values.length];
            int i = 0;
            while (i < values.length) {
                items[i] = this.findItem(values[i], ((Table)widget).getItems());
                ++i;
            }
            return new Object[]{items};
        }
        return super.parameterForType(typeName, value, widget);
    }

    TableItem findItem(String value, TableItem[] items) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(value)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    @Override
    String getTabText() {
        return "Table";
    }

    @Override
    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        this.itemForegroundColor = null;
        this.setItemForeground();
        this.itemBackgroundColor = null;
        this.setItemBackground();
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
        this.cellForegroundColor = null;
        this.setCellForeground();
        this.cellBackgroundColor = null;
        this.setCellBackground();
        oldFont = this.font;
        this.cellFont = null;
        this.setCellFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
        this.headerBackgroundColor = null;
        this.setHeaderBackground();
        this.headerForegroundColor = null;
        this.setHeaderForeground();
    }

    void setCellBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setBackground(1, this.cellBackgroundColor);
        }
        if ((color = this.cellBackgroundColor) == null) {
            color = this.table1.getItem(0).getBackground(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(7)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setCellForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setForeground(1, this.cellForegroundColor);
        }
        if ((color = this.cellForegroundColor) == null) {
            color = this.table1.getItem(0).getForeground(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(6)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setCellFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.table1.getItem(0).setFont(1, this.cellFont);
        }
        if ((ft = this.cellFont) == null) {
            ft = this.table1.getItem(0).getFont(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(8)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setItemBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setBackground(this.itemBackgroundColor);
        }
        if ((color = this.itemBackgroundColor) == null) {
            color = this.table1.getItem(0).getBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(4)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setForeground(this.itemForegroundColor);
        }
        if ((color = this.itemForegroundColor) == null) {
            color = this.table1.getItem(0).getForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(3)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.table1.getItem(0).setFont(this.itemFont);
        }
        if ((ft = this.itemFont) == null) {
            ft = this.table1.getItem(0).getFont();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(5)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setHeaderBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.setHeaderBackground(this.headerBackgroundColor);
        }
        if ((color = this.headerBackgroundColor) == null) {
            color = this.table1.getHeaderBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(10)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setHeaderForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.setHeaderForeground(this.headerForegroundColor);
        }
        if ((color = this.headerForegroundColor) == null) {
            color = this.table1.getHeaderForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(9)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setColumnsMoveable() {
        TableColumn[] columns;
        boolean selection = this.moveableColumns.getSelection();
        TableColumn[] tableColumnArray = columns = this.table1.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setMoveable(selection);
            ++n2;
        }
    }

    void setColumnsResizable() {
        TableColumn[] columns;
        boolean selection = this.resizableColumns.getSelection();
        TableColumn[] tableColumnArray = columns = this.table1.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setResizable(selection);
            ++n2;
        }
    }

    @Override
    void setExampleWidgetState() {
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setCellBackground();
        this.setCellForeground();
        this.setCellFont();
        this.setHeaderBackground();
        this.setHeaderForeground();
        if (!this.instance.startup) {
            this.setColumnsMoveable();
            this.setColumnsResizable();
            this.setWidgetHeaderVisible();
            this.setWidgetSortIndicator();
            this.setWidgetLinesVisible();
        }
        super.setExampleWidgetState();
        this.noScrollButton.setSelection((this.table1.getStyle() & 0x10) != 0);
        this.checkButton.setSelection((this.table1.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.table1.getStyle() & 0x10000) != 0);
        this.hideSelectionButton.setSelection((this.table1.getStyle() & 0x8000) != 0);
        try {
            TableColumn column = this.table1.getColumn(0);
            this.moveableColumns.setSelection(column.getMoveable());
            this.resizableColumns.setSelection(column.getResizable());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.headerVisibleButton.setSelection(this.table1.getHeaderVisible());
        this.linesVisibleButton.setSelection(this.table1.getLinesVisible());
    }

    void setWidgetHeaderVisible() {
        this.table1.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetSortIndicator() {
        TableColumn[] columns = this.table1.getColumns();
        if (this.sortIndicatorButton.getSelection()) {
            this.table1.setSortDirection(1024);
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                if (i == 0) {
                    this.table1.setSortColumn(column);
                }
                SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
                    int sortDirection = 1024;
                    if (e.widget == this.table1.getSortColumn()) {
                        switch (this.table1.getSortDirection()) {
                            case 1024: {
                                sortDirection = 128;
                                break;
                            }
                            case 128: {
                                sortDirection = 0;
                            }
                        }
                    } else {
                        this.table1.setSortColumn((TableColumn)e.widget);
                    }
                    this.table1.setSortDirection(sortDirection);
                });
                column.addSelectionListener(listener);
                column.setData("SortListener", (Object)listener);
                ++i;
            }
        } else {
            this.table1.setSortDirection(0);
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                SelectionListener listener = (SelectionListener)column.getData("SortListener");
                if (listener != null) {
                    column.removeSelectionListener(listener);
                }
                ++n2;
            }
        }
    }

    void setWidgetLinesVisible() {
        this.table1.setLinesVisible(this.linesVisibleButton.getSelection());
    }

    @Override
    protected void specialPopupMenuItems(Menu menu, Event event) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("getItem(Point) on mouse coordinates");
        this.menuMouseCoords = this.table1.toControl(new Point(event.x, event.y));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.eventConsole.append("getItem(Point(" + String.valueOf(this.menuMouseCoords) + ")) returned: " + String.valueOf(this.table1.getItem(this.menuMouseCoords)));
            this.eventConsole.append("\n");
        }));
    }
}

