/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class TextTab
extends ScrollableTab {
    Text text;
    Group textGroup;
    Button wrapButton;
    Button readOnlyButton;
    Button passwordButton;
    Button searchButton;
    Button iconCancelButton;
    Button iconSearchButton;
    Button leftButton;
    Button centerButton;
    Button rightButton;

    TextTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.textGroup = new Group((Composite)this.exampleGroup, 0);
        this.textGroup.setLayout((Layout)new GridLayout());
        this.textGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textGroup.setText("Text");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            style |= 8;
        }
        if (this.passwordButton.getSelection()) {
            style |= 0x400000;
        }
        if (this.searchButton.getSelection()) {
            style |= 0x80;
        }
        if (this.iconCancelButton.getSelection()) {
            style |= 0x100;
        }
        if (this.iconSearchButton.getSelection()) {
            style |= 0x200;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.leftButton.getSelection()) {
            style |= 0x4000;
        }
        if (this.centerButton.getSelection()) {
            style |= 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            style |= 0x20000;
        }
        this.text = new Text((Composite)this.textGroup, style);
        this.text.setText(ControlExample.getResourceString("Example_string") + Text.DELIMITER + ControlExample.getResourceString("One_Two_Three"));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.passwordButton = new Button((Composite)this.styleGroup, 32);
        this.passwordButton.setText("SWT.PASSWORD");
        this.searchButton = new Button((Composite)this.styleGroup, 32);
        this.searchButton.setText("SWT.SEARCH");
        this.iconCancelButton = new Button((Composite)this.styleGroup, 32);
        this.iconCancelButton.setText("SWT.ICON_CANCEL");
        this.iconSearchButton = new Button((Composite)this.styleGroup, 32);
        this.iconSearchButton.setText("SWT.ICON_SEARCH");
        Composite alignmentGroup = new Composite((Composite)this.styleGroup, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        alignmentGroup.setLayout((Layout)layout);
        alignmentGroup.setLayoutData((Object)new GridData(1808));
        this.leftButton = new Button(alignmentGroup, 16);
        this.leftButton.setText("SWT.LEFT");
        this.centerButton = new Button(alignmentGroup, 16);
        this.centerButton.setText("SWT.CENTER");
        this.rightButton = new Button(alignmentGroup, 16);
        this.rightButton.setText("SWT.RIGHT");
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener(ControlListener.controlResizedAdapter(e -> this.setExampleWidgetSize()));
        return this.tabFolderPage;
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.text};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"DoubleClickEnabled", "EchoChar", "Editable", "Message", "Orientation", "Selection", "Tabs", "Text", "TextChars", "TextLimit", "ToolTipText", "TopIndex"};
    }

    @Override
    String getTabText() {
        return "Text";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.text.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.text.getStyle() & 8) != 0);
        this.passwordButton.setSelection((this.text.getStyle() & 0x400000) != 0);
        this.searchButton.setSelection((this.text.getStyle() & 0x80) != 0);
        this.leftButton.setSelection((this.text.getStyle() & 0x4000) != 0);
        this.centerButton.setSelection((this.text.getStyle() & 0x1000000) != 0);
        this.rightButton.setSelection((this.text.getStyle() & 0x20000) != 0);
        if ((this.text.getStyle() & 0x80) != 0) {
            this.iconCancelButton.setSelection((this.text.getStyle() & 0x100) != 0);
            this.iconSearchButton.setSelection((this.text.getStyle() & 0x200) != 0);
            this.horizontalButton.setSelection(false);
            this.verticalButton.setSelection(false);
        } else {
            this.iconCancelButton.setSelection(false);
            this.iconSearchButton.setSelection(false);
            this.horizontalButton.setSelection((this.text.getStyle() & 0x100) != 0);
            this.verticalButton.setSelection((this.text.getStyle() & 0x200) != 0);
        }
        this.passwordButton.setEnabled((this.text.getStyle() & 4) != 0);
        this.searchButton.setEnabled((this.text.getStyle() & 4) != 0);
        this.iconCancelButton.setEnabled((this.text.getStyle() & 0x80) != 0);
        this.iconSearchButton.setEnabled((this.text.getStyle() & 0x80) != 0);
        this.wrapButton.setEnabled((this.text.getStyle() & 2) != 0);
        this.horizontalButton.setEnabled((this.text.getStyle() & 2) != 0);
        this.verticalButton.setEnabled((this.text.getStyle() & 2) != 0);
    }
}

