/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeTab
extends ScrollableTab {
    Tree tree1;
    Tree tree2;
    TreeItem textNode1;
    TreeItem imageNode1;
    Group treeGroup;
    Group imageTreeGroup;
    Group itemGroup;
    Button packColumnsButton;
    Button noScrollButton;
    Button checkButton;
    Button fullSelectionButton;
    Button multipleColumns;
    Button moveableColumns;
    Button resizableColumns;
    Button headerVisibleButton;
    Button sortIndicatorButton;
    Button headerImagesButton;
    Button subImagesButton;
    Button linesVisibleButton;
    Button editableButton;
    static final int ITEM_FOREGROUND_COLOR = 3;
    static final int ITEM_BACKGROUND_COLOR = 4;
    static final int ITEM_FONT = 5;
    static final int CELL_FOREGROUND_COLOR = 6;
    static final int CELL_BACKGROUND_COLOR = 7;
    static final int CELL_FONT = 8;
    static final int HEADER_FOREGROUND_COLOR = 9;
    static final int HEADER_BACKGROUND_COLOR = 10;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Color cellForegroundColor;
    Color cellBackgroundColor;
    Color headerForegroundColor;
    Color headerBackgroundColor;
    Font itemFont;
    Font cellFont;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[][] tableData = new String[][]{{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")}, {ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")}, {ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")}};
    Point menuMouseCoords;

    TreeTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createColorAndFontGroup() {
        super.createColorAndFontGroup();
        TableItem item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Font"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Font"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Header_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Header_Background_Color"));
        this.shell.addDisposeListener(event -> {
            if (this.itemFont != null) {
                this.itemFont.dispose();
            }
            if (this.cellFont != null) {
                this.cellFont.dispose();
            }
            this.itemBackgroundColor = null;
            this.itemForegroundColor = null;
            this.itemFont = null;
            this.cellBackgroundColor = null;
            this.cellForegroundColor = null;
            this.cellFont = null;
            this.headerForegroundColor = null;
            this.headerBackgroundColor = null;
        });
    }

    @Override
    void changeFontOrColor(int index) {
        switch (index) {
            case 3: {
                Color oldColor = this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = this.textNode1.getForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.itemForegroundColor = new Color(rgb);
                this.setItemForeground();
                break;
            }
            case 4: {
                Color oldColor = this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.textNode1.getBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.itemBackgroundColor = new Color(rgb);
                this.setItemBackground();
                break;
            }
            case 5: {
                Font oldFont = this.itemFont;
                if (oldFont == null) {
                    oldFont = this.textNode1.getFont();
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.itemFont;
                this.itemFont = new Font((Device)this.display, fontData);
                this.setItemFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            case 6: {
                Color oldColor = this.cellForegroundColor;
                if (oldColor == null) {
                    oldColor = this.textNode1.getForeground(1);
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.cellForegroundColor = new Color(rgb);
                this.setCellForeground();
                break;
            }
            case 7: {
                Color oldColor = this.cellBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.textNode1.getBackground(1);
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.cellBackgroundColor = new Color(rgb);
                this.setCellBackground();
                break;
            }
            case 8: {
                Font oldFont = this.cellFont;
                if (oldFont == null) {
                    oldFont = this.textNode1.getFont(1);
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.cellFont;
                this.cellFont = new Font((Device)this.display, fontData);
                this.setCellFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            case 9: {
                Color oldColor = this.headerForegroundColor;
                if (oldColor == null) {
                    oldColor = this.tree1.getHeaderForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.headerForegroundColor = new Color(rgb);
                this.setHeaderForeground();
                break;
            }
            case 10: {
                Color oldColor = this.headerBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.tree1.getHeaderBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                this.headerBackgroundColor = new Color(rgb);
                this.setHeaderBackground();
            }
            default: {
                super.changeFontOrColor(index);
            }
        }
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.multipleColumns = new Button((Composite)this.otherGroup, 32);
        this.multipleColumns.setText(ControlExample.getResourceString("Multiple_Columns"));
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.sortIndicatorButton = new Button((Composite)this.otherGroup, 32);
        this.sortIndicatorButton.setText(ControlExample.getResourceString("Sort_Indicator"));
        this.moveableColumns = new Button((Composite)this.otherGroup, 32);
        this.moveableColumns.setText(ControlExample.getResourceString("Moveable_Columns"));
        this.resizableColumns = new Button((Composite)this.otherGroup, 32);
        this.resizableColumns.setText(ControlExample.getResourceString("Resizable_Columns"));
        this.headerImagesButton = new Button((Composite)this.otherGroup, 32);
        this.headerImagesButton.setText(ControlExample.getResourceString("Header_Images"));
        this.subImagesButton = new Button((Composite)this.otherGroup, 32);
        this.subImagesButton.setText(ControlExample.getResourceString("Sub_Images"));
        this.editableButton = new Button((Composite)this.otherGroup, 32);
        this.editableButton.setText(ControlExample.getResourceString("Editable"));
        this.linesVisibleButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetLinesVisible()));
        this.multipleColumns.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
        this.headerVisibleButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetHeaderVisible()));
        this.sortIndicatorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetSortIndicator()));
        this.moveableColumns.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setColumnsMoveable()));
        this.resizableColumns.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setColumnsResizable()));
        this.headerImagesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
        this.subImagesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
        this.editableButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.makeTreeContentEditable()));
    }

    void makeTreeContentEditable() {
        this.makeTreeEditable(this.tree1);
        this.makeTreeEditable(this.tree2);
    }

    private void makeTreeEditable(Tree tree) {
        TreeEditor editor = new TreeEditor(tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        tree.addListener(8, event -> this.treeDoubleClickListener(tree, editor, event));
    }

    private void treeDoubleClickListener(Tree tree, TreeEditor editor, Event event) {
        if (!this.editableButton.getSelection()) {
            return;
        }
        Point point = new Point(event.x, event.y);
        TreeItem item = tree.getItem(point);
        if (item == null) {
            return;
        }
        String oldText = item.getText();
        Text text = new Text((Composite)tree, 0);
        text.setText(oldText);
        text.selectAll();
        text.setFocus();
        text.addListener(16, e -> {
            item.setText(text.getText());
            text.dispose();
        });
        text.addListener(1, e -> {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                item.setText(text.getText());
                text.dispose();
            }
        });
        editor.setEditor((Control)text, item);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.treeGroup = new Group((Composite)this.exampleGroup, 0);
        this.treeGroup.setLayout((Layout)new GridLayout());
        this.treeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeGroup.setText("Tree");
        this.imageTreeGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageTreeGroup.setLayout((Layout)new GridLayout());
        this.imageTreeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageTreeGroup.setText(ControlExample.getResourceString("Tree_With_Images"));
    }

    @Override
    void createExampleWidgets() {
        int j;
        TreeColumn treeColumn;
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.noScrollButton.getSelection()) {
            style |= 0x10;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.tree1 = new Tree((Composite)this.treeGroup, style);
        boolean multiColumn = this.multipleColumns.getSelection();
        if (multiColumn) {
            String[] stringArray = columnTitles;
            int n = columnTitles.length;
            int n2 = 0;
            while (n2 < n) {
                String columnTitle = stringArray[n2];
                treeColumn = new TreeColumn(this.tree1, 0);
                treeColumn.setText(columnTitle);
                treeColumn.setToolTipText(ControlExample.getResourceString("Tooltip", columnTitle));
                ++n2;
            }
            this.tree1.setSortColumn(this.tree1.getColumn(0));
        }
        int i = 0;
        while (i < 4) {
            TreeItem item = new TreeItem(this.tree1, 0);
            this.setItemText(item, i, ControlExample.getResourceString("Node_" + (i + 1)));
            if (i < 3) {
                TreeItem subitem = new TreeItem(item, 0);
                this.setItemText(subitem, i, ControlExample.getResourceString("Node_" + (i + 1) + "_1"));
            }
            ++i;
        }
        TreeItem[] treeRoots = this.tree1.getItems();
        TreeItem item = new TreeItem(treeRoots[1], 0);
        this.setItemText(item, 1, ControlExample.getResourceString("Node_2_2"));
        item = new TreeItem(item, 0);
        this.setItemText(item, 1, ControlExample.getResourceString("Node_2_2_1"));
        this.textNode1 = treeRoots[0];
        this.packColumns(this.tree1);
        try {
            TreeColumn column = this.tree1.getColumn(0);
            this.resizableColumns.setSelection(column.getResizable());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.tree2 = new Tree((Composite)this.imageTreeGroup, style);
        Image image = this.instance.images[0];
        if (multiColumn) {
            int i2 = 0;
            while (i2 < columnTitles.length) {
                treeColumn = new TreeColumn(this.tree2, 0);
                treeColumn.setText(columnTitles[i2]);
                treeColumn.setToolTipText(ControlExample.getResourceString("Tooltip", columnTitles[i2]));
                if (this.headerImagesButton.getSelection()) {
                    treeColumn.setImage(this.instance.images[i2 % 3]);
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < 4) {
            item = new TreeItem(this.tree2, 0);
            this.setItemText(item, i3, ControlExample.getResourceString("Node_" + (i3 + 1)));
            if (multiColumn && this.subImagesButton.getSelection()) {
                int j2 = 0;
                while (j2 < columnTitles.length) {
                    item.setImage(j2, image);
                    ++j2;
                }
            } else {
                item.setImage(image);
            }
            if (i3 < 3) {
                TreeItem subitem = new TreeItem(item, 0);
                this.setItemText(subitem, i3, ControlExample.getResourceString("Node_" + (i3 + 1) + "_1"));
                if (multiColumn && this.subImagesButton.getSelection()) {
                    int j3 = 0;
                    while (j3 < columnTitles.length) {
                        subitem.setImage(j3, image);
                        ++j3;
                    }
                } else {
                    subitem.setImage(image);
                }
            }
            ++i3;
        }
        treeRoots = this.tree2.getItems();
        item = new TreeItem(treeRoots[1], 0);
        this.setItemText(item, 1, ControlExample.getResourceString("Node_2_2"));
        if (multiColumn && this.subImagesButton.getSelection()) {
            j = 0;
            while (j < columnTitles.length) {
                item.setImage(j, image);
                ++j;
            }
        } else {
            item.setImage(image);
        }
        item = new TreeItem(item, 0);
        this.setItemText(item, 1, ControlExample.getResourceString("Node_2_2_1"));
        if (multiColumn && this.subImagesButton.getSelection()) {
            j = 0;
            while (j < columnTitles.length) {
                item.setImage(j, image);
                ++j;
            }
        } else {
            item.setImage(image);
        }
        this.imageNode1 = treeRoots[0];
        this.packColumns(this.tree2);
    }

    void setItemText(TreeItem item, int i, String node) {
        int index = i % 3;
        if (this.multipleColumns.getSelection()) {
            TreeTab.tableData[index][0] = node;
            item.setText(tableData[index]);
        } else {
            item.setText(node);
        }
    }

    @Override
    void createSizeGroup() {
        super.createSizeGroup();
        this.packColumnsButton = new Button((Composite)this.sizeGroup, 8);
        this.packColumnsButton.setText(ControlExample.getResourceString("Pack_Columns"));
        this.packColumnsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.packColumns(this.tree1);
            this.packColumns(this.tree2);
            this.setExampleWidgetSize();
        }));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.noScrollButton = new Button((Composite)this.styleGroup, 32);
        this.noScrollButton.setText("SWT.NO_SCROLL");
        this.noScrollButton.moveAbove((Control)this.borderButton);
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    @Override
    Item[] getExampleWidgetItems() {
        TreeColumn[] columns1 = this.tree1.getColumns();
        TreeColumn[] columns2 = this.tree2.getColumns();
        Item[] allItems = new Item[columns1.length + columns2.length];
        System.arraycopy(columns1, 0, allItems, 0, columns1.length);
        System.arraycopy(columns2, 0, allItems, columns1.length, columns2.length);
        return allItems;
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.tree1, this.tree2};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"ColumnOrder", "Selection", "ToolTipText", "TopItem"};
    }

    @Override
    Object[] parameterForType(String typeName, String value, Widget widget) {
        TreeItem item;
        if (typeName.equals("org.eclipse.swt.widgets.TreeItem") && (item = this.findItem(value, ((Tree)widget).getItems())) != null) {
            return new Object[]{item};
        }
        if (typeName.equals("[Lorg.eclipse.swt.widgets.TreeItem;")) {
            String[] values = this.split(value, ',');
            TreeItem[] items = new TreeItem[values.length];
            int i = 0;
            while (i < values.length) {
                TreeItem item2 = this.findItem(values[i], ((Tree)widget).getItems());
                if (item2 == null) break;
                items[i] = item2;
                ++i;
            }
            return new Object[]{items};
        }
        return super.parameterForType(typeName, value, widget);
    }

    TreeItem findItem(String value, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getText().equals(value)) {
                return item;
            }
            if ((item = this.findItem(value, item.getItems())) != null) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    @Override
    String getTabText() {
        return "Tree";
    }

    void packColumns(Tree tree) {
        if (this.multipleColumns.getSelection()) {
            int columnCount = tree.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                TreeColumn treeColumn = tree.getColumn(i);
                treeColumn.pack();
                ++i;
            }
        }
    }

    void setHeaderBackground() {
        TableItem item;
        Image oldImage1;
        Color color;
        if (!this.instance.startup) {
            this.tree1.setHeaderBackground(this.headerBackgroundColor);
            this.tree2.setHeaderBackground(this.headerBackgroundColor);
        }
        if ((color = this.headerBackgroundColor) == null) {
            color = this.tree1.getHeaderBackground();
        }
        if ((oldImage1 = (item = this.colorAndFontTable.getItem(10)).getImage()) != null) {
            oldImage1.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setHeaderForeground() {
        TableItem item;
        Image oldImage1;
        Color color;
        if (!this.instance.startup) {
            this.tree1.setHeaderForeground(this.headerForegroundColor);
            this.tree2.setHeaderForeground(this.headerForegroundColor);
        }
        if ((color = this.headerForegroundColor) == null) {
            color = this.tree1.getHeaderForeground();
        }
        if ((oldImage1 = (item = this.colorAndFontTable.getItem(9)).getImage()) != null) {
            oldImage1.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setColumnsMoveable() {
        TreeColumn[] columns2;
        TreeColumn[] columns1;
        boolean selection = this.moveableColumns.getSelection();
        TreeColumn[] treeColumnArray = columns1 = this.tree1.getColumns();
        int n = columns1.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.setMoveable(selection);
            ++n2;
        }
        TreeColumn[] treeColumnArray2 = columns2 = this.tree2.getColumns();
        int n3 = columns2.length;
        n = 0;
        while (n < n3) {
            TreeColumn column = treeColumnArray2[n];
            column.setMoveable(selection);
            ++n;
        }
    }

    void setColumnsResizable() {
        TreeColumn[] columns2;
        TreeColumn[] columns1;
        boolean selection = this.resizableColumns.getSelection();
        TreeColumn[] treeColumnArray = columns1 = this.tree1.getColumns();
        int n = columns1.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.setResizable(selection);
            ++n2;
        }
        TreeColumn[] treeColumnArray2 = columns2 = this.tree2.getColumns();
        int n3 = columns2.length;
        n = 0;
        while (n < n3) {
            TreeColumn column = treeColumnArray2[n];
            column.setResizable(selection);
            ++n;
        }
    }

    @Override
    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        this.itemForegroundColor = null;
        this.setItemForeground();
        this.itemBackgroundColor = null;
        this.setItemBackground();
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
        this.cellForegroundColor = null;
        this.setCellForeground();
        this.cellBackgroundColor = null;
        this.setCellBackground();
        oldFont = this.font;
        this.cellFont = null;
        this.setCellFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
        this.headerBackgroundColor = null;
        this.setHeaderBackground();
        this.headerForegroundColor = null;
        this.setHeaderForeground();
    }

    @Override
    void setExampleWidgetState() {
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setCellBackground();
        this.setCellForeground();
        this.setCellFont();
        this.setHeaderBackground();
        this.setHeaderForeground();
        if (!this.instance.startup) {
            this.setColumnsMoveable();
            this.setColumnsResizable();
            this.setWidgetHeaderVisible();
            this.setWidgetSortIndicator();
            this.setWidgetLinesVisible();
        }
        super.setExampleWidgetState();
        this.noScrollButton.setSelection((this.tree1.getStyle() & 0x10) != 0);
        this.checkButton.setSelection((this.tree1.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.tree1.getStyle() & 0x10000) != 0);
        try {
            TreeColumn column = this.tree1.getColumn(0);
            this.moveableColumns.setSelection(column.getMoveable());
            this.resizableColumns.setSelection(column.getResizable());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.headerVisibleButton.setSelection(this.tree1.getHeaderVisible());
        this.linesVisibleButton.setSelection(this.tree1.getLinesVisible());
    }

    void setCellBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.textNode1.setBackground(1, this.cellBackgroundColor);
            this.imageNode1.setBackground(1, this.cellBackgroundColor);
        }
        if ((color = this.cellBackgroundColor) == null) {
            color = this.textNode1.getBackground(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(7)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setCellForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.textNode1.setForeground(1, this.cellForegroundColor);
            this.imageNode1.setForeground(1, this.cellForegroundColor);
        }
        if ((color = this.cellForegroundColor) == null) {
            color = this.textNode1.getForeground(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(6)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setCellFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.textNode1.setFont(1, this.cellFont);
            this.imageNode1.setFont(1, this.cellFont);
        }
        if ((ft = this.cellFont) == null) {
            ft = this.textNode1.getFont(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(8)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setItemBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.textNode1.setBackground(this.itemBackgroundColor);
            this.imageNode1.setBackground(this.itemBackgroundColor);
        }
        if ((color = this.itemBackgroundColor) == null) {
            color = this.textNode1.getBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(4)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.textNode1.setForeground(this.itemForegroundColor);
            this.imageNode1.setForeground(this.itemForegroundColor);
        }
        if ((color = this.itemForegroundColor) == null) {
            color = this.textNode1.getForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(3)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.textNode1.setFont(this.itemFont);
            this.imageNode1.setFont(this.itemFont);
        }
        if ((ft = this.itemFont) == null) {
            ft = this.textNode1.getFont();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(5)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setWidgetHeaderVisible() {
        this.tree1.setHeaderVisible(this.headerVisibleButton.getSelection());
        this.tree2.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetSortIndicator() {
        if (this.sortIndicatorButton.getSelection()) {
            this.initializeSortState(this.tree1);
            this.initializeSortState(this.tree2);
        } else {
            this.resetSortState(this.tree1);
            this.resetSortState(this.tree2);
        }
    }

    void initializeSortState(Tree tree) {
        tree.setSortDirection(1024);
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn column = columns[i];
            if (i == 0) {
                tree.setSortColumn(column);
            }
            SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
                int sortDirection = 1024;
                if (e.widget == tree.getSortColumn()) {
                    switch (tree.getSortDirection()) {
                        case 1024: {
                            sortDirection = 128;
                            break;
                        }
                        case 128: {
                            sortDirection = 0;
                        }
                    }
                } else {
                    tree.setSortColumn((TreeColumn)e.widget);
                }
                tree.setSortDirection(sortDirection);
            });
            column.addSelectionListener(listener);
            column.setData("SortListener", (Object)listener);
            ++i;
        }
    }

    void resetSortState(Tree tree) {
        TreeColumn[] columns;
        tree.setSortDirection(0);
        TreeColumn[] treeColumnArray = columns = tree.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            SelectionListener listener = (SelectionListener)column.getData("SortListener");
            if (listener != null) {
                column.removeSelectionListener(listener);
            }
            ++n2;
        }
    }

    void setWidgetLinesVisible() {
        this.tree1.setLinesVisible(this.linesVisibleButton.getSelection());
        this.tree2.setLinesVisible(this.linesVisibleButton.getSelection());
    }

    @Override
    protected void specialPopupMenuItems(Menu menu, Event event) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("getItem(Point) on mouse coordinates");
        Tree t = (Tree)event.widget;
        this.menuMouseCoords = t.toControl(new Point(event.x, event.y));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.eventConsole.append("getItem(Point(" + String.valueOf(this.menuMouseCoords) + ")) returned: " + String.valueOf(t.getItem(this.menuMouseCoords)));
            this.eventConsole.append("\n");
        }));
    }
}

