/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.fileviewer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.examples.fileviewer.FileViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

class IconCache {
    public final int shellIcon = 0;
    public final int iconClosedDrive = 1;
    public final int iconClosedFolder = 2;
    public final int iconFile = 3;
    public final int iconOpenDrive = 4;
    public final int iconOpenFolder = 5;
    public final int cmdCopy = 6;
    public final int cmdCut = 7;
    public final int cmdDelete = 8;
    public final int cmdParent = 9;
    public final int cmdPaste = 10;
    public final int cmdPrint = 11;
    public final int cmdRefresh = 12;
    public final int cmdRename = 13;
    public final int cmdSearch = 14;
    public final String[] stockImageLocations = new String[]{"generic_example.gif", "icon_ClosedDrive.gif", "icon_ClosedFolder.gif", "icon_File.gif", "icon_OpenDrive.gif", "icon_OpenFolder.gif", "cmd_Copy.gif", "cmd_Cut.gif", "cmd_Delete.gif", "cmd_Parent.gif", "cmd_Paste.gif", "cmd_Print.gif", "cmd_Refresh.gif", "cmd_Rename.gif", "cmd_Search.gif"};
    public Image[] stockImages;
    public final int cursorDefault = 0;
    public final int cursorWait = 1;
    public Cursor[] stockCursors;
    private Map<Program, Image> iconCache;

    public void initResources(Display display) {
        if (this.stockImages == null) {
            this.stockImages = new Image[this.stockImageLocations.length];
            int i = 0;
            while (i < this.stockImageLocations.length) {
                Image image = this.createStockImage(display, this.stockImageLocations[i]);
                if (image == null) {
                    this.freeResources();
                    throw new IllegalStateException(FileViewer.getResourceString("error.CouldNotLoadResources"));
                }
                this.stockImages[i] = image;
                ++i;
            }
        }
        if (this.stockCursors == null) {
            Cursor[] cursorArray = new Cursor[2];
            cursorArray[1] = display.getSystemCursor(1);
            this.stockCursors = cursorArray;
        }
        this.iconCache = new HashMap<Program, Image>();
    }

    public void freeResources() {
        if (this.stockImages != null) {
            Image[] imageArray = this.stockImages;
            int n = this.stockImages.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
            this.stockImages = null;
        }
        if (this.iconCache != null) {
            for (Image image : this.iconCache.values()) {
                image.dispose();
            }
            this.iconCache = null;
        }
        this.stockCursors = null;
    }

    private Image createStockImage(Display display, String path) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = IconCache.class.getResourceAsStream(path);){
                ImageData imageData = new ImageData(stream);
                ImageData mask = imageData.getTransparencyMask();
                Image result = new Image((Device)display, imageData, mask);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Image getIconFromProgram(Program program) {
        Image image = this.iconCache.get(program);
        if (image == null) {
            ImageData imageData = program.getImageData();
            if (imageData != null) {
                image = new Image(null, imageData, imageData.getTransparencyMask());
                this.iconCache.put(program, image);
            } else {
                image = this.stockImages[3];
            }
        }
        return image;
    }
}

