/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class AdvancedGraphics {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("examples_graphics");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Image loadImage(Device device, Class<AdvancedGraphics> clazz, String string) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream stream = clazz.getResourceAsStream(string);){
                Image image = new Image(device, stream);
                if (stream != null) return image;
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SWTException sWTException) {
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public Shell open(Display display) {
        Shell shell = new Shell(display);
        shell.setText(RESOURCE_BUNDLE.getString("AdvancedGraphics"));
        try {
            Path path = new Path((Device)display);
            path.dispose();
        }
        catch (SWTException sWTException) {
            MessageBox dialog = new MessageBox(shell, 40);
            dialog.setText(RESOURCE_BUNDLE.getString("Warning"));
            dialog.setMessage(RESOURCE_BUNDLE.getString("LibNotFound"));
            dialog.open();
            shell.dispose();
            return null;
        }
        FontData fd = shell.getFont().getFontData()[0];
        Font font = new Font((Device)display, fd.getName(), 96, 3);
        Image image = AdvancedGraphics.loadImage((Device)display, AdvancedGraphics.class, "irmaos.jpg");
        Rectangle rect = image.getBounds();
        shell.addListener(9, event -> {
            GC gc = event.gc;
            Transform tr = new Transform((Device)display);
            tr.translate((float)(rectangle.width / 4), (float)(rectangle.height / 2));
            tr.rotate(-30.0f);
            if (image != null) {
                gc.drawImage(image, 0, 0, rectangle.width, rectangle.height, 0, 0, rectangle.width, rectangle.height);
            }
            gc.setAlpha(100);
            gc.setTransform(tr);
            Path path = new Path((Device)display);
            path.addString("SWT", 0.0f, 0.0f, font);
            gc.setBackground(display.getSystemColor(5));
            gc.setForeground(display.getSystemColor(9));
            gc.fillPath(path);
            gc.drawPath(path);
            tr.dispose();
            path.dispose();
        });
        shell.setSize(shell.computeSize(rect.width, rect.height));
        shell.open();
        shell.addListener(12, event -> {
            if (image != null) {
                image.dispose();
            }
            font.dispose();
        });
        return shell;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new AdvancedGraphics().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

