/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.examples.graphics.ColorListener;
import org.eclipse.swt.examples.graphics.GradientDialog;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ColorMenu {
    boolean enableColorItems = true;
    boolean enablePatternItems;
    boolean enableGradientItems;

    public void setColorItems(boolean enable) {
        this.enableColorItems = enable;
    }

    public boolean getColorItems() {
        return this.enableColorItems;
    }

    public void setPatternItems(boolean enable) {
        this.enablePatternItems = enable;
    }

    public boolean getPatternItems() {
        return this.enablePatternItems;
    }

    public void setGradientItems(boolean enable) {
        this.enableGradientItems = enable;
    }

    public boolean getGradientItems() {
        return this.enableGradientItems;
    }

    public Menu createMenu(Control parent, ColorListener cl) {
        Menu menu = new Menu(parent);
        MenuItemListener menuItemListener = this.createMenuItemListener(parent);
        menu.addListener(13, (Listener)menuItemListener);
        menu.addListener(12, (Listener)menuItemListener);
        menuItemListener.setColorListener(cl);
        if (this.enableColorItems) {
            this.addColorItems(menu, menuItemListener, menuItemListener.getMenuResources());
        }
        if (this.enablePatternItems) {
            this.addPatternItems(menu, menuItemListener, menuItemListener.getMenuResources());
        }
        if (this.enableGradientItems) {
            this.addGradientItems(menu, menuItemListener);
        }
        return menu;
    }

    private void addColorItems(Menu menu, MenuItemListener menuListener, List<Image> menuResources) {
        Display display = menu.getDisplay();
        if (menu.getItemCount() != 0) {
            new MenuItem(menu, 2);
        }
        String[] names = new String[]{GraphicsExample.getResourceString("White"), GraphicsExample.getResourceString("Black"), GraphicsExample.getResourceString("Red"), GraphicsExample.getResourceString("Green"), GraphicsExample.getResourceString("Blue"), GraphicsExample.getResourceString("Yellow"), GraphicsExample.getResourceString("Cyan")};
        Color[] colors = new Color[]{display.getSystemColor(1), display.getSystemColor(2), display.getSystemColor(3), display.getSystemColor(5), display.getSystemColor(9), display.getSystemColor(7), display.getSystemColor(13)};
        int i = 0;
        while (i < names.length) {
            MenuItem item = new MenuItem(menu, 0);
            item.setText(names[i]);
            item.addListener(13, (Listener)menuListener);
            Color color = colors[i];
            GraphicsBackground gb = new GraphicsBackground();
            Image image = GraphicsExample.createImage((Device)display, color);
            gb.setBgColor1(color);
            gb.setBgImage(image);
            gb.setThumbNail(image);
            menuResources.add(image);
            item.setImage(image);
            item.setData((Object)gb);
            ++i;
        }
        menuListener.customColorMI = new MenuItem(menu, 0);
        menuListener.customColorMI.setText(GraphicsExample.getResourceString("CustomColor"));
        menuListener.customColorMI.addListener(13, (Listener)menuListener);
        GraphicsBackground gb = new GraphicsBackground();
        menuListener.customColorMI.setData((Object)gb);
    }

    private void addPatternItems(Menu menu, MenuItemListener menuListener, List<Image> menuResources) {
        Display display = menu.getDisplay();
        if (menu.getItemCount() != 0) {
            new MenuItem(menu, 2);
        }
        String[] names = new String[]{GraphicsExample.getResourceString("Pattern1"), GraphicsExample.getResourceString("Pattern2"), GraphicsExample.getResourceString("Pattern3")};
        Image[] images = new Image[]{this.loadImage(display, "pattern1.jpg", menuResources), this.loadImage(display, "pattern2.jpg", menuResources), this.loadImage(display, "pattern3.jpg", menuResources)};
        int i = 0;
        while (i < names.length) {
            MenuItem item = new MenuItem(menu, 0);
            item.setText(names[i]);
            item.addListener(13, (Listener)menuListener);
            Image image = images[i];
            GraphicsBackground gb = new GraphicsBackground();
            gb.setBgImage(image);
            gb.setThumbNail(image);
            item.setImage(image);
            item.setData((Object)gb);
            ++i;
        }
        menuListener.customPatternMI = new MenuItem(menu, 0);
        menuListener.customPatternMI.setText(GraphicsExample.getResourceString("CustomPattern"));
        menuListener.customPatternMI.addListener(13, (Listener)menuListener);
        GraphicsBackground gb = new GraphicsBackground();
        menuListener.customPatternMI.setData((Object)gb);
    }

    private void addGradientItems(Menu menu, MenuItemListener menuListener) {
        if (menu.getItemCount() != 0) {
            new MenuItem(menu, 2);
        }
        menuListener.customGradientMI = new MenuItem(menu, 0);
        menuListener.customGradientMI.setText(GraphicsExample.getResourceString("Gradient"));
        menuListener.customGradientMI.addListener(13, (Listener)menuListener);
        GraphicsBackground gb = new GraphicsBackground();
        menuListener.customGradientMI.setData((Object)gb);
    }

    private MenuItemListener createMenuItemListener(Control parent) {
        return new MenuItemListener(parent);
    }

    private Image loadImage(Display display, String name, List<Image> resources) {
        Image image = GraphicsExample.loadImage((Device)display, GraphicsExample.class, name);
        if (image != null) {
            resources.add(image);
        }
        return image;
    }

    static class MenuItemListener
    implements Listener {
        MenuItem customColorMI;
        MenuItem customPatternMI;
        MenuItem customGradientMI;
        Control parent;
        Image customImage;
        Image customImageThumb;
        Color customColor;
        GraphicsBackground background;
        ColorListener colorListener;
        List<Image> resourceImages;

        public MenuItemListener(Control parent) {
            this.parent = parent;
            this.resourceImages = new ArrayList<Image>();
        }

        public void setColorListener(ColorListener cl) {
            this.colorListener = cl;
        }

        public List<Image> getMenuResources() {
            return this.resourceImages;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    for (Image image : this.resourceImages) {
                        image.dispose();
                    }
                    this.resourceImages = new ArrayList<Image>();
                    break;
                }
                case 13: {
                    Display display = event.display;
                    MenuItem item = (MenuItem)event.widget;
                    if (this.customColorMI == item) {
                        RGB rgb;
                        ColorDialog dialog = new ColorDialog(this.parent.getShell());
                        if (this.customColor != null && !this.customColor.isDisposed()) {
                            dialog.setRGB(this.customColor.getRGB());
                        }
                        if ((rgb = dialog.open()) == null) {
                            return;
                        }
                        this.customColor = new Color(rgb);
                        if (this.customPatternMI != null) {
                            this.customPatternMI.setImage(null);
                        }
                        if (this.customGradientMI != null) {
                            this.customGradientMI.setImage(null);
                        }
                        if (this.customImage != null) {
                            this.customImage.dispose();
                        }
                        this.customImage = GraphicsExample.createImage((Device)display, this.customColor);
                        GraphicsBackground gb = new GraphicsBackground();
                        gb.setBgImage(this.customImage);
                        gb.setThumbNail(this.customImage);
                        gb.setBgColor1(this.customColor);
                        item.setData((Object)gb);
                        item.setImage(this.customImage);
                        this.resourceImages.add(this.customImage);
                    } else if (this.customPatternMI == item) {
                        FileDialog dialog = new FileDialog(this.parent.getShell());
                        dialog.setFilterExtensions(new String[]{"*.jpg", "*.gif", "*.*"});
                        String name = dialog.open();
                        if (name == null) {
                            return;
                        }
                        if (this.customColorMI != null) {
                            this.customColorMI.setImage(null);
                        }
                        if (this.customGradientMI != null) {
                            this.customGradientMI.setImage(null);
                        }
                        if (this.customImage != null) {
                            this.customImage.dispose();
                        }
                        if (this.customImageThumb != null) {
                            this.customImageThumb.dispose();
                        }
                        this.customImage = new Image((Device)display, name);
                        this.customImageThumb = GraphicsExample.createThumbnail((Device)display, name);
                        GraphicsBackground gb = new GraphicsBackground();
                        gb.setBgImage(this.customImage);
                        gb.setThumbNail(this.customImageThumb);
                        item.setData((Object)gb);
                        item.setImage(this.customImageThumb);
                        this.resourceImages.add(this.customImageThumb);
                    } else if (this.customGradientMI == item) {
                        GradientDialog dialog = new GradientDialog(this.parent.getShell());
                        if (this.background != null) {
                            if (this.background.getBgColor1() != null) {
                                dialog.setFirstRGB(this.background.getBgColor1().getRGB());
                            }
                            if (this.background.getBgColor2() != null) {
                                dialog.setSecondRGB(this.background.getBgColor2().getRGB());
                            }
                        }
                        if (dialog.open() != 32) {
                            return;
                        }
                        Color colorA = new Color(dialog.getFirstRGB());
                        Color colorB = new Color(dialog.getSecondRGB());
                        if (colorA == null || colorB == null) {
                            return;
                        }
                        if (this.customColorMI != null) {
                            this.customColorMI.setImage(null);
                        }
                        if (this.customPatternMI != null) {
                            this.customPatternMI.setImage(null);
                        }
                        if (this.customImage != null) {
                            this.customImage.dispose();
                        }
                        this.customImage = GraphicsExample.createImage((Device)display, colorA, colorB, 16, 16);
                        GraphicsBackground gb = new GraphicsBackground();
                        gb.setBgImage(this.customImage);
                        gb.setThumbNail(this.customImage);
                        gb.setBgColor1(colorA);
                        gb.setBgColor2(colorB);
                        item.setData((Object)gb);
                        item.setImage(this.customImage);
                        this.resourceImages.add(this.customImage);
                    } else {
                        if (this.customColorMI != null) {
                            this.customColorMI.setImage(null);
                        }
                        if (this.customPatternMI != null) {
                            this.customPatternMI.setImage(null);
                        }
                        if (this.customGradientMI != null) {
                            this.customGradientMI.setImage(null);
                        }
                    }
                    this.background = (GraphicsBackground)item.getData();
                    this.colorListener.setColor(this.background);
                }
            }
        }
    }
}

