/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class CountDownTab
extends AnimatedGraphicsTab {
    final int startNumber = 5;
    int nextNumber = 5;
    int angle = -90;
    Spinner lineWidthSpinner;
    Combo aliasCombo;
    Combo lineCapCombo;
    int antialias;
    int lineCap;
    int[] capValues = new int[]{1, 3, 2};
    int[] aliasValues;

    public CountDownTab(GraphicsExample example) {
        super(example);
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        this.aliasValues = nArray;
    }

    @Override
    public void createControlPanel(Composite parent) {
        super.createControlPanel(parent);
        if (this.nextNumber < 1) {
            this.nextNumber = 5;
        }
        this.playItem.addListener(13, event -> {
            if (this.nextNumber < 1) {
                this.nextNumber = 5;
            }
        });
        GridLayout gridLayout = new GridLayout(2, false);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("LineWidth"));
        this.lineWidthSpinner = new Spinner(comp, 2112);
        this.lineWidthSpinner.setSelection(20);
        this.lineWidthSpinner.setMinimum(1);
        this.lineWidthSpinner.setMaximum(100);
        this.lineWidthSpinner.addListener(13, event -> {
            if (!this.pauseItem.isEnabled()) {
                this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Antialiasing"));
        this.aliasCombo = new Combo(comp, 4);
        this.aliasCombo.add("DEFAULT");
        this.aliasCombo.add("OFF");
        this.aliasCombo.add("ON");
        this.aliasCombo.select(0);
        this.antialias = this.aliasValues[0];
        this.aliasCombo.addListener(13, event -> {
            this.antialias = this.aliasValues[this.aliasCombo.getSelectionIndex()];
            if (!this.pauseItem.isEnabled()) {
                this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("LineCap"));
        this.lineCapCombo = new Combo(comp, 4);
        this.lineCapCombo.add("FLAT");
        this.lineCapCombo.add("SQUARE");
        this.lineCapCombo.add("ROUND");
        this.lineCapCombo.select(0);
        this.lineCap = this.capValues[0];
        this.lineCapCombo.addListener(13, event -> {
            this.lineCap = this.capValues[this.lineCapCombo.getSelectionIndex()];
            if (!this.pauseItem.isEnabled()) {
                this.example.redraw();
            }
        });
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Misc");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Countdown");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("CountdownDescription");
    }

    @Override
    public int getInitialAnimationTime() {
        return 28;
    }

    @Override
    public void next(int width, int height) {
        if (this.angle == 270) {
            --this.nextNumber;
            if (this.nextNumber < 1) {
                this.setAnimation(false);
            }
            this.angle = -90;
        }
        this.angle += 10;
    }

    @Override
    public void paint(GC gc, int width, int height) {
        int diameter;
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        int n = diameter = width < height ? width - 25 : height - 25;
        if (!this.getAnimation() && this.nextNumber == 0) {
            Font font = new Font(device, CountDownTab.getPlatformFontFace(1), diameter / 2, 0);
            gc.setFont(font);
            gc.setForeground(device.getSystemColor(10));
            gc.setTextAntialias(1);
            String text = GraphicsExample.getResourceString("SWT");
            Point point = gc.stringExtent(text);
            int textWidth = point.x;
            int textHeight = point.y;
            gc.drawString(text, (width - textWidth) / 2, (height - textHeight) / 2, true);
            font.dispose();
        } else {
            Font font = new Font(device, CountDownTab.getPlatformFontFace(0), 6 * diameter / 10, 0);
            gc.setFont(font);
            gc.setLineWidth(this.lineWidthSpinner.getSelection());
            gc.setLineCap(this.lineCap);
            gc.setAntialias(this.antialias);
            gc.setTextAntialias(this.antialias);
            Path path = new Path(device);
            path.addArc((float)((width - diameter) / 2), (float)((height - diameter) / 2), (float)diameter, (float)diameter, 0.0f, 360.0f);
            path.addArc((float)((width - diameter + 50) / 2), (float)((height - diameter + 50) / 2), (float)(diameter - 50), (float)(diameter - 50), 0.0f, 360.0f);
            gc.drawPath(path);
            gc.setBackground(device.getSystemColor(3));
            gc.fillPath(path);
            path.dispose();
            Point point = gc.stringExtent(Integer.toString(this.nextNumber));
            int textWidth = point.x;
            int textHeight = point.y;
            gc.drawString(Integer.toString(this.nextNumber), (width - textWidth) / 2, (height - textHeight) / 2, true);
            Transform transform = new Transform(device);
            transform.translate((float)(width / 2), (float)(height / 2));
            transform.rotate((float)this.angle);
            gc.setTransform(transform);
            gc.setForeground(device.getSystemColor(3));
            gc.drawLine(0, 0, diameter / 2, 0);
            transform.dispose();
            font.dispose();
        }
    }

    static String getPlatformFontFace(int index) {
        if (SWT.getPlatform() == "win32") {
            return (new String[]{"Courier", "Impact"})[index];
        }
        if (SWT.getPlatform() == "gtk") {
            return (new String[]{"Courier", "Baekmuk Headline"})[index];
        }
        return (new String[]{"Courier", "Verdana"})[index];
    }
}

