/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;

public class CustomAlphaTab
extends AnimatedGraphicsTab {
    private Spinner alphaSpinner;
    private Button colorButton;
    private GraphicsBackground background;
    private Menu menu;
    private int angle;

    public CustomAlphaTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Alpha");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("CustomAlpha");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("CustomAlphaDescription");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        super.createControlPanel(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Alpha"));
        this.alphaSpinner = new Spinner(comp, 2112);
        this.alphaSpinner.setMinimum(0);
        this.alphaSpinner.setMaximum(255);
        this.alphaSpinner.setSelection(127);
        this.alphaSpinner.addListener(13, event -> this.example.redraw());
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.background = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.background = (GraphicsBackground)this.menu.getItem(4).getData();
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.background.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void next(int width, int height) {
        this.angle = (this.angle + 1) % 360;
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Pattern pattern = null;
        if (this.background.getBgColor1() != null) {
            gc.setBackground(this.background.getBgColor1());
        } else if (this.background.getBgImage() != null) {
            pattern = new Pattern(device, this.background.getBgImage());
            gc.setBackgroundPattern(pattern);
        }
        gc.setAntialias(1);
        gc.setAlpha(this.alphaSpinner.getSelection());
        Transform transform = new Transform(device);
        transform.translate((float)(width / 2), (float)(height / 2));
        transform.rotate((float)(-this.angle));
        transform.translate((float)(-width / 2), (float)(-height / 2));
        gc.setTransform(transform);
        transform.dispose();
        int diameter = height < width ? height : width;
        Path path = new Path(device);
        path.addArc((float)((width - diameter / 5) / 2), (float)((height - diameter / 5) / 2), (float)(diameter / 5), (float)(diameter / 5), 0.0f, 360.0f);
        path.addArc((float)(5 * (width - diameter / 8) / 12), (float)(4 * (height - diameter / 8) / 12), (float)(diameter / 8), (float)(diameter / 8), 0.0f, 360.0f);
        path.addArc((float)(7 * (width - diameter / 8) / 12), (float)(8 * (height - diameter / 8) / 12), (float)(diameter / 8), (float)(diameter / 8), 0.0f, 360.0f);
        path.addArc((float)(6 * (width - diameter / 12) / 12), (float)(3 * (height - diameter / 12) / 12), (float)(diameter / 12), (float)(diameter / 12), 0.0f, 360.0f);
        path.addArc((float)(6 * (width - diameter / 12) / 12), (float)(9 * (height - diameter / 12) / 12), (float)(diameter / 12), (float)(diameter / 12), 0.0f, 360.0f);
        path.addArc(11.5f * (float)(width - diameter / 18) / 20.0f, (float)(5 * (height - diameter / 18) / 18), (float)(diameter / 18), (float)(diameter / 18), 0.0f, 360.0f);
        path.addArc(8.5f * (float)(width - diameter / 18) / 20.0f, (float)(13 * (height - diameter / 18) / 18), (float)(diameter / 18), (float)(diameter / 18), 0.0f, 360.0f);
        path.addArc(62.0f * (float)(width - diameter / 25) / 100.0f, (float)(32 * (height - diameter / 25) / 100), (float)(diameter / 25), (float)(diameter / 25), 0.0f, 360.0f);
        path.addArc(39.0f * (float)(width - diameter / 25) / 100.0f, (float)(67 * (height - diameter / 25) / 100), (float)(diameter / 25), (float)(diameter / 25), 0.0f, 360.0f);
        gc.fillPath(path);
        path.dispose();
        if (pattern != null) {
            pattern.dispose();
        }
    }
}

