/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;

public class CustomFontTab
extends GraphicsTab {
    String text = GraphicsExample.getResourceString("SWT");
    GraphicsBackground fontForeground;
    Combo fontFaceCb;
    Combo fontStyleCb;
    Spinner fontPointSpinner;
    Button colorButton;
    List<String> fontNames;
    int[] styleValues;
    String[] fontStyles;
    Menu menu;

    public CustomFontTab(GraphicsExample example) {
        super(example);
        FontData[] fontData = Display.getCurrent().getFontList(null, true);
        this.fontNames = new ArrayList<String>();
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            String nextName = element.getName();
            if (!this.fontNames.contains(nextName)) {
                int j = 0;
                while (j < this.fontNames.size() && nextName.compareTo(this.fontNames.get(j)) > 0) {
                    ++j;
                }
                this.fontNames.add(j, nextName);
            }
            ++n2;
        }
        this.fontStyles = new String[]{GraphicsExample.getResourceString("Regular"), GraphicsExample.getResourceString("Italic"), GraphicsExample.getResourceString("Bold"), GraphicsExample.getResourceString("BoldItalic")};
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 3;
        this.styleValues = nArray;
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Font");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("CustomFont");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("CustomFontDescription");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new RowLayout());
        Composite comp = new Composite(mainComp, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 16384).setText(GraphicsExample.getResourceString("FontFace"));
        this.fontFaceCb = new Combo(comp, 4);
        for (String name : this.fontNames) {
            this.fontFaceCb.add(name);
        }
        this.fontFaceCb.select(0);
        this.fontFaceCb.addListener(13, event -> this.example.redraw());
        comp = new Composite(mainComp, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 16384).setText(GraphicsExample.getResourceString("FontStyle"));
        this.fontStyleCb = new Combo(comp, 4);
        String[] stringArray = this.fontStyles;
        int n = this.fontStyles.length;
        int n2 = 0;
        while (n2 < n) {
            String fontStyle = stringArray[n2];
            this.fontStyleCb.add(fontStyle);
            ++n2;
        }
        this.fontStyleCb.select(0);
        this.fontStyleCb.addListener(13, event -> this.example.redraw());
        comp = new Composite(mainComp, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 16384).setText(GraphicsExample.getResourceString("FontSize"));
        this.fontPointSpinner = new Spinner(comp, 2112);
        this.fontPointSpinner.setMinimum(1);
        this.fontPointSpinner.setMaximum(1000);
        this.fontPointSpinner.setSelection(200);
        this.fontPointSpinner.addListener(13, event -> this.example.redraw());
        ColorMenu cm = new ColorMenu();
        cm.setColorItems(true);
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.fontForeground = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.fontForeground = (GraphicsBackground)this.menu.getItem(1).getData();
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.fontForeground.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        String fontFace = this.fontNames.get(this.fontFaceCb.getSelectionIndex());
        int points = this.fontPointSpinner.getSelection();
        int style = this.styleValues[this.fontStyleCb.getSelectionIndex()];
        Font font = new Font(device, fontFace, points, style);
        gc.setFont(font);
        gc.setTextAntialias(1);
        Point size = gc.stringExtent(this.text);
        int textWidth = size.x;
        int textHeight = size.y;
        Pattern pattern = null;
        if (this.fontForeground.getBgColor1() != null) {
            gc.setForeground(this.fontForeground.getBgColor1());
        } else if (this.fontForeground.getBgImage() != null) {
            pattern = new Pattern(device, this.fontForeground.getBgImage());
            gc.setForegroundPattern(pattern);
        }
        gc.drawString(this.text, (width - textWidth) / 2, (height - textHeight) / 2, true);
        font.dispose();
        if (pattern != null) {
            pattern.dispose();
        }
    }
}

