/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InterpolationTab
extends GraphicsTab {
    Combo imageCb;

    public InterpolationTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Image");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Interpolation");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("ImageInterpolationDesc");
    }

    @Override
    public void createControlPanel(Composite parent) {
        GridLayout gridLayout = new GridLayout(2, false);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Image"));
        this.imageCb = new Combo(comp, 4);
        this.imageCb.add(GraphicsExample.getResourceString("House"));
        this.imageCb.add(GraphicsExample.getResourceString("Question"));
        this.imageCb.add(GraphicsExample.getResourceString("Task"));
        this.imageCb.add(GraphicsExample.getResourceString("Font"));
        this.imageCb.add(GraphicsExample.getResourceString("Cube"));
        this.imageCb.add(GraphicsExample.getResourceString("SWT"));
        this.imageCb.add(GraphicsExample.getResourceString("Ovals"));
        this.imageCb.select(0);
        this.imageCb.addListener(13, event -> this.example.redraw());
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        float scaleX = 10.0f;
        float scaleY = 10.0f;
        Image image = null;
        switch (this.imageCb.getSelectionIndex()) {
            case 0: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "home_nav.gif");
                break;
            }
            case 1: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "help.gif");
                break;
            }
            case 2: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "task.gif");
                break;
            }
            case 3: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "font.gif");
                break;
            }
            case 4: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "cube.png");
                scaleX = 0.75f;
                scaleY = 0.5f;
                break;
            }
            case 5: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "swt.png");
                scaleX = 0.4f;
                scaleY = 0.8f;
                break;
            }
            case 6: {
                image = GraphicsExample.loadImage(device, GraphicsExample.class, "ovals.png");
                scaleX = 1.1f;
                scaleY = 0.5f;
            }
        }
        Rectangle bounds = image.getBounds();
        gc.drawImage(image, (width - bounds.width) / 2, 20);
        Font font = new Font(device, InterpolationTab.getPlatformFont(), 20, 0);
        gc.setFont(font);
        String text = GraphicsExample.getResourceString("OriginalImg");
        Point size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 25 + bounds.height, true);
        Transform transform = new Transform(device);
        transform.translate(((float)width - ((float)bounds.width * scaleX + 10.0f) * 4.0f) / 2.0f, (float)(25 + bounds.height + size.y) + ((float)height - ((float)(25 + bounds.height + size.y) + (float)bounds.height * scaleY)) / 2.0f);
        transform.scale(scaleX, scaleY);
        float[] point = new float[2];
        text = GraphicsExample.getResourceString("None");
        size = gc.stringExtent(text);
        point[0] = (scaleX * (float)bounds.width + 5.0f - (float)size.x) / (2.0f * scaleX);
        point[1] = bounds.height;
        transform.transform(point);
        gc.drawString(text, (int)point[0], (int)point[1], true);
        text = GraphicsExample.getResourceString("Low");
        size = gc.stringExtent(text);
        point[0] = (scaleX * (float)bounds.width + 5.0f - (float)size.x) / (2.0f * scaleX) + (float)bounds.width;
        point[1] = bounds.height;
        transform.transform(point);
        gc.drawString(text, (int)point[0], (int)point[1], true);
        text = GraphicsExample.getResourceString("Default");
        size = gc.stringExtent(text);
        point[0] = (scaleX * (float)bounds.width + 5.0f - (float)size.x) / (2.0f * scaleX) + (float)(2 * bounds.width);
        point[1] = bounds.height;
        transform.transform(point);
        gc.drawString(text, (int)point[0], (int)point[1], true);
        text = GraphicsExample.getResourceString("High");
        size = gc.stringExtent(text);
        point[0] = (scaleX * (float)bounds.width + 5.0f - (float)size.x) / (2.0f * scaleX) + (float)(3 * bounds.width);
        point[1] = bounds.height;
        transform.transform(point);
        gc.drawString(text, (int)point[0], (int)point[1], true);
        gc.setTransform(transform);
        transform.dispose();
        gc.setInterpolation(0);
        gc.drawImage(image, 0, 0);
        gc.setInterpolation(1);
        gc.drawImage(image, bounds.width, 0);
        gc.setInterpolation(-1);
        gc.drawImage(image, 2 * bounds.width, 0);
        gc.setInterpolation(2);
        gc.drawImage(image, 3 * bounds.width, 0);
        font.dispose();
        if (image != null) {
            image.dispose();
        }
    }

    static String getPlatformFont() {
        if (SWT.getPlatform() == "win32") {
            return "Arial";
        }
        if (SWT.getPlatform() == "gtk") {
            return "Baekmuk Batang";
        }
        return "Verdana";
    }
}

