/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PathReuseTab
extends GraphicsTab {
    Path path;

    public PathReuseTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Path");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("PathReuseOper");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("PathReuseOperDescription");
    }

    private void resetPath(Device device) {
        if (this.path != null) {
            this.path.dispose();
        }
        this.path = new Path(device);
        this.example.redraw();
    }

    @Override
    public void createControlPanel(Composite parent) {
        this.resetPath((Device)parent.getDisplay());
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(9, false));
        Button drawArcButton = new Button(comp, 8);
        drawArcButton.setText(GraphicsExample.getResourceString("DrawArc"));
        drawArcButton.addListener(13, event -> {
            this.path.moveTo(100.0f, 100.0f);
            this.path.addArc(100.0f, 100.0f, 250.0f, 250.0f, 90.0f, 180.0f);
            this.example.redraw();
        });
        Button drawLineButton = new Button(comp, 8);
        drawLineButton.setText(GraphicsExample.getResourceString("DrawLine"));
        drawLineButton.addListener(13, event -> {
            this.path.moveTo(400.0f, 100.0f);
            this.path.lineTo(500.0f, 100.0f);
            this.path.lineTo(400.0f, 200.0f);
            this.path.lineTo(500.0f, 300.0f);
            this.path.lineTo(400.0f, 300.0f);
            this.example.redraw();
        });
        Button drawRectangleButton = new Button(comp, 8);
        drawRectangleButton.setText(GraphicsExample.getResourceString("DrawRectangle"));
        drawRectangleButton.addListener(13, event -> {
            this.path.addRectangle(600.0f, 100.0f, 100.0f, 200.0f);
            this.example.redraw();
        });
        Button drawStringButton = new Button(comp, 8);
        drawStringButton.setText(GraphicsExample.getResourceString("DrawText"));
        FontData fd = comp.getFont().getFontData()[0];
        Font font = new Font((Device)comp.getDisplay(), fd.getName(), 60, 1);
        drawStringButton.addListener(13, event -> {
            this.path.addString("Text", 800.0f, 100.0f, font);
            this.example.redraw();
        });
        Button drawCubicButton = new Button(comp, 8);
        drawCubicButton.setText(GraphicsExample.getResourceString("DrawCubic"));
        drawCubicButton.addListener(13, event -> {
            this.path.moveTo(100.0f, 400.0f);
            this.path.cubicTo(100.0f, 400.0f, 150.0f, 600.0f, 400.0f, 500.0f);
            this.example.redraw();
        });
        Button drawQuadButton = new Button(comp, 8);
        drawQuadButton.setText(GraphicsExample.getResourceString("DrawQuad"));
        drawQuadButton.addListener(13, event -> {
            this.path.moveTo(500.0f, 400.0f);
            this.path.quadTo(500.0f, 400.0f, 500.0f, 600.0f);
            this.path.quadTo(600.0f, 500.0f, 700.0f, 600.0f);
            this.example.redraw();
        });
        Button addPathButton = new Button(comp, 8);
        addPathButton.setText(GraphicsExample.getResourceString("AddPath"));
        addPathButton.addListener(13, event -> {
            Path newPath = new Path((Device)comp.getDisplay());
            newPath.addArc(800.0f, 400.0f, 250.0f, 250.0f, 90.0f, -180.0f);
            this.path.addPath(newPath);
            this.example.redraw();
        });
        Button flattenButton = new Button(comp, 8);
        flattenButton.setText(GraphicsExample.getResourceString("FlattenPath"));
        flattenButton.addListener(13, event -> {
            this.path = new Path((Device)comp.getDisplay(), this.path, 5.0f);
            this.example.redraw();
        });
        Button closeButton = new Button(comp, 8);
        closeButton.setText(GraphicsExample.getResourceString("ClosePath"));
        closeButton.addListener(13, event -> {
            this.path.close();
            this.example.redraw();
        });
        Button resetButton = new Button(comp, 8);
        resetButton.setText(GraphicsExample.getResourceString("Reset"));
        resetButton.addListener(13, event -> this.resetPath((Device)parent.getDisplay()));
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        gc.setLineWidth(5);
        gc.setForeground(device.getSystemColor(2));
        gc.drawPath(this.path);
    }
}

