/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StarPolyTab
extends GraphicsTab {
    int[] radial = new int[22];
    static final int POINTS = 11;
    Combo fillRuleCb;

    public StarPolyTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public void createControlPanel(Composite parent) {
        new Label(parent, 0).setText(GraphicsExample.getResourceString("FillRule"));
        this.fillRuleCb = new Combo(parent, 4);
        this.fillRuleCb.add("FILL_EVEN_ODD");
        this.fillRuleCb.add("FILL_WINDING");
        this.fillRuleCb.select(0);
        this.fillRuleCb.addListener(13, event -> this.example.redraw());
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Polygons");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("StarPolygon");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("StarPolygonDescription");
    }

    @Override
    public void paint(GC gc, int width, int height) {
        int centerX = width / 2;
        int centerY = height / 2;
        int pos = 0;
        int i = 0;
        while (i < 11) {
            double r = Math.PI * 2 * (double)pos / 11.0;
            this.radial[i * 2] = (int)((1.0 + Math.cos(r)) * (double)centerX);
            this.radial[i * 2 + 1] = (int)((1.0 + Math.sin(r)) * (double)centerY);
            pos = (pos + 5) % 11;
            ++i;
        }
        gc.setFillRule(this.fillRuleCb.getSelectionIndex() != 0 ? 2 : 1);
        gc.setBackground(gc.getDevice().getSystemColor(7));
        gc.fillPolygon(this.radial);
        gc.drawPolygon(this.radial);
    }
}

