/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TransformReuseTab
extends GraphicsTab {
    Transform transform;

    public TransformReuseTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Transform");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("TransformReuseOper");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("TransformReuseOperDescription");
    }

    private void resetTransform(Device device) {
        if (this.transform != null) {
            this.transform.dispose();
        }
        this.transform = new Transform(device);
        this.example.redraw();
    }

    @Override
    public void createControlPanel(Composite parent) {
        this.resetTransform((Device)parent.getDisplay());
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(6, false));
        Button rotateButton = new Button(comp, 8);
        rotateButton.setText(GraphicsExample.getResourceString("Rotate"));
        rotateButton.addListener(13, event -> {
            this.transform.rotate(45.0f);
            this.example.redraw();
        });
        Button scaleButton = new Button(comp, 8);
        scaleButton.setText(GraphicsExample.getResourceString("Scale"));
        scaleButton.addListener(13, event -> {
            this.transform.scale(2.0f, 2.0f);
            this.example.redraw();
        });
        Button shearButton = new Button(comp, 8);
        shearButton.setText(GraphicsExample.getResourceString("Shear"));
        shearButton.addListener(13, event -> {
            this.transform.shear(2.0f, 2.0f);
            this.example.redraw();
        });
        Button translateButton = new Button(comp, 8);
        translateButton.setText(GraphicsExample.getResourceString("Translate"));
        translateButton.addListener(13, event -> {
            this.transform.translate(100.0f, 50.0f);
            this.example.redraw();
        });
        Button identityButton = new Button(comp, 8);
        identityButton.setText(GraphicsExample.getResourceString("Identity"));
        identityButton.addListener(13, event -> {
            this.transform.identity();
            this.example.redraw();
        });
        Button resetButton = new Button(comp, 8);
        resetButton.setText(GraphicsExample.getResourceString("Reset"));
        resetButton.addListener(13, event -> this.resetTransform((Device)parent.getDisplay()));
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Image image = GraphicsExample.loadImage(device, GraphicsExample.class, "ace_club.jpg");
        gc.setTransform(this.transform);
        gc.drawImage(image, 0, 0);
        image.dispose();
    }
}

