/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;

public class LineFigure
extends Figure {
    private Color foregroundColor;
    private Color backgroundColor;
    private int lineStyle;
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public LineFigure(Color foregroundColor, Color backgroundColor, int lineStyle, int x1, int y1, int x2, int y2) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.lineStyle = lineStyle;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public void draw(FigureDrawContext fdc) {
        Point p1 = fdc.toClientPoint(this.x1, this.y1);
        Point p2 = fdc.toClientPoint(this.x2, this.y2);
        fdc.gc.setForeground(this.foregroundColor);
        fdc.gc.setBackground(this.backgroundColor);
        fdc.gc.setLineStyle(this.lineStyle);
        fdc.gc.drawLine(p1.x, p1.y, p2.x, p2.y);
        fdc.gc.setLineStyle(1);
    }

    @Override
    public void addDamagedRegion(FigureDrawContext fdc, Region region) {
        region.add(fdc.toClientRectangle(this.x1, this.y1, this.x2, this.y2));
    }
}

