/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.internal.compiler.util.CharDeduplication;

public class CharDeduplicationTest
extends TestCase {
    public CharDeduplicationTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CharDeduplicationTest.class.getPackageName());
        suite.addTest((Test)new TestSuite(CharDeduplicationTest.class));
        return suite;
    }

    public void testDeduplication() {
        int i = 0;
        while (i < 3) {
            this.assertDeduplication("a");
            this.assertDeduplication("z");
            this.assertDeduplication("12");
            this.assertDeduplication("123");
            this.assertDeduplication("1234");
            this.assertDeduplication("12345");
            this.assertDeduplication("123456");
            this.assertDeduplication("1234567");
            this.assertDeduplication("eclipse");
            this.assertDeduplication("0");
            this.assertDeduplication("A");
            this.assertDeduplication("$");
            this.assertDeduplication("_");
            this.assertDeduplication("\u0000");
            this.assertDeduplication("\u007f");
            this.assertDeduplication("\u0080");
            ++i;
        }
    }

    public void testDeduplicationMid() {
        String text = "abcdefghijklmn";
        int start = 0;
        while (start < text.length()) {
            int end = start;
            while (end < text.length()) {
                this.assertDedup(text, true, start, end);
                ++end;
            }
            ++start;
        }
    }

    public void testDeduplicationTableSize() {
        CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();
        deduplication.reset();
        int overload = 0;
        while (overload < 3) {
            HashMap<Integer, char[]> expecteds = new HashMap<Integer, char[]>();
            int i = 0;
            while (i < 8 + overload) {
                int numberWithFixedLength = 10000 + i;
                String string = "" + numberWithFixedLength;
                char[] a = string.toCharArray();
                char[] expected = deduplication.sharedCopyOfRange(a, 0, a.length);
                expecteds.put(i, expected);
                ++i;
            }
            int t = 0;
            while (t < 2) {
                int i2 = 0;
                while (i2 < expecteds.size()) {
                    char[] expected = (char[])expecteds.get(i2);
                    char[] other = String.valueOf(expected).toCharArray();
                    if (overload == 0 || i2 > 0) {
                        this.assertDedup(true, 0, expected.length, expected, other);
                    } else {
                        char[] actual = deduplication.sharedCopyOfRange(other, 0, expected.length);
                        char[] other2 = String.valueOf(expected).toCharArray();
                        this.assertDedup(true, 0, expected.length, actual, other2);
                    }
                    ++i2;
                }
                ++t;
            }
            ++overload;
        }
    }

    public static void main(String[] args) {
        CharDeduplicationTest test = new CharDeduplicationTest("");
        System.out.println("min= ~" + (double)LongStream.range(0L, 20L).map(t -> test.runPerformanceTest()).min().getAsLong() / 1.0E9);
    }

    public long runPerformanceTest() {
        CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();
        int MAX_LENGTH = 6;
        int RUNS = 1000;
        int TOKENS = 1080;
        Random rnd = new Random(0L);
        StringBuilder content = new StringBuilder();
        int i = 0;
        while (i < TOKENS + MAX_LENGTH) {
            content.append((char)(65L + (Math.round(15.0 / rnd.nextDouble()) & 0xFL)));
            ++i;
        }
        char[] contents = content.toString().toCharArray();
        ArrayList<char[]> results = new ArrayList<char[]>(RUNS * TOKENS);
        long nanoTime = System.nanoTime();
        int l = 1;
        while (l < MAX_LENGTH) {
            int j = 0;
            while (j < RUNS) {
                int i2 = 0;
                while (i2 < TOKENS) {
                    char[] result = deduplication.sharedCopyOfRange(contents, i2, i2 + l);
                    results.add(result);
                    ++i2;
                }
                ++j;
            }
            ++l;
        }
        long nanoTime2 = System.nanoTime();
        long durationNanos = nanoTime2 - nanoTime;
        System.out.println(durationNanos);
        IdentityHashMap<char[], char[]> identityHashMap = new IdentityHashMap<char[], char[]>();
        for (char[] r : results) {
            identityHashMap.put(r, r);
        }
        System.out.println("deduplicated " + (float)(results.size() - identityHashMap.size()) * 100.0f / (float)results.size() + "%");
        return durationNanos;
    }

    public void testAll() {
        this.testDeduplication();
        this.testDeduplicationMid();
        this.testDeduplicationTableSize();
    }

    public void testMultithreaded() throws Exception {
        int nThreads = 8;
        List<FutureTask> tasks = IntStream.range(0, nThreads * 2).mapToObj(i -> new FutureTask<Object>(() -> {
            this.testAll();
            return null;
        })).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        tasks.forEach(executor::submit);
        for (FutureTask task : tasks) {
            try {
                task.get();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        executor.shutdownNow();
    }

    private void assertDeduplication(String string) {
        this.assertDedup(string, true, 0, string.length());
    }

    private void assertNoDeduplication(String string) {
        this.assertDedup(string, false, 0, string.length());
    }

    private void assertDedup(String string, boolean same, int startPosition, int end) {
        char[] a = string.toCharArray();
        char[] b = string.toCharArray();
        CharDeduplicationTest.assertNotSame((Object)a, (Object)b);
        CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();
        char[] expected = deduplication.sharedCopyOfRange(a, startPosition, end);
        this.assertDedup(same, startPosition, end, expected, b);
    }

    private char[] assertDedup(boolean same, int startPosition, int end, char[] expected, char[] other) {
        CharDeduplicationTest.assertNotSame((Object)expected, (Object)other);
        CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();
        char[] actual = deduplication.sharedCopyOfRange(other, startPosition, end);
        String state = "expected=" + String.valueOf(expected) + ", actual=" + String.valueOf(actual);
        if (same) {
            CharDeduplicationTest.assertSame((String)state, (Object)expected, (Object)actual);
        } else {
            CharDeduplicationTest.assertNotSame((String)("Expected different instances. But thats not a requirement but an implementation detail test:" + state), (Object)expected, (Object)actual);
        }
        return actual;
    }
}

