/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;

public class DeduplicationUtilTest
extends TestCase {
    public DeduplicationUtilTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DeduplicationUtilTest.class.getPackageName());
        suite.addTest((Test)new TestSuite(DeduplicationUtilTest.class));
        return suite;
    }

    public void testDeduplication() {
        this.assertDeduplicationString("aNeverUsedBefore".toCharArray());
        this.assertDeduplicationCharArray("aNeverUsedBefore");
        this.assertDeduplicationObject(() -> List.of("aNeverUsedBefore"));
        this.assertDeduplicationList(() -> Arrays.asList("1", "2", "3"));
        this.assertDeduplicationString("bNeverUsedBefore".toCharArray());
        this.assertDeduplicationCharArray("bNeverUsedBefore");
        this.assertDeduplicationObject(() -> List.of("bNeverUsedBefore"));
    }

    private void assertDeduplicationString(char[] stringTemplate) {
        String a = new String(stringTemplate);
        String b = new String(stringTemplate);
        DeduplicationUtilTest.assertNotSame((Object)a, (Object)b);
        String expected = DeduplicationUtil.intern((String)b);
        DeduplicationUtilTest.assertSame((Object)b, (Object)expected);
        b = null;
        expected = null;
        this.forceGc();
        String actual = DeduplicationUtil.intern((String)a);
        DeduplicationUtilTest.assertSame((Object)a, (Object)actual);
        a = new String(stringTemplate);
        b = new String(stringTemplate);
        DeduplicationUtilTest.assertNotSame((Object)a, (Object)b);
        String actual2 = DeduplicationUtil.intern((String)a);
        String expected2 = DeduplicationUtil.intern((String)b);
        DeduplicationUtilTest.assertSame((Object)expected2, (Object)actual2);
    }

    private void assertDeduplicationCharArray(String charArrayTemplate) {
        char[] a = charArrayTemplate.toCharArray();
        char[] b = charArrayTemplate.toCharArray();
        DeduplicationUtilTest.assertNotSame((Object)a, (Object)b);
        char[] expected = DeduplicationUtil.intern((char[])b);
        DeduplicationUtilTest.assertSame((Object)b, (Object)expected);
        b = null;
        expected = null;
        this.forceGc();
        char[] actual = DeduplicationUtil.intern((char[])a);
        DeduplicationUtilTest.assertSame((Object)a, (Object)actual);
        a = charArrayTemplate.toCharArray();
        b = charArrayTemplate.toCharArray();
        DeduplicationUtilTest.assertNotSame((Object)a, (Object)b);
        char[] actual2 = DeduplicationUtil.intern((char[])a);
        char[] expected2 = DeduplicationUtil.intern((char[])b);
        DeduplicationUtilTest.assertSame((Object)expected2, (Object)actual2);
    }

    private void assertDeduplicationObject(Supplier<Object> supplier) {
        Object a = supplier.get();
        Object b = supplier.get();
        DeduplicationUtilTest.assertNotSame((Object)a, (Object)b);
        DeduplicationUtilTest.assertEquals((Object)a, (Object)b);
        Object expected = DeduplicationUtil.internObject((Object)b);
        DeduplicationUtilTest.assertSame((Object)b, (Object)expected);
        b = null;
        expected = null;
        this.forceGc();
        Object actual = DeduplicationUtil.internObject((Object)a);
        int i = 0;
        while (i < 42) {
            if (actual == a) break;
            this.forceGc();
            actual = DeduplicationUtil.internObject((Object)a);
            ++i;
        }
        DeduplicationUtilTest.assertSame((Object)a, (Object)actual);
        a = supplier.get();
        b = supplier.get();
        DeduplicationUtilTest.assertNotSame((Object)a, (Object)b);
        DeduplicationUtilTest.assertEquals((Object)a, (Object)b);
        Object actual2 = DeduplicationUtil.internObject((Object)a);
        Object expected2 = DeduplicationUtil.internObject((Object)b);
        DeduplicationUtilTest.assertSame((Object)expected2, (Object)actual2);
    }

    private void assertDeduplicationList(Supplier<List<String>> supplier) {
        List<String> a = supplier.get();
        List<String> b = supplier.get();
        DeduplicationUtilTest.assertNotSame(a, b);
        DeduplicationUtilTest.assertEquals(a, b);
        List expected = DeduplicationUtil.intern(b);
        int i = 0;
        while (i < a.size()) {
            DeduplicationUtilTest.assertSame((Object)b.get(i), expected.get(i));
            ++i;
        }
        b = null;
        expected = null;
        this.forceGc();
        List actual = DeduplicationUtil.intern(a);
        int i2 = 0;
        while (i2 < 42) {
            if (actual == a) break;
            this.forceGc();
            actual = DeduplicationUtil.intern(a);
            ++i2;
        }
        i2 = 0;
        while (i2 < a.size()) {
            DeduplicationUtilTest.assertSame((Object)a.get(i2), actual.get(i2));
            ++i2;
        }
        a = supplier.get();
        b = supplier.get();
        DeduplicationUtilTest.assertNotSame(a, b);
        DeduplicationUtilTest.assertEquals(a, b);
        List actual2 = DeduplicationUtil.intern(a);
        List expected2 = DeduplicationUtil.intern(b);
        DeduplicationUtilTest.assertSame((Object)expected2, (Object)actual2);
    }

    private void forceGc() {
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

