/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.codeassist.complete.CompletionScanner;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public abstract class AbstractCompletionTest
extends AbstractCompilerTest {
    public static final String NONE = "<NONE>";
    public static final String NULL = "null";

    public AbstractCompletionTest(String testName) {
        super(testName);
    }

    public void checkDietParse(char[] source, int cursorLocation, String expectedCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.checkDietParse(source, cursorLocation, expectedCompletion, null, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, testName);
    }

    public void checkDietParse(char[] source, int cursorLocation, String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), false);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, cursorLocation);
        this.checkParse(expectedCompletion, expectedParentCompletion, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, testName, parser, unit);
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String[] expectedLabels, String testName) {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), false);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, cursorLocation);
        ASTNode foundMethod = null;
        if (unit.types != null) {
            int i = 0;
            while (i < unit.types.length) {
                TypeDeclaration type = unit.types[i];
                ASTNode method = this.findMethod(type, cursorLocation);
                if (method != null) {
                    foundMethod = method;
                    break;
                }
                ++i;
            }
        }
        if (foundMethod != null) {
            if (foundMethod instanceof AbstractMethodDeclaration) {
                parser.parseBlockStatements((AbstractMethodDeclaration)foundMethod, unit);
            } else {
                TypeDeclaration type = (TypeDeclaration)foundMethod;
                FieldDeclaration[] fields = type.fields;
                if (fields != null) {
                    int i = 0;
                    while (i < fields.length) {
                        FieldDeclaration field = fields[i];
                        if (field.declarationSourceStart <= cursorLocation && (cursorLocation <= field.declarationSourceEnd || field.declarationSourceEnd == 0)) {
                            if (!(field instanceof Initializer)) break;
                            parser.parseBlockStatements((Initializer)field, type, unit);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        this.checkParse(expectedCompletion, expectedParentCompletion, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, testName, parser, unit);
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.checkMethodParse(source, cursorLocation, expectedCompletion, null, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, null, testName);
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.checkMethodParse(source, cursorLocation, expectedCompletion, expectedParentCompletion, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, null, testName);
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String[] expectedLabels, String testName) {
        this.checkMethodParse(source, cursorLocation, expectedCompletion, null, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, expectedLabels, testName);
    }

    private void checkParse(String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName, CompletionParser parser, CompilationUnitDeclaration unit) {
        String computedCompletion = parser.assistNode == null ? NONE : parser.assistNode.toString();
        String computedParentCompletion = NULL;
        if (expectedParentCompletion != null) {
            computedParentCompletion = parser.assistNodeParent == null ? NONE : parser.assistNodeParent.toString();
        }
        String computedUnitToString = unit.toString();
        if (!expectedCompletion.equals(computedCompletion)) {
            System.out.println(Util.displayString(computedCompletion));
        }
        if (expectedParentCompletion != null && !expectedParentCompletion.equals(computedParentCompletion)) {
            System.out.println(Util.displayString(computedParentCompletion));
        }
        if (!expectedUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        String computedCompletionIdentifier = NULL;
        if (expectedCompletionIdentifier != null) {
            char[] chars = ((CompletionScanner)parser.scanner).completionIdentifier;
            computedCompletionIdentifier = chars == null ? NONE : new String(chars);
        }
        String computedReplacedSource = NULL;
        if (expectedReplacedSource != null) {
            char[] chars = null;
            if (parser.assistNode != null) {
                int start = parser.assistNode.sourceStart;
                int end = parser.assistNode.sourceEnd;
                if (parser.assistNode instanceof CompletionOnMemberAccess) {
                    CompletionOnMemberAccess memberAccess = (CompletionOnMemberAccess)parser.assistNode;
                    if (!(memberAccess.receiver instanceof ThisReference)) {
                        long position = memberAccess.nameSourcePosition;
                        start = (int)(position >>> 32);
                        end = (int)position;
                    }
                }
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)start, (int)(end + 1));
            } else if (parser.assistIdentifier() != null && ((CompletionScanner)parser.scanner).completedIdentifierEnd >= ((CompletionScanner)parser.scanner).completedIdentifierStart) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)((CompletionScanner)parser.scanner).completedIdentifierStart, (int)(((CompletionScanner)parser.scanner).completedIdentifierEnd + 1));
            }
            computedReplacedSource = chars == null ? NONE : new String(chars);
        }
        AbstractCompletionTest.assertEquals(testName, this.concatResults(expectedCompletion, expectedParentCompletion, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource), this.concatResults(computedCompletion, computedParentCompletion, computedUnitToString, computedCompletionIdentifier, computedReplacedSource));
    }

    private String concatResults(String completionNode, String parentCompletionNode, String unitToString, String completionIdentifier, String replacedSource) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("### Completion node ###\n");
        buffer.append(completionNode);
        buffer.append("\n### Parent completion node ###\n");
        buffer.append(parentCompletionNode);
        buffer.append("\n### Completed identifier ###\n");
        buffer.append(completionIdentifier);
        buffer.append("\n### Replaced source ###\n");
        buffer.append(replacedSource);
        buffer.append("\n### Completed unit ###\n");
        buffer.append(unitToString);
        return buffer.toString();
    }

    private ASTNode findMethod(TypeDeclaration type, int cursorLocation) {
        FieldDeclaration[] fields;
        int i;
        if (type.methods != null) {
            i = 0;
            while (i < type.methods.length) {
                AbstractMethodDeclaration method = type.methods[i];
                if (method.declarationSourceStart <= cursorLocation && (cursorLocation <= method.declarationSourceEnd || method.declarationSourceEnd == 0)) {
                    return method;
                }
                ++i;
            }
        }
        if (type.memberTypes != null) {
            i = 0;
            while (i < type.memberTypes.length) {
                TypeDeclaration memberType = type.memberTypes[i];
                ASTNode method = this.findMethod(memberType, cursorLocation);
                if (method != null) {
                    return method;
                }
                ++i;
            }
        }
        if ((fields = type.fields) != null) {
            int i2 = 0;
            while (i2 < fields.length) {
                FieldDeclaration field = fields[i2];
                if (field instanceof Initializer && field.declarationSourceStart <= cursorLocation && (cursorLocation <= field.declarationSourceEnd || field.declarationSourceEnd == 0)) {
                    return type;
                }
                ++i2;
            }
        }
        return null;
    }

    protected void runTestCheckDietParse(String compilationUnit, String completeBehind, String expectedCompletionNodeToString, String expectedUnitDisplayString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        int cursorLocation = compilationUnit.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkDietParse(compilationUnit.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, expectedCompletionIdentifier, expectedReplacedSource, testName);
    }

    protected void runTestCheckMethodParse(String compilationUnit, String completeBehind, String expectedCompletionNodeToString, String expectedUnitDisplayString, String expectedCompletionIdentifier, String expectedReplacedSource, String[] expectedLabels, String testName) {
        int completeBehindStart = compilationUnit.indexOf(completeBehind);
        AbstractCompletionTest.assertTrue((String)"completeBehind string not found", (completeBehindStart >= 0 ? 1 : 0) != 0);
        int cursorLocation = completeBehindStart + completeBehind.length() - 1;
        this.checkMethodParse(compilationUnit.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, expectedCompletionIdentifier, expectedReplacedSource, expectedLabels, testName);
    }

    protected void runTestCheckMethodParse(String compilationUnit, String completeBehind, String expectedCompletionNodeToString, String expectedUnitDisplayString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.runTestCheckMethodParse(compilationUnit, completeBehind, expectedCompletionNodeToString, expectedUnitDisplayString, expectedCompletionIdentifier, expectedReplacedSource, null, testName);
    }
}

