/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.codeassist.select.SelectionParser;
import org.eclipse.jdt.internal.codeassist.select.SelectionScanner;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public abstract class AbstractSelectionTest
extends AbstractCompilerTest {
    public static final String NONE = "<NONE>";

    public AbstractSelectionTest(String testName) {
        super(testName);
    }

    public void checkDietParse(char[] source, int selectionStart, int selectionEnd, String expectedSelection, String expectedUnitToString, String expectedSelectionIdentifier, String expectedSelectedSource, String testName) {
        char[] chars;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        SelectionParser parser = new SelectionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, selectionStart, selectionEnd);
        String computedUnitToString = unit.toString();
        String computedSelection = parser.assistNode == null ? NONE : parser.assistNode.toString();
        AbstractSelectionTest.assertEquals("invalid selection node-" + testName, expectedSelection, computedSelection);
        if (!expectedUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString, 2));
        }
        AbstractSelectionTest.assertEquals("invalid selection unit-" + testName, expectedUnitToString, computedUnitToString);
        if (expectedSelectionIdentifier != null) {
            chars = ((SelectionScanner)parser.scanner).selectionIdentifier;
            String computedSelectionIdentifier = chars == null ? NONE : new String(chars);
            AbstractSelectionTest.assertEquals("invalid selection identifier-" + testName, expectedSelectionIdentifier, computedSelectionIdentifier);
        }
        if (expectedSelectedSource != null) {
            chars = null;
            if (parser.assistNode != null) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)parser.assistNode.sourceStart, (int)(parser.assistNode.sourceEnd + 1));
            } else if (parser.assistIdentifier() != null && ((SelectionScanner)parser.scanner).selectionEnd >= ((SelectionScanner)parser.scanner).selectionStart) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)((SelectionScanner)parser.scanner).selectionStart, (int)(((SelectionScanner)parser.scanner).selectionEnd + 1));
            }
            String computedSelectedSource = chars == null ? NONE : new String(chars);
            AbstractSelectionTest.assertEquals("invalid replaced source-" + testName, expectedSelectedSource, computedSelectedSource);
        }
    }

    public void checkMethodParse(char[] source, int selectionStart, int selectionEnd, String expectedSelection, String expectedUnitToString, String expectedSelectionIdentifier, String expectedSelectedSource, String[] expectedLabels, String testName) {
        char[] chars;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        SelectionParser parser = new SelectionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, selectionStart, selectionEnd);
        ASTNode foundMethod = null;
        if (unit.types != null) {
            int i = 0;
            while (i < unit.types.length) {
                TypeDeclaration type = unit.types[i];
                ASTNode method = this.findMethod(type, selectionStart);
                if (method != null) {
                    foundMethod = method;
                    break;
                }
                ++i;
            }
        }
        AbstractSelectionTest.assertTrue((String)"no method found at cursor location", (foundMethod != null ? 1 : 0) != 0);
        if (foundMethod instanceof AbstractMethodDeclaration) {
            parser.parseBlockStatements((AbstractMethodDeclaration)foundMethod, unit);
        } else {
            TypeDeclaration type = (TypeDeclaration)foundMethod;
            FieldDeclaration[] fields = type.fields;
            if (fields != null) {
                int i = 0;
                while (i < fields.length) {
                    FieldDeclaration field = fields[i];
                    if (field instanceof Initializer && field.sourceStart <= selectionStart && selectionStart <= field.sourceEnd) {
                        parser.parseBlockStatements((Initializer)field, type, unit);
                        break;
                    }
                    ++i;
                }
            }
        }
        String computedUnitToString = unit.toString();
        String computedCompletion = parser.assistNode == null ? NONE : parser.assistNode.toString();
        AbstractSelectionTest.assertEquals("invalid selection node-" + testName, expectedSelection, computedCompletion);
        if (!expectedUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString, 2));
        }
        AbstractSelectionTest.assertEquals("invalid selection unit-" + testName, expectedUnitToString, computedUnitToString);
        if (expectedSelectionIdentifier != null) {
            chars = ((SelectionScanner)parser.scanner).selectionIdentifier;
            String computedSelectionIdentifier = chars == null ? NONE : new String(chars);
            AbstractSelectionTest.assertEquals("invalid selection identifier-" + testName, expectedSelectionIdentifier, computedSelectionIdentifier);
        }
        if (expectedSelectedSource != null) {
            chars = null;
            if (parser.assistNode != null) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)parser.assistNode.sourceStart, (int)(parser.assistNode.sourceEnd + 1));
            } else if (parser.assistIdentifier() != null && ((SelectionScanner)parser.scanner).selectionEnd >= ((SelectionScanner)parser.scanner).selectionStart) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)((SelectionScanner)parser.scanner).selectionStart, (int)(((SelectionScanner)parser.scanner).selectionEnd + 1));
            }
            String computedReplacedSource = chars == null ? NONE : new String(chars);
            AbstractSelectionTest.assertEquals("invalid replaced source-" + testName, expectedSelectedSource, computedReplacedSource);
        }
    }

    public void checkMethodParse(char[] source, int selectionStart, int selectionEnd, String expectedSelection, String expectedUnitToString, String expectedSelectionIdentifier, String expectedSelectedSource, String testName) {
        this.checkMethodParse(source, selectionStart, selectionEnd, expectedSelection, expectedUnitToString, expectedSelectionIdentifier, expectedSelectedSource, null, testName);
    }

    protected ASTNode findMethod(TypeDeclaration type, int cursorLocation) {
        FieldDeclaration[] fields;
        int i;
        if (type.methods != null) {
            i = 0;
            while (i < type.methods.length) {
                AbstractMethodDeclaration method = type.methods[i];
                if (method.declarationSourceStart <= cursorLocation && (cursorLocation <= method.declarationSourceEnd || method.declarationSourceEnd == 0)) {
                    return method;
                }
                ++i;
            }
        }
        if (type.memberTypes != null) {
            i = 0;
            while (i < type.memberTypes.length) {
                TypeDeclaration memberType = type.memberTypes[i];
                ASTNode method = this.findMethod(memberType, cursorLocation);
                if (method != null) {
                    return method;
                }
                ++i;
            }
        }
        if ((fields = type.fields) != null) {
            int i2 = 0;
            while (i2 < fields.length) {
                FieldDeclaration field = fields[i2];
                if (field instanceof Initializer) {
                    Initializer initializer = (Initializer)field;
                    Block block = initializer.block;
                    if (block != null && block.sourceStart <= cursorLocation && (cursorLocation <= block.sourceEnd || block.sourceEnd == 0)) {
                        return type;
                    }
                }
                ++i2;
            }
        }
        return null;
    }

    protected void runTestCheckMethodParse(String compilationUnit, String selectionStartBehind, String selectionEndBehind, String expectedSelectionNodeToString, String expectedUnitDisplayString, String expectedSelectionIdentifier, String expectedReplacedSource, String testName) {
        int selectionStartBehindStart = compilationUnit.indexOf(selectionStartBehind);
        AbstractSelectionTest.assertTrue((String)"selectionStartBehind string not found", (selectionStartBehindStart != -1 ? 1 : 0) != 0);
        int selectionStart = selectionStartBehindStart + selectionStartBehind.length();
        int selectionEndBehindStart = compilationUnit.indexOf(selectionEndBehind);
        AbstractSelectionTest.assertTrue((String)"selectionEndBehind string not found", (selectionEndBehindStart != -1 ? 1 : 0) != 0);
        int selectionEnd = selectionEndBehindStart + selectionEndBehind.length() - 1;
        this.checkMethodParse(compilationUnit.toCharArray(), selectionStart, selectionEnd, expectedSelectionNodeToString, expectedUnitDisplayString, expectedSelectionIdentifier, expectedReplacedSource, testName);
    }
}

