/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class AllocationExpressionCompletionTest
extends AbstractCompletionTest {
    public AllocationExpressionCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return AllocationExpressionCompletionTest.buildAllCompliancesTestSuite(AllocationExpressionCompletionTest.class);
    }

    public void testInIfStatement1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (true) {\t\t\t\t\t\t\t\n\t\t\tnew z.y.X(1, 2, i);\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(", "<CompleteOnAllocationExpression:new z.y.X(<CompleteOnName:>, 2, i)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (true)\n        {\n          <CompleteOnAllocationExpression:new z.y.X(<CompleteOnName:>, 2, i)>;\n        }\n  }\n}\n", "", "new z.y.X(1, 2, i)", "<complete inside an if statement>");
    }

    public void testInIfStatement2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (true) {\t\t\t\t\t\t\t\n\t\t\tnew z.y.X(1, 2, i);\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (true)\n        {\n          new z.y.X(1, 2, <CompleteOnName:>, i);\n        }\n  }\n}\n", "", "", "<complete inside an if statement>");
    }

    public void testNoQualificationQualifiedTypeName1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew z.y.X(1, 2, i);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(", "<CompleteOnAllocationExpression:new z.y.X()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnAllocationExpression:new z.y.X()>;\n  }\n}\n", "", "", "<complete on non qualified instance creation with qualified type name>");
    }

    public void testNoQualificationQualifiedTypeName2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew z.y.X(1, 2, i);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new z.y.X(1, 2, <CompleteOnName:>, i);\n  }\n}\n", "", "", "<complete on non qualified instance creation with qualified type name>");
    }

    public void testNoQualificationSimpleTypeName1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew X(1, 2, i);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(", "<CompleteOnAllocationExpression:new X()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnAllocationExpression:new X()>;\n  }\n}\n", "", "", "<complete on non qualified instance creation with simple type name>");
    }

    public void testNoQualificationSimpleTypeName2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew X(1, 2, i);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new X(1, 2, <CompleteOnName:>, i);\n  }\n}\n", "", "", "<complete on non qualified instance creation with simple type name>");
    }

    public void testQualifiedWithName1() {
        this.runTestCheckMethodParse("class Bar {\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tBuz.x.new X(1, 2, i);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(", "<CompleteOnQualifiedAllocationExpression:Buz.x.new X(<CompleteOnName:>, 2, i)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnQualifiedAllocationExpression:Buz.x.new X(<CompleteOnName:>, 2, i)>;\n  }\n}\n", "", "Buz.x.new X(1, 2, i)", "<complete on name qualified instance creation>");
    }

    public void testQualifiedWithName2() {
        this.runTestCheckMethodParse("class Bar {\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tBuz.x.new X(1, 2, i);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Buz.x.new X(1, 2, <CompleteOnName:>, i);\n  }\n}\n", "", "", "<complete on name qualified instance creation>");
    }

    public void testQualifiedWithPrimary1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tprimary().new X(1, 2, i);\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(", "<CompleteOnQualifiedAllocationExpression:primary().new X(<CompleteOnName:>, 2, i)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnQualifiedAllocationExpression:primary().new X(<CompleteOnName:>, 2, i)>;\n  }\n}\n", "", "primary().new X(1, 2, i)", "<complete on primary qualified instance creation>");
    }

    public void testQualifiedWithPrimary2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tprimary().new X(1, 2, i);\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    primary().new X(1, 2, <CompleteOnName:>, i);\n  }\n}\n", "", "", "<complete on primary qualified instance creation>");
    }
}

