/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.TestSourceElementRequestor;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class AnnotationDietRecoveryTest
extends AbstractCompilerTest {
    private static final boolean CHECK_ALL_PARSE = true;
    public static boolean optimizeStringLiterals = false;

    public AnnotationDietRecoveryTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return AnnotationDietRecoveryTest.buildMinimalComplianceTestSuite(AnnotationDietRecoveryTest.testClass(), 32);
    }

    public static Class testClass() {
        return AnnotationDietRecoveryTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        return options;
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietPlusBodyUnitToString, String expectedFullUnitToString, String expectedCompletionDietUnitToString, String testName) {
        CompilationResult compilationResult;
        CompilationUnit sourceUnit;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)(sourceUnit = new CompilationUnit(source, testName, null)), compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            int i = 0;
            int length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid source element diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid source element full structure" + testName, expectedFullUnitToString, computedUnitToString);
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser2 = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), false);
        CompilationUnit sourceUnit2 = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult2 = new CompilationResult((ICompilationUnit)sourceUnit2, 0, 0, 0);
        CompilationUnitDeclaration computedUnit2 = parser2.dietParse((ICompilationUnit)sourceUnit2, compilationResult2, Integer.MAX_VALUE);
        String computedUnitToString2 = computedUnit2.toString();
        if (!expectedCompletionDietUnitToString.equals(computedUnitToString2)) {
            System.out.println(Util.displayString(computedUnitToString2));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid completion diet structure" + testName, expectedCompletionDietUnitToString, computedUnitToString2);
    }

    public void test0001() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0002() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X <T> {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X<T> {\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0003() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\t\n  String foo()\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0004() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\n  String foo() default \"blabla\"\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() default \"blabla\" {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0005() {
        String s = "@Documented\t\t\t\n@Rentention(RententionPolicy.RUNTIME)\t\t\t\t\n@Target(ElementType.TYPE)\t\t\t\t\t\t\t\n@interface MyAnn { \t\t\t\t\t\t\t\t\t\n  String value() default \"Default Message\"\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\n\tpublic @MyAnn void something() { }\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "@Documented @Rentention(RententionPolicy.RUNTIME) @Target(ElementType.TYPE) @interface MyAnn {\n  String value() default \"Default Message\" {\n  }\n}\npublic class X {\n  public X() {\n  }\n  public @MyAnn void something() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "@Documented @Rentention(RententionPolicy.RUNTIME) @Target(ElementType.TYPE) @interface MyAnn {\n  String value() default \"Default Message\" {\n  }\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public @MyAnn void something() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0006() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\n  String foo() {}\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0007() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\n  String foo(\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0008() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t        \t\t\n  void foo(int var1, @Annot(at1=zzz, at2) int var2 {\t\n  }\t\t\t\t\t\t\t        \t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int var1) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(int var1) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0009() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t        \t\t\n  @SuppressWarnings(\"unchecked\");\n  List<Test> l;\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  @SuppressWarnings(\"unchecked\") List<Test> l;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  @SuppressWarnings(\"unchecked\") List<Test> l;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  List<Test> l;\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0010() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  String foo() {\t\t\t\t\t\t\t\n       @interface Y {\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  @interface Y {\n  }\n  public X() {\n  }\n  String foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  @interface Y {\n  }\n  public X() {\n    super();\n  }\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0011() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  #\t\t\t\t\t\t\t\t\t\t\n  @AnAnnotation({var})\t\t\t\t\t\n  public void foo() {\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  public @AnAnnotation({var}) void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  public @AnAnnotation({var}) void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0012() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t        \t\t\n  void foo(int var1, @Annot(at1=zzz, at2=@Annot(at3=zzz, at4)) int var2 {\t\n  }\t\t\t\t\t\t\t        \t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int var1) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(int var1) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0013() {
        String expectedDietPlusBodyUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name)\t\t\t\t\t\t\n@AnAnnotation2(name2)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0014() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n#\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name)\t\t\t\t\t\t\n@AnAnnotation2(name2)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0015() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name)\t\t\t\t\t\t\n@AnAnnotation2(name2)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n#\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0016() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name)\t\t\t\t\t\t\n@AnAnnotation2(name2)\t\t\t\t\t\n#\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0017() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name)\t\t\t\t\t\t\n#\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation2(name2)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0018() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name=)\t\t\t\t\t\t\n@AnAnnotation2(name2)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name = $missing$) @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name = $missing$) @AnAnnotation2(name2) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic @AnAnnotation2(name2) class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0019() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name)\t\t\t\t\t\t\n@AnAnnotation2(name2=)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2 = $missing$) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name) @AnAnnotation2(name2 = $missing$) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0020() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  @AnAnnotation(name) #\t\t\t\t\t\n  int field;\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  @AnAnnotation(name) int field;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  @AnAnnotation(name) int field;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  int field;\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0021() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  @AnAnnotation(name=)\t\t\t\t\t\n  int field;\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  @AnAnnotation(name = $missing$) int field;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  @AnAnnotation(name = $missing$) int field;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  int field;\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0022() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  @AnAnnotation(name) #\t\t\t\t\t\n  void foo() {}\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  @AnAnnotation(name) void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  @AnAnnotation(name) void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0023() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  @AnAnnotation(name=)\t\t\t\t\t\n  void foo() {}\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  @AnAnnotation(name = $missing$) void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  @AnAnnotation(name = $missing$) void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0024() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo(int param1, @AnAnnotation(name) # int param2) {}\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int param1, @AnAnnotation(name) int param2) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(int param1, @AnAnnotation(name) int param2) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int param1) {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0025() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo(int param1, @AnAnnotation(name=) int param2) {}\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int param1, @AnAnnotation(name = $missing$) int param2) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(int param1, @AnAnnotation(name = $missing$) int param2) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int param1) {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0026() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo(int param1, @AnAnnotation(@AnAnnotation1(name1=\"a\", name2=) int param2) {}\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int param1, @AnAnnotation @AnAnnotation1(name1 = \"a\",name2 = $missing$) int param2) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(int param1, @AnAnnotation @AnAnnotation1(name1 = \"a\",name2 = $missing$) int param2) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int param1) {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0027() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(name1=\"a\", #)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(name1 = \"a\") class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(name1 = \"a\") class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0028() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(name1=\"a\", name2=@AnAnnotation2(name3=\"b\"), #)\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(name1 = \"a\",name2 = @AnAnnotation2(name3 = \"b\")) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(name1 = \"a\",name2 = @AnAnnotation2(name3 = \"b\")) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0030() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(\"a\"#)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(\"a\") class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(\"a\") class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0031() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(\"a\", name2=@AnAnnotation2(name3=\"b\"), #)\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(\"a\") @AnAnnotation2(name3 = \"b\") class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(\"a\") @AnAnnotation2(name3 = \"b\") class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0032() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(\"a\", name2=@AnAnnotation2(name3=\"b\"))\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(\"a\") @AnAnnotation2(name3 = \"b\") class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(\"a\") @AnAnnotation2(name3 = \"b\") class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0033() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(name=new Object() {})\t#\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(name = new Object() {\n}) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(name = new Object() {\n}) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0034() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(name=new Object() {},#)\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(name = new Object() {\n}) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(name = new Object() {\n}) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0035() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation1(name=new Object() {#})\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation1(name = $missing$) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation1(name = $missing$) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0036() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class Test {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  public Test() {}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  @SuppressWarnings(value=\"\")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  private int id;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class Test {\n  private @SuppressWarnings(value = \"\") int id;\n  public Test() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class Test {\n  private @SuppressWarnings(value = \"\") int id;\n  public Test() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class Test {\n  private @SuppressWarnings(value = \"\") int id;\n  public Test() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0037() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class Test {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  public int id0;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  @SuppressWarnings(value=\"\")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  private int id;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class Test {\n  public int id0;\n  private @SuppressWarnings(value = \"\") int id;\n  public Test() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class Test {\n  public int id0;\n  private @SuppressWarnings(value = \"\") int id;\n  public Test() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class Test {\n  public int id0;\n  private @SuppressWarnings(value = \"\") int id;\n  public Test() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0038() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name=)\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name = $missing$) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name = $missing$) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0039() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name1=a,name2=)\t\t\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name1 = a,name2 = $missing$) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name1 = a,name2 = $missing$) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0040() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\n@AnAnnotation(name1=a,name2=,name3=c)\t\npublic class X {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic @AnAnnotation(name1 = a,name2 = $missing$) class X {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic @AnAnnotation(name1 = a,name2 = $missing$) class X {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n}\n";
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0041() {
        String s = "package snippet;\npublic class Bug366003 {\n        void foo(Object o1){}\n        @Blah org.User(@Bla String str){}\n}\n";
        String expectedDietUnitToString = "package snippet;\npublic class Bug366003 {\n  public Bug366003() {\n  }\n  void foo(Object o1) {\n  }\n  @Blah User(@Bla String str) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package snippet;\npublic class Bug366003 {\n  public Bug366003() {\n    super();\n  }\n  void foo(Object o1) {\n  }\n  @Blah User(@Bla String str) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package snippet;\npublic class Bug366003 {\n  public Bug366003() {\n  }\n  void foo(Object o1) {\n  }\n  User(@Bla String str) {\n  }\n}\n";
        String testName = "<annotation recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }
}

