/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class CompletionRecoveryTest
extends AbstractCompletionTest {
    public CompletionRecoveryTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return CompletionRecoveryTest.buildAllCompliancesTestSuite(CompletionRecoveryTest.class);
    }

    public void test01() {
        String str = "import java.io.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends IOException {\t\t\n\tint foo(){\t\t\t\t\t\t\t\t\n\t\tString str = ;\t\t\t\t\t\t\n\t\tstr.\t\t\t\t\t\t\t\t\n";
        String completeBehind = "str.";
        String expectedCompletionNodeToString = "<CompleteOnName:str.>";
        String completionIdentifier = "";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X extends IOException {\n  public X() {\n  }\n  int foo() {\n    String str;\n    <CompleteOnName:str.>;\n  }\n}\n";
        String expectedReplacedSource = "str.";
        String testName = "<complete on variable behind ill-formed declaration>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test02() {
        String str = "import java.io.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends IOException {\t\t\n\tint foo(){\t\t\t\t\t\t\t\t\n\t\tString str = ;\t\t\t\t\t\t\n\t\t{\t\t\t\t\t\t\t\t\t\n\t\t \tint i;\t\t\t\t\t\t\t\n\t\t\tstr.\t\t\t\t\t\t\t\n";
        String completeBehind = "str.";
        String expectedCompletionNodeToString = "<CompleteOnName:str.>";
        String completionIdentifier = "";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X extends IOException {\n  public X() {\n  }\n  int foo() {\n    String str;\n    {\n      int i;\n      <CompleteOnName:str.>;\n    }\n  }\n}\n";
        String expectedReplacedSource = "str.";
        String testName = "<complete on variable behind ill-formed declaration and nested block>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test03() {
        String str = "import java.io.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends IOException {\t\t\n\tint foo(){\t\t\t\t\t\t\t\t\n\t\tfinal String str = ;\t\t\t\t\n\t\tclass L {\t\t\t\t\t\t\t\n\t\t \tint i = str\t\t\t\t\t\t\n";
        String completeBehind = "i = str";
        String expectedCompletionNodeToString = "<CompleteOnName:str>";
        String completionIdentifier = "str";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X extends IOException {\n  public X() {\n  }\n  int foo() {\n    final String str;\n    class L {\n      int i = <CompleteOnName:str>;\n      L() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "str";
        String testName = "<complete on variable behind ill-formed declaration and inside local type field initialization>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test04() {
        String str = "import java.io.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends \t\t\t\t\t\n\tint foo(String str)\t\t\t\t\t\t\n\t\tString variable = ;\t\t\t\t\t\n\t\t{\t\t\t\t\t\t\t\t\t\n\t\t \tString variableNotInScope;\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t\tfoo(varia\t\t\t\t\t\t\t\n";
        String completeBehind = "foo(var";
        String expectedCompletionNodeToString = "<CompleteOnName:var>";
        String completionIdentifier = "var";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X {\n  public X() {\n  }\n  int foo(String str) {\n    String variable;\n    foo(<CompleteOnName:var>);\n  }\n}\n";
        String expectedReplacedSource = "varia";
        String testName = "<complete on variable behind closed scope>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test05() {
        String str = "import java.io.*;\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends \t\t\t\t\t\t\t\n\tint foo(String str)\t\t\t\t\t\t\t\t\n\t\tString str = ;\t\t\t\t\t\t\t\t\n\t\t{\t\t\t\t\t\t\t\t\t\t\t\n\t\t \tString strNotInScope;\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L {\t\t\t\t\t\t\t\t\t\n\t\t\tint bar(){\t\t\t\t\t\t\t\t\n\t\t\t\tfoo(str\t\t\t\t\t\t\t\t\n\t\t\tvoid stringAppend(String s1, String s2)\t\n";
        String completeBehind = "foo(str";
        String expectedCompletionNodeToString = "<CompleteOnName:str>";
        String completionIdentifier = "str";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X {\n  public X() {\n  }\n  int foo(String str) {\n    String str;\n    class L {\n      L() {\n      }\n      int bar() {\n        foo(<CompleteOnName:str>);\n      }\n      void stringAppend(String s1, String s2) {\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "str";
        String testName = "<complete on variable str with sibling method stringAppend()>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test06() {
        String str = "import java.io.*;\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends \t\t\t\t\t\t\t\n\tint foo(String str)\t\t\t\t\t\t\t\t\n\t\tString str = ;\t\t\t\t\t\t\t\t\n\t\t{\t\t\t\t\t\t\t\t\t\t\t\n\t\t \tString strNotInScope;\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L {\t\t\t\t\t\t\t\t\t\n\t\t\tint notInterestingBody(){\t\t\t\t\n\t\t\t\tSystem.out.println();\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\tint bar(){\t\t\t\t\t\t\t\t\n\t\t\t\tfoo(str\t\t\t\t\t\t\t\t\n\t\t\tvoid stringAppend(String s1, String s2)\t\n";
        String completeBehind = "foo(str";
        String expectedCompletionNodeToString = "<CompleteOnName:str>";
        String completionIdentifier = "str";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X {\n  public X() {\n  }\n  int foo(String str) {\n    String str;\n    class L {\n      L() {\n      }\n      int notInterestingBody() {\n      }\n      int bar() {\n        foo(<CompleteOnName:str>);\n      }\n      void stringAppend(String s1, String s2) {\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "str";
        String testName = "<complete on variable eliminating other uninteresting method bodies>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test07() {
        String str = "import java.io.*\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\npublic class X extends IOException {\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\n\t\tX x = new X(\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String completeBehind = "= n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedUnitDisplayString = "import java.io.*;\npublic class X extends IOException {\n  public X() {\n  }\n  int foo() {\n    X x = <CompleteOnName:n>;\n  }\n}\n";
        String expectedReplacedSource = "new";
        String testName = "<complete on new keyword>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test08() {
        this.runTestCheckDietParse("package test;\nimport java.util.Vector;\npublic class VA {\n\tObject o1 = new Object() {\n\t\tV\n\t\tvoid foo2() {\n\t\t\tint i = 1;\n\t\t}\n\t};\n\tString s2;\n\tvoid bar() {\n\t}\n\tvoid foo() { \n\t\tnew String[] {}..equals()\n\t}\n}\n", "\t\tV", "<CompleteOnType:V>", "package test;\nimport java.util.Vector;\npublic class VA {\n  Object o1 = new Object() {\n    <CompleteOnType:V>;\n    void foo2() {\n    }\n  };\n  String s2;\n  public VA() {\n  }\n  void bar() {\n  }\n  void foo() {\n  }\n}\n", "V", "V", "<completion on field type in anonymous type>");
    }

    public void test09() {
        this.runTestCheckDietParse("package pack;\t\t\t\t\t\t\t\t\nclass A  {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String[] argv\t\n\t\t\tnew Member().f\t\t\t\t\t\n\t\t\t;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tclass Member {\t\t\t\t\t\t\t\n\t\tint foo()\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n};\t\t\t\t\t\t\t\t\t\t\t\n", "argv", "<CompleteOnArgumentName:String[] argv>", "package pack;\nclass A {\n  class Member {\n    Member() {\n    }\n    int foo() {\n    }\n  }\n  A() {\n  }\n  public static void main(<CompleteOnArgumentName:String[] argv>) {\n  }\n}\n", "argv", "argv", "<completion on argument name>");
    }

    public void test10() {
        this.runTestCheckMethodParse("package pack;\t\t\t\t\t\t\t\t\nclass A  {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String[] argv\t\n\t\t\tnew Member().f\t\t\t\t\t\n\t\t\t;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tclass Member {\t\t\t\t\t\t\t\n\t\tint foo()\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n};\t\t\t\t\t\t\t\t\t\t\t\n", "argv", "<CompleteOnArgumentName:String[] argv>", "package pack;\nclass A {\n  class Member {\n    Member() {\n    }\n    int foo() {\n    }\n  }\n  A() {\n  }\n  public static void main(<CompleteOnArgumentName:String[] argv>) {\n  }\n}\n", "argv", "argv", "<completion on argument name>");
    }

    public void test11() {
        this.runTestCheckMethodParse("package pack;\t\t\t\t\t\t\t\t\nclass A  {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String[] argv\t\n\t\t\tnew Member().f\t\t\t\t\t\n\t\t\t;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tclass Member {\t\t\t\t\t\t\t\n\t\tint foo()\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n};\t\t\t\t\t\t\t\t\t\t\t\n", "new Member().f", "<CompleteOnMemberAccess:new Member().f>", "package pack;\nclass A {\n  class Member {\n    Member() {\n    }\n    int foo() {\n    }\n  }\n  A() {\n  }\n  public static void main(String[] argv) {\n    <CompleteOnMemberAccess:new Member().f>;\n  }\n}\n", "f", "f", "<complete inside method with incomplete signature>");
    }

    public void test12() {
        this.runTestCheckMethodParse("class DD  {\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String[] argv\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\nclass D {\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tint i;\t\t\t\t\t\t\t\t\t\t\n\tclass Mem1 {}\t\t\t\t\t\t\t\t\n\tint dumb(String s)\t\t\t\t\t\t\t\n\tint dumb(float fNum, double dNum) {\t\t\t\n\t\tdumb(\"world\", i);\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tif (i == 0) {\t\t\t\t\t\t\t\n\t\t\tclass Local {\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\tint hello() \t\t\t\t\t\n", "argv", "<CompleteOnArgumentName:String[] argv>", "class DD {\n  DD() {\n  }\n  public static void main(<CompleteOnArgumentName:String[] argv>) {\n  }\n}\n", "argv", "argv", "<complete on argument name with class decl later on>");
    }

    public void test13() {
        this.runTestCheckMethodParse("class C {\t\t\t\t\t\t\n\tvoid test() {\t\t\t\t\n\t\tString[].\t\t\t\t\n\t}\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n", "String[].", "<CompleteOnClassLiteralAccess:String[].>", "class C {\n  C() {\n  }\n  void test() {\n    <CompleteOnClassLiteralAccess:String[].>;\n  }\n}\n", "", "String[].", "<complete behind array type>");
    }

    public void test14() {
        this.runTestCheckDietParse("public class B {\t\t\t\n\tclass Member {}\t\t\t\n\t\t\t\t\t\t\t\n\tint[] j;\t\t\t\t\n", "int[", "<NONE>", "public class B {\n  class Member {\n    Member() {\n    }\n  }\n  public B() {\n  }\n}\n", "", "<NONE>", "<complete inside array type>");
    }

    public void test15() {
        this.runTestCheckDietParse("public class B {\t\t\t\n\tclass Member {}\t\t\t\n\t\t\t\t\t\t\t\n\tint[\t\t\t\t\t\n", "int[", "<NONE>", "public class B {\n  class Member {\n    Member() {\n    }\n  }\n  public B() {\n  }\n}\n", "", "<NONE>", "<complete inside array type>");
    }

    public void test16() {
        this.runTestCheckDietParse("public class B {\t\t\t\n\tclass Member {}\t\t\t\n\t\t\t\t\t\t\t\n\tint[\t\t\t\t\t\n\tObje\t\t\t\t\t\n", "Obje", "<CompleteOnType:Obje>", "public class B {\n  class Member {\n    Member() {\n    }\n  }\n  <CompleteOnType:Obje>;\n  public B() {\n  }\n}\n", "Obje", "Obje", "<complete behind invalid array type>");
    }

    public void test17() {
        this.runTestCheckMethodParse("class D {\t\t\t\t\n\tclass Member {}\t\t\n\t\t\t\t\t\t\n\tvoid test() {\t\t\n\t\tint.\t\t\t\n\t\ttest();\t\t\t\n\t}\t\t\t\t\t\n", "int.", "<CompleteOnClassLiteralAccess:int.>", "class D {\n  class Member {\n    Member() {\n    }\n  }\n  D() {\n  }\n  void test() {\n    <CompleteOnClassLiteralAccess:int.>;\n  }\n}\n", "", "int.", "<complete behind invalid base type>");
    }

    public void test18() {
        this.runTestCheckMethodParse("class E {\t\t\t\t\t\n\tint bar() {\t\t\t\t\n\t\tclass Local {\t\t\n\t\t\tint hello() {\t\n", "hello()", "<CompleteOnName:>", "class E {\n  E() {\n  }\n  int bar() {\n    class Local {\n      Local() {\n      }\n      int hello() {\n      }\n    }\n    <CompleteOnName:>;\n  }\n}\n", "", "", "<complete behind incomplete local method header>");
    }

    public void test19() {
        this.runTestCheckMethodParse("public class Test {\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\n\t\t} catch (Exception e) {\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\n\t\te\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\n\t\te", "<CompleteOnName:e>", "public class Test {\n  public Test() {\n  }\n  void foo() {\n    <CompleteOnName:e>;\n  }\n}\n", "e", "e", "<complete behind catch variable>");
    }

    public void test20() {
        this.runTestCheckMethodParse("public class Test {\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\n\t\t} catch (Exception e) {\t\t\t\n\t\t\te\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\n\t\t\te", "<CompleteOnName:e>", "public class Test {\n  public Test() {\n  }\n  void foo() {\n    {\n      Exception e;\n      <CompleteOnName:e>;\n    }\n  }\n}\n", "e", "e", "<complete on catch variable>");
    }

    public void test21() {
        this.runTestCheckMethodParse("public class Test {\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\n\t\t\tbar\t\t\t\t\t\t\n\t\t} catch (Exception e) {\t\t\t\n\t\t\te\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\n\t\t\te", "<CompleteOnName:e>", "public class Test {\n  public Test() {\n  }\n  void foo() {\n    {\n      Exception e;\n      <CompleteOnName:e>;\n    }\n  }\n}\n", "e", "e", "<complete on catch variable after syntax error>");
    }

    public void test22() {
        this.runTestCheckDietParse("public class SomeType {\n\tpublic SomeType(int i){}\n}\n\nclass SomeOtherType extends SomeType {\n\tSomeOtherType(int i){\n\t\tsuper(i);\n\t}\n}\n", "\tSomeOther", "<CompleteOnType:SomeOther>", "public class SomeType {\n  public SomeType(int i) {\n  }\n}\nclass SomeOtherType extends SomeType {\n  <CompleteOnType:SomeOther>;\n  int i;\n  {\n  }\n  SomeOtherType() {\n  }\n}\n", "SomeOther", "SomeOtherType", "<complete on constructor type name>");
    }

    public void test23() {
        this.runTestCheckMethodParse("package p;\npublic class X {\n  void foo(){)\n    {\n      Obj\n    }\n  }\n}\n", "Obj", "<CompleteOnName:Obj>", "package p;\npublic class X {\n  public X() {\n  }\n  void foo() {\n    {\n      <CompleteOnName:Obj>;\n    }\n  }\n}\n", "Obj", "Obj", "<complete in initializer>");
    }

    public void test24() {
        this.runTestCheckMethodParse("package p;\npublic class X {\n  void foo(){)\n    int v1;\n    {\n      int v2\n    }\n    Obj  }\n}\n", "Obj", "<CompleteOnName:Obj>", "package p;\npublic class X {\n  public X() {\n  }\n  void foo() {\n    int v1;\n    <CompleteOnName:Obj>;\n  }\n}\n", "Obj", "Obj", "<complete after initializer>");
    }

    public void test25() {
        this.runTestCheckMethodParse("package p;\npublic class X {\n  void foo(){\n      this.12\n  }\n}\n", "this.", "<CompleteOnMemberAccess:this.>", "package p;\npublic class X {\n  public X() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:this.>;\n  }\n}\n", "", "this.", "<complete after dot number>");
    }

    public void test26() {
        this.runTestCheckMethodParse("import org.eclipse.swt.*;\nimport org.eclipse.swt.events.*;\nimport org.eclipse.swt.widgets.*;\n\npublic class Try {\n\n    void main(Shell shell) {\n\n        final Label label= new Label(shell, SWT.WRAP);\n        label.addPaintListener(new PaintListener() {\n            public void paintControl(PaintEvent e) {\n                e.gc.setLineCap(SWT.CAP_); // content assist after CAP_\n            }\n        });\n\n        shell.addControlListener(new ControlAdapter() { });\n\n        while (!shell.isDisposed()) { }\n    }\n}\n\n", "SWT.CAP_", "<CompleteOnName:SWT.CAP_>", "import org.eclipse.swt.*;\nimport org.eclipse.swt.events.*;\nimport org.eclipse.swt.widgets.*;\npublic class Try {\n  public Try() {\n  }\n  void main(Shell shell) {\n    final Label label;\n    label.addPaintListener(new PaintListener() {\n  public void paintControl(PaintEvent e) {\n    e.gc.setLineCap(<CompleteOnName:SWT.CAP_>);\n  }\n});\n  }\n}\n", "CAP_", "SWT.CAP_", "<complete after dot number>");
    }
}

