/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ComplianceDiagnoseTest
extends AbstractRegressionTest {
    public ComplianceDiagnoseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ComplianceDiagnoseTest.buildAllCompliancesTestSuite(ComplianceDiagnoseTest.testClass());
    }

    public static Class testClass() {
        return ComplianceDiagnoseTest.class;
    }

    public void runComplianceParserTest(String[] testFiles, String expected13ProblemLog, String expected14ProblemLog, String expected15ProblemLog) {
        this.runNegativeTest(testFiles, expected15ProblemLog);
    }

    public void runComplianceParserTest(String[] testFiles, String expected13ProblemLog, String expected14ProblemLog, String expected15ProblemLog, String expected17ProblemLog) {
        this.runNegativeTest(testFiles, expected17ProblemLog);
    }

    public void runComplianceParserTest(String[] testFiles, String expected13ProblemLog, String expected14ProblemLog, String expected15ProblemLog, String expected16ProblemLog, String expected17ProblemLog, String expected18ProblemLog) {
        this.runNegativeTest(testFiles, expected18ProblemLog);
    }

    public void runComplianceParserTest(String[] testFiles, String expected1_3ProblemLog, String expected1_4ProblemLog, String expected1_5ProblemLog, String expected1_6ProblemLog, String expected1_7ProblemLog, String expected1_8ProblemLog, String expected9ProblemLog, String expected10ProblemLog, String expected11ProblemLog, String expected12ProblemLog, String expected13ProblemLog, String expected14ProblemLog, String expected15ProblemLog, String below16ProblemLog, String expected16ProblemLog, String expected17ProblemLog, String expected18ProblemLog, String expected19ProblemLog, String expected20ProblemLog, String expected22ProblemLog) {
        if (this.complianceLevel == 0x340000L) {
            this.runNegativeTest(testFiles, expected1_8ProblemLog);
        } else if (this.complianceLevel == 0x350000L) {
            this.runNegativeTest(testFiles, expected9ProblemLog);
        } else if (this.complianceLevel == 0x360000L) {
            this.runNegativeTest(testFiles, expected10ProblemLog);
        } else if (this.complianceLevel == 0x370000L) {
            this.runNegativeTest(testFiles, expected11ProblemLog);
        } else if (this.complianceLevel == 0x380000L) {
            this.runNegativeTest(testFiles, expected12ProblemLog);
        } else if (this.complianceLevel == 0x390000L) {
            this.runNegativeTest(testFiles, expected13ProblemLog);
        } else if (this.complianceLevel == 0x3A0000L) {
            this.runNegativeTest(testFiles, expected14ProblemLog);
        } else if (this.complianceLevel == 0x3B0000L) {
            this.runNegativeTest(testFiles, expected15ProblemLog);
        } else if (this.complianceLevel == 0x3C0000L) {
            this.runNegativeTest(testFiles, expected16ProblemLog);
        } else if (this.complianceLevel == 0x3D0000L) {
            this.runNegativeTest(testFiles, expected17ProblemLog);
        } else if (this.complianceLevel == 0x3E0000L) {
            this.runNegativeTest(testFiles, expected18ProblemLog);
        } else if (this.complianceLevel == 0x3F0000L) {
            this.runNegativeTest(testFiles, expected19ProblemLog);
        } else if (this.complianceLevel == 0x400000L) {
            this.runNegativeTest(testFiles, expected20ProblemLog);
        } else {
            this.runNegativeTest(testFiles, expected22ProblemLog);
        }
    }

    public void test0001() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.BBB.*;\npublic class X {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.*;\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.BBB.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0002() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.BBB.CCC;\npublic class X {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.CCC;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.BBB.CCC;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.CCC;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0003() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"x/X.java", "package x;\npublic enum X {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in x\\X.java (at line 2)\n\tpublic enum X {\n\t       ^^^^\nSyntax error on token \"enum\", class expected\n----------\n";
        String expected15ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0004() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(String o: c) {\n\t\t}\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t    ^^^^^^^^^^^\nSyntax error, 'for each' statements are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t              ^\nc cannot be resolved to a variable\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t              ^\nc cannot be resolved to a variable\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0005() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(Z ... arg){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^^^^^^^^^\nSyntax error, varargs are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0006() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends String, T2> extends Y {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                           ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0007() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public interface X <T1 extends String, T2> extends Y {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                                                   ^\nY cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                               ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                                                   ^\nY cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0008() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> int foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t                                   ^^^^^\nThis method must return a result of type int\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0009() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> X(){\n\t}\n}\n"};
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> X(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n";
        this.runConformTest(true, testFiles, expected15ProblemLog, null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void testPatternsInCase() {
        String[] testFiles = new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        Object o = null;\n        switch (o) {\n            case X x, null:\n                break;\n            case String s, default :\n               break;\n        }\n    }\n   }\n"};
        String expectedProblemLogFrom7_13 = "----------\n1. ERROR in X.java (at line 4)\n\tswitch (o) {\n\t        ^\nCannot switch on a value of type Object. Only convertible int values, strings or enum variables are permitted\n----------\n2. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t^^^^^^^^^^^^^^\nMulti-constant case labels supported from Java 14 onwards only\n----------\n3. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t     ^^^\nThe Java feature 'Type Patterns' is only available with source level 16 and above\n----------\n4. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t     ^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n5. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n6. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nCannot mix pattern with other case labels\n----------\n7. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n8. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t^^^^^^^^^^^^^^^^^^^^^^\nMulti-constant case labels supported from Java 14 onwards only\n----------\n9. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t     ^^^^^^^^\nThe Java feature 'Type Patterns' is only available with source level 16 and above\n----------\n10. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t     ^^^^^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n11. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n12. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n13. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n";
        String expectedProblemLogFrom14_15 = "----------\n1. ERROR in X.java (at line 4)\n\tswitch (o) {\n\t        ^\nCannot switch on a value of type Object. Only convertible int values, strings or enum variables are permitted\n----------\n2. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t     ^^^\nThe Java feature 'Type Patterns' is only available with source level 16 and above\n----------\n3. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t     ^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n4. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n5. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nCannot mix pattern with other case labels\n----------\n6. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n7. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t     ^^^^^^^^\nThe Java feature 'Type Patterns' is only available with source level 16 and above\n----------\n8. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t     ^^^^^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n9. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n10. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n11. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n";
        String expectedProblemLogFrom16_20 = "----------\n1. ERROR in X.java (at line 4)\n\tswitch (o) {\n\t        ^\nCannot switch on a value of type Object. Only convertible int values, strings or enum variables are permitted\n----------\n2. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t     ^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n3. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n4. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nCannot mix pattern with other case labels\n----------\n5. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n6. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t     ^^^^^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n7. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n8. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n9. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n";
        String expectedProblemLogFrom21 = "----------\n1. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 5)\n\tcase X x, null:\n\t          ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n3. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n4. ERROR in X.java (at line 7)\n\tcase String s, default :\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n";
        if (this.complianceLevel < 0x3A0000L) {
            this.runNegativeTest(testFiles, expectedProblemLogFrom7_13);
        } else if (this.complianceLevel < 0x3C0000L) {
            this.runNegativeTest(testFiles, expectedProblemLogFrom14_15);
        } else if (this.complianceLevel < 0x410000L) {
            this.runNegativeTest(testFiles, expectedProblemLogFrom16_20);
        } else {
            this.runNegativeTest(testFiles, expectedProblemLogFrom21);
        }
    }

    public void test0010() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ<Y1, Y2> var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0011() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic X(){\n\t\t<Y1, Y2>this(null);\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t ^^\nY1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t     ^^\nY2 cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t ^^\nY1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t     ^^\nY2 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t        ^^^^^^^^^^^\nThe constructor X(null) is undefined\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0012() {
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n  void foo() {\n    assert true;\n  }\n}\n\n"};
        String expected13ProblemLog = "----------\n1. WARNING in X.java (at line 3)\n\tassert true;\n\t^^^^^^\n'assert' should not be used as an identifier, since it is a reserved keyword from source level 1.4 on\n----------\n2. ERROR in X.java (at line 3)\n\tassert true;\n\t^^^^^^\nSyntax error on token \"assert\", AssignmentOperator expected after this token\n----------\n";
        String expected15ProblemLog = expected14ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0013() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.*\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n3. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t                  ^\nSyntax error on token \"*\", ; expected after this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t                  ^\nSyntax error on token \"*\", ; expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0014() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public enum X \n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic enum X \n\t       ^^^^\n'enum' should not be used as an identifier, since it is a reserved keyword from source level 1.5 on\n----------\n2. ERROR in X.java (at line 2)\n\t}\n\t^\nSyntax error on token \"}\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X \n\t            ^\nSyntax error on token \"X\", { expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0015() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(String o: c) {\n\t\t\t#\n\t\t}\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t    ^^^^^^^^^^^\nSyntax error, 'for each' statements are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0016() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(Z ... arg){\n\t}\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^^^^^^^^^\nSyntax error, varargs are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0017() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends String, T2> extends Y {\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                           ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0018() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> int foo(){\n\t}\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0019() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ<Y1, Y2> var;\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 3)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0020() {
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n  void foo() {\n    assert true;\n    #\n  }\n}\n\n"};
        String expected13ProblemLog = "----------\n1. WARNING in X.java (at line 3)\n\tassert true;\n\t^^^^^^\n'assert' should not be used as an identifier, since it is a reserved keyword from source level 1.4 on\n----------\n2. ERROR in X.java (at line 3)\n\tassert true;\n\t^^^^^^\nSyntax error on token \"assert\", AssignmentOperator expected after this token\n----------\n3. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = expected14ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0021() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import staic aaa.*;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t       ^^^^^\nThe import staic cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t             ^^^\nSyntax error on token \"aaa\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t       ^^^^^\nSyntax error on token \"staic\", static expected\n----------\n2. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t       ^^^^^\nThe import staic cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0022() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.*.*;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n3. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t                   ^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t                  ^\nSyntax error on token \"*\", Identifier expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0023() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static for;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static for;\n\t       ^^^^^^^^^^\nSyntax error on tokens, Name expected instead\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static for;\n\t              ^^^\nSyntax error on token \"for\", invalid Name\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void _test0024() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static {aaa};\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static {aaa};\n\t       ^^^^^^^^^^^^\nSyntax error on tokens, Name expected instead\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static {aaa};\n\t              ^^^^^\nSyntax error on tokens, Name expected instead\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0025() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"x/X.java", "package x;\nstatic aaa.*;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in x\\X.java (at line 2)\n\tstatic aaa.*;\n\t^^^^^^\nSyntax error on token \"static\", import expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in x\\X.java (at line 1)\n\tpackage x;\n\t         ^\nSyntax error on token \";\", import expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0026() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(Object o ? c){\n\t\t}\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t    ^^^^^^\nSyntax error on token \"Object\", ( expected\n----------\n2. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t           ^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n3. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t                ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Assignment\n----------\n4. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t                ^\nSyntax error, insert \"; ; ) Statement\" to complete BlockStatements\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t             ^\nSyntax error on token \"?\", : expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0027() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(Object o : switch){\n\t\t}\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o : switch){\n\t             ^\nSyntax error on token \":\", delete this token\n----------\n2. ERROR in X.java (at line 3)\n\tfor(Object o : switch){\n\t             ^\nSyntax error, insert \": Expression )\" to complete EnhancedForStatementHeader\n----------\n3. ERROR in X.java (at line 3)\n\tfor(Object o : switch){\n\t             ^\nSyntax error, insert \"Statement\" to complete BlockStatements\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o : switch){\n\t               ^^^^^^\nSyntax error on token \"switch\", invalid Expression\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0028() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int ... ){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... ){\n\t             ^^^\nSyntax error on token \"...\", invalid VariableDeclaratorId\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... ){\n\t             ^^^\nSyntax error on token \"...\", VariableDeclaratorId expected after this token\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0029() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int ... for){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... for){\n\t             ^^^^^^^\nSyntax error on tokens, VariableDeclaratorId expected instead\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... for){\n\t                 ^^^\nSyntax error on token \"for\", invalid VariableDeclaratorId\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void _test0030() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int .. aaa){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int .. aaa){\n\t             ^^\nSyntax error on tokens, delete these tokens\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int .. aaa){\n\t             ^^\nSyntax error on tokens, delete these tokens\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0031() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int ... aaa bbb){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... aaa bbb){\n\t         ^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 1.5 or greater\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(int ... aaa bbb){\n\t             ^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n4. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... aaa bbb){\n\t                     ^^^\nSyntax error on token \"bbb\", delete this token\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void _test0032() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends String, T2 extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                                              ^\nY cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                           ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                                              ^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                                              ^\nY cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0033() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X T1 extends String, T2> extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X T1 extends String, T2> extends Y {\n\t               ^^\nSyntax error on token \"T1\", delete this token\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X T1 extends String, T2> extends Y {\n\t                          ^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X T1 extends String, T2> extends Y {\n\t             ^\nSyntax error on token \"X\", < expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0034() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extnds String, T2> extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t^^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, ClassHeaderName expected instead\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^\nextnds cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^\nSyntax error on token \"extnds\", extends expected\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^\nextnds cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0035() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends for, T2> extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends for, T2> extends Y {\n\t               ^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends for, T2> extends Y {\n\t                           ^^^\nSyntax error on token \"for\", invalid ReferenceType\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0036() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t                               ^^^^^\nReturn type for the method is missing\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t                               ^^^^^\nReturn type for the method is missing\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0037() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extnds String, T2> int foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t       ^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t        ^^\nT1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t                            ^\nSyntax error on token \">\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t        ^^\nT1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t           ^^^^^^\nSyntax error on token \"extnds\", extends expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0038() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String T2> int foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String T2> int foo(){\n\t       ^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String T2> int foo(){\n\t                            ^\nSyntax error on token \">\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String T2> int foo(){\n\t                          ^^\nSyntax error on token \"T2\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0039() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ Y1, Y2> var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t        ^\nSyntax error on token \">\", , expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t        ^\nSyntax error on token \">\", , expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0040() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ <Y1, Y2 var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t  ^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t       ^^\nY2 cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t       ^^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n2. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t       ^^\nY2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0041() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ <Y1, for Y2> var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, for Y2> var;\n\t  ^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, for Y2> var;\n\t       ^^^\nSyntax error on token \"for\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0042() {
        Object problemLog;
        String[] testFiles = new String[]{"X.java", "void ___eval() {\n\tnew Runnable() {\n\t\tint ___run() throws Throwable {\n\t\t\treturn blah;\n\t\t}\n\t\tprivate String blarg;\n\t\tpublic void run() {\n\t\t}\n\t};\n}\npublic class X {\n\tprivate static int x;\n\tprivate String blah;\n\tpublic static void main(String[] args) {\n\t}\n\tpublic void hello() {\n\t}\n\tpublic boolean blah() {\n\t\treturn false;\n\t}\n\tpublic void foo() {\n\t}\n}\n"};
        Object object = problemLog = this.complianceLevel >= 0x440000L ? "----------\n1. ERROR in X.java (at line 1)\n\tvoid ___eval() {\n\t^\nImplicitly Declared Classes and Instance Main Methods is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in X.java (at line 1)\n\tvoid ___eval() {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n3. ERROR in X.java (at line 4)\n\treturn blah;\n\t       ^^^^\nblah cannot be resolved to a variable\n----------\n" : "----------\n1. ERROR in X.java (at line 1)\n\tvoid ___eval() {\n\t^\nThe preview feature Implicitly Declared Classes and Instance Main Methods is only available with source level 24 and above\n----------\n2. ERROR in X.java (at line 1)\n\tvoid ___eval() {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n3. ERROR in X.java (at line 4)\n\treturn blah;\n\t       ^^^^\nblah cannot be resolved to a variable\n----------\n";
        if (this.complianceLevel < 0x3C0000L) {
            problemLog = (String)problemLog + "4. ERROR in X.java (at line 14)\n\tpublic static void main(String[] args) {\n\t                   ^^^^^^^^^^^^^^^^^^^\nThe method main cannot be declared static; static methods can only be declared in a static or top level type\n----------\n";
        }
        this.runNegativeTest(testFiles, (String)problemLog);
    }

    public void test0043() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"x/X.java", "package x;\npublic class X {\n}\npublic static void foo(){}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in x\\X.java (at line 3)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n2. ERROR in x\\X.java (at line 4)\n\tpublic static void foo(){}\n\t                         ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n";
        String expected15ProblemLog = expected13ProblemLog;
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0044() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String>super(\"SUCCESS\");\n\t\t\t}\n\t\t}\n\t\tnew Local();\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T> X(T t){\n\t        ^\nSyntax error, type parameters are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n3. ERROR in X.java (at line 9)\n\t<String>super(\"SUCCESS\");\n\t ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0045() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic void foo(){\n\t}\n\t}\n\tpublic void bar() {\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = expected13ProblemLog;
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0046() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public @interface X {\n\tString annName();\n}"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic @interface X {\n\t                  ^\nSyntax error, annotation declarations are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0047() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"A.java", "public @interface A {}", "X.java", "@A public class X {\n}"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in A.java (at line 1)\n\tpublic @interface A {}\n\t                  ^\nSyntax error, annotation declarations are only available if source level is 1.5 or greater\n----------\n----------\n1. ERROR in X.java (at line 1)\n\t@A public class X {\n\t^^\nSyntax error, annotations are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0048() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(X ... arg[]){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(X ... arg[]){\n\t         ^^^^^^^^^\nSyntax error, varargs are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(X ... arg[]){\n\t               ^^^\nExtended dimensions are illegal for a variable argument\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0049() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "@interface MyAnn {\n\tString value1() default \"\";\n\tString value2();\n}\nclass ZZZ {}\t\t\npublic @MyAnn(\"\",\"\") class Test {\t\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\t@interface MyAnn {\n\t           ^^^^^\nSyntax error, annotation declarations are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t              ^^\nSyntax error, insert \")\" to complete Modifier\n----------\n3. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t              ^^\nThe attribute value is undefined for the annotation type MyAnn\n----------\n4. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t                           ^^^^\nThe public type Test must be defined in its own file\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t              ^^\nThe attribute value is undefined for the annotation type MyAnn\n----------\n2. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t                ^\nSyntax error on token \",\", < expected\n----------\n3. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t                           ^^^^\nThe public type Test must be defined in its own file\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0050() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(List<String>... args) {}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^^^^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^\nList cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t              ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^\nList cannot be resolved to a type\n----------\n";
        String expected17ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^\nList cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t                         ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog, expected17ProblemLog);
    }

    public void test0051() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(java.util.List2<String>... args) {}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 1.5 or greater\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t         ^^^^^^^^^^^^^^^\njava.util.List2 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t                         ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t         ^^^^^^^^^^^^^^^\njava.util.List2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0052() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo1() {\n\t\tclass Y  {\n\t\t}\n\t\tvoid foo2() {\n\t\t}\n\t\tclass Z<T> { \n\t\t}\n\t}\n} \n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo2() {\n\t^^^^\nSyntax error on token \"void\", new expected\n----------\n2. ERROR in X.java (at line 7)\n\tclass Z<T> { \n\t^^^^^\nSyntax error on token \"class\", invalid AssignmentOperator\n----------\n3. ERROR in X.java (at line 7)\n\tclass Z<T> { \n\t         ^\nSyntax error on token \">\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo2() {\n\t^^^^\nSyntax error on token \"void\", new expected\n----------\n2. ERROR in X.java (at line 6)\n\t}\n\t^\nSyntax error, insert \";\" to complete Statement\n----------\n";
        String expectedJ16ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo2() {\n\t^^^^\nSyntax error on token \"void\", record expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, this.complianceLevel < 0x3C0000L ? expected15ProblemLog : expectedJ16ProblemLog);
    }

    public void test0053() {
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tassert true;\n\t}\n}\n"};
        String expected13ProblemLog = "----------\n1. WARNING in X.java (at line 3)\n\tassert true;\n\t^^^^^^\n'assert' should not be used as an identifier, since it is a reserved keyword from source level 1.4 on\n----------\n2. ERROR in X.java (at line 3)\n\tassert true;\n\t^^^^^^\nSyntax error on token \"assert\", AssignmentOperator expected after this token\n----------\n";
        String expected15ProblemLog = expected14ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0054() {
        String expected13ProblemLog;
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry (int i = 0) {};\n\t}\n}\n"};
        String expected15ProblemLog = expected14ProblemLog = (expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\ttry (int i = 0) {};\n\t     ^^^^^^^^^\nResource specification not allowed here for source level below 1.7\n----------\n");
        String expected17ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\ttry (int i = 0) {};\n\t     ^^^\nThe resource type int does not implement java.lang.AutoCloseable\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog, expected17ProblemLog);
    }

    public void test0056() {
        String expected13ProblemLog;
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(Foo e) {\n\t\t\ttry {\n\t\t\t\tthrow e;\n\t\t\t} catch (SonOfFoo e1) {\n\t\t\t \te1.printStackTrace();\n\t\t\t} catch (Foo e1) {}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"};
        String expected15ProblemLog = expected14ProblemLog = (expected13ProblemLog = "----------\n1. WARNING in X.java (at line 14)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 15)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 16)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
        String expected17ProblemLog = "----------\n1. ERROR in X.java (at line 8)\n\t} catch (SonOfFoo e1) {\n\t         ^^^^^^^^\nUnreachable catch block for SonOfFoo. This exception is never thrown from the try statement body\n----------\n2. WARNING in X.java (at line 14)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 15)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 16)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog, expected17ProblemLog);
    }

    public void testBug399778() {
        String[] testFiles = new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X  {\n\t\tList<String> l = null == null ? Arrays.asList() : Arrays.asList(\"Hello\",\"world\");\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tList<String> l = null == null ? Arrays.asList() : Arrays.asList(\"Hello\",\"world\");\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<capture#1-of ? extends Object> to List<String>\n----------\n";
        this.runComplianceParserTest(testFiles, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, "");
    }

    public void testBug399778a() {
        String[] testFiles = new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X  {\n\t\tList<String> l = (List<String>) (null == null ? Arrays.asList() : Arrays.asList(\"Hello\",\"world\"));\n}\n"};
        String expectedProblemLog = "----------\n1. WARNING in X.java (at line 4)\n\tList<String> l = (List<String>) (null == null ? Arrays.asList() : Arrays.asList(\"Hello\",\"world\"));\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List<capture#1-of ? extends Object> to List<String>\n----------\n";
        this.runComplianceParserTest(testFiles, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog);
    }

    public void testBug399781() {
        String[] testFiles = new String[]{"X.java", "public class X {\n   int _;\n\tvoid foo(){\n\t\tint _   = 3;\n\t\tint _123 = 4;\n\t\tint a_   = 5;\n\t}\n   void goo(int _) {}\n   void zoo() {\n      try {\n      } catch (Exception _) {\n      }\n   }\n}\n"};
        String problemLog = null;
        problemLog = this.complianceLevel == 0x340000L ? "----------\n1. WARNING in X.java (at line 2)\n\tint _;\n\t    ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n2. WARNING in X.java (at line 4)\n\tint _   = 3;\n\t    ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n3. WARNING in X.java (at line 4)\n\tint _   = 3;\n\t    ^\nThe local variable _ is hiding a field from type X\n----------\n4. WARNING in X.java (at line 8)\n\tvoid goo(int _) {}\n\t             ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n5. WARNING in X.java (at line 8)\n\tvoid goo(int _) {}\n\t             ^\nThe parameter _ is hiding a field from type X\n----------\n6. WARNING in X.java (at line 11)\n\t} catch (Exception _) {\n\t                   ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n7. WARNING in X.java (at line 11)\n\t} catch (Exception _) {\n\t                   ^\nThe parameter _ is hiding a field from type X\n----------\n" : (this.complianceLevel < 0x420000L ? "----------\n1. ERROR in X.java (at line 2)\n\tint _;\n\t    ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n2. ERROR in X.java (at line 4)\n\tint _   = 3;\n\t    ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n3. WARNING in X.java (at line 4)\n\tint _   = 3;\n\t    ^\nThe local variable _ is hiding a field from type X\n----------\n4. ERROR in X.java (at line 8)\n\tvoid goo(int _) {}\n\t             ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n5. WARNING in X.java (at line 8)\n\tvoid goo(int _) {}\n\t             ^\nThe parameter _ is hiding a field from type X\n----------\n6. ERROR in X.java (at line 11)\n\t} catch (Exception _) {\n\t                   ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n7. WARNING in X.java (at line 11)\n\t} catch (Exception _) {\n\t                   ^\nThe parameter _ is hiding a field from type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tint _;\n\t    ^\nAs of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters\n----------\n2. ERROR in X.java (at line 8)\n\tvoid goo(int _) {}\n\t             ^\nAs of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters\n----------\n3. WARNING in X.java (at line 8)\n\tvoid goo(int _) {}\n\t             ^\nThe parameter _ is hiding a field from type X\n----------\n");
        this.runNegativeTest(testFiles, problemLog);
    }

    public void test401850() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n   static void foo(Object o) {\n\t   System.out.println(\"foo(Object)\");\n   }\n   static void foo(X<String> o) {\n\t   System.out.println(\"foo(X<String>)\");\n   }\n   public static void main(String[] args) { \n      foo(new X<>()); \n   } \n}\n"}, "foo(X<String>)");
    }

    public void test421477() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  default void f() {\n  }\n  default X() {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tdefault void f() {\n\t             ^^^\nDefault methods are allowed only in interfaces.\n----------\n2. ERROR in X.java (at line 4)\n\tdefault X() {}\n\t        ^\nSyntax error on token \"X\", Identifier expected after this token\n----------\n");
    }

    public void test428605() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n       default void f() {\n       }\n       static void g() {\n       }\n} \n"}, "");
    }

    public void testBug440285() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Function;\nclass Y{}\nclass Z{}\npublic class X {\n\tFunction<Integer, int[]> m1 = int[]::<Y, Z>new;\n\tFunction<Integer, int[]> m2 = int[]::<Y>new;\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tFunction<Integer, int[]> m1 = int[]::<Y, Z>new;\n\t                                      ^^^^\nType arguments are not allowed here\n----------\n2. ERROR in X.java (at line 6)\n\tFunction<Integer, int[]> m2 = int[]::<Y>new;\n\t                                      ^\nType arguments are not allowed here\n----------\n");
    }

    public void testBug531714_001() {
        if (this.complianceLevel >= 0x380000L) {
            return;
        }
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tint tw = switch (i) {\n\t\t\tcase 0 -> i * 0;\n\t\t\tcase 1 -> 2;\n\t\t\tdefault -> 3;\n\t\t};\n\t\treturn tw;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tint tw = switch (i) {\n\t\t\tcase 0 -> i * 0;\n\t\t\tcase 1 -> 2;\n\t\t\tdefault -> 3;\n\t\t};\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSwitch Expressions are supported from Java 14 onwards only\n----------\n2. ERROR in X.java (at line 4)\n\tcase 0 -> i * 0;\n\t^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n3. ERROR in X.java (at line 5)\n\tcase 1 -> 2;\n\t^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n4. ERROR in X.java (at line 6)\n\tdefault -> 3;\n\t^^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n";
        this.runComplianceParserTest(testFiles, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog);
    }

    public void testBug531714_002() {
        if (this.complianceLevel >= 0x380000L) {
            return;
        }
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tcase 0 -> i * 0;\n\t\t\tcase 1 -> 2;\n\t\t\tdefault -> 3;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tcase 0 -> i * 0;\n\t^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n2. ERROR in X.java (at line 4)\n\tcase 0 -> i * 0;\n\t          ^^^^^\nInvalid expression as statement\n----------\n3. ERROR in X.java (at line 5)\n\tcase 1 -> 2;\n\t^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n4. ERROR in X.java (at line 5)\n\tcase 1 -> 2;\n\t          ^\nInvalid expression as statement\n----------\n5. ERROR in X.java (at line 6)\n\tdefault -> 3;\n\t^^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n6. ERROR in X.java (at line 6)\n\tdefault -> 3;\n\t           ^\nInvalid expression as statement\n----------\n";
        this.runComplianceParserTest(testFiles, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog, expectedProblemLog);
    }

    public void testIssue2008() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic X(){\n\t}\n   void _() {\n       _();\n   }\n       public static void main(String [] args) {\n           System.out.println(\"OK\");\n       }\n   class _ {\n   }\n}\n"};
        String expected1_8ProblemLog = "----------\n1. WARNING in X.java (at line 4)\n\tvoid _() {\n\t     ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n2. WARNING in X.java (at line 5)\n\t_();\n\t^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n3. WARNING in X.java (at line 10)\n\tclass _ {\n\t      ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n";
        String expected9to20ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tvoid _() {\n\t     ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n2. ERROR in X.java (at line 5)\n\t_();\n\t^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n3. ERROR in X.java (at line 10)\n\tclass _ {\n\t      ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n";
        String expected22ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tvoid _() {\n\t     ^\nSyntax error on token \"_\", Identifier expected\n----------\n2. ERROR in X.java (at line 4)\n\tvoid _() {\n\t     ^\nvoid is an invalid type for the variable _\n----------\n3. ERROR in X.java (at line 5)\n\t_();\n\t^\nSyntax error on token \"_\", this expected\n----------\n4. ERROR in X.java (at line 10)\n\tclass _ {\n\t      ^\nSyntax error on token \"_\", Identifier expected\n----------\n";
        if (this.complianceLevel == 0x340000L) {
            this.runConformTest(true, testFiles, expected1_8ProblemLog, "OK", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
        } else if (this.complianceLevel < 0x420000L) {
            this.runNegativeTest(testFiles, expected9to20ProblemLog);
        } else {
            this.runNegativeTest(testFiles, expected22ProblemLog);
        }
    }
}

