/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class EnumCompletionParserTest
extends AbstractCompletionTest {
    public EnumCompletionParserTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return EnumCompletionParserTest.buildAllCompliancesTestSuite(EnumCompletionParserTest.class);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        return options;
    }

    public void test0001() {
        String str = "public class Completion {\n\t/*here*/\n}\nenum Natural {\n\tONE;\n}\n";
        String completeBehind = "/*here*/";
        int cursorLocation = str.indexOf("/*here*/") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "public class Completion {\n  <CompleteOnType:>;\n  public Completion() {\n  }\n}\nenum Natural {\n  ONE(),\n  Natural() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0002() {
        String str = "public class Test {\n\tvoid foo() {\n\t  switch(c) {\n\t  \tcase FOO :\n\t  \t  break;\n\t  }\n\t}\n}\n";
        String completeBehind = "FOO";
        int cursorLocation = str.indexOf("FOO") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedReplacedSource = "<NONE>";
        String expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
        expectedCompletionNodeToString = "<CompleteOnName:FOO>";
        expectedParentNodeToString = "switch (c) {\ncase <CompleteOnName:FOO> :\n    break;\n}";
        completionIdentifier = "FOO";
        expectedReplacedSource = "FOO";
        expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n    switch (c) {\n    case <CompleteOnName:FOO> :\n        break;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "full ast");
    }

    public void test0003() {
        String str = "public class Test {\n\tvoid foo() {\n\t  switch(c) {\n\t  \tcase BAR :\n\t  \tcase FOO :\n\t  \t  break;\n\t  }\n\t}\n}\n";
        String completeBehind = "FOO";
        int cursorLocation = str.indexOf("FOO") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedReplacedSource = "<NONE>";
        String expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
        expectedCompletionNodeToString = "<CompleteOnName:FOO>";
        expectedParentNodeToString = "switch (c) {\ncase BAR :\ncase <CompleteOnName:FOO> :\n    break;\n}";
        completionIdentifier = "FOO";
        expectedReplacedSource = "FOO";
        expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n    switch (c) {\n    case BAR :\n    case <CompleteOnName:FOO> :\n        break;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "full ast");
    }

    public void test0004() {
        String str = "public class Test {\n\tvoid foo() {\n\t  switch(c) {\n\t  \tcase BAR :\n\t  \t  break;\n\t  \tcase FOO :\n\t  \t  break;\n\t  }\n\t}\n}\n";
        String completeBehind = "FOO";
        int cursorLocation = str.indexOf("FOO") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedReplacedSource = "<NONE>";
        String expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
        expectedCompletionNodeToString = "<CompleteOnName:FOO>";
        expectedParentNodeToString = "switch (c) {\ncase BAR :\n    break;\ncase <CompleteOnName:FOO> :\n    break;\n}";
        completionIdentifier = "FOO";
        expectedReplacedSource = "FOO";
        expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n    switch (c) {\n    case BAR :\n        break;\n    case <CompleteOnName:FOO> :\n        break;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "full ast");
    }

    public void test0005() {
        String str = "public class Test {\n\tvoid foo() {\n\t  switch(c) {\n\t  \tcase BAR :\n\t  \t  break;\n\t  \tcase FOO :\n\t  }\n\t}\n}\n";
        String completeBehind = "FOO";
        int cursorLocation = str.indexOf("FOO") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedReplacedSource = "<NONE>";
        String expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
        expectedCompletionNodeToString = "<CompleteOnName:FOO>";
        expectedParentNodeToString = "switch (c) {\ncase BAR :\n    break;\ncase <CompleteOnName:FOO> :\n}";
        completionIdentifier = "FOO";
        expectedReplacedSource = "FOO";
        expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n    switch (c) {\n    case BAR :\n        break;\n    case <CompleteOnName:FOO> :\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "full ast");
    }

    public void test0006() {
        String str = "public class Test {\n\tvoid foo() {\n\t  switch(c) {\n\t  \tcase BAR :\n\t  \t  break;\n\t  \tcase FOO\n\t  }\n\t}\n}\n";
        String completeBehind = "FOO";
        int cursorLocation = str.indexOf("FOO") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedReplacedSource = "<NONE>";
        String expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
        expectedCompletionNodeToString = "<CompleteOnName:FOO>";
        expectedParentNodeToString = "switch (c) {\ncase BAR :\n    break;\ncase <CompleteOnName:FOO> :\n}";
        completionIdentifier = "FOO";
        expectedReplacedSource = "FOO";
        expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n    {\n      switch (c) {\n      case BAR :\n          break;\n      case <CompleteOnName:FOO> :\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "full ast");
    }

    public void test0007() {
        String str = "public class Test {\n\tvoid foo() {\n\t  switch(c) {\n\t  \tcase BAR0 :\n\t      switch(c) {\n\t        case BAR :\n\t  \t      break;\n\t  \t    case FOO\n\t      }\n\t  \t  break;\n\t  \tcase BAR2 :\n\t  \t  break;\n\t  }\n\t}\n}\n";
        String completeBehind = "FOO";
        int cursorLocation = str.indexOf("FOO") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedReplacedSource = "<NONE>";
        String expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
        expectedCompletionNodeToString = "<CompleteOnName:FOO>";
        expectedParentNodeToString = "switch (c) {\ncase BAR :\n    break;\ncase <CompleteOnName:FOO> :\n}";
        completionIdentifier = "FOO";
        expectedReplacedSource = "FOO";
        expectedUnitDisplayString = "public class Test {\n  public Test() {\n  }\n  void foo() {\n    {\n      {\n        switch (c) {\n        case BAR :\n            break;\n        case <CompleteOnName:FOO> :\n        }\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "full ast");
    }

    public void test0008() {
        String str = "public enum Test {\n\tA() {\n\t  void foo() {\n\t    zzz\n\t  }\n\t}\n}\n";
        String completeBehind = "zzz";
        int cursorLocation = str.indexOf("zzz") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        String expectedUnitDisplayString = "public enum Test {\n  A() {\n    void foo() {\n      <CompleteOnName:zzz>;\n    }\n  },\n  public Test() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0009() {
        String str = "public enum Test {\n\tB,\n\tA() {\n\t  void foo() {\n\t    zzz\n\t  }\n\t}\n}\n";
        String completeBehind = "zzz";
        int cursorLocation = str.indexOf("zzz") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        String expectedUnitDisplayString = "public enum Test {\n  B(),\n  A() {\n    void foo() {\n      <CompleteOnName:zzz>;\n    }\n  },\n  public Test() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0010() {
        String str = "public enum Test {\n\t#\n\tB,\n\tA() {\n\t  void foo() {\n\t    zzz\n\t  }\n\t}\n}\n";
        String completeBehind = "zzz";
        int cursorLocation = str.indexOf("zzz") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        String expectedUnitDisplayString = "public enum Test {\n  B(),\n  A() {\n    void foo() {\n      <CompleteOnName:zzz>;\n    }\n  },\n  public Test() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0011() {
        String str = "public enum Test {\n\tB() {\n\t  void foo() {\n\t  }\n\t},\n\tA() {\n\t  void foo() {\n\t    zzz\n\t  }\n\t}\n}\n";
        String completeBehind = "zzz";
        int cursorLocation = str.indexOf("zzz") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        String expectedUnitDisplayString = "public enum Test {\n  B() {\n    void foo() {\n    }\n  },\n  A() {\n    void foo() {\n      <CompleteOnName:zzz>;\n    }\n  },\n  public Test() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0012() {
        String str = "public enum Test {\n\t#\n\tB() {\n\t  void foo() {\n\t  }\n\t},\n\tA() {\n\t  void foo() {\n\t    zzz\n\t  }\n\t}\n}\n";
        String completeBehind = "zzz";
        int cursorLocation = str.indexOf("zzz") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        String expectedUnitDisplayString = "public enum Test {\n  B() {\n    void foo() {\n    }\n  },\n  A() {\n    void foo() {\n      <CompleteOnName:zzz>;\n    }\n  },\n  public Test() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0013() {
        String str = "public enum Test {\n\t#\n\tB() {\n\t  void foo() {\n\t    #\n\t  }\n\t},\n\tA() {\n\t  void foo() {\n\t    zzz\n\t  }\n\t}\n}\n";
        String completeBehind = "zzz";
        int cursorLocation = str.indexOf("zzz") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        String expectedUnitDisplayString = "public enum Test {\n  B() {\n    void foo() {\n    }\n  },\n  A() {\n    void foo() {\n      <CompleteOnName:zzz>;\n    }\n  },\n  public Test() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0014() {
        String str = "public enum Enum1 {\n  A {\n    tos\n  };\n}\n";
        String completeBehind = "tos";
        int cursorLocation = str.indexOf("tos") + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:tos>";
        String expectedParentNodeToString = "() {\n  <CompleteOnType:tos>;\n}";
        String completionIdentifier = "tos";
        String expectedReplacedSource = "tos";
        String expectedUnitDisplayString = "public enum Enum1 {\n  A() {\n    <CompleteOnType:tos>;\n  },\n  public Enum1() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }
}

