/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class FieldAccessCompletionTest
extends AbstractCompletionTest {
    public FieldAccessCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return FieldAccessCompletionTest.buildAllCompliancesTestSuite(FieldAccessCompletionTest.class);
    }

    public void testAdditiveExpressionMinus() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn 1 - fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (1 - <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on additive expression minus>");
    }

    public void testAdditiveExpressionPlus() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn 1 + fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (1 + <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on additive expression plus>");
    }

    public void testAndExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn isTrue & fred().xyz;\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (isTrue & <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on and expression>");
    }

    public void testArgumentList() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tbizz(1, \"2\", fred().xyz);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    bizz(1, \"2\", <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on argument list>");
    }

    public void testArrayAccess() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn v[fred().xyz];\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return v[<CompleteOnMemberAccess:fred().x>];\n  }\n}\n", "x", "xyz", "<complete on array access>");
    }

    public void testArrayAccessPrimaryNoNewArray() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn buzz()[fred().xyz];\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return buzz()[<CompleteOnMemberAccess:fred().x>];\n  }\n}\n", "x", "xyz", "<complete on array access primary no new array>");
    }

    public void testArrayInitializer() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\n\t\tint[] i = new int[] {fred().xyz}\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int[] i = new int[]{<CompleteOnMemberAccess:fred().x>};\n  }\n}\n", "x", "xyz", "<complete on array initializer>");
    }

    public void testArrayInitializerComma() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\n\t\tint[] i = new int[] {fred().xyz,}\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int[] i = new int[]{<CompleteOnMemberAccess:fred().x>};\n  }\n}\n", "x", "xyz", "<complete on array initializer comma>");
    }

    public void testAssignment() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\n\t\ti = fred().xyz;\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    i = <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on assignment>");
    }

    public void testBlock() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t\t} catch (Exception e) {}\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      <CompleteOnMemberAccess:fred().x> = new Foo();\n    }\n  }\n}\n", "x", "xyz", "<complete on block>");
    }

    public void testBlockStatements() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on block statements>");
    }

    public void testBlockStatementsInConstructorBody() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\t\n\t\tsuper();\t\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n    super();\n    <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on block statements in constructor body>");
    }

    public void testBlockStatementsInInitializer() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\t{\t\t\t\t\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  {\n    int i;\n    <CompleteOnMemberAccess:fred().x>;\n  }\n  Bar() {\n  }\n}\n", "x", "xyz", "<complete on block statements in initializer>");
    }

    public void testBlockStatementsInStaticInitializer() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic {\t\t\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  static {\n    int i;\n    <CompleteOnMemberAccess:fred().x>;\n  }\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "x", "xyz", "<complete on block statements in static initializer>");
    }

    public void testCastExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tBar foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn (fred().xyz)buzz();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  Bar foo() {\n    return <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on cast expression>");
    }

    public void testCastExpressionUnaryExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tBar foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn (Bar)(fred().xyz);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  Bar foo() {\n    return (Bar) <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on cast expression unary expression>");
    }

    public void testClassInstanceCreationExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tnew Bar(fred().xyz);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new Bar(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on class instance creation expression>");
    }

    public void testClassInstanceCreationExpressionName() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tBar.new Bar(fred().xyz);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Bar.new Bar(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on class instance creation expression name>");
    }

    public void testClassInstanceCreationExpressionPrimary() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tbizz().new Bar(fred().xyz);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    bizz().new Bar(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on class instance creation expression primary>");
    }

    public void testConditionalAndExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn isTrue && fred().xyz;\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (isTrue && <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on conditional and expression>");
    }

    public void testConditionalExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tBar foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn fred().xyz == null ? null : new Bar();\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  Bar foo() {\n    return ((<CompleteOnMemberAccess:fred().x> == null) ? null : new Bar());\n  }\n}\n", "x", "xyz", "<complete on conditional expression>");
    }

    public void testConditionalExpressionConditionalExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn isTrue ? true : fred().xyz;\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (isTrue ? true : <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on conditional expression conditional expression>");
    }

    public void testConditionalOrExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn isTrue || fred().xyz;\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (isTrue || <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on conditional or expression>");
    }

    public void testConstructorBody() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n    super();\n    <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on constructor body>");
    }

    public void testDimWithOrWithOutExpr() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tint[] v = new int[fred().xyz];\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int[] v = new int[<CompleteOnMemberAccess:fred().x>];\n  }\n}\n", "x", "xyz", "<complete on dim with or without expr>");
    }

    public void testDoExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tdo\t\t\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t\twhile (fred().xyz);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    do\n      System.out.println();\nwhile (<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on do expression>");
    }

    public void testDoStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tdo\t\t\t\t\t\t\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t\twhile (true);\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on do statement>");
    }

    public void testEqualityExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 1 == fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (1 == <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on equality expression>");
    }

    public void testEqualityExpressionNot() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 1 != fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (1 != <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on equality expression not>");
    }

    public void testExclusiveOrExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn isTrue ^ fred().xyz;\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (isTrue ^ <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on exclusive or expression>");
    }

    public void testExplicitConstructorInvocationInConstructorBody() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar() {\t\t\t\t\t\t\t\n\t\t\tBar.x.x.super();\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "Bar.x.x", "<CompleteOnName:Bar.x.x>", "class Bar {\n  public class InnerBar {\n    public InnerBar() {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar() {\n      super();\n      <CompleteOnName:Bar.x.x>;\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "x", "Bar.x.x", "<complete on explicit constructor invocation in constructor body>");
    }

    public void testForInit() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfor (int i = fred().xyz; i < 2; i++)\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i = <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on for init>");
    }

    public void testForStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfor (int i = 0; i < 2; i++)\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    for (int i;; (i < 2); i ++) \n      <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on for statement>");
    }

    public void testForStatementExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfor (int i = 0; fred().xyz > i; i++)\t\t\n\t\t\tSystemout.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    for (int i;; (<CompleteOnMemberAccess:fred().x> > i); i ++) \n      Systemout.println();\n  }\n}\n", "x", "xyz", "<complete on for statement expression>");
    }

    public void testForUpdate() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfor (int i = 0; i < 2; i+= fred().xyz)\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    for (int i;; (i < 2); i += <CompleteOnMemberAccess:fred().x>) \n      System.out.println();\n  }\n}\n", "x", "xyz", "<complete on for update>");
    }

    public void testIfExpresionThen() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tif (fred().xyz)\t\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (<CompleteOnMemberAccess:fred().x>)\n        System.out.println();\n  }\n}\n", "x", "xyz", "<complete on \"if expression then\">");
    }

    public void testIfExpresionThenElse() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tif (fred().xyz)\t\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t\telse\t\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (<CompleteOnMemberAccess:fred().x>)\n        System.out.println();\n    else\n        System.out.println();\n  }\n}\n", "x", "xyz", "<complete on \"if expression then else\">");
    }

    public void testIfThenElseStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tif (false)\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t\telse\t\t\t\t\t\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (false)\n        System.out.println();\n    else\n        <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on \"if then else\" statement>");
    }

    public void testIfThenStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tif (true)\t\t\t\t\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (true)\n        <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on \"if then\" statement>");
    }

    public void testIfThenStatementElse() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tif (true)\t\t\t\t\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t\telse\t\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if (true)\n        <CompleteOnMemberAccess:fred().x> = new Foo();\n    else\n        System.out.println();\n  }\n}\n", "x", "xyz", "<complete on \"if then statement else\">");
    }

    public void testInclusiveOrExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn isTrue | fred().xyz;\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (isTrue | <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on inclusive or expression>");
    }

    public void testLabeledStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfredCall: fred().xyz = new Foo();\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    fredCall: <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", new String[]{"fredCall"}, "<complete on labeled statement>");
    }

    public void testMethodBody() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on method body>");
    }

    public void testMethodInvocation() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tbizz(fred().xyz);\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    bizz(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on method invocation>");
    }

    public void testMethodInvocationPrimary() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tbuzz().bizz(fred().xyz);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    buzz().bizz(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on method invocation primary>");
    }

    public void testMethodInvocationSuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tsuper.bizz(fred().xyz);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    super.bizz(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on method invocation super>");
    }

    public void testMultiplicativeExpressiondDivision() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tdouble foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 2 / fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  double foo() {\n    return (2 / <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on multiplicative expression division>");
    }

    public void testMultiplicativeExpressionMultiplication() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn 2 * fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (2 * <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on multiplicative expression multiplication>");
    }

    public void testMultiplicativeExpressionRemainder() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn 2 % fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (2 % <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on multiplicative expression remainder>");
    }

    public void testPreIncrementExpressionMinusMinus() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\t-- fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    -- <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on pre increment expression minus minus>");
    }

    public void testPreIncrementExpressionPlusPlus() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\t++ fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    ++ <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on pre increment expression plus plus>");
    }

    public void testPrimaryNoNewArray() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\t(fred().xyz).zzz();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:fred().x>.zzz();\n  }\n}\n", "x", "xyz", "<complete on primary no new array>");
    }

    public void testRelationalExpressionGreaterThan() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 1 > fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (1 > <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on relational expression greater than>");
    }

    public void testRelationalExpressionGreaterThanOrEquals() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 1 >= fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (1 >= <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on relational expression greater than or equal>");
    }

    public void testRelationalExpressionLessThan() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 1 < fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (1 < <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on relational expression less than>");
    }

    public void testRelationalExpressionLessThanOrEqual() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn 1 <= fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (1 <= <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on relational expression less than or equal>");
    }

    public void testReturnStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\n\t\treturn fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on return statement>");
    }

    public void testShiftExpressionLeft() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn i << fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (i << <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on shift expression left>");
    }

    public void testShiftExpressionRight() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn i >> fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (i >> <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on shift expression right>");
    }

    public void testShiftExpressionRightUnSigned() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tint foo() {\t\t\t\t\t\t\t\t\t\t\n\t\treturn i >>> fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  int foo() {\n    return (i >>> <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on shift expression right unsigned>");
    }

    public void testStatementExpressionList() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\n\t\tfor (int i = 0, length = fred().xyz; i < 2; i++)\t\n\t\t\tSystem.out.println();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    int length = <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on statement expression list>");
    }

    public void testSwitchBlockStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tint i =  0;\t\t\t\t\t\t\t\t\n\t\tswitch (i) {\t\t\t\t\t\t\t\n\t\t\tcase 0: fred().xyz = new Foo();\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    switch (i) {\n    case 0 :\n        <CompleteOnMemberAccess:fred().x> = new Foo();\n    }\n  }\n}\n", "x", "xyz", "<complete on switch block statement>");
    }

    public void testSwitchExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tswitch (fred().xyz) {\t\t\t\t\t\t\n\t\t\tcase 0: System.out.println();\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    switch (<CompleteOnMemberAccess:fred().x>) {\n    case 0 :\n        System.out.println();\n    }\n  }\n}\n", "x", "xyz", "<complete on switch expression>");
    }

    public void testSwitchLabel() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tint i =  0;\t\t\t\t\t\t\t\t\t\n\t\tswitch (i) {\t\t\t\t\t\t\t\t\n\t\t\tcase fred().xyz: System.out.println();\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    switch (i) {\n    case <CompleteOnMemberAccess:fred().x> :\n        System.out.println();\n    }\n  }\n}\n", "x", "xyz", "<complete on switch label>");
    }

    public void testSynchronizedStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tsynchronized (fred().xyz) {\t\t\t\t\n\t\t\t System.out.println();\t\t\t\t\n\t\t} \t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    synchronized (<CompleteOnMemberAccess:fred().x>)\n      {\n        System.out.println();\n      }\n  }\n}\n", "x", "xyz", "<complete on synchronized expression>");
    }

    public void testThrowExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tthrow fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    throw <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on throw expression>");
    }

    public void testUnaryExpressionBitwiseComplement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\ti = ~ fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    i = (~ <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on unary expression bitwise complement>");
    }

    public void testUnaryExpressionLogicalComplement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\ti = ! fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    i = (! <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on unary expression logical complement>");
    }

    public void testUnaryExpressionMinus() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\ti = - fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    i = (- <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on unary expression minus>");
    }

    public void testUnaryExpressionPlus() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\ti = + fred().xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    i = (+ <CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on unary expression plus>");
    }

    public void testVariableDeclarator() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\n\t\tint i = fred().xyz;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i = <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on variable declarator>");
    }

    public void testVariableInitializers() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\n\t\tint i = 0, j = fred().xyz;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    int j = <CompleteOnMemberAccess:fred().x>;\n  }\n}\n", "x", "xyz", "<complete on variable initializers>");
    }

    public void testWhileExpression() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\twhile (fred().xyz)\t\t\t\t\t\t\n\t\t\tSystem.out.println();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    while (<CompleteOnMemberAccess:fred().x>)      System.out.println();\n  }\n}\n", "x", "xyz", "<complete on while expresion>");
    }

    public void testWhileStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\twhile (true)\t\t\t\t\t\t\t\n\t\t\tfred().xyz = new Foo();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    while (true)      <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on while statement>");
    }
}

