/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class InnerTypeCompletionTest
extends AbstractCompletionTest {
    public InnerTypeCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return InnerTypeCompletionTest.buildAllCompliancesTestSuite(InnerTypeCompletionTest.class);
    }

    public void testAnonymousFirstMethod() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tObject o = new Object() {\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\tvoid fuzz() {\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Object o = new Object() {\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n      void fuzz() {\n      }\n    };\n  }\n}\n", "x", "xyz", "<complete in anonymous inner class in first method>");
    }

    public void testAnonymousNoStatementBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tObject o = new Object() {\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Object o = new Object() {\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    };\n  }\n}\n", "x", "xyz", "<complete in anonymous inner class with no statement before>");
    }

    public void testAnonymousOneFieldBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tObject o = new Object() {\t\t\t\t\n\t\t\tint field = 1;\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Object o = new Object() {\n      int field;\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    };\n  }\n}\n", "x", "xyz", "<complete in anonymous inner class with one field before>");
    }

    public void testAnonymousOneStatementBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tint i = 1;\t\t\t\t\t\t\t\t\n\t\tObject o = new Object() {\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    Object o = new Object() {\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    };\n  }\n}\n", "x", "xyz", "<complete in anonymous inner class with one statement before>");
    }

    public void testAnonymousSecondMethod() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tObject o = new Object() {\t\t\t\t\n\t\t\tvoid fuzz() {\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Object o = new Object() {\n      void fuzz() {\n      }\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    };\n  }\n}\n", "x", "xyz", "<complete in anonymous inner class in second method>");
    }

    public void testLocalTypeFirstMethod() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tclass InnerBar {\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\tvoid fuzz() {\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    class InnerBar {\n      InnerBar() {\n      }\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n      void fuzz() {\n      }\n    }\n  }\n}\n", "x", "xyz", "<complete in local type declaration in first method>");
    }

    public void testLocalTypeNoStatementBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tclass InnerBar {\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    class InnerBar {\n      InnerBar() {\n      }\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    }\n  }\n}\n", "x", "xyz", "<complete in local type declaration with no statement before>");
    }

    public void testLocalTypeOneFieldBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tclass InnerBar {\t\t\t\t\t\t\n\t\t\tint field = 1;\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    class InnerBar {\n      int field;\n      InnerBar() {\n      }\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    }\n  }\n}\n", "x", "xyz", "<complete in local type declaration with one field before>");
    }

    public void testLocalTypeOneStatementBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tint i = 1;\t\t\t\t\t\t\t\t\n\t\tclass InnerBar {\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    class InnerBar {\n      InnerBar() {\n      }\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    }\n  }\n}\n", "x", "xyz", "<complete in local type declaration with 1 statement before>");
    }

    public void testLocalTypeSecondMethod() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tclass InnerBar {\t\t\t\t\t\t\n\t\t\tvoid fuzz() {\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\tvoid buzz() {\t\t\t\t\t\t\n\t\t\t\tint i = fred().xyz;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    class InnerBar {\n      InnerBar() {\n      }\n      void fuzz() {\n      }\n      void buzz() {\n        int i = <CompleteOnMemberAccess:fred().x>;\n      }\n    }\n  }\n}\n", "x", "xyz", "<complete in local type declaration in second method>");
    }
}

