/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class LabelStatementCompletionTest
extends AbstractCompletionTest {
    public LabelStatementCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return LabelStatementCompletionTest.buildAllCompliancesTestSuite(LabelStatementCompletionTest.class);
    }

    public void test1FTEO9L() {
        String cu = "package p; \t\t\t\t\t\n\t\t\t\t\t\t\t\t\nclass CCHelper {\t\t\t\t\n\tclass Member1 {\t\t\t\t\n\t}\t\t\t\t\t\t\t\n\tclass Member2 {\t\t\t\t\n\t}\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\n\t}\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\npublic class CC {\t\t\t\t\n\tvoid foo() {\t\t\t\t\n\t\tnew CCHelper()\t\t\t\n\t\t\t.new CCHelper()\t\t\n\t\t\t.new M\t\t\t\t\n\t}\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        this.runTestCheckMethodParse(cu, "\t\t\t.n", "<CompleteOnMemberAccess:new CCHelper().n>", "package p;\nclass CCHelper {\n  class Member1 {\n    Member1() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  CCHelper() {\n  }\n  void foo() {\n  }\n}\npublic class CC {\n  public CC() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new CCHelper().n>;\n  }\n}\n", "n", "new", "<regression test 1FTEO9L (first case)>");
        this.runTestCheckMethodParse(cu, "\t\t\t.new CC", "<CompleteOnType:CC>", "package p;\nclass CCHelper {\n  class Member1 {\n    Member1() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  CCHelper() {\n  }\n  void foo() {\n  }\n}\npublic class CC {\n  public CC() {\n  }\n  void foo() {\n    new CCHelper().new <CompleteOnType:CC>();\n  }\n}\n", "CC", "CCHelper", "<regression test 1FTEO9L (second case)>");
        this.runTestCheckMethodParse(cu, "\t\t\t.new CCHelper()\t\t\n\t\t\t.n", "<CompleteOnMemberAccess:new CCHelper().new CCHelper().n>", "package p;\nclass CCHelper {\n  class Member1 {\n    Member1() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  CCHelper() {\n  }\n  void foo() {\n  }\n}\npublic class CC {\n  public CC() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new CCHelper().new CCHelper().n>;\n  }\n}\n", "n", "new", "<regression test 1FTEO9L (third case)>");
        this.runTestCheckMethodParse(cu, "\t\t\t.new CCHelper()\t\t\n\t\t\t.new M", "<CompleteOnType:M>", "package p;\nclass CCHelper {\n  class Member1 {\n    Member1() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  CCHelper() {\n  }\n  void foo() {\n  }\n}\npublic class CC {\n  public CC() {\n  }\n  void foo() {\n    new CCHelper().new CCHelper().new <CompleteOnType:M>();\n  }\n}\n", "M", "M", "<regression test 1FTEO9L (fourth case)>");
    }

    public void testInCaseWithIdentifier() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tlabel1: {\t\t\t\t\t\t\t\t\t\n\t\t\tswitch (i) {\t\t\t\t\t\t\t\n\t\t\t\tcase a: label2: X o = new Object();\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      {\n        <CompleteOnName:X>;\n      }\n    }\n  }\n}\n", "X", "X", new String[]{"label1", "label2"}, "<complete in case with identifier>");
    }

    public void testInCaseWithNumberConstant() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tlabel1: {\t\t\t\t\t\t\t\t\t\n\t\t\tswitch (i) {\t\t\t\t\t\t\t\n\t\t\t\tcase 1: label2: X o = new Object();\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      {\n        <CompleteOnName:X>;\n      }\n    }\n  }\n}\n", "X", "X", new String[]{"label1", "label2"}, "<complete in case with number>");
    }

    public void testInLabeledInnerClass() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tlabel1: {\t\t\t\t\t\t\t\t\n\t\t\tObject o = new Object() {\t\t\t\n\t\t\t\tvoid fred() {\t\t\t\t\t\n\t\t\t\t\tlabel2: {\t\t\t\t\t\n\t\t\t\t\t\tX o = new Object();\t\t\n\t\t\t\t\t}\t\t\t\t\t\t\t\n\t\t\t\t}\t\t\t\t\t\t\t\t\n\t\t\t};\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      Object o = new Object() {\n        void fred() {\n          label2: {\n  <CompleteOnType:X> o;\n}\n        }\n      };\n    }\n  }\n}\n", "X", "X", new String[]{"label2"}, "<complete in labeled inner class>");
    }

    public void testInLabeledInnerClassWithErrorBefore() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tint i == 2; \n\t\tlabel1: {\t\t\t\t\t\t\t\t\n\t\t\tObject o = new Object() {\t\t\t\n\t\t\t\tvoid fred() {\t\t\t\t\t\n\t\t\t\t\tlabel2: {\t\t\t\t\t\n\t\t\t\t\t\tX o = new Object();\t\t\n\t\t\t\t\t}\t\t\t\t\t\t\t\n\t\t\t\t}\t\t\t\t\t\t\t\t\n\t\t\t};\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    {\n      Object o;\n      new Object() {\n        void fred() {\n          {\n            <CompleteOnName:X>;\n          }\n        }\n      };\n    }\n  }\n}\n", "X", "X", new String[]{"label2"}, "<complete in labeled inner class with syntax error before>");
    }

    public void testOneLevelDeep() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tlabel1: X o = new Object();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnName:X>;\n  }\n}\n", "X", "X", new String[]{"label1"}, "<complete in one level deep>");
    }

    public void testSecondLabel() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tlabel1: buzz();\t\t\t\t\t\t\t\n\t\tlabel2: X o = new Object();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnName:X>;\n  }\n}\n", "X", "X", new String[]{"label2"}, "<complete in second labeled statement>");
    }

    public void testTwoLevelDeep() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tlabel1: {\t\t\t\t\t\t\t\t\n\t\t\tlabel2: X o = new Object();\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      <CompleteOnName:X>;\n    }\n  }\n}\n", "X", "X", new String[]{"label1", "label2"}, "<complete in two level deep>");
    }
}

