/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class NameReferenceCompletionTest
extends AbstractCompletionTest {
    public NameReferenceCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return NameReferenceCompletionTest.buildAllCompliancesTestSuite(NameReferenceCompletionTest.class);
    }

    public void test1FTZ849() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tX o = new X;\t\t\t\t\t\t\n\t\tfred.xyz;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred.x", "<CompleteOnName:fred.x>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    X o;\n    <CompleteOnName:fred.x>;\n  }\n}\n", "x", "fred.xyz", "<1FTZ849>");
    }

    public void test1FUUP73() {
        this.runTestCheckDietParse("public class A {\t\t\t\t\t\n\tString s = \"hello\";\t\t\t\n\tObject o = s.concat(\"boo\");\t\n", "Object o = s", "<CompleteOnName:s>", "public class A {\n  String s;\n  Object o = <CompleteOnName:s>;\n  public A() {\n  }\n}\n", "s", "s", "<1FUUP73>");
        this.runTestCheckDietParse("public class A {\t\t\t\t\t\n\tString s = \"hello\";\t\t\t\n\tObject o = s.concat(\"boo\");\t\n", "Object o = s.c", "<CompleteOnName:s.c>", "public class A {\n  String s;\n  Object o = <CompleteOnName:s.c>;\n  public A() {\n  }\n}\n", "c", "s.concat", "<1FUUP73>");
    }

    public void test1FVRQQA_1() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tEnumeration e = null; \t\t\t\t\n\t\te.to\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "e.to", "<CompleteOnName:e.to>", "class X {\n  X() {\n  }\n  void foo() {\n    Enumeration e;\n    <CompleteOnName:e.to>;\n  }\n}\n", "to", "e.to", "<1FVRQQA_1>");
    }

    public void test1FVRQQA_2() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\t\n\t\tfor (Enumeration e = getSomeEnumeration(); e.has\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "e.has", "<CompleteOnName:e.has>", "class X {\n  X() {\n  }\n  void foo() {\n    Enumeration e;\n    for (; <CompleteOnName:e.has>; ) \n      ;\n  }\n}\n", "has", "e.has", "<1FVRQQA_2>");
    }

    public void test1FVT66Q_1() {
        this.runTestCheckMethodParse("package test;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\npublic class Test {\t\t\t\t\t\n\tpublic void foo() {\t\t\t\t\t\n\t\tfinal int codeAssistTarget= 3;\t\n\t\t\t\t\t\t\t\t\t\t\n\t\tThread t= new Thread() {\t\t\n\t\t\tpublic void run() {\t\t\t\n\t\t\t\tcodeAss\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\n\t\tcodeA\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\tcodeAss", "<CompleteOnName:codeAss>", "package test;\npublic class Test {\n  public Test() {\n  }\n  public void foo() {\n    final int codeAssistTarget;\n    Thread t;\n    new Thread() {\n      public void run() {\n        <CompleteOnName:codeAss>;\n      }\n    };\n  }\n}\n", "codeAss", "codeAss", "<1FVT66Q_1>");
    }

    public void test1FVT66Q_2() {
        this.runTestCheckMethodParse("package test;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\npublic class Test {\t\t\t\t\t\n\tpublic void foo() {\t\t\t\t\t\n\t\tfinal int codeAssistTarget= 3;\t\n\t\t\t\t\t\t\t\t\t\t\n\t\tThread t= new Thread() {\t\t\n\t\t\tpublic void run() {\t\t\t\n\t\t\t\tcodeAss\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\n\t\tcodeA\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\n\t\tcodeA", "<CompleteOnName:codeA>", "package test;\npublic class Test {\n  public Test() {\n  }\n  public void foo() {\n    final int codeAssistTarget;\n    Thread t;\n    <CompleteOnName:codeA>;\n  }\n}\n", "codeA", "codeA", "<1FVT66Q_2>");
    }

    public void test1G8DE30() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew Runnable() {\t\t\t\t\t\n\t\t\tpublic void run() {\t\t\t\t\n\t\t\t\tBar\t\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "public void run() {\t\t\t\t\n\t\t\t\t", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new Runnable() {\n      public void run() {\n        <CompleteOnName:>;\n      }\n    };\n  }\n}\n", "", "Bar", "<1G8DE30>");
    }

    public void testEmptyNameReference() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "int i = 0;\t\t\t\t\t\t\t\n\t\t", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnName:>;\n  }\n}\n", "", "", "<complete on empty name reference>");
    }

    public void testEmptyNameReferenceAfterCast() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tX x = (X)\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "(X)", "<CompleteOnName:>", "class X {\n  X() {\n  }\n  void foo() {\n    X x = (X) <CompleteOnName:>;\n  }\n}\n", "", "", "<complete on empty name reference after cast>");
    }

    public void testEmptyNameReferenceAfterPlus() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\t1 + \t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "1 +", "<CompleteOnName:>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnName:>;\n  }\n}\n", "", "", "<complete on empty name reference after + operator>");
    }

    public void testEmptyNameReferenceInArrayDim() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint[]\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "int[", "<CompleteOnName:>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnName:>;\n  }\n}\n", "", "", "<complete on empty name reference in array dim>");
    }

    public void testEmptyNameReferenceInInnerClass() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tclass Y {\t\t\t\t\t\t\t\n\t\t\tvoid bar() {\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "\n\t\t\t\t", "<CompleteOnName:>", "class X {\n  X() {\n  }\n  void foo() {\n    class Y {\n      Y() {\n      }\n      void bar() {\n        <CompleteOnName:>;\n      }\n    }\n  }\n}\n", "", "", "<complete on empty name reference in inner class>");
    }

    public void testInIfThenStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (bar()) \t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "\n\t\t\t", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnName:>;\n  }\n}\n", "", "", "<complete in if then statement>");
    }

    public void testInIfThenWithInstanceOfStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (this instanceof Bar) \t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "\n\t\t\t", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if ((this instanceof Bar))\n        <CompleteOnName:>;\n  }\n}\n", "", "", "<complete in if then statement>");
    }

    public void testInnerClassFieldInitializer() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tObject o = new Object() {\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\n\t\t\txyz\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t};\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "xyz", "<CompleteOnName:xyz>", "class Bar {\n  Object o = new Object() {\n    void foo() {\n      <CompleteOnName:xyz>;\n    }\n  };\n  Bar() {\n  }\n}\n", "xyz", "xyz", "<complete on name reference in inner class in field initializer>");
    }

    public void testInvocationFieldInitializer() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tString s = fred(1 + );\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "(1 + ", "<CompleteOnName:>", "class Bar {\n  String s = (1 + <CompleteOnName:>);\n  Bar() {\n  }\n  void foo() {\n  }\n}\n", "", "", "<complete on empty name reference in invocation in field initializer>");
    }

    public void testMethodInvocationAnonymousInnerClass() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tprimary().bizz(\t\t\t\t\t\t\t\n\t\t\tnew X() {\t\t\t\t\t\t\t\n\t\t\t\tvoid fuzz() {\t\t\t\t\t\n\t\t\t\t\tx.y.z\t\t\t\t\t\t\n\t\t\t\t}\t\t\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t);\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x.", "<CompleteOnName:x.>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new X() {\n      void fuzz() {\n        <CompleteOnName:x.>;\n      }\n    };\n  }\n}\n", "", "x.y.z", "<complete inside anonymous inner class inside method invocation 1>");
    }

    public void testQualifiedNameReferenceShrinkAll() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\ta.b.c.Xxx o = new Y(i);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "\t\ta", "<CompleteOnName:a>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnName:a>;\n  }\n}\n", "a", "a", "<complete on qualified name reference (shrink all)>");
    }

    public void testQualifiedNameReferenceShrinkAllButOne() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar() {\t\t\t\t\t\t\t\n\t\t\tBar.x.x.super();\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "Bar.", "<CompleteOnName:Bar.>", "class Bar {\n  public class InnerBar {\n    public InnerBar() {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar() {\n      super();\n      <CompleteOnName:Bar.>;\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "", "Bar.", "<complete on qualified name reference (shrink all but one)>");
    }

    public void testQualifiedNameReferenceShrinkAllButOne2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\ta.b.c.X o = new Y(i);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "\t\ta.", "<CompleteOnName:a.>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnName:a.>;\n  }\n}\n", "", "a.", "<complete on qualified name reference (shrink all but one) 2>");
    }

    public void testQualifiedNameReferenceShrinkNone() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar() {\t\t\t\t\t\t\t\n\t\t\tBar.x.x.super();\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "Bar.x.x", "<CompleteOnName:Bar.x.x>", "class Bar {\n  public class InnerBar {\n    public InnerBar() {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar() {\n      super();\n      <CompleteOnName:Bar.x.x>;\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "x", "Bar.x.x", "<complete on qualified name reference (shrink none)>");
    }

    public void testQualifiedNameReferenceShrinkNone2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\ta.b.c.Xxx o = new Y(i);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:a.b.c.X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnName:a.b.c.X>;\n  }\n}\n", "X", "a.b.c.Xxx", "<complete on qualified name reference (shrink none) 2>");
    }

    public void testQualifiedNameReferenceShrinkOne() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar() {\t\t\t\t\t\t\t\n\t\t\tBar.x.x.super();\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "Bar.x.", "<CompleteOnName:Bar.x.>", "class Bar {\n  public class InnerBar {\n    public InnerBar() {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar() {\n      super();\n      <CompleteOnName:Bar.x.>;\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "", "Bar.x.", "<complete on qualified name reference (shrink one)>");
    }

    public void testQualifiedNameReferenceShrinkOne2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\ta.b.c.X o = new Y(i);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "a.b.c.", "<CompleteOnName:a.b.c.>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnName:a.b.c.>;\n  }\n}\n", "", "a.b.c.", "<complete on qualified name reference (shrink one) 2>");
    }

    public void testUnicode() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\n\tvoid foo() {\t\t\t\n\t\tbar.\\u005ax \t\t\n\t}\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\n", "x", "<CompleteOnName:bar.Zx>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnName:bar.Zx>;\n  }\n}\n", "Zx", "bar.\\u005ax", "<complete on unicode>");
    }
}

