/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class ParserTest1_7
extends AbstractCompilerTest {
    public static final boolean ONLY_DIET_PLUS_BODY_WITH_STATEMENT_RECOVERY = false;

    public static Class testClass() {
        return ParserTest1_7.class;
    }

    public static Test suite() {
        return ParserTest1_7.buildMinimalComplianceTestSuite(ParserTest1_7.testClass(), 32);
    }

    public ParserTest1_7(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietWithStatementRecoveryUnitToString, String expectedDietPlusBodyUnitToString, String expectedDietPlusBodyWithStatementRecoveryUnitToString, String expectedFullUnitToString, String expectedFullWithStatementRecoveryUnitToString, String testName) {
        int length;
        int i;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), true);
        parser.setStatementsRecovery(false);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit diet structure with statement recovery enabled" + testName, expectedDietWithStatementRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), true);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = 0;
            length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit diet structure" + testName, expectedDietWithStatementRecoveryUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = 0;
            length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyWithStatementRecoveryUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit diet+body structure with statement recovery enabled" + testName, expectedDietPlusBodyWithStatementRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), true);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        ParserTest1_7.assertEquals("Invalid unit full structure with statement recovery enabled" + testName, expectedFullWithStatementRecoveryUnitToString, computedUnitToString);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        return options;
    }

    public void test0001() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\")) {\n\t\t\tSystem.out.println(reader.read());\n\t\t} catch(FileNotFoundException | IOException | Exception e) {\n\t\t\te.printStackTrace();\n\t\t} finally {\n\t\t\tSystem.out.println(\"Finishing try-with-resources\");\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException | IOException | Exception e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException | IOException | Exception e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException | IOException | Exception e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\")) {\n\t\t\tSystem.out.println(reader.read());\n\t\t} catch(FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t} finally {\n\t\t\tSystem.out.println(\"Finishing try-with-resources\");\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0003() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\")) {\n\t\t\tSystem.out.println(reader.read());\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0004() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\")) {\n\t\t\tSystem.out.println(reader.read());\n\t\t} finally {\n\t\t\tSystem.out.println(\"Finishing try-with-resources\");\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0005() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\")) {\n\t\t\tSystem.out.println(reader.read());\n\t\t} catch(FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0006() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry {\n\t\t\tSystem.out.println(reader.read());\n\t\t} catch(FileNotFoundException | IOException | Exception e) {\n\t\t\te.printStackTrace();\n\t\t} finally {\n\t\t\tSystem.out.println(\"Finishing try-with-resources\");\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException | IOException | Exception e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException | IOException | Exception e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException | IOException | Exception e)\n      {\n        e.printStackTrace();\n      }\n    finally\n      {\n        System.out.println(\"Finishing try-with-resources\");\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0007() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\tList<String> l = new ArrayList<>();\n\t\tSystem.out.println(l);\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<String> l = new ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<String> l = new ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<String> l = new ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0008() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\tList<> l = new ArrayList<>();\n\t\tSystem.out.println(l);\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<> l = new ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<> l = new ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<> l = new ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0009() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\tList<String> l = new java.util.ArrayList<>();\n\t\tSystem.out.println(l);\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<String> l = new java.util.ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<String> l = new java.util.ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    List<String> l = new java.util.ArrayList<>();\n    System.out.println(l);\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0010() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\tB<String>.C<Integer> o = new B<>.C<>();\n\t\tSystem.out.println(l);\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    B<String>.C<Integer> o = new B<>.C<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    B<String>.C<Integer> o = new B<>.C<>();\n    System.out.println(l);\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    B<String>.C<Integer> o = new B<>.C<>();\n    System.out.println(l);\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0011() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\");) {\n\t\t\tSystem.out.println(reader.read());\n\t\t} catch(FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0012() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class A {\n\tpublic void foo(String fileName) {\n\t\ttry (Reader reader = new FileReader(\"fileName\");\n\t\t\tReader reader2 = new FileReader(\"fileName\");) {\n\t\t\tSystem.out.println(reader.read());\n\t\t} catch(FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  public void foo(String fileName) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\");\n        Reader reader2 = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\");\n        Reader reader2 = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  public void foo(String fileName) {\n    try (Reader reader = new FileReader(\"fileName\");\n        Reader reader2 = new FileReader(\"fileName\"))\n      {\n        System.out.println(reader.read());\n      }\n    catch (FileNotFoundException e)\n      {\n        e.printStackTrace();\n      }\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }
}

