/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class ReferenceTypeCompletionTest
extends AbstractCompletionTest {
    public ReferenceTypeCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return ReferenceTypeCompletionTest.buildAllCompliancesTestSuite(ReferenceTypeCompletionTest.class);
    }

    public void test1FTZCIG() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew X() {\t\t\t\t\t\t\t\n\t\t\tprotected void bar() {\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "p", "<CompleteOnType:p>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new X() {\n      <CompleteOnType:p>;\n      void bar() {\n      }\n    };\n  }\n}\n", "p", "protected", "<1FTZCIG>");
    }

    public void testBlock() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\t\n\t\t\tXxx o = new Y();\t\t\t\t\n\t\t} catch (Exception e) {\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      <CompleteOnName:X>;\n    }\n  }\n}\n", "X", "Xxx", "<complete on block>");
    }

    public void testBlockStatements() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\tXxx o = new Y();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnName:X>;\n  }\n}\n", "X", "Xxx", "<complete on block statements>");
    }

    public void testCatchClause1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\t\n\t\t\tfred();\t\t\t\t\t\t\t\n\t\t} catch (Xxx e) {\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnException:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    try\n      {\n        fred();\n      }\n    catch (<CompleteOnException:X>  )\n      {\n      }\n  }\n}\n", "X", "Xxx", "<complete on catch clause 1>");
    }

    public void testCatchClause2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\t\n\t\t\tfred();\t\t\t\t\t\t\t\n\t\t} catch (final Xxx e) {\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnException:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    try\n      {\n        fred();\n      }\n    catch (<CompleteOnException:X>  )\n      {\n      }\n  }\n}\n", "X", "Xxx", "<complete on catch clause 2>");
    }

    public void testCatchClause3() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\t\n\t\t\tfred();\t\t\t\t\t\t\t\n\t\t} catch (x.y.Xxx e) {\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x.y.X", "<CompleteOnException:x.y.X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    try\n      {\n        fred();\n      }\n    catch (<CompleteOnException:x.y.X>  )\n      {\n      }\n  }\n}\n", "X", "x.y.Xxx", "<complete on catch clause 3>");
    }

    public void testClassBody() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tXxx foo() {\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  <CompleteOnType:X>\n}\n", "X", "Xxx", "<complete on  class body>");
    }

    public void testClassBodyDeclarations() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tint i = 0;\t\t\t\t\t\t\t\t\n\tXxx foo() {\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  int i;\n  Bar() {\n  }\n  <CompleteOnType:X>\n}\n", "X", "Xxx", "<complete on  class body declarations>");
    }

    public void testClassInstanceCreationExpression1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew Xxx().zzz();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new <CompleteOnType:X>();\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression 1>");
    }

    public void testClassInstanceCreationExpression2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew Y(new Xxx()).zzz();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new Y(new <CompleteOnType:X>());\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression 2>");
    }

    public void testClassInstanceCreationExpression3() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew Y(1, true, new Xxx()).zzz();\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    new Y(1, true, new <CompleteOnType:X>()).zzz();\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression 3>");
    }

    public void testClassInstanceCreationExpression4() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tfred().new Y(new Xxx()).zzz();\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    fred().new Y(new <CompleteOnType:X>()).zzz();\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression 4>");
    }

    public void testClassInstanceCreationExpressionName1() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tstatic Bar baz;\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tBar.baz.new Xxx();\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      Bar.baz.new <CompleteOnType:X>();\n    }\n  }\n  static Bar baz;\n  <clinit>() {\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with name 1>");
    }

    public void testClassInstanceCreationExpressionName2() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tstatic Bar baz;\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tnew Y(Bar.baz.new Xxx());\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      new Y(Bar.baz.new <CompleteOnType:X>());\n    }\n  }\n  static Bar baz;\n  <clinit>() {\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with name 2>");
    }

    public void testClassInstanceCreationExpressionName3() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tstatic Bar baz;\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tnew Y(1, true, Bar.baz.new Xxx());\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      new Y(1, true, Bar.baz.new <CompleteOnType:X>());\n    }\n  }\n  static Bar baz;\n  <clinit>() {\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with name 3>");
    }

    public void testClassInstanceCreationExpressionName4() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tstatic Bar baz;\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tfred().new Y(Bar.baz.new Xxx());\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      fred().new Y(Bar.baz.new <CompleteOnType:X>());\n    }\n  }\n  static Bar baz;\n  <clinit>() {\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with name 4>");
    }

    public void testClassInstanceCreationExpressionPrimary1() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tnew Bar().new Xxx();\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      new Bar().new <CompleteOnType:X>();\n    }\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with primary 1>");
    }

    public void testClassInstanceCreationExpressionPrimary2() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tnew Y(new Bar().new Xxx());\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      new Y(new Bar().new <CompleteOnType:X>());\n    }\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with primary 2>");
    }

    public void testClassInstanceCreationExpressionPrimary3() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tfred().new Y(new Bar().new Xxx());\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      fred().new Y(new Bar().new <CompleteOnType:X>());\n    }\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with primary 3>");
    }

    public void testClassInstanceCreationExpressionPrimary4() {
        this.runTestCheckMethodParse("public class Bar {\t\t\t\t\t\t\t\t\n\tpublic class X {\t\t\t\t\t\t\t\n\t\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tnew Y(1, true, new Bar().new Xxx());\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "new X", "<CompleteOnType:X>", "public class Bar {\n  public class X {\n    public X() {\n    }\n    void foo() {\n      new Y(1, true, new Bar().new <CompleteOnType:X>());\n    }\n  }\n  public Bar() {\n  }\n}\n", "X", "Xxx", "<complete on class instance creation expression with primary 4>");
    }

    public void testClassTypeList() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() throws Exception, Xxx {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnException:X>", "class Bar {\n  Bar() {\n  }\n  void foo() throws Exception, <CompleteOnException:X> {\n  }\n}\n", "X", "Xxx", "<complete on class type list>");
    }

    public void testConstructorBody() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\n\t\tXxx o = new Y();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n    super();\n    <CompleteOnName:X>;\n  }\n}\n", "X", "Xxx", "<complete on constructor body>");
    }

    public void testConstructorDeclarator() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tBar(Xxx o) {\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar(<CompleteOnType:X> o) {\n  }\n}\n", "X", "Xxx", "<complete on constructor declarator>");
    }

    public void testDeepReference() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (a == 2) {\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t\ttry {\t\t\t\t\t\t\t\t\n\t\t} finally {\t\t\t\t\t\t\t\n\t\t\tif (1 == fgh) {\t\t\t\t\t\n\t\t\t\tXxx o = null;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    if ((a == 2))\n        {\n        }\n    try\n      {\n      }\n    finally\n      {\n        if ((1 == fgh))\n            {\n              <CompleteOnType:X> o;\n            }\n      }\n  }\n}\n", "X", "Xxx", "<complete on deep type>");
    }

    public void testExtendsClass() {
        this.runTestCheckDietParse("class Bar extends Xxx {\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnClass:X>", "class Bar extends <CompleteOnClass:X> {\n  Bar() {\n  }\n}\n", "X", "Xxx", "<complete on extends>");
    }

    public void testExtendsInterface() {
        this.runTestCheckDietParse("interface Bar extends Xxx {\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnInterface:X>", "interface Bar extends <CompleteOnInterface:X> {\n}\n", "X", "Xxx", "<complete on extends>");
    }

    public void testFieldDeclarationWithModifiers() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tpublic final Xxx foo;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>;", "class Bar {\n  <CompleteOnType:X>;\n  Bar() {\n  }\n}\n", "X", "Xxx", "<complete on field declaration with modifiers>");
    }

    public void testFieldDeclarationWithoutModifiers() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tXxx foo;\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>;", "class Bar {\n  <CompleteOnType:X>;\n  Bar() {\n  }\n}\n", "X", "Xxx", "<complete on field declaration without modifiers>");
    }

    public void testFormalParameter() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo(final Xxx x) {\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo(final <CompleteOnType:X> x) {\n  }\n}\n", "X", "Xxx", "<complete on formal parameter>");
    }

    public void testFormalParameterList() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo(int i, final Object o, Xxx x) {\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo(int i, final Object o, <CompleteOnType:X> x) {\n  }\n}\n", "X", "Xxx", "<complete on formal parameter list>");
    }

    public void testForStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfor (Xxx o = new Y(); o.size() < 10; ) {\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnName:X>;\n  }\n}\n", "X", "Xxx", "<complete on for statement>");
    }

    public void testImplements() {
        this.runTestCheckDietParse("class Bar implements Xxx {\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnInterface:X>", "class Bar implements <CompleteOnInterface:X> {\n  Bar() {\n  }\n}\n", "X", "Xxx", "<complete on implements>");
    }

    public void testInstanceOf() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tboolean foo() {\t\t\t\t\t\t\t\t\n\t\treturn this instanceof Xxx;\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  boolean foo() {\n    return (this instanceof <CompleteOnType:X>);\n  }\n}\n", "X", "Xxx", "<complete on instanceof>");
    }

    public void testInterfaceBody() {
        this.runTestCheckDietParse("interface Bar {\t\t\t\t\t\t\t\n\tXxx foo();\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "interface Bar {\n  <CompleteOnType:X>\n}\n", "X", "Xxx", "<complete on interface body>");
    }

    public void testInterfaceMemberDeclarations() {
        this.runTestCheckDietParse("interface Bar {\t\t\t\t\t\t\t\n\tint CONSTANT = 0;\t\t\t\t\t\t\n\tXxx foo();\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "interface Bar {\n  int CONSTANT;\n  <clinit>() {\n  }\n  <CompleteOnType:X>\n}\n", "X", "Xxx", "<complete on interface member declarations>");
    }

    public void testInterfaceTypeList() {
        this.runTestCheckDietParse("interface Bar extends Comparable, Xxx {\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnInterface:X>", "interface Bar extends Comparable, <CompleteOnInterface:X> {\n}\n", "X", "Xxx", "<complete on interface list>");
    }

    public void testLocalVariableDeclaration() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tfinal Xxx o = new Y();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnName:X>;\n  }\n}\n", "X", "Xxx", "<complete on local variable declaration>");
    }

    public void testMethodBody() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tXxx o = new Y();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnName:X>;\n  }\n}\n", "X", "Xxx", "<complete on method body>");
    }

    public void testMethodDeclarator() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo(Xxx o) {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo(<CompleteOnType:X> o) {\n  }\n}\n", "X", "Xxx", "<complete on method declarator>");
    }

    public void testMethodHeaderWithModifiers() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tpublic static Xxx foo() {\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  <CompleteOnType:X>\n}\n", "X", "Xxx", "<complete on method header with modifiers>");
    }

    public void testMethodHeaderWithoutModifiers() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tXxx foo() {\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  <CompleteOnType:X>\n}\n", "X", "Xxx", "<complete on method header without modifiers>");
    }

    public void testQualifiedTypeReferenceShrinkAll() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\tnew a.b.c.Xxx();\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "\t\tnew a", "<CompleteOnType:a>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    new <CompleteOnType:a>();\n  }\n}\n", "a", "a", "<complete on qualified type reference (shrink all)>");
    }

    public void testQualifiedTypeReferenceShrinkAllButOne() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\tnew a.b.c.Xxx();\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "a.", "<CompleteOnType:a.>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    new <CompleteOnType:a.>();\n  }\n}\n", "", "a.", "<complete on qualified type reference (shrink all but one)>");
    }

    public void testQualifiedTypeReferenceShrinkNone() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\tnew a.b.c.Xxx();\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:a.b.c.X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    new <CompleteOnType:a.b.c.X>();\n  }\n}\n", "X", "a.b.c.Xxx", "<complete on qualified type reference (shrink none)>");
    }

    public void testQualifiedTypeReferenceShrinkOne() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 0;\t\t\t\t\t\t\t\n\t\tnew a.b.c.Xxx();\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "a.b.c.", "<CompleteOnType:a.b.c.>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    new <CompleteOnType:a.b.c.>();\n  }\n}\n", "", "a.b.c.", "<complete on qualified type reference (shrink one)>");
    }

    public void testSwitchBlockStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tint i = 1;\t\t\t\t\t\t\t\n\t\tswitch (i) {\t\t\t\t\t\t\n\t\t\tcase 1: \t\t\t\t\t\t\n\t\t\t\tXxx o = fred(i);\t\t\t\n\t\t\t\tbreak;\t\t\t\t\t\t\n\t\t\tdefault:\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnType:X>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    int i;\n    switch (i) {\n    case 1 :\n        <CompleteOnType:X> o;\n        break;\n    default :\n    }\n  }\n}\n", "X", "Xxx", "<complete on switch block statement>");
    }

    public void testThrows() {
        this.runTestCheckDietParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() throws Xxx {\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnException:X>", "class Bar {\n  Bar() {\n  }\n  void foo() throws <CompleteOnException:X> {\n  }\n}\n", "X", "Xxx", "<complete on throws>");
    }
}

