/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSelectionTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.codeassist.select.SelectionJavadoc;
import org.eclipse.jdt.internal.codeassist.select.SelectionParser;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class SelectionMarkdownTest
extends AbstractSelectionTest {
    String source;
    ICompilationUnit unit;
    StringBuilder result;

    public SelectionMarkdownTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return SelectionMarkdownTest.buildMinimalComplianceTestSuite(SelectionMarkdownTest.class, 0x100000);
    }

    protected void assertValid(String expected) {
        String actual = this.result.toString();
        if (!actual.equals(expected)) {
            System.out.println("Expected result for test " + this.testName() + ":");
            System.out.println(Util.displayString(actual, 3));
            System.out.println("\tsource: [");
            System.out.print(Util.indentString(this.source, 2));
            System.out.println("]\n");
            SelectionMarkdownTest.assertEquals("Invalid selection node", expected, actual);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.unit = null;
    }

    void setUnit(String name, String source) {
        this.source = source;
        this.unit = new CompilationUnit(source.toCharArray(), name, null);
        this.result = new StringBuilder();
    }

    protected CompilationResult findJavadoc(String selection) {
        return this.findJavadoc(selection, 1);
    }

    protected CompilationResult findJavadoc(String selection, int occurences) {
        SelectionMarkdownTest.assertNotNull((String)"Missing compilation unit!", (Object)this.unit);
        int selectionStart = this.source.indexOf(selection);
        int length = selection.length();
        int selectionEnd = selectionStart + length - 1;
        int i = 1;
        while (i < occurences) {
            selectionStart = this.source.indexOf(selection, selectionEnd);
            selectionEnd = selectionStart + length - 1;
            ++i;
        }
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        SelectionParser parser = new SelectionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnitDeclaration unitDecl = parser.dietParse(this.unit, new CompilationResult(this.unit, 0, 0, 0), selectionStart, selectionEnd);
        parser.getMethodBodies(unitDecl);
        unitDecl.traverse((ASTVisitor)new JavadocSelectionVisitor(), unitDecl.scope);
        return unitDecl.compilationResult();
    }

    @Override
    protected Map getCompilerOptions() {
        Map optionsMap = super.getCompilerOptions();
        optionsMap.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
        optionsMap.put("org.eclipse.jdt.core.compiler.compliance", "23");
        optionsMap.put("org.eclipse.jdt.core.compiler.source", "23");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        return optionsMap;
    }

    public void test01() {
        this.setUnit("Test.java", "public class Test {\n\t /// @see #foo() \n\tvoid bar() {\n\t\tfoo();\n\t}\n\tvoid foo() {}\n}\n");
        this.findJavadoc("foo");
        this.assertValid("/**<SelectOnMethod:#foo()>*/\n");
    }

    public void test02() {
        this.setUnit("Test.java", "public class Test {\n\t /// {@link #foo() foo} \n\tvoid bar() {\n\t\tfoo();\n\t}\n\tvoid foo() {}\n}\n");
        this.findJavadoc("foo");
        this.assertValid("/**<SelectOnMethod:#foo()>*/\n");
    }

    public void test03() {
        this.setUnit("Test.java", "public class Test {\n\t /// @see Test \n\tvoid foo() {}\n}\n");
        this.findJavadoc("Test", 2);
        this.assertValid("/**<SelectOnType:Test>*/\n");
    }

    public void test04() {
        this.setUnit("Test.java", "public class Test {\n\t /// Javadoc {@link Test} \n\tvoid foo() {}\n}\n");
        this.findJavadoc("Test", 2);
        this.assertValid("/**<SelectOnType:Test>*/\n");
    }

    public void test05() {
        this.setUnit("Test.java", "public class Test {\n\tint field;\n\t /// @see #field \n\tvoid foo() {}\n}\n");
        this.findJavadoc("field", 2);
        this.assertValid("/**<SelectOnField:#field>*/\n");
    }

    public void test06() {
        this.setUnit("Test.java", "public class Test {\n\tint field;\n\t /// {@link #field}\n\tvoid foo() {}\n}\n");
        this.findJavadoc("field", 2);
        this.assertValid("/**<SelectOnField:#field>*/\n");
    }

    public void test07() {
        this.setUnit("Test.java", "public class Test {\n\t/// \n\t/// @see Test#field\n\t/// @see #foo(int, String)\n\t/// @see Test#foo(int, String)\n\t/// \n\tvoid bar() {\n\t\tfoo(0, \"\");\n\t}\n\tint field;\n\tvoid foo(int x, String s) {}\n}\n");
        this.findJavadoc("foo");
        this.findJavadoc("String");
        this.findJavadoc("Test", 2);
        this.findJavadoc("foo", 2);
        this.findJavadoc("String", 2);
        this.findJavadoc("Test", 3);
        this.findJavadoc("field");
        this.assertValid("/**<SelectOnMethod:#foo(int , String )>*/\n/**<SelectOnType:String>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnMethod:Test#foo(int , String )>*/\n/**<SelectOnType:String>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnField:Test#field>*/\n");
    }

    public void test08() {
        this.setUnit("Test.java", "public class Test {\n\t /// \n\t /// First {@link #foo(int, String)}\n\t /// Second {@link Test#foo(int, String) method foo}\n\t /// Third {@link Test#field field}\n\t /// \n\tvoid bar() {\n\t\tfoo(0, \"\");\n\t}\n\tint field;\n\tvoid foo(int x, String s) {}\n}\n");
        this.findJavadoc("foo");
        this.findJavadoc("String");
        this.findJavadoc("Test", 2);
        this.findJavadoc("foo", 2);
        this.findJavadoc("String", 2);
        this.findJavadoc("Test", 3);
        this.findJavadoc("field");
        this.assertValid("/**<SelectOnMethod:#foo(int , String )>*/\n/**<SelectOnType:String>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnMethod:Test#foo(int , String )>*/\n/**<SelectOnType:String>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnField:Test#field>*/\n");
    }

    public void test09() {
        this.setUnit("test/junit/Test.java", "package test.junit;\npublic class Test {\n\t /// \n\t /// @see test.junit.Test\n\t /// @see test.junit.Test#field\n\t /// @see test.junit.Test#foo(Object[] array)\n\t /// \n\tvoid bar() {\n\t\tfoo(null);\n\t}\n\tint field;\n\tvoid foo(Object[] array) {}\n}\n");
        this.findJavadoc("test", 2);
        this.findJavadoc("junit", 2);
        this.findJavadoc("Test", 2);
        this.findJavadoc("test", 3);
        this.findJavadoc("junit", 3);
        this.findJavadoc("Test", 3);
        this.findJavadoc("field");
        this.findJavadoc("test", 4);
        this.findJavadoc("junit", 4);
        this.findJavadoc("Test", 4);
        this.findJavadoc("foo");
        this.findJavadoc("Object");
        this.findJavadoc("array");
        this.assertValid("/**<SelectOnType:test>*/\n/**<SelectOnType:test.junit>*/\n/**<SelectOnType:test.junit.Test>*/\n/**<SelectOnType:test>*/\n/**<SelectOnType:test.junit>*/\n/**<SelectOnType:test.junit.Test>*/\n/**<SelectOnField:test.junit.Test#field>*/\n/**<SelectOnType:test>*/\n/**<SelectOnType:test.junit>*/\n/**<SelectOnType:test.junit.Test>*/\n/**<SelectOnMethod:test.junit.Test#foo(Object[] array)>*/\n/**<SelectOnType:Object>*/\n/**\n */\n");
    }

    public void test10() {
        this.setUnit("test/junit/Test.java", "package test.junit;\npublic class Test {\n\t /// Javadoc {@linkplain test.junit.Test}\n\t /// {@linkplain test.junit.Test#field field}\n\t /// last line {@linkplain test.junit.Test#foo(Object[] array) foo(Object[])}\n\t /// \n\tvoid bar() {\n\t\tfoo(null);\n\t}\n\tint field;\n\tvoid foo(Object[] array) {}\n}\n");
        this.findJavadoc("test", 2);
        this.findJavadoc("junit", 2);
        this.findJavadoc("Test", 2);
        this.findJavadoc("test", 3);
        this.findJavadoc("junit", 3);
        this.findJavadoc("Test", 3);
        this.findJavadoc("field");
        this.findJavadoc("test", 4);
        this.findJavadoc("junit", 4);
        this.findJavadoc("Test", 4);
        this.findJavadoc("foo");
        this.findJavadoc("Object");
        this.findJavadoc("array");
        this.assertValid("/**<SelectOnType:test>*/\n/**<SelectOnType:test.junit>*/\n/**<SelectOnType:test.junit.Test>*/\n/**<SelectOnType:test>*/\n/**<SelectOnType:test.junit>*/\n/**<SelectOnType:test.junit.Test>*/\n/**<SelectOnField:test.junit.Test#field>*/\n/**<SelectOnType:test>*/\n/**<SelectOnType:test.junit>*/\n/**<SelectOnType:test.junit.Test>*/\n/**<SelectOnMethod:test.junit.Test#foo(Object[] array)>*/\n/**<SelectOnType:Object>*/\n/**\n */\n");
    }

    public void test11() {
        this.setUnit("Test.java", "public class Test {\n\t /// \n\t /// @throws RuntimeException runtime exception\n\t /// @throws InterruptedException interrupted exception\n\t /// \n\tvoid foo() {}\n}\n");
        this.findJavadoc("RuntimeException");
        this.findJavadoc("InterruptedException");
        this.assertValid("/**<SelectOnType:RuntimeException>*/\n/**<SelectOnType:InterruptedException>*/\n");
    }

    public void test12() {
        this.setUnit("Test.java", "public class Test {\n\t /// \n\t /// @exception RuntimeException runtime exception\n\t /// @exception InterruptedException interrupted exception\n\t /// \n\tvoid foo() {}\n}\n");
        this.findJavadoc("RuntimeException");
        this.findJavadoc("InterruptedException");
        this.assertValid("/**<SelectOnType:RuntimeException>*/\n/**<SelectOnType:InterruptedException>*/\n");
    }

    public void test13() {
        this.setUnit("Test.java", "public class Test {\n\t /// \n\t /// @param xxx integer param\n\t /// @param str string param\n\t /// \n\tvoid foo(int xxx, String str) {}\n}\n");
        this.findJavadoc("xxx");
        this.findJavadoc("str");
        this.assertValid("/**<SelectOnLocalVariable:xxx>*/\n/**<SelectOnLocalVariable:str>*/\n");
    }

    public void test14() {
        this.setUnit("Test.java", "/// \n/// Javadoc of {@link Test}\n/// @see Field#foo\n/// \npublic class Test {}\n/// \n/// Javadoc on {@link Field} to test selection in javadoc field references\n/// @see #foo\n/// \nclass Field {\n\t /// \n\t /// Javadoc on {@link #foo} to test selection in javadoc field references\n\t /// @see #foo\n\t /// @see Field#foo\n\t /// \n\tint foo;\n}\n");
        this.findJavadoc("Field");
        this.findJavadoc("foo");
        this.findJavadoc("Field", 2);
        this.findJavadoc("foo", 2);
        this.findJavadoc("foo", 3);
        this.findJavadoc("foo", 4);
        this.findJavadoc("Field", 4);
        this.findJavadoc("foo", 5);
        this.assertValid("/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n/**<SelectOnType:Field>*/\n/**<SelectOnField:#foo>*/\n/**<SelectOnField:#foo>*/\n/**<SelectOnField:#foo>*/\n/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n");
    }

    public void test15() {
        this.setUnit("Test.java", "/// \n/// Javadoc of {@link Test}\n/// @see Method#foo(int, String)\n/// \npublic class Test {}\n/// \n/// Javadoc on {@link Method} to test selection in javadoc method references\n/// @see #foo(int, String)\n/// \nclass Method {\n\t /// \n\t /// Javadoc on {@link #foo(int,String)} to test selection in javadoc method references\n\t /// @see #foo(int, String)\n\t /// @see Method#foo(int, String)\n\t /// \n\tvoid bar() {}\n\t /// \n\t /// Method with parameter and throws clause to test selection in javadoc\n\t /// @param xxx TODO\n\t /// @param str TODO\n\t /// @throws RuntimeException blabla\n\t /// @throws InterruptedException bloblo\n\t /// \n\tvoid foo(int xxx, String str) throws RuntimeException, InterruptedException {}\n}\n");
        this.findJavadoc("Method");
        this.findJavadoc("foo");
        this.findJavadoc("Method", 2);
        this.findJavadoc("foo", 2);
        this.findJavadoc("foo", 3);
        this.findJavadoc("foo", 4);
        this.findJavadoc("Method", 4);
        this.findJavadoc("foo", 5);
        this.findJavadoc("xxx");
        this.findJavadoc("str");
        this.findJavadoc("RuntimeException");
        this.findJavadoc("InterruptedException");
        this.assertValid("/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo(int , String )>*/\n/**<SelectOnType:Method>*/\n/**<SelectOnMethod:#foo(int , String )>*/\n/**<SelectOnMethod:#foo(int , String )>*/\n/**<SelectOnMethod:#foo(int , String )>*/\n/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo(int , String )>*/\n/**<SelectOnLocalVariable:xxx>*/\n/**<SelectOnLocalVariable:str>*/\n/**<SelectOnType:RuntimeException>*/\n/**<SelectOnType:InterruptedException>*/\n");
    }

    public void test16() {
        this.setUnit("Test.java", "/// \n/// Javadoc of {@link Test}\n/// @see Other\n/// \npublic class Test {}\n/// \n/// Javadoc of {@link Other}\n/// @see Test\n/// \nclass Other {}\n");
        this.findJavadoc("Test");
        this.findJavadoc("Other");
        this.findJavadoc("Test", 3);
        this.findJavadoc("Other", 2);
        this.assertValid("/**<SelectOnType:Test>*/\n/**<SelectOnType:Other>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnType:Other>*/\n");
    }

    public void test17() {
        this.setUnit("Test.java", "/// \n/// @see Test.Field#foo\n/// \npublic class Test {\n\t /// \n\t /// @see Field#foo\n\t /// \n\tclass Field {\n\t\t/// \n\t\t///  @see #foo\n\t\t///  @see Field#foo\n\t\t///  @see Test.Field#foo\n\t\t/// \n\t\tint foo;\n\t}\n}\n");
        this.findJavadoc("Test");
        this.findJavadoc("Field");
        this.findJavadoc("foo");
        this.findJavadoc("Field", 2);
        this.findJavadoc("foo", 2);
        this.findJavadoc("foo", 3);
        this.findJavadoc("Field", 4);
        this.findJavadoc("foo", 4);
        this.findJavadoc("Test", 3);
        this.findJavadoc("Field", 5);
        this.findJavadoc("foo", 5);
        this.assertValid("/**<SelectOnType:Test>*/\n/**<SelectOnType:Test.Field>*/\n/**<SelectOnField:Test.Field#foo>*/\n/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n/**<SelectOnField:#foo>*/\n/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnType:Test.Field>*/\n/**<SelectOnField:Test.Field#foo>*/\n");
    }

    public void test18() {
        this.setUnit("Test.java", "/// \n/// @see Test.Method#foo()\n/// \npublic class Test {\n\t /// \n\t /// @see Method#foo()\n\t /// \n\tclass Method {\n\t\t/// \n\t\t/// @see #foo()\n\t\t/// @see Method#foo()\n\t\t/// @see Test.Method#foo()\n\t\t/// \n\t\tvoid foo() {}\n\t}\n}");
        this.findJavadoc("Test");
        this.findJavadoc("Method");
        this.findJavadoc("foo");
        this.findJavadoc("Method", 2);
        this.findJavadoc("foo", 2);
        this.findJavadoc("foo", 3);
        this.findJavadoc("Method", 4);
        this.findJavadoc("foo", 4);
        this.findJavadoc("Test", 3);
        this.findJavadoc("Method", 5);
        this.findJavadoc("foo", 5);
        this.assertValid("/**<SelectOnType:Test>*/\n/**<SelectOnType:Test.Method>*/\n/**<SelectOnMethod:Test.Method#foo()>*/\n/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo()>*/\n/**<SelectOnMethod:#foo()>*/\n/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo()>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnType:Test.Method>*/\n/**<SelectOnMethod:Test.Method#foo()>*/\n");
    }

    public void test19() {
        this.setUnit("Test.java", "/// \n/// @see Test.Other\n/// \npublic class Test {\n\t /// \n\t /// @see Test\n\t /// @see Other\n\t /// @see Test.Other\n\t /// \n\tclass Other {}\n}");
        this.findJavadoc("Test");
        this.findJavadoc("Other");
        this.findJavadoc("Test", 3);
        this.findJavadoc("Other", 2);
        this.findJavadoc("Test", 4);
        this.findJavadoc("Other", 3);
        this.assertValid("/**<SelectOnType:Test>*/\n/**<SelectOnType:Test.Other>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnType:Other>*/\n/**<SelectOnType:Test>*/\n/**<SelectOnType:Test.Other>*/\n");
    }

    public void test20() {
        this.setUnit("Test.java", "public class Test {\n\tvoid bar() {\n\t\t/// \n\t\t///  @see Field#foo\n\t\t/// \n\t\tclass Field {\n\t\t\t/// \n\t\t\t///  @see #foo\n\t\t\t///  @see Field#foo\n\t\t\t/// \n\t\t\tint foo;\n\t\t}\n\t}\n}\n");
        this.findJavadoc("Field");
        this.findJavadoc("foo");
        this.findJavadoc("foo", 2);
        this.findJavadoc("Field", 3);
        this.findJavadoc("foo", 3);
        this.assertValid("/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n/**<SelectOnField:#foo>*/\n/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n");
    }

    public void test21() {
        this.setUnit("Test.java", "public class Test {\n\tvoid bar() {\n\t\t/// \n\t\t///  @see Method#foo()\n\t\t/// \n\t\tclass Method {\n\t\t\t/// \n\t\t\t///  @see #foo()\n\t\t\t///  @see Method#foo()\n\t\t\t/// \n\t\t\tvoid foo() {}\n\t\t}\n\t}\n}");
        this.findJavadoc("Method");
        this.findJavadoc("foo");
        this.findJavadoc("foo", 2);
        this.findJavadoc("Method", 3);
        this.findJavadoc("foo", 3);
        this.assertValid("/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo()>*/\n/**<SelectOnMethod:#foo()>*/\n/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo()>*/\n");
    }

    public void test22() {
        this.setUnit("Test.java", "public class Test {\n\tvoid bar() {\n\t\t/// \n\t\t///  @see Test\n\t\t///  @see Other\n\t\t/// \n\t\tclass Other {}\n\t}\n}");
        this.findJavadoc("Test", 2);
        this.findJavadoc("Other");
        this.assertValid("/**<SelectOnType:Test>*/\n/**<SelectOnType:Other>*/\n");
    }

    public void test23() {
        this.setUnit("Test.java", "public class Test {\n\tvoid bar() {\n\t\tnew Object() {\n\t\t\t/// \n\t\t\t///  @see Field#foo\n\t\t\t/// \n\t\t\tclass Field {\n\t\t\t\t/// \n\t\t\t\t/// @see #foo\n\t\t\t\t/// @see Field#foo\n\t\t\t\t/// \n\t\t\t\tint foo;\n\t\t\t}\n\t\t};\n\t}\n}\n");
        this.findJavadoc("Field");
        this.findJavadoc("foo");
        this.findJavadoc("foo", 2);
        this.findJavadoc("Field", 3);
        this.findJavadoc("foo", 3);
        this.assertValid("/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n/**<SelectOnField:#foo>*/\n/**<SelectOnType:Field>*/\n/**<SelectOnField:Field#foo>*/\n");
    }

    public void test24() {
        this.setUnit("Test.java", "public class Test {\n\tvoid bar() {\n\t\tnew Object() {\n\t\t\t/// \n\t\t\t///  @see Method#foo()\n\t\t\t/// \n\t\t\tclass Method {\n\t\t\t\t/// \n\t\t\t\t/// @see #foo()\n\t\t\t\t/// @see Method#foo()\n\t\t\t\t/// \n\t\t\t\tvoid foo() {}\n\t\t\t}\n\t\t};\n\t}\n}");
        this.findJavadoc("Method");
        this.findJavadoc("foo");
        this.findJavadoc("foo", 2);
        this.findJavadoc("Method", 3);
        this.findJavadoc("foo", 3);
        this.assertValid("/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo()>*/\n/**<SelectOnMethod:#foo()>*/\n/**<SelectOnType:Method>*/\n/**<SelectOnMethod:Method#foo()>*/\n");
    }

    public void test25() {
        this.setUnit("Test.java", "public class Test {\n\tvoid bar() {\n\t\tnew Object() {\n\t\t\t/// \n\t\t\t///  @see Test\n\t\t\t///  @see Other\n\t\t\t/// \n\t\t\tclass Other {}\n\t\t};\n\t}\n}");
        this.findJavadoc("Test", 2);
        this.findJavadoc("Other");
        this.assertValid("/**<SelectOnType:Test>*/\n/**<SelectOnType:Other>*/\n");
    }

    public void test26() {
        this.setUnit("Test.java", "/// \n/// @see \n/// @throws noException\n/// @see Test\n/// @see Other\n/// \npublic class Test {\n\t /// \n\t /// @see\n\t /// @param noParam\n\t /// @throws noException\n\t /// \n\tvoid bar() {}\n}");
        CompilationResult compilationResult = this.findJavadoc("Other");
        SelectionMarkdownTest.assertEquals("SelectionJavadocParser should not report errors", "", Util.getProblemLog(compilationResult, false, false));
    }

    class JavadocSelectionVisitor
    extends ASTVisitor {
        JavadocSelectionVisitor() {
        }

        public boolean visit(ConstructorDeclaration constructor, ClassScope scope) {
            if (constructor.javadoc != null) {
                SelectionMarkdownTest.assertTrue((String)("Invalid type for Javadoc on " + String.valueOf(constructor)), (boolean)(constructor.javadoc instanceof SelectionJavadoc));
                SelectionMarkdownTest.this.result.append(constructor.javadoc.toString());
            }
            return super.visit(constructor, scope);
        }

        public boolean visit(FieldDeclaration field, MethodScope scope) {
            if (field.javadoc != null) {
                SelectionMarkdownTest.assertTrue((String)("Invalid type for Javadoc on " + String.valueOf(field)), (boolean)(field.javadoc instanceof SelectionJavadoc));
                SelectionMarkdownTest.this.result.append(field.javadoc.toString());
            }
            return super.visit(field, scope);
        }

        public boolean visit(MethodDeclaration method, ClassScope scope) {
            if (method.javadoc != null) {
                SelectionMarkdownTest.assertTrue((String)("Invalid type for Javadoc on " + String.valueOf(method)), (boolean)(method.javadoc instanceof SelectionJavadoc));
                SelectionMarkdownTest.this.result.append(method.javadoc.toString());
            }
            return super.visit(method, scope);
        }

        public boolean visit(TypeDeclaration type, BlockScope scope) {
            if (type.javadoc != null) {
                SelectionMarkdownTest.assertTrue((String)("Invalid type for Javadoc on " + String.valueOf(type)), (boolean)(type.javadoc instanceof SelectionJavadoc));
                SelectionMarkdownTest.this.result.append(type.javadoc.toString());
            }
            return super.visit(type, scope);
        }

        public boolean visit(TypeDeclaration type, ClassScope scope) {
            if (type.javadoc != null) {
                SelectionMarkdownTest.assertTrue((String)("Invalid type for Javadoc on " + String.valueOf(type)), (boolean)(type.javadoc instanceof SelectionJavadoc));
                SelectionMarkdownTest.this.result.append(type.javadoc.toString());
            }
            return super.visit(type, scope);
        }

        public boolean visit(TypeDeclaration type, CompilationUnitScope scope) {
            if (type.javadoc != null) {
                SelectionMarkdownTest.assertTrue((String)("Invalid type for Javadoc on " + String.valueOf(type)), (boolean)(type.javadoc instanceof SelectionJavadoc));
                SelectionMarkdownTest.this.result.append(type.javadoc.toString());
            }
            return super.visit(type, scope);
        }
    }
}

