/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSelectionTest;

public class SelectionParserTest10
extends AbstractSelectionTest {
    public static Test suite() {
        return SelectionParserTest10.buildMinimalComplianceTestSuite(SelectionParserTest10.class, 128);
    }

    public SelectionParserTest10(String testName) {
        super(testName);
    }

    public void test001() throws JavaModelException {
        String string = "public class X {\n  public static void main(String[] args) {\n    var s_s = args[0];\n  }\n}\n";
        String selection = "s_s";
        String expectedSelection = "<SelectionOnLocalName:var s_s = args[0]>;";
        String completionIdentifier = "s_s";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public static void main(String[] args) {\n    <SelectionOnLocalName:var s_s = args[0]>;\n  }\n}\n";
        String expectedReplacedSource = "s_s";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = string.lastIndexOf(selection) + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test002() throws JavaModelException {
        String string = "public class X {\n  public static void main(String[] args) {\n    var s_s = args[0];\n  }\n}\n";
        String selection = "var";
        String expectedSelection = "<SelectOnType:var>";
        String completionIdentifier = "var";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public static void main(String[] args) {\n    <SelectOnType:var> s_s = args[0];\n  }\n}\n";
        String expectedReplacedSource = "var";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = string.lastIndexOf(selection) + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }
}

