/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSelectionTest;

public class SelectionParserTest14
extends AbstractSelectionTest {
    public static Test suite() {
        return SelectionParserTest14.buildMinimalComplianceTestSuite(SelectionParserTest14.class, 2048);
    }

    public SelectionParserTest14(String testName) {
        super(testName);
    }

    public void test001() throws JavaModelException {
        String string = "public class X {\nstatic final String ONE=\"One\", TWO = \"Two\", THREE=\"Three\";\n  public static void foo(String num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE:\n\t\t System.out.println(num);\n\t\t break;\n    }  }\n}";
        String selection = "ONE";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "ONE";
        String expectedUnitDisplayString = "public class X {\n  static final String ONE;\n  static final String TWO;\n  static final String THREE;\n  <clinit>() {\n  }\n  public X() {\n  }\n  public static void foo(String num) {\n    {\n      switch (num) {\n      case <SelectOnName:ONE> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "ONE";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = string.lastIndexOf(selection) + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test002() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE:\n\t\t System.out.println(num);\n\t\t break;\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "ONE";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "ONE";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num) {\n    {\n      switch (num) {\n      case <SelectOnName:ONE> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "ONE";
        String testName = "X.java";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test003() throws JavaModelException {
        String string = "public class X {\nstatic final String ONE=\"One\", TWO = \"Two\", THREE=\"Three\";\n  public static void foo(String num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE:\n\t\t System.out.println(num);\n\t\t break;\n    }  }\n}";
        String selection = "TWO";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "TWO";
        String expectedUnitDisplayString = "public class X {\n  static final String ONE;\n  static final String TWO;\n  static final String THREE;\n  <clinit>() {\n  }\n  public X() {\n  }\n  public static void foo(String num) {\n    {\n      switch (num) {\n      case <SelectOnName:TWO> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "TWO";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = string.lastIndexOf(selection) + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test004() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE:\n\t\t System.out.println(num);\n\t\t break;\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "TWO";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "TWO";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num) {\n    {\n      switch (num) {\n      case <SelectOnName:TWO> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "TWO";
        String testName = "X.java";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test005() throws JavaModelException {
        String string = "public class X {\nstatic final String ONE=\"One\", TWO = \"Two\", THREE=\"Three\";\n  public static void foo(String num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE ->\n\t\t System.out.println(num);\n    }  }\n}";
        String selection = "ONE";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "ONE";
        String expectedUnitDisplayString = "public class X {\n  static final String ONE;\n  static final String TWO;\n  static final String THREE;\n  <clinit>() {\n  }\n  public X() {\n  }\n  public static void foo(String num) {\n    {\n      switch (num) {\n      case <SelectOnName:ONE> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "ONE";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = string.lastIndexOf(selection) + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test006() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE ->\n\t\t System.out.println(num);\n\t\t break; // illegal, but should be ignored and shouldn't matter\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "ONE";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "ONE";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num) {\n    {\n      switch (num) {\n      case <SelectOnName:ONE> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "ONE";
        String testName = "X.java";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test007() throws JavaModelException {
        String string = "public class X {\nstatic final String ONE=\"One\", TWO = \"Two\", THREE=\"Three\";\n  public static void foo(String num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE ->\n\t\t System.out.println(num);\n\t\t break;\n    }  }\n}";
        String selection = "TWO";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "TWO";
        String expectedUnitDisplayString = "public class X {\n  static final String ONE;\n  static final String TWO;\n  static final String THREE;\n  <clinit>() {\n  }\n  public X() {\n  }\n  public static void foo(String num) {\n    {\n      switch (num) {\n      case <SelectOnName:TWO> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "TWO";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = string.lastIndexOf(selection) + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test008() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num) {\n \t switch (num) {\n\t   case ONE, TWO, THREE ->\n\t\t System.out.println(num);\n\t\t break;\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "TWO";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "TWO";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num) {\n    {\n      switch (num) {\n      case <SelectOnName:TWO> :\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "TWO";
        String testName = "X.java";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test009() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num_) {\n \t switch (num_) {\n\t   case ONE, TWO, THREE ->\n\t\t System.out.println(num_);\n\t\t break;\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "num_";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "num_";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num_) {\n    {\n      switch (num_) {\n      case THREE ->\n          <SelectOnName:num_>;\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "num_";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test010() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num_) {\n \t switch (num_) {\n\t   case ONE, TWO, THREE -> {\n\t\t int i_j = 0;\t\t System.out.println(i_j);\n\t\t break;\t\t }\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "i_j";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "i_j";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num_) {\n    {\n      {\n        switch (num_) {\n        case THREE ->\n            int i_j;\n            <SelectOnName:i_j>;\n        }\n      }\n    }\n  }\n}\n";
        String expectedReplacedSource = "i_j";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test011() throws JavaModelException {
        String string = "public class X {\n  public static void foo(Num num_) {\n \t switch (num_) {\n\t   case ONE, TWO, THREE -> {\n\t\t break;\t\t }\n    }  }\n\tenum Num { ONE, TWO, THREE;}\n}";
        String selection = "num_";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "num_";
        String expectedUnitDisplayString = "public class X {\n  enum Num {\n    ONE(),\n    TWO(),\n    THREE(),\n    <clinit>() {\n    }\n    Num() {\n    }\n  }\n  public X() {\n  }\n  public static void foo(Num num_) {\n    <SelectOnName:num_>;\n  }\n}\n";
        String expectedReplacedSource = "num_";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test012() throws JavaModelException {
        String string = "public class X {\n  public static void foo(int num_) {\n \t switch (num_ + 1) {\n\t   case 1, 2, 3 -> {\n\t\t break;\t\t }\n    }  }\n}";
        String selection = "num_";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "num_";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public static void foo(int num_) {\n    <SelectOnName:num_>;\n  }\n}\n";
        String expectedReplacedSource = "num_";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test013() throws JavaModelException {
        String string = "public class X {\n  public static void foo(int num_) {\n \t int i = switch (num_) {\n\t   case 1, 2, 3 -> (num_ + 1);\n      default -> 0;\n    }  }\n}";
        String selection = "num_";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "num_";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public static void foo(int num_) {\n    int i =     switch (num_) {\n    case 3 ->\n        <SelectOnName:num_>;\n    };\n  }\n}\n";
        String expectedReplacedSource = "num_";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test014() throws JavaModelException {
        String string = "public class X {\n  public static void foo(int num_) {\n \t int i = switch (num_) {\n\t   case 1, 2, 3 -> 0;\n      default -> (num_ + 1);\n    }  }\n}";
        String selection = "num_";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "num_";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public static void foo(int num_) {\n    int i =     switch (num_) {\n    case 3 ->\n        0;\n    default ->\n        <SelectOnName:num_>;\n    };\n  }\n}\n";
        String expectedReplacedSource = "num_";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test015() throws JavaModelException {
        String string = "public class X {\n  public static void foo(int num_) {\n \t int i = switch (num_) {\n\t   case 1, 2, 3 -> 0;\n      default -> (num_ + 1);\n    }  }\n}";
        String selection = "num_";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "num_";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public static void foo(int num_) {\n    int i =     switch (num_) {\n    case 3 ->\n        0;\n    default ->\n        <SelectOnName:num_>;\n    };\n  }\n}\n";
        String expectedReplacedSource = "num_";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test016() throws JavaModelException {
        String string = "public class X {\n\tpublic void bar(int s) {\n\t\tint i_j = switch (s) {\n\t\t\tcase 1, 2, 3 -> (s+1);\n\t\t\tdefault -> i_j;\n\t\t};\n\t}\n}\n";
        String selection = "i_j";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "i_j";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public void bar(int s) {\n    int i_j =     switch (s) {\n    case 3 ->\n        (s + 1);\n    default ->\n        <SelectOnName:i_j>;\n    };\n  }\n}\n";
        String expectedReplacedSource = "i_j";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test017() throws JavaModelException {
        String string = "public class X {\n\tpublic void bar(int s) {\n\t\tint i_j = switch (s) {\n\t\t\tcase 1, 2, 3 -> (s+1);\n\t\t\tdefault -> (1+i_j);\n\t\t};\n\t}\n}\n";
        String selection = "i_j";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "i_j";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  public void bar(int s) {\n    int i_j =     switch (s) {\n    case 3 ->\n        (s + 1);\n    default ->\n        <SelectOnName:i_j>;\n    };\n  }\n}\n";
        String expectedReplacedSource = "i_j";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test018() throws JavaModelException {
        String string = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {} \ninterface IN1 extends IN0 {} \ninterface IN2 extends IN0 {}\npublic class X {\n\t IN1 n_1() { return new IN1() {}; } \n\tIN2 n_2() { return null; } \n\t<M> void m( Supplier< M> m2) { } \n\tvoid testSw(int i) { \n\t\tm(switch(i) { \n\t\t\tcase 1 -> this::n_1; \n\t\t\tdefault -> this::n_2; }); \n\t}\n}";
        String selection = "n_1";
        String selectKey = "<SelectionOnReferenceExpressionName:this::";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "n_1";
        String expectedUnitDisplayString = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {\n}\ninterface IN1 extends IN0 {\n}\ninterface IN2 extends IN0 {\n}\npublic class X {\n  public X() {\n  }\n  IN1 n_1() {\n  }\n  IN2 n_2() {\n  }\n  <M>void m(Supplier<M> m2) {\n  }\n  void testSw(int i) {\n    m(switch (i) {\ncase 1 ->\n    <SelectionOnReferenceExpressionName:this::n_1>;\ndefault ->\n    this::n_2;\n});\n  }\n}\n";
        String expectedReplacedSource = "this::n_1";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test019() throws JavaModelException {
        String string = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {} \ninterface IN1 extends IN0 {} \ninterface IN2 extends IN0 {}\npublic class X {\n\t IN1 n_1() { return new IN1() {}; } \n\tIN2 n_2() { return null; } \n\t<M> void m( Supplier< M> m2) { } \n\tvoid testSw(int i) { \n\t\tm(switch(i) { \n\t\t\tcase 2 -> () -> n_1(); \n\t\t\tdefault -> this::n_2; }); \n\t}\n}";
        String selection = "n_1";
        String selectKey = "<SelectOnMessageSend:";
        String expectedSelection = selectKey + selection + "()>";
        String selectionIdentifier = "n_1";
        String expectedUnitDisplayString = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {\n}\ninterface IN1 extends IN0 {\n}\ninterface IN2 extends IN0 {\n}\npublic class X {\n  public X() {\n  }\n  IN1 n_1() {\n  }\n  IN2 n_2() {\n  }\n  <M>void m(Supplier<M> m2) {\n  }\n  void testSw(int i) {\n    m(switch (i) {\ncase 2 ->\n    () -> <SelectOnMessageSend:n_1()>;\ndefault ->\n    this::n_2;\n});\n  }\n}\n";
        String expectedReplacedSource = "n_1()";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test020() throws JavaModelException {
        String string = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {} \ninterface IN1 extends IN0 {} \ninterface IN2 extends IN0 {}\npublic class X {\n\t IN1 n_1() { return new IN1() {}; } \n\tIN2 n_2() { return null; } \n\t<M> void m( Supplier< M> m2) { } \n\tvoid testSw(int i) { \n\t\tm(switch(i) { \n\t\t\tdefault -> this::n_2; }); \n\t}\n}";
        String selection = "n_2";
        String selectKey = "<SelectionOnReferenceExpressionName:this::";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "n_2";
        String expectedUnitDisplayString = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {\n}\ninterface IN1 extends IN0 {\n}\ninterface IN2 extends IN0 {\n}\npublic class X {\n  public X() {\n  }\n  IN1 n_1() {\n  }\n  IN2 n_2() {\n  }\n  <M>void m(Supplier<M> m2) {\n  }\n  void testSw(int i) {\n    m(switch (i) {\ndefault ->\n    <SelectionOnReferenceExpressionName:this::n_2>;\n});\n  }\n}\n";
        String expectedReplacedSource = "this::n_2";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test021() throws JavaModelException {
        String string = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {} \ninterface IN1 extends IN0 {} \ninterface IN2 extends IN0 {}\npublic class X {\n\t IN1 n_1(int ijk) { return new IN1() {}; } \n\tIN2 n_2() { return null; } \n\t<M> void m( Supplier< M> m2) { } \n\tvoid testSw(int ijk) { \n\t\tm(switch(ijk) { \n\t\t\tdefault -> () -> n_1(ijk); }); \n\t}\n}";
        String selection = "n_1";
        String selectKey = "<SelectOnMessageSend:";
        String expectedSelection = selectKey + selection + "(ijk)>";
        String selectionIdentifier = "n_1";
        String expectedUnitDisplayString = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {\n}\ninterface IN1 extends IN0 {\n}\ninterface IN2 extends IN0 {\n}\npublic class X {\n  public X() {\n  }\n  IN1 n_1(int ijk) {\n  }\n  IN2 n_2() {\n  }\n  <M>void m(Supplier<M> m2) {\n  }\n  void testSw(int ijk) {\n    m(switch (ijk) {\ndefault ->\n    () -> <SelectOnMessageSend:n_1(ijk)>;\n});\n  }\n}\n";
        String expectedReplacedSource = "n_1(ijk)";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void test022() throws JavaModelException {
        String string = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {} \ninterface IN1 extends IN0 {} \ninterface IN2 extends IN0 {}\npublic class X {\n\t IN1 n_1(int ijk) { return new IN1() {}; } \n\tIN2 n_2() { return null; } \n\t<M> void m( Supplier< M> m2) { } \n\tvoid testSw(int ijk) { \n\t\tm(switch(ijk) { \n\t\t\tdefault -> () -> n_1(ijk); }); \n\t}\n}";
        String selection = "ijk";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "ijk";
        String expectedUnitDisplayString = "import org.eclipse.jdt.annotation.*;\nimport java.util.function.*;\ninterface IN0 {\n}\ninterface IN1 extends IN0 {\n}\ninterface IN2 extends IN0 {\n}\npublic class X {\n  public X() {\n  }\n  IN1 n_1(int ijk) {\n  }\n  IN2 n_2() {\n  }\n  <M>void m(Supplier<M> m2) {\n  }\n  void testSw(int ijk) {\n    m(switch (ijk) {\ndefault ->\n    () -> n_1(<SelectOnName:ijk>);\n});\n  }\n}\n";
        String expectedReplacedSource = "ijk";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void testIssue708_1() throws JavaModelException {
        String string = "public class X {\n\tpublic void test(Type type, String string) {\n\t\tswitch (type) {\n\t\tcase openDeclarationFails -> {\n\t\t\tswitch (string) {\n\t\t\t\tcase \"Test\" -> method(Type.openDeclarationFails);\n\t\t\t}\n\t\t}\n\t\t}\n\t}\n\tprivate void method(Type relay) {}\n\tstatic public enum Type {\n\t\topenDeclarationFails, anotherValue;\n\t}\n}";
        String selection = "openDeclarationFails";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + selection + ">";
        String selectionIdentifier = "openDeclarationFails";
        String expectedUnitDisplayString = "public class X {\n  public static enum Type {\n    openDeclarationFails(),\n    anotherValue(),\n    <clinit>() {\n    }\n    public Type() {\n    }\n  }\n  public X() {\n  }\n  public void test(Type type, String string) {\n    {\n      switch (type) {\n      case <SelectOnName:openDeclarationFails> :\n      }\n    }\n  }\n  private void method(Type relay) {\n  }\n}\n";
        String expectedReplacedSource = "openDeclarationFails";
        String testName = "X.java";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }

    public void testIssue708_2() throws JavaModelException {
        String string = "public class X {\n\tstatic public enum Type {\n\t\topenDeclarationFails, anotherValue;\n\t}\n\tpublic void test(Type type, String string) {\n\t\tswitch (type) {\n\t\tcase openDeclarationFails -> {\n\t\t\tswitch (string) {\n\t\t\tcase \"Test\" -> method(Type.openDeclarationFails);\n\t\t\t}\n\t\t}\n\t\tcase anotherValue -> {\n\t\t\tswitch (string) {\n\t\t\tcase \"Test\" -> method(Type.anotherValue);\n\t\t\t}\n\t\t}\n\t\t}\n\t}\n\tprivate void method(Type relay) {}\n}";
        String selection = "anotherValue";
        String selectKey = "<SelectOnName:";
        String expectedSelection = selectKey + "Type." + selection + ">";
        String selectionIdentifier = "anotherValue";
        String expectedUnitDisplayString = "public class X {\n  public static enum Type {\n    openDeclarationFails(),\n    anotherValue(),\n    <clinit>() {\n    }\n    public Type() {\n    }\n  }\n  public X() {\n  }\n  public void test(Type type, String string) {\n    {\n      {\n        {\n          switch (type) {\n          case openDeclarationFails ->\n              {\n                switch (string) {\n                case \"Test\" ->\n                    method(Type.openDeclarationFails);\n                }\n              }\n          case anotherValue ->\n              switch (string) {\n              case \"Test\" ->\n                  <SelectOnName:Type.anotherValue>;\n              }\n          }\n        }\n      }\n    }\n  }\n  private void method(Type relay) {\n  }\n}\n";
        String expectedReplacedSource = "Type.anotherValue";
        String testName = "X.java";
        int selectionStart = string.lastIndexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelection, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }
}

