/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import org.eclipse.jdt.internal.compiler.env.ISourceMethod;

public class SourceMethod
implements ISourceMethod {
    private final int modifiers;
    private final int declarationStart;
    private int declarationEnd;
    private final char[] returnTypeName;
    private final char[] selector;
    private final int nameSourceStart;
    private final int nameSourceEnd;
    private final char[][] argumentTypeNames;
    private final char[][] argumentNames;
    private final char[][] exceptionTypeNames;
    private final char[] source;
    private String explicitConstructorCall;
    char[][] typeParameterNames;
    char[][][] typeParameterBounds;

    public SourceMethod(int declarationStart, int modifiers, char[] returnTypeName, char[] selector, int nameSourceStart, int nameSourceEnd, char[][] argumentTypeNames, char[][] argumentNames, char[][] exceptionTypeNames, char[] source) {
        this.declarationStart = declarationStart;
        this.modifiers = modifiers;
        this.returnTypeName = returnTypeName;
        this.selector = selector;
        this.nameSourceStart = nameSourceStart;
        this.nameSourceEnd = nameSourceEnd;
        this.argumentTypeNames = argumentTypeNames;
        this.argumentNames = argumentNames;
        this.exceptionTypeNames = exceptionTypeNames;
        this.source = source;
    }

    public String displayModifiers() {
        StringBuilder buffer = new StringBuilder();
        if (this.modifiers == 0) {
            return null;
        }
        if ((this.modifiers & 1) != 0) {
            buffer.append("public ");
        }
        if ((this.modifiers & 4) != 0) {
            buffer.append("protected ");
        }
        if ((this.modifiers & 2) != 0) {
            buffer.append("private ");
        }
        if ((this.modifiers & 0x10) != 0) {
            buffer.append("final ");
        }
        if ((this.modifiers & 8) != 0) {
            buffer.append("static ");
        }
        if ((this.modifiers & 0x400) != 0) {
            buffer.append("abstract ");
        }
        if ((this.modifiers & 0x100) != 0) {
            buffer.append("native ");
        }
        if ((this.modifiers & 0x20) != 0) {
            buffer.append("synchronized ");
        }
        if (buffer.toString().trim().equals("")) {
            return null;
        }
        return buffer.toString().trim();
    }

    public String getActualName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.source, this.nameSourceStart, this.nameSourceEnd - this.nameSourceStart + 1);
        return buffer.toString();
    }

    public char[][] getArgumentNames() {
        return this.argumentNames;
    }

    public char[][] getArgumentTypeNames() {
        return this.argumentTypeNames;
    }

    public int getDeclarationSourceEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationStart;
    }

    public char[][] getExceptionTypeNames() {
        return this.exceptionTypeNames;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getNameSourceEnd() {
        return this.nameSourceEnd;
    }

    public int getNameSourceStart() {
        return this.nameSourceStart;
    }

    public char[] getReturnTypeName() {
        return this.returnTypeName;
    }

    public char[] getSelector() {
        return this.selector;
    }

    public char[][][] getTypeParameterBounds() {
        return this.typeParameterBounds;
    }

    public char[][] getTypeParameterNames() {
        return this.typeParameterNames;
    }

    public boolean isConstructor() {
        return this.returnTypeName == null;
    }

    protected void setDeclarationSourceEnd(int position) {
        this.declarationEnd = position;
    }

    protected void setExplicitConstructorCall(String s) {
        this.explicitConstructorCall = s;
    }

    public String tabString(int tab) {
        Object s = "";
        int i = tab;
        while (i > 0) {
            s = (String)s + "\t";
            --i;
        }
        return s;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        int max;
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.tabString(tab));
        String displayModifiers = this.displayModifiers();
        if (displayModifiers != null) {
            buffer.append(displayModifiers).append(" ");
        }
        if (this.returnTypeName != null) {
            buffer.append(this.returnTypeName).append(" ");
        }
        buffer.append(this.selector).append("(");
        if (this.argumentTypeNames != null) {
            i = 0;
            max = this.argumentTypeNames.length;
            while (i < max) {
                buffer.append(this.argumentTypeNames[i]).append(" ").append(this.argumentNames[i]).append(", ");
                ++i;
            }
        }
        buffer.append(") ");
        if (this.exceptionTypeNames != null) {
            buffer.append("throws ");
            i = 0;
            max = this.exceptionTypeNames.length;
            while (i < max) {
                buffer.append(this.exceptionTypeNames[i]).append(", ");
                ++i;
            }
        }
        if (this.explicitConstructorCall != null) {
            buffer.append("{\n").append(this.tabString(tab + 1)).append(this.explicitConstructorCall).append(this.tabString(tab)).append("}");
        } else {
            buffer.append("{}");
        }
        return buffer.toString();
    }
}

